/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSSettings {
    private final boolean isTypeCheckingEnabled;
    @NotNull
    private final String myFlowPath;
    private final boolean isOtherServicesEnabled;
    private final boolean isAutoSaveEnabled;
    public static final FlowJSSettings DEFAULT = new Builder().build();

    public FlowJSSettings(@NotNull Builder builder) {
        if (builder == null) {
            FlowJSSettings.$$$reportNull$$$0(0);
        }
        this.isTypeCheckingEnabled = builder.isTypeCheckingEnabled;
        this.myFlowPath = FileUtil.toSystemIndependentName((String)builder.myFlowPath);
        this.isOtherServicesEnabled = builder.isOtherServicesEnabled;
        this.isAutoSaveEnabled = builder.isAutoSaveEnabled;
    }

    @NotNull
    public Builder toBuilder() {
        Builder builder = new Builder().setTypeCheckingEnabled(this.isTypeCheckingEnabled).setFlowExecutablePath(this.myFlowPath).setOtherServicesEnabled(this.isOtherServicesEnabled).setAutoSaveEnabled(this.isAutoSaveEnabled);
        if (builder == null) {
            FlowJSSettings.$$$reportNull$$$0(1);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowJSSettings settings = (FlowJSSettings)o;
        if (!this.myFlowPath.equals(settings.myFlowPath)) {
            return false;
        }
        if (this.isTypeCheckingEnabled != settings.isTypeCheckingEnabled) {
            return false;
        }
        if (this.isOtherServicesEnabled != settings.isOtherServicesEnabled) {
            return false;
        }
        return this.isAutoSaveEnabled == settings.isAutoSaveEnabled;
    }

    public int hashCode() {
        int result2 = this.myFlowPath.hashCode();
        result2 = 31 * result2 + (this.isTypeCheckingEnabled ? 1 : 0);
        result2 = 31 * result2 + (this.isOtherServicesEnabled ? 1 : 0);
        result2 = 31 * result2 + (this.isAutoSaveEnabled ? 0 : 1);
        return result2;
    }

    public String toString() {
        return "FlowSettings{myFlowPath='" + this.myFlowPath + '\'' + '}';
    }

    public boolean isTypeCheckingEnabled() {
        return this.isTypeCheckingEnabled;
    }

    public boolean isOtherServicesEnabled() {
        return this.isOtherServicesEnabled;
    }

    @NotNull
    public String getFlowExecutablePath() {
        String string = this.myFlowPath;
        if (string == null) {
            FlowJSSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public FlowJSExecutable getFlowExecutable() {
        return StringUtil.isEmpty((String)this.myFlowPath) ? null : new FlowJSExecutable(new File(this.myFlowPath));
    }

    public boolean isAutoSaveEnabled() {
        return this.isAutoSaveEnabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlowExecutablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FlowJSExecutable {
        @NotNull
        private final File myFile;

        public FlowJSExecutable(@NotNull File file2) {
            if (file2 == null) {
                FlowJSExecutable.$$$reportNull$$$0(0);
            }
            this.myFile = file2;
        }

        @NotNull
        public GeneralCommandLine createCommandLine(@NotNull Project project) {
            GeneralCommandLine result2;
            if (project == null) {
                FlowJSExecutable.$$$reportNull$$$0(1);
            }
            if (this.myFile.isDirectory()) {
                String nodePath;
                NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(project).getInterpreter();
                if (interpreter instanceof NodeJsLocalInterpreter) {
                    nodePath = ((NodeJsLocalInterpreter)interpreter).getInterpreterSystemDependentPath();
                } else {
                    if (!(interpreter instanceof WslNodeInterpreter)) {
                        Logger.getInstance(FlowJSExecutable.class).error("Can't find node interpreter");
                    }
                    nodePath = SystemInfo.isWindows ? "node.exe" : "node";
                }
                NodePackage flowBinPackage = new NodePackage(this.myFile.getPath());
                File binFile = flowBinPackage.findBinFile();
                if (binFile == null) {
                    Logger.getInstance(FlowJSExecutable.class).warn("Can't find bin file");
                    binFile = new File(this.myFile, "cli.js");
                }
                result2 = new GeneralCommandLine(new String[]{nodePath, binFile.getAbsolutePath()});
            } else {
                result2 = new GeneralCommandLine(new String[]{this.myFile.getAbsolutePath()});
            }
            result2.setWorkDirectory(project.getBasePath());
            GeneralCommandLine generalCommandLine = result2;
            if (generalCommandLine == null) {
                FlowJSExecutable.$$$reportNull$$$0(2);
            }
            return generalCommandLine;
        }

        @NotNull
        public String getPackageOrExePath() {
            String string = this.myFile.getAbsolutePath();
            if (string == null) {
                FlowJSExecutable.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSSettings$FlowJSExecutable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSSettings$FlowJSExecutable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createCommandLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPackageOrExePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createCommandLine";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Builder {
        private String myFlowPath = "";
        private boolean isTypeCheckingEnabled = true;
        private boolean isOtherServicesEnabled = true;
        private boolean isAutoSaveEnabled = true;

        @NotNull
        public Builder setFlowExecutablePath(@NotNull String flowPath) {
            if (flowPath == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myFlowPath = flowPath;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder;
        }

        @NotNull
        public Builder setTypeCheckingEnabled(boolean isEnabled) {
            this.isTypeCheckingEnabled = isEnabled;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder;
        }

        @NotNull
        public Builder setOtherServicesEnabled(boolean isEnabled) {
            this.isOtherServicesEnabled = isEnabled;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder;
        }

        @NotNull
        public Builder setAutoSaveEnabled(boolean isEnabled) {
            this.isAutoSaveEnabled = isEnabled;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public FlowJSSettings build() {
            FlowJSSettings flowJSSettings = new FlowJSSettings(this);
            if (flowJSSettings == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return flowJSSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flowPath";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/flow/FlowJSSettings$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/flow/FlowJSSettings$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setFlowExecutablePath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTypeCheckingEnabled";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setOtherServicesEnabled";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAutoSaveEnabled";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setFlowExecutablePath";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

