/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.psi;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.ecmascript6.parsing.TypeScriptPsiTypeParser;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.parsing.modifiers.JSOneOfModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSOrderedModifiersStructure;
import com.intellij.lang.javascript.types.TypeScriptFunctionSignatureElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.Key;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class FlowJSPsiTypeParser<T extends ES6Parser<?, ?, ?, ?>>
extends TypeScriptPsiTypeParser<T> {
    static final Key<Boolean> FORCED_TYPE_KEY = Key.create((String)"js.parser.forced.type");
    static final Key<Boolean> OPAQUE_TYPE_KEY = Key.create((String)"js.parser.flow.opaque.type");
    private static final Key<Boolean> ARROW_FUNCTION_RETURN_TYPE_KEY = Key.create((String)"js.parser.arrow.function.return.type");
    private static final JSModifiersStructure TYPE_MEMBER_MODIFIERS = new JSOrderedModifiersStructure(new JSModifiersStructureLeaf(JSTokenTypes.STATIC_KEYWORD), new JSOneOfModifiersStructure(JSTokenTypes.PLUS, JSTokenTypes.MINUS));

    public FlowJSPsiTypeParser(T parser) {
        super(parser);
    }

    @Override
    public boolean parseUnionOrIntersectionComponent(boolean functionTypeAllowed) {
        return this.parseDistinctType(functionTypeAllowed);
    }

    @Override
    public boolean tryParseFunctionReturnType() {
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            boolean result2 = true;
            if (this.builder.getTokenType() != JSTokenTypes.PERC) {
                result2 = this.parseType();
            }
            this.tryParseTypePredicate();
            return result2;
        }
        return super.tryParseFunctionReturnType();
    }

    @Override
    protected boolean parseFunctionReturnType(PsiBuilder.Marker marker, boolean result2) {
        result2 &= FlowJSPsiTypeParser.checkMatches(this.builder, JSTokenTypes.EQGT, "javascript.parser.message.expected.eqgt");
        boolean bl = !Boolean.TRUE.equals(this.builder.getUserData(ARROW_FUNCTION_RETURN_TYPE_KEY));
        marker.done(TypeScriptElementTypes.FUNCTION_TYPE);
        return result2 &= this.parseInUnionOrIntersectionType(true, true, bl);
    }

    @Override
    public boolean tryParseArrowFunctionReturnType() {
        this.builder.putUserData(ARROW_FUNCTION_RETURN_TYPE_KEY, (Object)Boolean.TRUE);
        boolean result2 = false;
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            result2 = true;
            if (this.builder.getTokenType() != JSTokenTypes.PERC) {
                result2 = this.parseInUnionOrIntersectionType(true, true, true);
            }
            this.tryParseTypePredicate();
        }
        this.builder.putUserData(ARROW_FUNCTION_RETURN_TYPE_KEY, null);
        return result2;
    }

    @Override
    protected boolean isFunctionTypeAllowed(boolean isFirstComponent, boolean allowedByContext) {
        return allowedByContext;
    }

    @Override
    protected boolean parseDistinctType(boolean functionTypeAllowed) {
        PsiBuilder.Marker functionTypeStartMarker = this.builder.mark();
        PsiBuilder.Marker functionParameterListMarker = this.builder.mark();
        boolean result2 = this.parseDistinctTypeInner(functionTypeAllowed);
        if (Boolean.TRUE.equals(this.builder.getUserData(ARROW_FUNCTION_RETURN_TYPE_KEY))) {
            functionTypeAllowed = false;
        }
        while (functionTypeAllowed && this.builder.getTokenType() == JSTokenTypes.EQGT) {
            functionParameterListMarker.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterListElementType());
            result2 &= this.parseFunctionReturnType(functionTypeStartMarker, result2);
            functionTypeStartMarker = functionTypeStartMarker.precede();
            functionParameterListMarker = functionParameterListMarker.precede();
        }
        functionParameterListMarker.drop();
        functionTypeStartMarker.drop();
        return result2;
    }

    private boolean parseDistinctTypeInner(boolean functionTypeAllowed) {
        IElementType firstToken = this.builder.getTokenType();
        PsiBuilder.Marker markerForArrayType = this.builder.mark();
        if (firstToken == JSTokenTypes.QUEST) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            this.parseDistinctType(functionTypeAllowed);
            marker.done(FlowJSElementTypes.MAYBE_TYPE);
            return this.parseArrayTypeSuffix(markerForArrayType);
        }
        if (firstToken == JSTokenTypes.MULT) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            marker.done(TypeScriptElementTypes.SINGLE_TYPE);
            return this.parseArrayTypeSuffix(markerForArrayType);
        }
        if (firstToken == JSTokenTypes.FUNCTION_KEYWORD) {
            return this.parserSingleType() & this.parseArrayTypeSuffix(markerForArrayType);
        }
        if (firstToken == JSTokenTypes.LBRACE_OR) {
            return this.parseObjectType(JSTokenTypes.OR_RBRACE, "javascript.parser.message.missing.or_rbrace") & this.parseArrayTypeSuffix(markerForArrayType);
        }
        if (firstToken == JSTokenTypes.LPAR) {
            boolean isNamedFunctionTypeParameter = functionTypeAllowed && this.isFunctionTypeExpected();
            IElementType lookahead = this.builder.lookAhead(1);
            if (!isNamedFunctionTypeParameter && lookahead != JSTokenTypes.RPAR && lookahead != JSTokenTypes.AND && lookahead != JSTokenTypes.OR) {
                PsiBuilder.Marker beforeLBrace = this.builder.mark();
                this.builder.advanceLexer();
                PsiBuilder.Marker afterLBrace = this.builder.mark();
                Boolean alreadyProcessingArrow = (Boolean)this.builder.getUserData(ARROW_FUNCTION_RETURN_TYPE_KEY);
                this.builder.putUserData(ARROW_FUNCTION_RETURN_TYPE_KEY, null);
                this.parseDistinctType(true);
                this.builder.putUserData(ARROW_FUNCTION_RETURN_TYPE_KEY, (Object)alreadyProcessingArrow);
                IElementType tokenAfterType = this.builder.getTokenType();
                if (tokenAfterType == JSTokenTypes.COMMA) {
                    this.parseFunctionParameters(false);
                    FlowJSPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
                    beforeLBrace.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterListElementType());
                    afterLBrace.drop();
                    this.parseFunctionReturnType(beforeLBrace.precede(), true);
                } else if (tokenAfterType == JSTokenTypes.AND || tokenAfterType == JSTokenTypes.OR) {
                    this.builder.advanceLexer();
                    this.parseInUnionOrIntersectionType(tokenAfterType == JSTokenTypes.OR, false, functionTypeAllowed);
                    beforeLBrace.drop();
                    afterLBrace.done(TypeScriptElementTypes.UNION_OR_INTERSECTION_TYPE);
                    if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                        PsiBuilder.Marker precede = afterLBrace.precede();
                        precede.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterType());
                        this.parseFunctionParameters(false);
                    }
                    FlowJSPsiTypeParser.checkMatches(this.builder, JSTokenTypes.RPAR, "javascript.parser.message.expected.rparen");
                } else if (tokenAfterType == JSTokenTypes.RPAR) {
                    if (this.builder.lookAhead(1) == JSTokenTypes.EQGT && functionTypeAllowed && !Boolean.TRUE.equals(alreadyProcessingArrow)) {
                        this.builder.advanceLexer();
                        beforeLBrace.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterListElementType());
                        afterLBrace.drop();
                        this.parseFunctionReturnType(beforeLBrace.precede(), true);
                    } else {
                        this.builder.advanceLexer();
                        beforeLBrace.drop();
                        afterLBrace.drop();
                    }
                } else {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.rparen", (Object[])new Object[0]));
                    beforeLBrace.drop();
                    afterLBrace.drop();
                    markerForArrayType.drop();
                    return false;
                }
                return this.parseArrayTypeSuffix(markerForArrayType);
            }
        }
        markerForArrayType.drop();
        return super.parseDistinctType(functionTypeAllowed);
    }

    @Override
    public boolean parseTypeMember() {
        PsiBuilder.Marker marker = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            this.builder.advanceLexer();
            this.parseType();
            this.forceCheckForSemicolonOrComma();
            marker.done(FlowJSElementTypes.OBJECT_TYPE_SPREAD);
            return true;
        }
        if (JSTokenTypes.GET_SET.contains(this.builder.getTokenType()) && JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.lookAhead(1))) {
            PsiBuilder.Marker mark = this.builder.mark();
            this.builder.advanceLexer();
            mark.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getAttributeListElementType());
        }
        ((ES6Parser)this.myJavaScriptParser).parseModifiers(TYPE_MEMBER_MODIFIERS, true, AFTER_TYPE_MEMBER_MODIFIERS_PREDICATE);
        return super.parseTypeMember(marker);
    }

    @Override
    public boolean isIndexSignatureProperty() {
        return this.builder.getTokenType() == JSTokenTypes.LBRACKET;
    }

    @Override
    public boolean parseIndexSignatureNoMarker(PsiBuilder.Marker marker, boolean checkSemicolon) {
        return FlowJSPsiTypeParser.parseIndexSignatureNoMarker(marker, this.builder, (ES6Parser)this.myJavaScriptParser, checkSemicolon, false);
    }

    @Override
    @NotNull
    protected IElementType getFunctionSignatureElementType() {
        TypeScriptFunctionSignatureElementType typeScriptFunctionSignatureElementType = FlowJSElementTypes.FUNCTION_SIGNATURE;
        if (typeScriptFunctionSignatureElementType == null) {
            FlowJSPsiTypeParser.$$$reportNull$$$0(0);
        }
        return typeScriptFunctionSignatureElementType;
    }

    @Override
    public boolean tryParseType() {
        if (Boolean.TRUE.equals(this.builder.getUserData(FORCED_TYPE_KEY)) && this.builder.getTokenType() != JSTokenTypes.COLON) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.colon", (Object[])new Object[0]));
        }
        return super.tryParseType();
    }

    @Override
    protected boolean parseTypeParameter() {
        PsiBuilder.Marker typeParameter = this.builder.mark();
        if (this.builder.getTokenType() == JSTokenTypes.PLUS || this.builder.getTokenType() == JSTokenTypes.MINUS) {
            this.builder.advanceLexer();
        }
        if (!this.isIdentifierToken(this.builder.getTokenType())) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            typeParameter.drop();
            return false;
        }
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.builder.advanceLexer();
            this.parseType();
        } else if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            this.parseType();
            if (this.builder.getTokenType() == JSTokenTypes.EQ) {
                this.builder.advanceLexer();
                this.parseType();
            }
        }
        typeParameter.done(TypeScriptElementTypes.TYPE_PARAMETER);
        return true;
    }

    @Override
    protected boolean allowLastCommaInTupleType() {
        return true;
    }

    @Override
    protected boolean parseFunctionParameterList() {
        if (!this.tryParseTypeParameterList()) {
            return true;
        }
        if (this.builder.getTokenType() != JSTokenTypes.LPAR) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.lparen", (Object[])new Object[0]));
            PsiBuilder.Marker parameterList = this.builder.mark();
            parameterList.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterListElementType());
            return true;
        }
        PsiBuilder.Marker parameterList = this.builder.mark();
        this.builder.advanceLexer();
        boolean result2 = this.parseFunctionParameters(true);
        if (this.builder.getTokenType() == JSTokenTypes.RPAR) {
            this.builder.advanceLexer();
        }
        parameterList.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterListElementType());
        return result2;
    }

    private boolean parseFunctionParameters(boolean first) {
        boolean result2 = true;
        while (this.builder.getTokenType() != JSTokenTypes.RPAR) {
            if (first) {
                first = false;
            } else if (this.builder.getTokenType() == JSTokenTypes.COMMA) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.RPAR && ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).allowLastCommaInParameterAndArgumentList()) {
                    break;
                }
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.comma.or.rparen", (Object[])new Object[0]));
                result2 = false;
                break;
            }
            PsiBuilder.Marker parameter = this.builder.mark();
            if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
                this.builder.advanceLexer();
            }
            if (JSKeywordSets.IDENTIFIER_NAMES.contains(this.builder.getTokenType()) && (this.builder.lookAhead(1) == JSTokenTypes.COLON || this.builder.lookAhead(1) == JSTokenTypes.QUEST && this.builder.lookAhead(2) == JSTokenTypes.COLON)) {
                this.builder.advanceLexer();
                if (this.builder.getTokenType() == JSTokenTypes.QUEST) {
                    ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseParameterOptionalMark();
                }
                this.builder.advanceLexer();
            }
            result2 &= this.parseType();
            parameter.done(((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).getParameterType());
        }
        return result2;
    }

    @Override
    public boolean parseTypeAliasType() {
        if (this.builder.getTokenType() == JSTokenTypes.COLON) {
            this.builder.advanceLexer();
            PsiBuilder.Marker typeConstraint = this.builder.mark();
            this.parseType();
            typeConstraint.done((IElementType)TypeScriptElementTypes.TYPE_PARAMETER_CONSTRAINT);
        }
        if (this.builder.getTokenType() != JSTokenTypes.EQ) {
            if (!Boolean.TRUE.equals(this.builder.getUserData(OPAQUE_TYPE_KEY))) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.equal", (Object[])new Object[0]));
            }
            return false;
        }
        this.builder.advanceLexer();
        return this.parseType();
    }

    @Override
    @NotNull
    protected String getTypeNameExpectedMessage() {
        String string = JSBundle.message((String)"javascript.parser.message.expected.typename.or.*", (Object[])new Object[0]);
        if (string == null) {
            FlowJSPsiTypeParser.$$$reportNull$$$0(1);
        }
        return string;
    }

    private void tryParseTypePredicate() {
        if (this.builder.getTokenType() != JSTokenTypes.PERC) {
            return;
        }
        PsiBuilder.Marker typePredicate = this.builder.mark();
        this.builder.advanceLexer();
        if (this.builder.getTokenType() != JSTokenTypes.IDENTIFIER || !"checks".equals(this.builder.getTokenText())) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.checks", (Object[])new Object[0]));
        }
        this.builder.advanceLexer();
        if (this.builder.getTokenType() == JSTokenTypes.LPAR) {
            ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parseParenthesizedExpression();
        }
        typePredicate.done(FlowJSElementTypes.TYPE_PREDICATE);
    }

    @Override
    protected boolean isAcceptableTokenTypeAfterTypeArguments(IElementType tokenType) {
        return tokenType == JSTokenTypes.LPAR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/flow/psi/FlowJSPsiTypeParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionSignatureElementType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNameExpectedMessage";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

