/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.FormattableInjectedBlockInJS;
import com.intellij.lang.javascript.formatter.JSBinaryExpressionBlock;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSBlockEx;
import com.intellij.lang.javascript.formatter.blocks.JSParameterBlock;
import com.intellij.lang.javascript.formatter.blocks.JSParameterListBlock;
import com.intellij.lang.javascript.formatter.blocks.JSSpacingStrategy;
import com.intellij.lang.javascript.formatter.blocks.SubBlockVisitor;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.inject.JSFormattableInjectionUtil;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.typescript.formatter.TypedJSSpacingProcessor;
import com.intellij.lang.typescript.formatter.blocks.TypedJSSubBlockVisitor;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.webcore.formatter.chainedMethods.CallChainDotBlock;
import com.intellij.xml.template.formatter.TemplateFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSBlockContext {
    @NotNull
    private final CommonCodeStyleSettings myCommonSettings;
    @NotNull
    private final CodeStyleSettings myTopSettings;
    @NotNull
    private final Language myDialect;
    @Nullable
    protected XmlFormattingPolicy myPolicy;
    @NotNull
    private final JSCodeStyleSettings myDialectSettings;
    @NotNull
    private final FormattingMode myFormattingMode;

    public JSBlockContext(@NotNull CodeStyleSettings topSettings, @NotNull Language dialect, @Nullable JSCodeStyleSettings explicitSettings, @NotNull FormattingMode formattingMode) {
        if (topSettings == null) {
            JSBlockContext.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            JSBlockContext.$$$reportNull$$$0(1);
        }
        if (formattingMode == null) {
            JSBlockContext.$$$reportNull$$$0(2);
        }
        this.myTopSettings = topSettings;
        this.myFormattingMode = formattingMode;
        this.myDialectSettings = (JSCodeStyleSettings)((Object)ObjectUtils.coalesce((Object)((Object)explicitSettings), (Object)topSettings.getCustomSettings(JSCodeStyleSettings.getSettingsClass(dialect))));
        this.myCommonSettings = topSettings.getCommonSettings(dialect);
        this.myDialect = dialect;
    }

    public void setXmlFormattingPolicy(XmlFormattingPolicy xmlFormattingPolicy) {
        this.myPolicy = xmlFormattingPolicy;
    }

    @NotNull
    public static JSBlockContext createDefault(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            JSBlockContext.$$$reportNull$$$0(3);
        }
        JSBlockContext jSBlockContext = new JSBlockContext(settings, (Language)JavascriptLanguage.INSTANCE, null, FormattingMode.REFORMAT);
        if (jSBlockContext == null) {
            JSBlockContext.$$$reportNull$$$0(4);
        }
        return jSBlockContext;
    }

    @NotNull
    public FormattingMode getFormattingMode() {
        FormattingMode formattingMode = this.myFormattingMode;
        if (formattingMode == null) {
            JSBlockContext.$$$reportNull$$$0(5);
        }
        return formattingMode;
    }

    @NotNull
    public CodeStyleSettings getTopSettings() {
        CodeStyleSettings codeStyleSettings = this.myTopSettings;
        if (codeStyleSettings == null) {
            JSBlockContext.$$$reportNull$$$0(6);
        }
        return codeStyleSettings;
    }

    @NotNull
    public Language getDialect() {
        Language language = this.myDialect;
        if (language == null) {
            JSBlockContext.$$$reportNull$$$0(7);
        }
        return language;
    }

    @NotNull
    public JSCodeStyleSettings getDialectSettings() {
        JSCodeStyleSettings jSCodeStyleSettings = this.myDialectSettings;
        if (jSCodeStyleSettings == null) {
            JSBlockContext.$$$reportNull$$$0(8);
        }
        return jSCodeStyleSettings;
    }

    @NotNull
    public CommonCodeStyleSettings getCommonSettings() {
        CommonCodeStyleSettings commonCodeStyleSettings = this.myCommonSettings;
        if (commonCodeStyleSettings == null) {
            JSBlockContext.$$$reportNull$$$0(9);
        }
        return commonCodeStyleSettings;
    }

    @NotNull
    public Block createBlock(@NotNull ASTNode child, @Nullable Wrap wrap, @Nullable Alignment childAlignment, @Nullable Indent childIndent, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory, @Nullable JSBlock parentBlock) {
        Block outerLangBlock;
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(10);
        }
        if (child instanceof JSXmlLiteralExpression && this.myPolicy != null) {
            SubBlockVisitor.JSXmlTagBlock jSXmlTagBlock = new SubBlockVisitor.JSXmlTagBlock(child, wrap, childAlignment, this.myPolicy, childIndent, parentBlock);
            if (jSXmlTagBlock == null) {
                JSBlockContext.$$$reportNull$$$0(11);
            }
            return jSXmlTagBlock;
        }
        if (child.getElementType() == JSStubElementTypes.STRING_TEMPLATE_EXPRESSION && parentBlock != null && parentBlock.processInjections() && JSFormattableInjectionUtil.hostContainsFormattableInjection(child.getPsi())) {
            FormattableInjectedBlockInJS formattableInjectedBlockInJS = new FormattableInjectedBlockInJS(child, childAlignment, childIndent, wrap, this.myTopSettings);
            if (formattableInjectedBlockInJS == null) {
                JSBlockContext.$$$reportNull$$$0(12);
            }
            return formattableInjectedBlockInJS;
        }
        Block block = outerLangBlock = child.getPsi() instanceof OuterLanguageElement ? TemplateFormatUtil.buildTemplateLanguageBlock((OuterLanguageElement)((OuterLanguageElement)child.getPsi()), (CodeStyleSettings)this.myTopSettings, (Indent)childIndent) : null;
        if (outerLangBlock != null) {
            Block block2 = outerLangBlock;
            if (block2 == null) {
                JSBlockContext.$$$reportNull$$$0(13);
            }
            return block2;
        }
        JSBlock jSBlock = this.createSubBlock(child, childAlignment, childIndent, wrap, alignmentFactory, parentBlock);
        if (jSBlock == null) {
            JSBlockContext.$$$reportNull$$$0(14);
        }
        return jSBlock;
    }

    @NotNull
    protected JSBlock createSubBlock(@NotNull ASTNode child, @Nullable Alignment childAlignment, @Nullable Indent childIndent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @Nullable JSBlock parentBlock) {
        IElementType childType;
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(15);
        }
        if ((childType = child.getElementType()) == JSElementTypes.BINARY_EXPRESSION) {
            JSBinaryExpressionBlock jSBinaryExpressionBlock = JSBlockContext.indentEachBinaryOperandSeparately(child, parentBlock) ? new JSBinaryExpressionBlock(child, childAlignment, Indent.getNoneIndent(), wrap, true, sharedAlignmentFactory, this) : new JSBinaryExpressionBlock(child, childAlignment, childIndent, wrap, false, sharedAlignmentFactory, this);
            if (jSBinaryExpressionBlock == null) {
                JSBlockContext.$$$reportNull$$$0(16);
            }
            return jSBinaryExpressionBlock;
        }
        if (childType == JSElementTypes.ARGUMENT_LIST) {
            JSBlock jSBlock = this.createParameterListBLock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory);
            if (jSBlock == null) {
                JSBlockContext.$$$reportNull$$$0(17);
            }
            return jSBlock;
        }
        ASTNode parent = child.getTreeParent();
        if (parent != null) {
            IElementType parentType = parent.getElementType();
            if (parentType == JSElementTypes.ARGUMENT_LIST) {
                if (childType != JSTokenTypes.LPAR && (childType != JSTokenTypes.RPAR || JSFormatterUtil.isEnterAtNewArgument(this.myFormattingMode, child)) && childType != JSTokenTypes.COMMA) {
                    JSBlock jSBlock = this.createParameterBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory);
                    if (jSBlock == null) {
                        JSBlockContext.$$$reportNull$$$0(18);
                    }
                    return jSBlock;
                }
            } else if ((parentType == JSElementTypes.REFERENCE_EXPRESSION || parentType == ES6ElementTypes.BIND_EXPRESSION) && JSBlock.CALL_CHAIN_DOT_LIKE_TYPES.contains(childType)) {
                JSDotBlock jSDotBlock = new JSDotBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
                if (jSDotBlock == null) {
                    JSBlockContext.$$$reportNull$$$0(19);
                }
                return jSDotBlock;
            }
        }
        JSBlock jSBlock = this.createDefaultBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory);
        if (jSBlock == null) {
            JSBlockContext.$$$reportNull$$$0(20);
        }
        return jSBlock;
    }

    private static boolean indentEachBinaryOperandSeparately(@NotNull ASTNode child, JSBlock parentBlock) {
        ASTNode parent;
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(21);
        }
        if ((parent = child.getTreeParent()) == null || parentBlock == null) {
            return false;
        }
        IElementType parentElementType = parent.getElementType();
        return parentElementType == JSStubElementTypes.RETURN_STATEMENT || parentElementType == JSElementTypes.ARGUMENT_LIST || parentElementType == JSElementTypes.PARENTHESIZED_EXPRESSION && !SubBlockVisitor.shouldIndentParenthesized(parent) || parentElementType == JSStubElementTypes.ASSIGNMENT_EXPRESSION || JSElementTypes.FUNCTION_EXPRESSIONS.contains(parentElementType) || JSStubElementTypes.PROPERTY == parentElementType || JSElementTypes.IF_STATEMENT == parentElementType || JSElementTypes.BODY_VARIABLES.contains(parentElementType) || parentElementType == JSElementTypes.CONDITIONAL_EXPRESSION && child != parent.getFirstChildNode();
    }

    @NotNull
    public JSSpacingStrategy createSpacingStrategy(@NotNull ASTNode node) {
        if (node == null) {
            JSBlockContext.$$$reportNull$$$0(22);
        }
        JSSpacingStrategy jSSpacingStrategy = new JSSpacingStrategy(this.myDialectSettings, this.getCommonSettings(), (child1, child2) -> {
            if (node == null) {
                JSBlockContext.$$$reportNull$$$0(34);
            }
            return this.createSpacingProcessor(node, (ASTNode)child1, (ASTNode)child2).calcSpacing();
        });
        if (jSSpacingStrategy == null) {
            JSBlockContext.$$$reportNull$$$0(23);
        }
        return jSSpacingStrategy;
    }

    @NotNull
    private JSSpacingProcessor createSpacingProcessor(ASTNode node, ASTNode child1, ASTNode child2) {
        JSSpacingProcessor jSSpacingProcessor = JSBlockContext.isTypedJSDialect(this.myDialect) ? new TypedJSSpacingProcessor(node, child1, child2, this.getTopSettings(), this.getDialect(), this.myDialectSettings) : new JSSpacingProcessor(node, child1, child2, this.getTopSettings(), this.getDialect(), this.myDialectSettings);
        if (jSSpacingProcessor == null) {
            JSBlockContext.$$$reportNull$$$0(24);
        }
        return jSSpacingProcessor;
    }

    @NotNull
    public SubBlockVisitor createSubBlockVisitor(@NotNull JSBlock parentBlock, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory) {
        if (parentBlock == null) {
            JSBlockContext.$$$reportNull$$$0(25);
        }
        SubBlockVisitor subBlockVisitor = JSBlockContext.isTypedJSDialect(this.myDialect) ? new TypedJSSubBlockVisitor(parentBlock, alignmentFactory, this) : new SubBlockVisitor(parentBlock, alignmentFactory, this);
        if (subBlockVisitor == null) {
            JSBlockContext.$$$reportNull$$$0(26);
        }
        return subBlockVisitor;
    }

    @NotNull
    private JSBlock createParameterListBLock(@NotNull ASTNode child, @Nullable Alignment childAlignment, @Nullable Indent childIndent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(27);
        }
        JSParameterListBlock jSParameterListBlock = new JSParameterListBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
        if (jSParameterListBlock == null) {
            JSBlockContext.$$$reportNull$$$0(28);
        }
        return jSParameterListBlock;
    }

    @NotNull
    private JSBlock createParameterBlock(@NotNull ASTNode child, @Nullable Alignment childAlignment, @Nullable Indent childIndent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(29);
        }
        JSParameterBlock jSParameterBlock = new JSParameterBlock(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
        if (jSParameterBlock == null) {
            JSBlockContext.$$$reportNull$$$0(30);
        }
        return jSParameterBlock;
    }

    @NotNull
    private JSBlock createDefaultBlock(@NotNull ASTNode child, @Nullable Alignment childAlignment, @Nullable Indent childIndent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        if (child == null) {
            JSBlockContext.$$$reportNull$$$0(31);
        }
        JSBlockEx jSBlockEx = new JSBlockEx(child, childAlignment, childIndent, wrap, sharedAlignmentFactory, this);
        if (jSBlockEx == null) {
            JSBlockContext.$$$reportNull$$$0(32);
        }
        return jSBlockEx;
    }

    private static boolean isTypedJSDialect(@NotNull Language dialect) {
        if (dialect == null) {
            JSBlockContext.$$$reportNull$$$0(33);
        }
        return dialect == JavaScriptSupportLoader.FLOW_JS || dialect.isKindOf((Language)JavaScriptSupportLoader.TYPESCRIPT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topSettings";
                break;
            }
            case 1: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingMode";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSBlockContext";
                break;
            }
            case 10: 
            case 15: 
            case 21: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 22: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSBlockContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefault";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormattingMode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialectSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlock";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubBlock";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpacingStrategy";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpacingProcessor";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createSubBlockVisitor";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterListBLock";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createParameterBlock";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDefault";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createBlock";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createSubBlock";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "indentEachBinaryOperandSeparately";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createSpacingStrategy";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createSubBlockVisitor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createParameterListBLock";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createParameterBlock";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBlock";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isTypedJSDialect";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createSpacingStrategy$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 30: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSDotBlock
    extends JSBlockEx
    implements CallChainDotBlock {
        public JSDotBlock(@NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Indent indent, @Nullable Wrap wrap, @Nullable ASTNodeBasedAlignmentFactory sharedAlignmentFactory, @NotNull JSBlockContext jsBlockContext) {
            if (node == null) {
                JSDotBlock.$$$reportNull$$$0(0);
            }
            if (jsBlockContext == null) {
                JSDotBlock.$$$reportNull$$$0(1);
            }
            super(node, alignment, indent, wrap, sharedAlignmentFactory, jsBlockContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jsBlockContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/formatter/JSBlockContext$JSDotBlock";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

