/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.formatting.FormattingModelProvider;
import com.intellij.formatting.WrapType;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlPolicy;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavascriptFormattingModelBuilder
implements FormattingModelBuilderEx {
    public static final Key<Alignment> BLOCK_ALIGNMENT = Key.create((String)"js.block.alignment");

    public static FormattingModel createJSFormattingModel(PsiFile file2, CodeStyleSettings settings, Block rootBlock) {
        Document document = FormattingDocumentModelImpl.getDocumentToBeUsedFor((PsiFile)file2);
        if (document != null && FormattingDocumentModelImpl.canUseDocumentModel((Document)document, (PsiFile)file2) && file2 instanceof JSFile && file2.getContext() == null) {
            return new DocumentBasedFormattingModel(rootBlock, file2.getProject(), settings, file2.getFileType(), file2);
        }
        return FormattingModelProvider.createFormattingModelForPsiFile((PsiFile)file2, (Block)rootBlock, (CodeStyleSettings)settings);
    }

    @NotNull
    public FormattingModel createModel(@NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (element == null) {
            JavascriptFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            JavascriptFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        if (mode == null) {
            JavascriptFormattingModelBuilder.$$$reportNull$$$0(2);
        }
        Language dialect = JSLanguageUtil.getLanguageDialect(element);
        Alignment alignment = (Alignment)element.getNode().getUserData(BLOCK_ALIGNMENT);
        JSBlockContext jsBlockContext = this.createBlockFactory(settings, dialect, mode);
        Block rootBlock = jsBlockContext.createBlock(element.getNode(), null, alignment, null, null, null);
        FormattingModel formattingModel = JavascriptFormattingModelBuilder.createJSFormattingModel(element.getContainingFile(), settings, rootBlock);
        XmlFormattingPolicy xmlFormattingPolicy = JavascriptFormattingModelBuilder.getPolicy(element, settings, formattingModel.getDocumentModel());
        jsBlockContext.setXmlFormattingPolicy(xmlFormattingPolicy);
        FormattingModel formattingModel2 = formattingModel;
        if (formattingModel2 == null) {
            JavascriptFormattingModelBuilder.$$$reportNull$$$0(3);
        }
        return formattingModel2;
    }

    @NotNull
    public FormattingModel createModel(PsiElement element, CodeStyleSettings settings) {
        FormattingModel formattingModel = this.createModel(element, settings, FormattingMode.REFORMAT);
        if (formattingModel == null) {
            JavascriptFormattingModelBuilder.$$$reportNull$$$0(4);
        }
        return formattingModel;
    }

    @NotNull
    protected JSBlockContext createBlockFactory(CodeStyleSettings settings, Language dialect, FormattingMode mode) {
        JSBlockContext jSBlockContext = new JSBlockContext(settings, dialect, null, mode);
        if (jSBlockContext == null) {
            JavascriptFormattingModelBuilder.$$$reportNull$$$0(5);
        }
        return jSBlockContext;
    }

    @NotNull
    private static XmlFormattingPolicy getPolicy(PsiElement element, CodeStyleSettings settings, FormattingDocumentModel model) {
        Object object = DialectDetector.isJSX(element) ? new HtmlPolicy(settings, model){

            public WrapType getWrappingTypeForTagBegin(XmlTag tag) {
                PsiElement parent = tag.getParent();
                if (JavascriptFormattingModelBuilder.isRestrictedProduction(parent)) {
                    return WrapType.NONE;
                }
                if (!(parent instanceof XmlTag)) {
                    return WrapType.NORMAL;
                }
                if (JavascriptFormattingModelBuilder.newlineProhibitedBefore((PsiElement)tag)) {
                    return WrapType.NONE;
                }
                return super.getWrappingTypeForTagBegin(tag);
            }

            public boolean indentChildrenOf(XmlTag parentTag) {
                if (parentTag != null && parentTag.getName().isEmpty()) {
                    return true;
                }
                return super.indentChildrenOf(parentTag);
            }

            public boolean allowWrapBeforeText() {
                return false;
            }

            public boolean insertLineBreakBeforeTag(XmlTag xmlTag) {
                return false;
            }

            protected boolean isInlineTag(XmlTag tag) {
                return StringUtil.isCapitalized((String)tag.getName()) || super.isInlineTag(tag);
            }
        } : new XmlPolicy(settings, model){

            public WrapType getWrappingTypeForTagBegin(XmlTag tag) {
                if (!(tag.getParent() instanceof XmlTag)) {
                    return WrapType.NORMAL;
                }
                return super.getWrappingTypeForTagBegin(tag);
            }
        };
        if (object == null) {
            JavascriptFormattingModelBuilder.$$$reportNull$$$0(6);
        }
        return object;
    }

    @Nullable
    public CommonCodeStyleSettings.IndentOptions getIndentOptionsToUse(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges, @NotNull CodeStyleSettings settings) {
        if (file2 == null) {
            JavascriptFormattingModelBuilder.$$$reportNull$$$0(7);
        }
        if (ranges == null) {
            JavascriptFormattingModelBuilder.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            JavascriptFormattingModelBuilder.$$$reportNull$$$0(9);
        }
        return null;
    }

    private static boolean newlineProhibitedBefore(PsiElement tag) {
        PsiElement prevSibling = tag.getPrevSibling();
        return prevSibling instanceof PsiWhiteSpace && prevSibling.getPrevSibling() instanceof XmlText;
    }

    private static boolean isRestrictedProduction(@Nullable PsiElement parent) {
        return parent instanceof JSReturnStatement || parent instanceof JSYieldExpression || parent instanceof JSThrowStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JavascriptFormattingModelBuilder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIndentOptionsToUse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

