/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks.alignment;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.FormattingMode;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSConditionalExpressionAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.LineCommentAlignmentFactory;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLocalAlignmentFactory
implements ASTNodeBasedAlignmentFactory {
    private final CommonCodeStyleSettings mySettings;
    private final FormattingMode myFormattingMode;
    private final Alignment myLocalAlignment;
    private final LineCommentAlignmentFactory myLineCommentAlignmentFactory;
    private final JSConditionalExpressionAlignmentFactory myJSConditionalExpressionAlignmentFactory;
    private ASTNodeBasedAlignmentFactory mySharedAlignmentFactory;

    public JSLocalAlignmentFactory(@NotNull CommonCodeStyleSettings settings, FormattingMode formattingMode) {
        if (settings == null) {
            JSLocalAlignmentFactory.$$$reportNull$$$0(0);
        }
        this.mySettings = settings;
        this.myFormattingMode = formattingMode;
        CommonCodeStyleSettings.IndentOptions indentOptions = this.mySettings.getIndentOptions();
        assert (indentOptions != null);
        this.myLocalAlignment = Alignment.createAlignment();
        this.myLineCommentAlignmentFactory = new LineCommentAlignmentFactory(this.mySettings);
        this.myJSConditionalExpressionAlignmentFactory = new JSConditionalExpressionAlignmentFactory(this.mySettings, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
    }

    @Nullable
    protected Alignment getAlignment(@NotNull ASTNode parent, @NotNull ASTNode child) {
        Alignment eolCommentAlignment;
        if (parent == null) {
            JSLocalAlignmentFactory.$$$reportNull$$$0(1);
        }
        if (child == null) {
            JSLocalAlignmentFactory.$$$reportNull$$$0(2);
        }
        IElementType childType = child.getElementType();
        IElementType parentType = parent.getElementType();
        if (childType == JSTokenTypes.END_OF_LINE_COMMENT && (eolCommentAlignment = this.myLineCommentAlignmentFactory.getAlignment(child)) != null) {
            return eolCommentAlignment;
        }
        if (parentType == JSElementTypes.FOR_STATEMENT && this.mySettings.ALIGN_MULTILINE_FOR && (JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(childType) || JSElementTypes.VAR_STATEMENTS.contains(childType))) {
            return this.myLocalAlignment;
        }
        if (JSElementTypes.PARAMETER_LISTS.contains(parentType) && this.mySettings.ALIGN_MULTILINE_PARAMETERS && (JSExtendedLanguagesTokenSetProvider.PARAMETERS.contains(childType) || JSTokenTypes.COMMENTS.contains(childType) || JSFormatterUtil.isEnterAtNewArgument(this.myFormattingMode, child))) {
            return this.myLocalAlignment;
        }
        if (parentType == JSElementTypes.CONDITIONAL_EXPRESSION) {
            return this.myJSConditionalExpressionAlignmentFactory.getAlignment(child);
        }
        if (JSElementTypes.EXTENDS_IMPLEMENTS_LISTS.contains(parentType) && this.mySettings.ALIGN_MULTILINE_EXTENDS_LIST && JSStubElementTypes.EXTENDS_LIST_MEMBER == childType) {
            return this.myLocalAlignment;
        }
        if (parentType == JSElementTypes.PARENTHESIZED_EXPRESSION && this.mySettings.ALIGN_MULTILINE_PARENTHESIZED_EXPRESSION) {
            return this.myLocalAlignment;
        }
        if (parentType == JSElementTypes.ARRAY_LITERAL_EXPRESSION && this.mySettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION && JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(childType)) {
            return this.myLocalAlignment;
        }
        return null;
    }

    public Alignment getLocalAlignment() {
        return this.myLocalAlignment;
    }

    @Override
    public final Alignment getAlignment(@NotNull ASTNode child) {
        Alignment alignment;
        ASTNode parent;
        if (child == null) {
            JSLocalAlignmentFactory.$$$reportNull$$$0(3);
        }
        if ((parent = child.getTreeParent()) != null && (alignment = this.getAlignment(parent, child)) != null) {
            return alignment;
        }
        if (this.mySharedAlignmentFactory != null) {
            return this.mySharedAlignmentFactory.getAlignment(child);
        }
        return null;
    }

    public void setSharedAlignmentFactory(ASTNodeBasedAlignmentFactory sharedAlignmentFactory) {
        this.mySharedAlignmentFactory = sharedAlignmentFactory;
    }

    public ASTNodeBasedAlignmentFactory getSharedAlignmentFactory() {
        return this.mySharedAlignmentFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/alignment/JSLocalAlignmentFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAlignment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

