/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.lang.javascript.frameworks.webpack.Webpack4PluginSchemaProvider;
import com.intellij.lang.javascript.json.JsonSchemaInJavaScriptProvider;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Webpack4PluginProviderRegistrar
extends AbstractProjectComponent {
    private static final List<String> pluginNames = ContainerUtil.newArrayList();

    protected Webpack4PluginProviderRegistrar(Project project) {
        super(project);
    }

    public void initComponent() {
        Webpack4PluginProviderRegistrar.registerPluginSchemas();
    }

    private static void registerPluginSchemas() {
        ExtensionsArea area = Extensions.getRootArea();
        ExtensionPoint extensionPoint = area.getExtensionPoint(JsonSchemaInJavaScriptProvider.EP_NAME);
        JsonSchemaInJavaScriptProvider[] extensions = (JsonSchemaInJavaScriptProvider[])extensionPoint.getExtensions();
        Set existingPlugins = Arrays.stream(extensions).filter(e -> e instanceof Webpack4PluginSchemaProvider).map(e -> ((Webpack4PluginSchemaProvider)e).getPluginQualifiedName()).collect(Collectors.toSet());
        for (String name : pluginNames) {
            if (existingPlugins.contains(name)) continue;
            extensionPoint.registerExtension((Object)new Webpack4PluginSchemaProvider(name));
        }
    }

    static {
        pluginNames.add("BannerPlugin");
        pluginNames.add("DllPlugin");
        pluginNames.add("DllReferencePlugin");
        pluginNames.add("HashedModuleIdsPlugin");
        pluginNames.add("LoaderOptionsPlugin");
        pluginNames.add("SourceMapDevToolPlugin");
        pluginNames.add("WatchIgnorePlugin");
        pluginNames.add("debug.ProfilingPlugin");
        pluginNames.add("optimize.AggressiveSplittingPlugin");
        pluginNames.add("optimize.LimitChunkCountPlugin");
        pluginNames.add("optimize.MinChunkSizePlugin");
    }
}

