/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.codeInsight.template.Template;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.ActionScriptEventDispatchUtils;
import com.intellij.lang.javascript.generation.BaseJSGenerateAction;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.BindablePropertiesForm;
import com.intellij.lang.javascript.generation.EventBinder;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSGetterSetterGenerationMode;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.refactoring.JSChangeVisibilityUtil;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSVariableIntentionAction;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaScriptGenerateAccessorHandler
extends BaseJSGenerateHandler {
    public static final String FLASH_EVENT_FQN = "flash.events.Event";
    public static final String PARAMETER_NAME = "value";
    private final JSGetterSetterGenerationMode myMode;
    private JCheckBox myMakePrivate;
    private BindablePropertiesForm myBindablePropertiesForm;

    public JavaScriptGenerateAccessorHandler(JSGetterSetterGenerationMode mode, boolean skipMemberChooserDialog) {
        super(skipMemberChooserDialog);
        this.myMode = mode;
    }

    public JavaScriptGenerateAccessorHandler(JSGetterSetterGenerationMode mode) {
        this.myMode = mode;
    }

    @Override
    protected String getTitleKey() {
        return this.myMode == JSGetterSetterGenerationMode.Getter ? "generate.getter.fields.chooser.title" : (this.myMode == JSGetterSetterGenerationMode.Setter ? "generate.setter.fields.chooser.title" : "generate.getter.setter.chooser.title");
    }

    @Override
    protected String getNoCandidatesMessage() {
        return this.myMode == JSGetterSetterGenerationMode.Getter ? JSBundle.message((String)"no.variables.for.getter", (Object[])new Object[0]) : (this.myMode == JSGetterSetterGenerationMode.Setter ? JSBundle.message((String)"no.variables.for.setter", (Object[])new Object[0]) : JSBundle.message((String)"no.variables.for.getter.setter", (Object[])new Object[0]));
    }

    @Override
    @Nullable
    protected JComponent getOptionsComponent(PsiElement jsClass, Collection<JSChooserElementNode> candidates) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            for (JSChooserElementNode candidate : candidates) {
                JSAttributeList attrList;
                PsiElement element = candidate.getPsiElement();
                if (!(element instanceof JSVariable) || (attrList = ((JSVariable)element).getAttributeList()) != null && attrList.getAccessType() == JSAttributeList.AccessType.PRIVATE) continue;
                this.myMakePrivate = new JCheckBox("Make private", true);
                this.myMakePrivate.setFocusable(false);
                this.myMakePrivate.setMnemonic('M');
                break;
            }
            if (jsClass instanceof JSClass && ActionScriptEventDispatchUtils.isEventDispatcher((JSClass)jsClass)) {
                this.myBindablePropertiesForm = new BindablePropertiesForm(jsClass.getProject(), this.myMode == JSGetterSetterGenerationMode.Setter || this.myMode == JSGetterSetterGenerationMode.GetterAndSetter);
                if (this.myMakePrivate != null) {
                    JPanel panel = new JPanel(new BorderLayout());
                    panel.add((Component)this.myBindablePropertiesForm.getMainPanel(), "Center");
                    panel.add((Component)this.myMakePrivate, "South");
                    return panel;
                }
                return this.myBindablePropertiesForm.getMainPanel();
            }
        }
        return this.myMakePrivate;
    }

    @Override
    protected BaseCreateMembersFix<JSNamedElement> createFix(final PsiElement jsClass) {
        boolean makePrivate;
        final EventBinder eventBinder = ApplicationManager.getApplication().isUnitTestMode() ? ActionScriptEventDispatchUtils.createTestEventBinder((JSClass)jsClass) : this.myBindablePropertiesForm;
        boolean bl = makePrivate = this.myMakePrivate == null || this.myMakePrivate.isSelected();
        if (this.myMode == JSGetterSetterGenerationMode.GetterAndSetter) {
            return new BaseCreateMembersFix<JSNamedElement>((PsiElement)((JSClass)jsClass)){
                final MyBaseCreateMethodsFix generateGetterFix;
                final MyBaseCreateMethodsFix generateSetterFix;
                {
                    super(jsClass2);
                    this.generateGetterFix = new MyBaseCreateMethodsFix(JSGetterSetterGenerationMode.Getter, (JSClass)jsClass, eventBinder, makePrivate, null);
                    this.generateSetterFix = new MyBaseCreateMethodsFix(JSGetterSetterGenerationMode.Setter, (JSClass)jsClass, eventBinder, makePrivate, null);
                }

                @Override
                public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.evalAnchor(editor, file2);
                    for (JSNamedElement e : this.getElementsToProcess()) {
                        this.generateGetterFix.fixName(e);
                        this.anchor = this.doAddOneMethod(project, this.generateGetterFix.buildFunctionText(e, null), this.anchor);
                        this.anchor = this.doAddOneMethod(project, this.generateSetterFix.buildFunctionText(e, null), this.anchor);
                    }
                    this.generateSetterFix.createEventConstantAndImportEventIfNeeded(project, editor, this.anchor, this.getElementsToProcess());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$1", "invoke"));
                }
            };
        }
        return new MyBaseCreateMethodsFix(this.myMode, (JSClass)jsClass, eventBinder, makePrivate, null);
    }

    @Override
    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
        boolean skipVarsThatHaveGetters = this.myMode == JSGetterSetterGenerationMode.Getter || this.myMode == JSGetterSetterGenerationMode.GetterAndSetter;
        boolean skipVarsThatHaveSetters = this.myMode == JSGetterSetterGenerationMode.Setter || this.myMode == JSGetterSetterGenerationMode.GetterAndSetter;
        JavaScriptGenerateAccessorHandler.collectJSVariables(clazz, candidates, skipVarsThatHaveGetters, skipVarsThatHaveSetters, false, !(clazz instanceof ES6Class), true, this.myMode != JSGetterSetterGenerationMode.Getter, true);
    }

    @Override
    protected boolean isValidForTarget(PsiElement jsClass) {
        return BaseJSGenerateAction.isClassWithMembersToGenerate(jsClass);
    }

    private static boolean equalsIgnoreQuotes(String newName, String varName) {
        if (newName == null || varName == null) {
            return false;
        }
        if (newName.equals(varName)) {
            return true;
        }
        if ((newName.startsWith("'") || newName.startsWith("\"")) && (varName.startsWith("'") || varName.startsWith("\""))) {
            return newName.substring(1, newName.length() - 1).equals(varName.substring(1, varName.length() - 1));
        }
        return false;
    }

    public static class MyBaseCreateMethodsFix
    extends BaseCreateMembersFix<JSNamedElement> {
        private static final Key<String> ACCESSOR_NAME = Key.create((String)"JavaScript.Accessor.Forced.Name");
        private static final Key<String> INNER_FIELD_NAME = Key.create((String)"JavaScript.Accessor.Forced.Inner.Name");
        private final JSGetterSetterGenerationMode myMode;
        @Nullable
        private final EventBinder myEventBinder;
        private final boolean myMakePrivate;
        private final JSCodeStyleSettings codeStyleSettings;
        @Nullable
        private final String myQualifier;

        public MyBaseCreateMethodsFix(JSGetterSetterGenerationMode mode, JSClass jsClass, @Nullable EventBinder eventBinder, boolean makePrivate, @Nullable String qualifier) {
            super((PsiElement)jsClass);
            this.myMode = mode;
            this.myEventBinder = eventBinder;
            this.myMakePrivate = makePrivate;
            if (qualifier == null) {
                qualifier = JSClassUtils.getDefaultFieldQualifier((PsiElement)jsClass, false);
            }
            this.myQualifier = qualifier;
            this.codeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)jsClass);
        }

        @Override
        public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
            if (project == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(0);
            }
            super.invoke(project, editor, file2);
            this.createEventConstantAndImportEventIfNeeded(project, editor, this.anchor, this.getElementsToProcess());
        }

        private void createEventConstantAndImportEventIfNeeded(Project project, Editor editor, PsiElement importContext, Collection<JSNamedElement> variables) {
            if ((this.myMode == JSGetterSetterGenerationMode.Setter || this.myMode == JSGetterSetterGenerationMode.GetterAndSetter) && this.myEventBinder != null && this.myEventBinder.isBindEvent()) {
                ImportUtils.importAndShortenReference(JavaScriptGenerateAccessorHandler.FLASH_EVENT_FQN, importContext, true, false);
                if (this.myEventBinder.isCreateEventConstant()) {
                    this.createEventConstant(project, editor, variables);
                }
            }
        }

        private void createEventConstant(final Project project, final Editor editor, Collection<JSNamedElement> variables) {
            assert (this.myEventBinder != null);
            ArrayList<Pair> varNameAndAccessorNameList = new ArrayList<Pair>(variables.size());
            for (JSNamedElement variable : variables) {
                varNameAndAccessorNameList.add(Pair.create((Object)variable.getName(), (Object)this.buildName(variable)));
            }
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            for (Pair varNameAndAccessorName : varNameAndAccessorNameList) {
                JSFunction jsFunction;
                PsiElement eventConstantIdentifier;
                String eventName = this.myEventBinder.getEventName((String)varNameAndAccessorName.first);
                String eventConstantName = this.myEventBinder.getEventConstantName((String)varNameAndAccessorName.first);
                if (this.myJsClass instanceof XmlBackedJSClassImpl) {
                    ((XmlBackedJSClassImpl)this.myJsClass).clearCaches();
                }
                if ((eventConstantIdentifier = MyBaseCreateMethodsFix.findEventConstantIdentifier((PsiElement)(jsFunction = ((JSClass)this.myJsClass).findFunctionByNameAndKind((String)varNameAndAccessorName.second, JSFunction.FunctionKind.SETTER)), eventConstantName)) == null || !eventConstantIdentifier.isValid()) continue;
                final String constantDeclaration = MessageFormat.format("public static const {0}:String = \"{1}\";", eventConstantName, eventName);
                new CreateJSVariableIntentionAction(eventConstantName, true, true, false){

                    @Override
                    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, @NotNull PsiElement anchorParent) {
                        if (anchorParent == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        template.addTextSegment(constantDeclaration);
                    }

                    public void apply(PsiElement psiElement) {
                        this.applyFix(project, psiElement, psiElement.getContainingFile(), editor);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchorParent", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix$1", "buildTemplate"));
                    }
                }.apply(eventConstantIdentifier);
            }
        }

        @Override
        protected boolean shouldHandleNoTypeAsAnyType() {
            return true;
        }

        private static PsiElement findEventConstantIdentifier(PsiElement psiElement, final String eventConstantName) {
            final Ref elementRef = new Ref();
            PsiTreeUtil.processElements((PsiElement)psiElement, (PsiElementProcessor)new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (element instanceof JSReferenceExpression && element.getText().equals(eventConstantName)) {
                        elementRef.set((Object)element);
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix$2", "execute"));
                }
            });
            return (PsiElement)elementRef.get();
        }

        @Override
        protected String buildFunctionBodyText(String retType, JSParameterList parameterList, JSNamedElement func) {
            String semicolon = this.codeStyleSettings.USE_SEMICOLON_AFTER_STATEMENT ? ";" : "";
            String innerFieldName = (String)func.getUserData(INNER_FIELD_NAME);
            String varName = innerFieldName != null ? innerFieldName : JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)func, false);
            if (this.myMode == JSGetterSetterGenerationMode.Setter) {
                String checkNeedEvent = null;
                String dispatchEvent = null;
                if (this.myEventBinder != null && this.myEventBinder.isBindEvent()) {
                    String quotedEventNameOrConstant = this.myEventBinder.isCreateEventConstant() ? this.myEventBinder.getEventConstantName(varName) : "\"" + this.myEventBinder.getEventName(varName) + "\"";
                    dispatchEvent = "\ndispatchEvent(new Event(" + quotedEventNameOrConstant + "))" + semicolon;
                    checkNeedEvent = "if(" + varName + "==" + JavaScriptGenerateAccessorHandler.PARAMETER_NAME + ") return" + semicolon + "\n";
                }
                return new JSFunctionsRefactoringUtil.AccessorsGenerator(this.myJsClass, StringUtil.notNullize((String)varName)).setter().setQualifier(this.myQualifier).setNamedElement(func).setBeforeText(checkNeedEvent).setAfterText(dispatchEvent).generate();
            }
            if (this.myMode == JSGetterSetterGenerationMode.Getter) {
                return new JSFunctionsRefactoringUtil.AccessorsGenerator(this.myJsClass, StringUtil.notNullize((String)varName)).setQualifier(this.myQualifier).setNamedElement(func).generate();
            }
            return " {}";
        }

        @Override
        protected void adjustAttributeList(JSAttributeListWrapper attributeListWrapper, JSNamedElement function) {
            JSAttributeList.AccessType accessType;
            JSAttributeList list;
            String accessorName;
            JSFunction pairAccessor;
            attributeListWrapper.overrideAccessType(JSAttributeList.AccessType.PUBLIC);
            attributeListWrapper.overrideModifier(JSAttributeList.ModifierType.READONLY, false);
            attributeListWrapper.removeOriginalAttributes();
            if (!DialectDetector.isActionScript((PsiElement)function)) {
                attributeListWrapper.removeAccessModifier();
            }
            if (this.myMode == JSGetterSetterGenerationMode.Getter && this.myEventBinder != null && this.myEventBinder.isBindEvent()) {
                attributeListWrapper.addAttribute("Bindable", "event", this.myEventBinder.getEventName(function.getName()));
            }
            if ((this.myMode == JSGetterSetterGenerationMode.Getter || this.myMode == JSGetterSetterGenerationMode.Setter) && this.myJsClass instanceof JSClass && (pairAccessor = ((JSClass)this.myJsClass).findFunctionByNameAndKind(accessorName = JSRefactoringUtil.transformVarNameToAccessorName(function.getName(), this.codeStyleSettings), this.myMode == JSGetterSetterGenerationMode.Getter ? JSFunction.FunctionKind.SETTER : JSFunction.FunctionKind.GETTER)) != null && (list = pairAccessor.getAttributeList()) != null && (accessType = list.getAccessType()) != JSAttributeList.AccessType.PUBLIC) {
                attributeListWrapper.overrideAccessType(accessType);
            }
        }

        @Override
        protected String buildFunctionKind(JSNamedElement fun) {
            if (this.myMode == JSGetterSetterGenerationMode.Getter) {
                return "get ";
            }
            if (this.myMode == JSGetterSetterGenerationMode.Setter) {
                return "set ";
            }
            return super.buildFunctionKind(fun);
        }

        @Override
        protected String buildReturnType(String typeString) {
            if (this.myMode == JSGetterSetterGenerationMode.Setter) {
                return DialectDetector.isActionScript(this.myJsClass) ? "void" : null;
            }
            return super.buildReturnType(typeString);
        }

        public void findOrCreateConstructorPropertyBindVariable(@NotNull JSParameter parameter) {
            JSStatement[] body;
            String parameterName;
            if (parameter == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(1);
            }
            if ((parameterName = parameter.getName()) == null) {
                return;
            }
            String accessorName = JSRefactoringUtil.transformVarNameToAccessorName(parameterName, this.codeStyleSettings);
            parameter.putUserData(ACCESSOR_NAME, (Object)accessorName);
            if (DialectDetector.isTypeScript((PsiElement)parameter)) {
                if (accessorName.equals(parameterName)) {
                    this.renameVariable((JSNamedElement)parameter, parameterName);
                }
                return;
            }
            JSFunction function = parameter.getDeclaringFunction();
            String innerFieldName = this.codeStyleSettings.FIELD_PREFIX + accessorName;
            parameter.putUserData(INNER_FIELD_NAME, (Object)innerFieldName);
            String nameAccess = StringUtil.notNullize((String)JSClassUtils.getDefaultFieldQualifier((PsiElement)function, true)) + innerFieldName;
            JSBlockStatement block = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function, JSBlockStatement.class);
            if (block == null) {
                return;
            }
            for (JSStatement element : body = block.getStatements()) {
                JSReferenceExpression reference;
                JSAssignmentExpression assignment;
                JSDefinitionExpression definitionExpression;
                if (!(element instanceof JSExpressionStatement) || !(((JSExpressionStatement)element).getExpression() instanceof JSAssignmentExpression) || (definitionExpression = (assignment = (JSAssignmentExpression)((JSExpressionStatement)element).getExpression()).getDefinitionExpression()) == null || !(definitionExpression.getExpression() instanceof JSReferenceExpression) || !((reference = (JSReferenceExpression)definitionExpression.getExpression()).getQualifier() instanceof JSThisExpression) || !parameterName.equals(definitionExpression.getInitializerReference())) continue;
                if (innerFieldName.equals(definitionExpression.getName())) {
                    return;
                }
                if (!parameterName.equals(definitionExpression.getName())) continue;
                this.renameInnerPropUsages(reference, innerFieldName);
                block.deleteChildRange((PsiElement)element, (PsiElement)element);
            }
            body = block.getStatements();
            String assignmentText = nameAccess + "=" + parameterName + JSCodeStyleSettings.getSemicolon((PsiElement)function.getContainingFile());
            PsiElement psiToInsert = JSChangeUtil.createStatementFromText(function.getProject(), assignmentText).getPsi();
            if (body.length == 0) {
                block.add(psiToInsert);
            } else {
                block.addAfter(psiToInsert, (PsiElement)body[body.length - 1]);
            }
        }

        private void renameInnerPropUsages(@NotNull JSReferenceExpression reference, @NotNull String newName) {
            PsiElement resolvedProperty;
            if (reference == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(2);
            }
            if (newName == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(3);
            }
            if (!((resolvedProperty = reference.resolve()) instanceof JSDefinitionExpression)) {
                return;
            }
            PsiElement dummy = ((JSDefinitionExpression)resolvedProperty.copy()).setName(newName);
            assert (dummy != null);
            for (PsiReference ref : ReferencesSearch.search((PsiElement)resolvedProperty, (SearchScope)GlobalSearchScope.fileScope((PsiFile)reference.getContainingFile())).findAll()) {
                if (JSResolveUtil.getClassOfContext(ref.getElement()) != this.myJsClass || ref.getElement() == reference) continue;
                ref.bindToElement(dummy);
            }
        }

        private void renameInIndexAccessExpression(@NotNull JSDefinitionExpression definition) {
            if (definition == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(4);
            }
            if (!BaseJSGenerateHandler.indexedPropertyAccessCheck((JSNamedElementBase)definition, (PairProcessor<String, String>)((PairProcessor)(existing, future) -> {
                if (definition == null) {
                    MyBaseCreateMethodsFix.$$$reportNull$$$0(11);
                }
                definition.putUserData(INNER_FIELD_NAME, existing);
                definition.putUserData(ACCESSOR_NAME, future);
                return false;
            }))) {
                return;
            }
            definition.putUserData(ACCESSOR_NAME, (Object)JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)definition, false));
            JSExpression expression = definition.getExpression();
            if (expression instanceof JSReferenceExpression) {
                JSReferenceExpression reference = (JSReferenceExpression)expression;
                assert (reference.getQualifier() != null);
                JSReferenceExpression copy = (JSReferenceExpression)JSChangeUtil.createExpressionFromText(definition.getProject(), reference.getQualifier().getText() + "." + this.codeStyleSettings.FIELD_PREFIX + reference.getReferenceNameElement()).getPsi(JSReferenceExpression.class);
                this.rebindUsages((JSExpression)copy, expression);
                reference.replace((JSExpression)copy);
            } else if (expression instanceof JSIndexedPropertyAccessExpression) {
                String copyText;
                JSIndexedPropertyAccessExpression indexedAcc = (JSIndexedPropertyAccessExpression)expression;
                JSExpression indexed = indexedAcc.getIndexExpression();
                if (indexed instanceof JSLiteralExpression && ((JSLiteralExpression)indexed).isQuotedLiteral()) {
                    Convertor wrap = str -> this.codeStyleSettings.USE_DOUBLE_QUOTES ? "[\"" + str + "\"]" : "['" + str + "']";
                    String text = StringUtil.notNullize((String)((JSLiteralExpression)indexed).getStringValue());
                    if (text.startsWith("_")) {
                        definition.putUserData(ACCESSOR_NAME, wrap.convert((Object)text.substring(1)));
                        definition.putUserData(INNER_FIELD_NAME, wrap.convert((Object)text));
                        return;
                    }
                    String innerPropText = (String)wrap.convert((Object)("_" + text));
                    definition.putUserData(INNER_FIELD_NAME, (Object)innerPropText);
                    definition.putUserData(ACCESSOR_NAME, wrap.convert((Object)text));
                    copyText = indexedAcc.getQualifier().getText() + innerPropText;
                } else {
                    String prefix = this.codeStyleSettings.USE_DOUBLE_QUOTES ? "\"_\"" : "'_'";
                    boolean parenthesis = !(indexed instanceof JSReferenceExpression);
                    String innerText = parenthesis ? "(" + indexed.getText() + ")" : indexed.getText();
                    String newIndexed = prefix + " + " + innerText;
                    copyText = indexedAcc.getQualifier().getText() + "[" + newIndexed + "]";
                }
                JSIndexedPropertyAccessExpression copy = (JSIndexedPropertyAccessExpression)JSChangeUtil.createExpressionFromText(definition.getProject(), copyText).getPsi(JSIndexedPropertyAccessExpression.class);
                this.rebindUsages((JSExpression)copy, expression);
                indexedAcc.replace((JSExpression)copy);
            }
        }

        private void rebindUsages(@NotNull JSExpression copy, @NotNull JSExpression expression) {
            if (copy == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(5);
            }
            if (expression == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(6);
            }
            JSExpressionStatement definition = (JSExpressionStatement)JSChangeUtil.createStatementFromText(expression.getProject(), copy.getText() + "=1").getPsi(JSExpressionStatement.class);
            JSExpression assignment = definition.getExpression();
            assert (assignment instanceof JSAssignmentExpression);
            JSChangeUtil.rebindVariableUsages((PsiElement)expression, (PsiElement)((JSAssignmentExpression)assignment).getDefinitionExpression(), this.myJsClass);
        }

        @Override
        protected void fixName(JSNamedElement jsVariable) {
            String varName;
            if (jsVariable instanceof JSDefinitionExpression && ((JSDefinitionExpression)jsVariable).getExpression() instanceof JSIndexedPropertyAccessExpression) {
                this.renameInIndexAccessExpression((JSDefinitionExpression)jsVariable);
                return;
            }
            if (jsVariable instanceof JSParameter && this.myJsClass instanceof ES6Class) {
                this.findOrCreateConstructorPropertyBindVariable((JSParameter)jsVariable);
                return;
            }
            String newName = JSRefactoringUtil.transformVarNameToAccessorName(super.buildName(jsVariable), this.codeStyleSettings);
            String variableName = jsVariable.getName();
            String string = varName = variableName == null ? null : JSSymbolUtil.handleSpecialPropertyNames(variableName, JSCodeStyleSettings.getQuoteChar(this.myJsClass));
            if (JavaScriptGenerateAccessorHandler.equalsIgnoreQuotes(newName, varName) && this.codeStyleSettings.FIELD_PREFIX.length() > 0 && !varName.startsWith(this.codeStyleSettings.FIELD_PREFIX)) {
                this.renameVariable(jsVariable, varName);
            }
            if (this.myMakePrivate && jsVariable instanceof JSVariable && !(jsVariable instanceof JSParameter)) {
                JSChangeVisibilityUtil.setVisibility((JSAttributeListOwner)jsVariable, JSAttributeList.AccessType.PRIVATE);
            }
        }

        private void renameVariable(JSNamedElement jsVariable, String varName) {
            MyBaseCreateMethodsFix.renameVariable(jsVariable, varName, this.getNewFieldName(varName), (Processor<PsiReference>)((Processor)ref -> JSResolveUtil.getClassOfContext(ref.getElement()) == this.myJsClass));
        }

        @NotNull
        private String getNewFieldName(String varName) {
            if (varName.startsWith("[") && varName.endsWith("]")) {
                String string = "[\"" + this.codeStyleSettings.FIELD_PREFIX + "\" + " + varName.substring(1, varName.length() - 1) + "]";
                if (string == null) {
                    MyBaseCreateMethodsFix.$$$reportNull$$$0(7);
                }
                return string;
            }
            if (varName.startsWith("\"") && varName.endsWith("\"")) {
                String string = "\"" + this.codeStyleSettings.FIELD_PREFIX + varName.substring(1, varName.length() - 1) + "\"";
                if (string == null) {
                    MyBaseCreateMethodsFix.$$$reportNull$$$0(8);
                }
                return string;
            }
            if (varName.startsWith("'") && varName.endsWith("'")) {
                String string = "'" + this.codeStyleSettings.FIELD_PREFIX + varName.substring(1, varName.length() - 1) + "'";
                if (string == null) {
                    MyBaseCreateMethodsFix.$$$reportNull$$$0(9);
                }
                return string;
            }
            String string = this.codeStyleSettings.FIELD_PREFIX + varName;
            if (string == null) {
                MyBaseCreateMethodsFix.$$$reportNull$$$0(10);
            }
            return string;
        }

        public static void renameVariable(JSNamedElement jsVariable, String varName, String newVarName, Processor<PsiReference> usageScopeChecker) {
            PsiElement copy = null;
            if (jsVariable instanceof JSParameter) {
                JSParameterList parameterList = (JSParameterList)jsVariable.getParent().copy();
                for (JSParameter element : parameterList.getParameterVariables()) {
                    if (!varName.equals(element.getName())) continue;
                    copy = element;
                    break;
                }
                if (copy == null) {
                    return;
                }
                ((JSNamedElement)copy).setName(newVarName);
            } else {
                if (jsVariable instanceof JSVariable) {
                    JSVarStatement statementCopy = (JSVarStatement)jsVariable.getParent().copy();
                    char quote = JSCodeStyleSettings.getQuoteChar((PsiElement)jsVariable);
                    for (JSVariable variable : statementCopy.getVariables()) {
                        String name = variable.getName();
                        if (name == null || !varName.equals(JSSymbolUtil.handleSpecialPropertyNames(name, quote))) continue;
                        copy = variable;
                        break;
                    }
                } else {
                    copy = jsVariable.copy();
                }
                if (copy == null) {
                    return;
                }
                ((JSNamedElement)copy).setName(newVarName);
            }
            for (PsiReference ref : ReferencesSearch.search((PsiElement)jsVariable, (SearchScope)GlobalSearchScope.fileScope((PsiFile)jsVariable.getContainingFile())).findAll()) {
                if (usageScopeChecker != null && !usageScopeChecker.process((Object)ref) || ref.getElement().getParent() == jsVariable) continue;
                ref.bindToElement(copy);
            }
            jsVariable.setName(newVarName);
        }

        @Override
        protected String buildName(JSNamedElement fun) {
            String accessorName = (String)fun.getUserData(ACCESSOR_NAME);
            if (accessorName != null) {
                return accessorName;
            }
            return JSRefactoringUtil.transformVarNameToAccessorName(super.buildName(fun), this.codeStyleSettings);
        }

        @Override
        protected String buildParameterList(JSParameterList parameterList, JSNamedElement fun, MultiMap<String, String> types) {
            if (this.myMode == JSGetterSetterGenerationMode.Setter) {
                String stringType = null;
                if (fun instanceof JSVariable) {
                    JSType type = ((JSVariable)fun).getType();
                    stringType = DialectDetector.isTypeScript((PsiElement)fun) ? MyBaseCreateMethodsFix.getProcessedType(type, this.myJsClass, (PsiElement)fun) : JSTypeEvaluateManager.getBaseArrayType(this.getTypeString(type, fun, types));
                }
                return "(value" + (stringType != null ? ":" + stringType : "") + ")";
            }
            return parameterList != null ? parameterList.getText() : "()";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 4: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "definition";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "copy";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/generation/JavaScriptGenerateAccessorHandler$MyBaseCreateMethodsFix";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNewFieldName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreateConstructorPropertyBindVariable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "renameInnerPropUsages";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "renameInIndexAccessExpression";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "rebindUsages";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$renameInIndexAccessExpression$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

