/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptMemberInfo;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.generation.JSDocBasedElementNode;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSMethodToImplement;
import com.intellij.lang.javascript.inspections.JSClosureCompilerSyntaxInspection;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementMemberUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaScriptImplementMethodsHandler
extends BaseJSGenerateHandler {
    @Override
    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
        List<JSMethodToImplement> methodsToImplement = JavaScriptImplementMethodsHandler.getImplementTargets(clazz);
        methodsToImplement.sort(Comparator.comparing(JSMethodToImplement::getName));
        for (JSMethodToImplement method : methodsToImplement) {
            candidates.add(new JSDocBasedElementNode(method));
        }
    }

    @NotNull
    private static List<JSMethodToImplement> getImplementTargets(PsiElement clazz) {
        List<JSMethodToImplement> list = clazz instanceof JSClass ? JavaScriptImplementMethodsHandler.getMethodsToImplement((JSClass)clazz) : JavaScriptImplementMethodsHandler.getMethodsToImplement((JSObjectLiteralExpression)clazz);
        if (list == null) {
            JavaScriptImplementMethodsHandler.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static List<JSMethodToImplement> getMethodsToImplement(JSObjectLiteralExpression literal) {
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)literal);
        if (expectedType != null) {
            Map<TypeScriptMemberInfo, JSClass> membersForLiteral = TypeScriptImplementMemberUtil.getUnimplementedMembersForLiteral(literal, expectedType, false);
            ArrayList methodsToImplement = ContainerUtil.newArrayListWithCapacity((int)membersForLiteral.size());
            for (Map.Entry<TypeScriptMemberInfo, JSClass> item : membersForLiteral.entrySet()) {
                JSClass value = item.getValue();
                methodsToImplement.add(new JSMethodToImplement((JSPsiElementBase)item.getKey().getElement(), false, value == null ? "<doc>" : value.getQualifiedName()));
            }
            return methodsToImplement;
        }
        return ContainerUtil.emptyList();
    }

    @NotNull
    private static List<JSMethodToImplement> getMethodsToImplement(JSClass jsClass) {
        ArrayList methodsToImplement = ContainerUtil.newArrayList();
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)jsClass);
        if (comment instanceof JSDocComment) {
            OrderedSet implementedInterfaces = new OrderedSet();
            OrderedSet classesInHierarchy = new OrderedSet();
            GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)jsClass);
            String className = jsClass.getName();
            JSClosureCompilerSyntaxInspection.collectHierarchyMembers(className, (JSDocComment)comment, (OrderedSet<String>)implementedInterfaces, (OrderedSet<String>)classesInHierarchy, (Consumer<String>)((Consumer)s -> {}), Collections.emptySet());
            methodsToImplement.addAll(JSClosureCompilerSyntaxInspection.getNotImplementedMethods(className == null ? "<doc>" : className, implementedInterfaces, classesInHierarchy, name -> JSClassResolver.getInstance().findNamespaceMembers((String)name, scope), t -> t));
            if (((JSDocComment)comment).hasAbstractTag()) {
                ArrayList arrayList = methodsToImplement;
                if (arrayList == null) {
                    JavaScriptImplementMethodsHandler.$$$reportNull$$$0(1);
                }
                return arrayList;
            }
        }
        Set<JSClass> superClasses = JSClosureCompilerSyntaxInspection.collectSuperClasses(jsClass);
        methodsToImplement.addAll(JSClosureCompilerSyntaxInspection.getNotImplementedMethods(jsClass, Collections.emptySet(), superClasses, superClass -> Arrays.asList(superClass.getFunctions()), JSClass::getName));
        ArrayList arrayList = methodsToImplement;
        if (arrayList == null) {
            JavaScriptImplementMethodsHandler.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    protected String getTitleKey() {
        return "methods.to.implement.chooser.title";
    }

    @Override
    protected String getNoCandidatesMessage() {
        return JSBundle.message((String)"no.methods.to.implement", (Object[])new Object[0]);
    }

    @Override
    protected BaseCreateMembersFix createFix(PsiElement clazz) {
        String className;
        THashMap notImplementedNames = new THashMap();
        List<JSMethodToImplement> methodsToImplement = JavaScriptImplementMethodsHandler.getImplementTargets(clazz);
        for (JSMethodToImplement methodToImplement : methodsToImplement) {
            notImplementedNames.put(methodToImplement.getKey(), methodToImplement);
        }
        String string = className = clazz instanceof JSClass ? ((JSClass)clazz).getName() : null;
        if (className == null) {
            className = "<doc>";
        }
        return (BaseCreateMembersFix)JSFixFactory.getInstance().implementJSDocMethodsFix(className, (Map<JSMethodToImplement.MethodKey, JSMethodToImplement>)notImplementedNames);
    }

    @Override
    protected boolean isValidForTarget(PsiElement jsClass) {
        return jsClass instanceof JSClass && !((JSClass)jsClass).isInterface() && !DialectDetector.isActionScript(jsClass) && !DialectDetector.isTypeScript(jsClass);
    }

    @Override
    protected String getProductivityFeatureId() {
        return "codeassists.overrideimplement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/generation/JavaScriptImplementMethodsHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplementTargets";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodsToImplement";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

