/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixes;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.JSReplaceImplementsExtendsKeyword;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSMethodToImplement;
import com.intellij.lang.javascript.highlighting.TypeGuardSurroundKind;
import com.intellij.lang.javascript.inspections.AssignParameterToFieldAction;
import com.intellij.lang.javascript.inspections.CreateFieldFromParameterAction;
import com.intellij.lang.javascript.inspections.DownloadLibraryQuickFix;
import com.intellij.lang.javascript.inspections.ES6CreateClassOrInterfaceFix;
import com.intellij.lang.javascript.inspections.ES6CreateConstructorFix;
import com.intellij.lang.javascript.inspections.JSMoveToScopeStartIntentionAction;
import com.intellij.lang.javascript.inspections.JSRemoveElementLocalQuickFix;
import com.intellij.lang.javascript.inspections.JSSuppressByCommentFix;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.ActionScriptCreateClassOrInterfaceFix;
import com.intellij.lang.javascript.validation.fixes.AddConstructorAndSuperInvocationFix;
import com.intellij.lang.javascript.validation.fixes.AddSuperInvocationFix;
import com.intellij.lang.javascript.validation.fixes.ChangeTypeFix;
import com.intellij.lang.javascript.validation.fixes.CreateInheritanceFix;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionFromArgumentIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSFunctionIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSNamespaceIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSParameterIntentionAction;
import com.intellij.lang.javascript.validation.fixes.CreateJSVariableIntentionAction;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.javascript.validation.fixes.ImplementJSDocMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSAddRemoveSharpFix;
import com.intellij.lang.javascript.validation.fixes.JSChangeSignatureFix;
import com.intellij.lang.javascript.validation.fixes.JSChangeSignatureWithDelegationUpdateFix;
import com.intellij.lang.javascript.validation.fixes.JSInsertCastFix;
import com.intellij.lang.javascript.validation.fixes.JSInsertModifierFix;
import com.intellij.lang.javascript.validation.fixes.JSInsertPrimitiveWrapperFix;
import com.intellij.lang.javascript.validation.fixes.JSRemoveInitializerQuickFix;
import com.intellij.lang.javascript.validation.fixes.JSSetElementVisibilityFix;
import com.intellij.lang.javascript.validation.fixes.MakeMethodStaticFix;
import com.intellij.lang.javascript.validation.fixes.RemoveASTNodeFix;
import com.intellij.lang.javascript.validation.fixes.RenameReferenceFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptImplementAllMembersFix;
import com.intellij.lang.javascript.validation.fixes.TypeScriptInsertTypeGuardFix;
import com.intellij.lang.typescript.intentions.TypeScriptAddFileToConfigFix;
import com.intellij.lang.typescript.intentions.TypeScriptAddImportStatementFix;
import com.intellij.lang.typescript.intentions.TypeScriptChangeConstructorAccessRightsFix;
import com.intellij.lang.typescript.psi.TypeScriptReferencePathValidator;
import com.intellij.lang.typescript.psi.TypeScriptReferencePathValidatorImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.fix.RenameFix;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class JSFixFactoryImpl
extends JSFixFactory {
    @Override
    public LocalQuickFix createImplementMembersFix(JSExpression expr, JSType type) {
        if (DialectDetector.isTypeScript((PsiElement)expr)) {
            return new TypeScriptImplementAllMembersFix((PsiElement)expr, false);
        }
        return null;
    }

    @Override
    public LocalQuickFix changeTypeFix(JSNamedElement var, String expressionType, String nameKey) {
        return new ChangeTypeFix(var, expressionType, nameKey);
    }

    @Override
    public LocalQuickFix changeSignatureFix(JSFunction function, @NotNull Map<String, String> parameterTypeOverrides, @Nullable String overriddenReturnType) {
        if (parameterTypeOverrides == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(0);
        }
        JSFunction top = JSInheritanceUtil.findTopMethods(function).iterator().next();
        JSChangeSignatureFix fix = new JSChangeSignatureFix(top);
        fix.setReturnType(overriddenReturnType);
        fix.setParameterTypes(parameterTypeOverrides);
        return fix;
    }

    @Override
    public LocalQuickFix createInheritanceFix(JSClass expectedClass, PsiElement actualClass) {
        return new CreateInheritanceFix(actualClass, expectedClass.getQualifiedName(), expectedClass.isInterface());
    }

    @Override
    public LocalQuickFix jsInsertCastFix(String type, @NotNull DialectOptionHolder holder) {
        if (holder == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(1);
        }
        return new JSInsertCastFix(type, holder);
    }

    @Override
    public LocalQuickFix jsInsertPrimitiveWrapperFix(String type) {
        return new JSInsertPrimitiveWrapperFix(type);
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement removeASTNodeFix(@NotNull @PropertyKey(resourceBundle="messages.JavaScriptBundle") String propKey, boolean fixNewLines, @NotNull ASTNode startNode, @NotNull ASTNode endNode) {
        if (propKey == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(2);
        }
        if (startNode == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(3);
        }
        if (endNode == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(4);
        }
        return new RemoveASTNodeFix(propKey, fixNewLines, startNode, endNode);
    }

    @Override
    public LocalQuickFix renameReferenceFix() {
        return new RenameReferenceFix();
    }

    @Override
    public LocalQuickFix createJSVariableIntentionAction(String name, boolean field, boolean constant, boolean isModuleScope) {
        return new CreateJSVariableIntentionAction(name, field, constant, isModuleScope);
    }

    @Override
    public LocalQuickFix createJSParameterIntentionAction(String name) {
        return new CreateJSParameterIntentionAction();
    }

    @Override
    public LocalQuickFix createJSFunctionIntentionAction(String name, boolean isMethod, boolean isModuleScope) {
        return new CreateJSFunctionIntentionAction(name, isMethod, isModuleScope);
    }

    @Override
    public LocalQuickFix createJSFunctionFromArgumentIntentionAction(String name, JSExpression qualifier, boolean ecma) {
        return new CreateJSFunctionFromArgumentIntentionAction(name, qualifier, ecma);
    }

    @Override
    public LocalQuickFix createClassOrInterfaceFix(PsiElement expression, boolean isInterface, @Nullable JSArgumentList constructorArguments, @Nullable JSType expectedType) {
        DialectOptionHolder holder = DialectDetector.dialectOfElement(expression);
        if (holder == null) {
            return QuickFixes.EMPTY_FIX;
        }
        if (holder.isECMA4) {
            if (expression instanceof JSReferenceExpression) {
                return new ActionScriptCreateClassOrInterfaceFix((JSReferenceExpression)expression, isInterface, constructorArguments, expectedType);
            }
            return QuickFixes.EMPTY_FIX;
        }
        return new ES6CreateClassOrInterfaceFix(expression, isInterface, constructorArguments, expectedType);
    }

    @Override
    public IntentionAction addSuperInvocationFix(JSFunction constructor, @Nullable JSFunction superConstructor) {
        return new AddSuperInvocationFix(constructor, superConstructor);
    }

    @Override
    public IntentionAction addConstructorAndSuperInvocationFix(JSClass clazz, JSFunction superClassConstructor) {
        return new AddConstructorAndSuperInvocationFix(clazz, superClassConstructor);
    }

    @Override
    public LocalQuickFix changeSignatureFix(JSFunction element, @Nullable JSArgumentList argumentList) {
        return new JSChangeSignatureFix(element, argumentList);
    }

    @Override
    public LocalQuickFix changeSignatureWithDelegationUpdateFix(JSFunction element, @NotNull JSFunction functionToTakeParamsFrom, @NotNull JSCallExpression node) {
        if (functionToTakeParamsFrom == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(5);
        }
        if (node == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(6);
        }
        return new JSChangeSignatureWithDelegationUpdateFix(element, functionToTakeParamsFrom, node);
    }

    @Override
    public LocalQuickFix createJSNamespaceIntentionAction(String name) {
        return new CreateJSNamespaceIntentionAction(name);
    }

    @Override
    public LocalQuickFix makeMethodStaticFix() {
        return new MakeMethodStaticFix();
    }

    @Override
    public FixAndIntentionAction assignParameterToFieldAction(FixAndIntentionAction action, String fieldName, String parameterName, String className) {
        return new AssignParameterToFieldAction(action, fieldName, parameterName, className);
    }

    @Override
    public LocalQuickFix downloadLibraryQuickFix() {
        return new DownloadLibraryQuickFix();
    }

    @Override
    public LocalQuickFix jsMoveToScopeStartIntentionAction(boolean statement) {
        return new JSMoveToScopeStartIntentionAction(statement);
    }

    @Override
    public FixAndIntentionAction removeElementLocalQuickFix(String elementDescription) {
        return new JSRemoveElementLocalQuickFix(elementDescription);
    }

    @Override
    public void addFixesForFields(JSFunction node, PsiElement highlightedElement, String name, List<LocalQuickFix> fixes) {
        PsiElement element = JSResolveUtil.findParent((PsiElement)node);
        if (element instanceof JSClass) {
            FixAndIntentionAction intentionAction;
            String fieldName2;
            String fieldName = JSRefactoringUtil.transformAccessorNameToPropertyName(node.isSetProperty() ? node.getName() : name, (PsiElement)node);
            String string = fieldName2 = node.isSetProperty() ? null : JSRefactoringUtil.transformVarNameToAccessorName(name, (PsiElement)node);
            if (StringUtil.equals((CharSequence)fieldName, (CharSequence)fieldName2)) {
                fieldName2 = null;
            }
            String className = ((JSClass)element).getName();
            boolean noField = ((JSClass)element).findFieldByName(fieldName) == null;
            String existingField = fieldName;
            if (noField && fieldName2 != null) {
                noField = ((JSClass)element).findFieldByName(fieldName2) == null;
                existingField = fieldName2;
            }
            CreateFieldFromParameterAction action = null;
            if (noField) {
                if (fieldName2 != null) {
                    action = new CreateFieldFromParameterAction(fieldName2);
                    action.registerElementRefForFix(highlightedElement, null);
                    intentionAction = JSFixFactoryImpl.assignParameterToFieldAction(name, fieldName2, className, action);
                    intentionAction.registerElementRefForFix(highlightedElement, null);
                    fixes.add(intentionAction);
                }
                action = new CreateFieldFromParameterAction(fieldName);
                action.registerElementRefForFix(highlightedElement, null);
            }
            intentionAction = JSFixFactoryImpl.assignParameterToFieldAction(name, noField ? fieldName : existingField, className, action);
            intentionAction.registerElementRefForFix(highlightedElement, null);
            fixes.add(intentionAction);
        }
    }

    private static FixAndIntentionAction assignParameterToFieldAction(String parameterName, String fieldName, String className, FixAndIntentionAction action) {
        return JSFixFactoryImpl.getInstance().assignParameterToFieldAction(action, fieldName, parameterName, className);
    }

    @Override
    public IntentionAction typeScriptImplementMembersFix(JSClass aClass) {
        return new TypeScriptImplementAllMembersFix((PsiElement)aClass, false);
    }

    @Override
    public IntentionAction typeScriptImplementMembersAbstractFix(JSClass aClass) {
        return new TypeScriptImplementAllMembersFix((PsiElement)aClass, true);
    }

    @Override
    public LocalQuickFix createInsertTypeGuardFix(@NotNull PsiElement element, @NotNull JSType type, @NotNull TypeGuardSurroundKind surroundKind, String discriminatedPropertyName, boolean isNegative, boolean allowSimplifyForNullable) {
        if (element == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(7);
        }
        if (type == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(8);
        }
        if (surroundKind == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(9);
        }
        return new TypeScriptInsertTypeGuardFix(element, type, surroundKind, discriminatedPropertyName, isNegative, allowSimplifyForNullable);
    }

    @Override
    public InspectionJSFix renameFix() {
        return new RenameFix();
    }

    @Override
    @NotNull
    public List<LocalQuickFix> typeScriptAddImportStatementFix(String name, @NotNull PsiElement context) {
        if (context == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(10);
        }
        TypeScriptAddImportStatementFix fix = new TypeScriptAddImportStatementFix(name, context);
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new LocalQuickFix[]{fix, fix.createImportAllFix()});
        if (arrayList == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    public FixAndIntentionAction replaceImplementsKeywordByExtendsFix(@NotNull JSReferenceList referenceList) {
        if (referenceList == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(12);
        }
        return new JSReplaceImplementsExtendsKeyword(referenceList);
    }

    @Override
    @NotNull
    public List<LocalQuickFix> typeScriptConfigFixes(JSElement placeExpression, PsiElement resolveResult) {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new LocalQuickFix[]{new TypeScriptAddFileToConfigFix(placeExpression, resolveResult)});
        if (arrayList == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public TypeScriptReferencePathValidator typeScriptReferencePathValidator() {
        TypeScriptReferencePathValidator typeScriptReferencePathValidator = TypeScriptReferencePathValidatorImpl.INSTANCE;
        if (typeScriptReferencePathValidator == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(14);
        }
        return typeScriptReferencePathValidator;
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement createChangeVisibilityFix(@NotNull JSAttributeListOwner method, @Nullable JSAttributeList.AccessType visibility, @Nullable String namespace) {
        if (method == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(15);
        }
        return new JSSetElementVisibilityFix(method, visibility, namespace);
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement createAddRemoveSharpFix(@NotNull JSReferenceExpression expression, boolean remove) {
        if (expression == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(16);
        }
        return new JSAddRemoveSharpFix(expression, remove);
    }

    @Override
    public LocalQuickFixAndIntentionActionOnPsiElement insertModifier(@NotNull JSAttributeListOwner method, @NotNull JSAttributeList.ModifierType modifier) {
        if (method == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(17);
        }
        if (modifier == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(18);
        }
        return new JSInsertModifierFix(method, modifier);
    }

    @Override
    public SuppressQuickFix suppressByCommentFix(HighlightDisplayKey key, Class<? extends JSSuppressionHolder> holderClass) {
        return new JSSuppressByCommentFix(key, holderClass);
    }

    @Override
    public LocalQuickFix createConstructorFix(@NotNull JSCallExpression callExpression, @NotNull JSClass targetClass) {
        DialectOptionHolder holder;
        if (callExpression == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(19);
        }
        if (targetClass == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(20);
        }
        if ((holder = DialectDetector.dialectOfElement((PsiElement)callExpression)) == null) {
            return QuickFixes.EMPTY_FIX;
        }
        return new ES6CreateConstructorFix(callExpression, targetClass);
    }

    @Override
    public LocalQuickFix insertUseStrict(@NotNull JSExecutionScope executionScope) {
        if (executionScope == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(21);
        }
        return new LocalQuickFixOnPsiElement((PsiElement)executionScope){

            @NotNull
            public String getFamilyName() {
                String string = JSBundle.message((String)"js.strict.mode.inspection.fix", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getText() {
                String string = this.getFamilyName();
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (startElement == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (endElement == null) {
                    1.$$$reportNull$$$0(5);
                }
                String quote = JSCodeStyleSettings.getQuote((PsiElement)file2);
                String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)file2);
                String useStrictStmt = quote + "use strict" + quote + semicolon + "\n";
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
                assert (document != null);
                document.insertString(startElement.getTextOffset(), (CharSequence)useStrictStmt);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "startElement";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    @NotNull
    public LocalQuickFix implementJSDocMethodsFix(@NotNull String className, @NotNull Map<JSMethodToImplement.MethodKey, JSMethodToImplement> methods) {
        if (className == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(22);
        }
        if (methods == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(23);
        }
        ImplementJSDocMethodsFix implementJSDocMethodsFix = new ImplementJSDocMethodsFix(className, methods);
        if (implementJSDocMethodsFix == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(24);
        }
        return implementJSDocMethodsFix;
    }

    @Override
    @NotNull
    public LocalQuickFix removeInitializerFix() {
        JSRemoveInitializerQuickFix jSRemoveInitializerQuickFix = new JSRemoveInitializerQuickFix();
        if (jSRemoveInitializerQuickFix == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(25);
        }
        return jSRemoveInitializerQuickFix;
    }

    @Override
    @NotNull
    public LocalQuickFix changeConstructorAccessRightsFix(@NotNull JSFunction node, @NotNull JSAttributeList.AccessType accessType) {
        if (node == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(26);
        }
        if (accessType == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(27);
        }
        TypeScriptChangeConstructorAccessRightsFix typeScriptChangeConstructorAccessRightsFix = new TypeScriptChangeConstructorAccessRightsFix(node, accessType);
        if (typeScriptChangeConstructorAccessRightsFix == null) {
            JSFixFactoryImpl.$$$reportNull$$$0(28);
        }
        return typeScriptChangeConstructorAccessRightsFix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypeOverrides";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propKey";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionToTakeParamsFrom";
                break;
            }
            case 6: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surroundKind";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceList";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionScope";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSFixFactoryImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "typeScriptAddImportStatementFix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "typeScriptConfigFixes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "typeScriptReferencePathValidator";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "implementJSDocMethodsFix";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "removeInitializerFix";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "changeConstructorAccessRightsFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "changeSignatureFix";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "jsInsertCastFix";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeASTNodeFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "changeSignatureWithDelegationUpdateFix";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createInsertTypeGuardFix";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "typeScriptAddImportStatementFix";
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceImplementsKeywordByExtendsFix";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createChangeVisibilityFix";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createAddRemoveSharpFix";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "insertModifier";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createConstructorFix";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "insertUseStrict";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "implementJSDocMethodsFix";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "changeConstructorAccessRightsFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 13: 
            case 14: 
            case 24: 
            case 25: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

