/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSHighlightFunctionExitPointsHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file2, final @NotNull PsiElement target) {
        IElementType elementType;
        ASTNode node;
        if (editor == null) {
            JSHighlightFunctionExitPointsHandlerFactory.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JSHighlightFunctionExitPointsHandlerFactory.$$$reportNull$$$0(1);
        }
        if (target == null) {
            JSHighlightFunctionExitPointsHandlerFactory.$$$reportNull$$$0(2);
        }
        if ((node = target.getNode()) != null && ((elementType = node.getElementType()) == JSTokenTypes.RETURN_KEYWORD || elementType == JSTokenTypes.THROW_KEYWORD || elementType == JSTokenTypes.FUNCTION_KEYWORD || elementType == JSTokenTypes.EQGT)) {
            return new HighlightUsagesHandlerBase<PsiElement>(editor, file2){

                public List<PsiElement> getTargets() {
                    return new SmartList((Object)target);
                }

                @NotNull
                public String getFeatureId() {
                    if ("codeassists.highlight.return" == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return "codeassists.highlight.return";
                }

                protected void selectTargets(List<PsiElement> targets, Consumer<List<PsiElement>> selectionConsumer) {
                    selectionConsumer.consume(targets);
                }

                public void computeUsages(List<PsiElement> targets) {
                    final JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)targets.get(0), JSFunction.class);
                    JSExpression arrowFunctionReturnExpression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression(fun);
                    if (arrowFunctionReturnExpression != null) {
                        this.myReadUsages.add(arrowFunctionReturnExpression.getTextRange());
                        return;
                    }
                    if (fun != null) {
                        fun.acceptChildren((PsiElementVisitor)new JSRecursiveElementVisitor(){

                            public void visitJSReturnStatement(JSReturnStatement node) {
                                super.visitJSReturnStatement(node);
                                myReadUsages.add(node.getTextRange());
                            }

                            public void visitJSThrowStatement(JSThrowStatement node) {
                                super.visitJSThrowStatement(node);
                                JSTryStatement tryStatement = (JSTryStatement)PsiTreeUtil.getParentOfType((PsiElement)node, JSTryStatement.class);
                                if (tryStatement != null && PsiTreeUtil.findCommonParent((PsiElement)tryStatement, (PsiElement)fun) == fun) {
                                    return;
                                }
                                myReadUsages.add(node.getTextRange());
                            }

                            public void visitJSFunctionExpression(JSFunctionExpression node) {
                            }

                            public void visitJSFunctionDeclaration(JSFunction node) {
                            }
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSHighlightFunctionExitPointsHandlerFactory$1", "getFeatureId"));
                }
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/highlighting/JSHighlightFunctionExitPointsHandlerFactory";
        objectArray[2] = "createHighlightUsagesHandler";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

