/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.codeInsight.completion.HtmlCompletionContributor;
import com.intellij.json.psi.impl.JSStringLiteralEscaper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.highlighting.JSSpellcheckerProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.inspections.TextSplitter;
import com.intellij.spellchecker.tokenizer.EscapeSequenceTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class JSSpellcheckingStrategy
extends SpellcheckingStrategy {
    private final Tokenizer<JSLiteralExpression> myLiteralTokenizer = new JSLiteralTokenizer();
    private final Tokenizer<JSProperty> myPropertyTokenizer = new MyPropertyTokenizer();
    private final Tokenizer<JSNamedElement> myAttributeValueTokenizer = new MyAttributeValueTokenizer();
    private final JSSpellcheckerProvider[] myProviders = (JSSpellcheckerProvider[])JSSpellcheckerProvider.EP.getExtensions();

    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        PsiElement identifier;
        for (JSSpellcheckerProvider provider2 : this.myProviders) {
            Tokenizer tokenizer = provider2.getTokenizer(element);
            if (tokenizer == null) continue;
            Tokenizer tokenizer2 = tokenizer;
            if (tokenizer2 == null) {
                JSSpellcheckingStrategy.$$$reportNull$$$0(0);
            }
            return tokenizer2;
        }
        if (element instanceof TypeScriptModule && (identifier = ((TypeScriptModule)element).getNameIdentifier()) instanceof JSLiteralExpression) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                JSSpellcheckingStrategy.$$$reportNull$$$0(1);
            }
            return tokenizer;
        }
        PsiElement parent = element.getParent();
        if (element instanceof JSFunctionExpression && parent instanceof JSProperty) {
            Tokenizer tokenizer = EMPTY_TOKENIZER;
            if (tokenizer == null) {
                JSSpellcheckingStrategy.$$$reportNull$$$0(2);
            }
            return tokenizer;
        }
        if (element instanceof JSLiteralExpression) {
            if (element instanceof JSXmlLiteralExpression) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    JSSpellcheckingStrategy.$$$reportNull$$$0(3);
                }
                return tokenizer;
            }
            if (parent instanceof JSArgumentList && parent.getParent() instanceof JSCallExpression && ((JSCallExpression)parent.getParent()).isRequireCall()) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    JSSpellcheckingStrategy.$$$reportNull$$$0(4);
                }
                return tokenizer;
            }
            Tokenizer<JSLiteralExpression> tokenizer = this.myLiteralTokenizer;
            if (tokenizer == null) {
                JSSpellcheckingStrategy.$$$reportNull$$$0(5);
            }
            return tokenizer;
        }
        if (element instanceof JSAttribute) {
            PsiReference psiReference = element.getReference();
            if (psiReference != null && psiReference.resolve() != null) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    JSSpellcheckingStrategy.$$$reportNull$$$0(6);
                }
                return tokenizer;
            }
        } else if (element instanceof JSProperty) {
            ASTNode node = ((JSProperty)element).findNameIdentifier();
            if (node != null && (node.textContains('\'') || node.textContains('\"'))) {
                String text = node.getText();
                if (!StringUtil.isJavaIdentifier((String)text)) {
                    Tokenizer<JSNamedElement> tokenizer = this.myAttributeValueTokenizer;
                    if (tokenizer == null) {
                        JSSpellcheckingStrategy.$$$reportNull$$$0(7);
                    }
                    return tokenizer;
                }
                Tokenizer<JSProperty> tokenizer = this.myPropertyTokenizer;
                if (tokenizer == null) {
                    JSSpellcheckingStrategy.$$$reportNull$$$0(8);
                }
                return tokenizer;
            }
        } else {
            if (element instanceof JSDefinitionExpression) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    JSSpellcheckingStrategy.$$$reportNull$$$0(9);
                }
                return tokenizer;
            }
            if (element instanceof JSQualifiedNamedElement) {
                JSQualifiedNamedElement qualifiedNamedElement = (JSQualifiedNamedElement)element;
                ASTNode node = qualifiedNamedElement.findNameIdentifier();
                if (node != null && node.textContains('.')) {
                    Tokenizer<JSNamedElement> tokenizer = this.myAttributeValueTokenizer;
                    if (tokenizer == null) {
                        JSSpellcheckingStrategy.$$$reportNull$$$0(10);
                    }
                    return tokenizer;
                }
            } else if (element instanceof XmlAttributeValue && HtmlCompletionContributor.addSpecificCompletions((XmlAttribute)((XmlAttribute)parent)).length > 0) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    JSSpellcheckingStrategy.$$$reportNull$$$0(11);
                }
                return tokenizer;
            }
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            JSSpellcheckingStrategy.$$$reportNull$$$0(12);
        }
        return tokenizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy", "getTokenizer"));
    }

    public static class JSLiteralTokenizer
    extends EscapeSequenceTokenizer<JSLiteralExpression> {
        public void tokenize(@NotNull JSLiteralExpression element, TokenConsumer consumer) {
            if (element == null) {
                JSLiteralTokenizer.$$$reportNull$$$0(0);
            }
            if (element instanceof PsiLanguageInjectionHost && InjectedLanguageUtil.hasInjections((PsiLanguageInjectionHost)((PsiLanguageInjectionHost)element))) {
                return;
            }
            if (this.shouldNotCheckLiteral(element)) {
                return;
            }
            String text = StringUtil.unquoteString((String)element.getText());
            if (element instanceof JSStringTemplateExpression && ((JSStringTemplateExpression)element).getArguments().length > 0) {
                for (TextRange range : ((JSStringTemplateExpression)element).getStringRanges()) {
                    consumer.consumeToken((PsiElement)element, text, false, 0, range, (Splitter)PlainTextSplitter.getInstance());
                }
            } else if (!text.contains("\\")) {
                consumer.consumeToken((PsiElement)element, (Splitter)PlainTextSplitter.getInstance());
            } else {
                StringBuilder unescapedText = new StringBuilder();
                Ref offsetsRef = new Ref();
                JSStringLiteralEscaper.parseStringCharacters((String)text, (StringBuilder)unescapedText, (Ref)offsetsRef, (boolean)element.isRegExpLiteral(), (boolean)(element instanceof JSStringTemplateExpression));
                JSLiteralTokenizer.processTextWithOffsets((PsiElement)element, (TokenConsumer)consumer, (StringBuilder)unescapedText, (int[])((int[])offsetsRef.get()), (int)1);
            }
        }

        protected boolean shouldNotCheckLiteral(@NotNull JSLiteralExpression element) {
            if (element == null) {
                JSLiteralTokenizer.$$$reportNull$$$0(1);
            }
            return !element.isQuotedLiteral() || element.getTextLength() < 3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy$JSLiteralTokenizer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tokenize";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldNotCheckLiteral";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyAttributeValueTokenizer
    extends Tokenizer<JSNamedElement> {
        private MyAttributeValueTokenizer() {
        }

        public void tokenize(@NotNull JSNamedElement property, TokenConsumer consumer) {
            ASTNode node;
            if (property == null) {
                MyAttributeValueTokenizer.$$$reportNull$$$0(0);
            }
            if ((node = property.findNameIdentifier()) != null) {
                consumer.consumeToken(node.getPsi(), true, (Splitter)TextSplitter.getInstance());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy$MyAttributeValueTokenizer", "tokenize"));
        }
    }

    private static class MyPropertyTokenizer
    extends Tokenizer<JSProperty> {
        private MyPropertyTokenizer() {
        }

        public void tokenize(@NotNull JSProperty element, TokenConsumer consumer) {
            ASTNode node;
            if (element == null) {
                MyPropertyTokenizer.$$$reportNull$$$0(0);
            }
            if ((node = element.findNameIdentifier()) != null) {
                String text = StringUtil.unquoteString((String)node.getText());
                consumer.consumeToken(node.getPsi(), text, true, 1, TextRange.allOf((String)text), (Splitter)IdentifierSplitter.getInstance());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/highlighting/JSSpellcheckingStrategy$MyPropertyTokenizer", "tokenize"));
        }
    }
}

