/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSHierarchyProcessor;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSSubclassIndex;
import com.intellij.lang.javascript.psi.stubs.JSTypedefIndex;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeParser;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.TreeItem;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluateManager {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.index.JSTypeEvaluateManager");

    public static String getBaseArrayType(String type) {
        if (JSTypeEvaluateManager.isArrayType(type) && type.contains("[]")) {
            return "Array";
        }
        return type;
    }

    public static Collection<JSPsiElementBase> findNearestExtendedJSTypes(JSPsiElementBase function, @NotNull String qName) {
        if (qName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(0);
        }
        final LinkedList extendedTypes = new LinkedList();
        THashSet hasNonImplicitNamespaceElement = new THashSet();
        final JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)function).getClassResolver();
        final PsiFile psiFile = function.getContainingFile();
        JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex((PsiElement)function, Collections.singletonList(qName), false, false, new NamespaceProcessor((Set)hasNonImplicitNamespaceElement){
            final /* synthetic */ Set val$hasNonImplicitNamespaceElement;
            {
                this.val$hasNonImplicitNamespaceElement = set;
            }

            @Override
            public boolean process(String serializedType, VirtualFile file2) {
                JSType type = JSTypeUtils.createType(serializedType, JSTypeSource.EMPTY);
                if (type == null || type instanceof JSNamedType && ((JSNamedType)type).getTypeContext() == JSTypeContext.STATIC) {
                    return true;
                }
                String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
                if (qName == null) {
                    return true;
                }
                for (JSPsiElementBase element : resolver.findElementsByQNameIncludingImplicit(qName, JSResolveUtil.getResolveScope((PsiElement)psiFile))) {
                    extendedTypes.add(Pair.create((Object)element, (Object)qName));
                    if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance()) continue;
                    this.val$hasNonImplicitNamespaceElement.add(qName);
                }
                return true;
            }
        }, null);
        ArrayList<JSPsiElementBase> result2 = new ArrayList<JSPsiElementBase>(extendedTypes.size());
        for (Pair type : extendedTypes) {
            JSPsiElementBase element = (JSPsiElementBase)type.first;
            if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance() && hasNonImplicitNamespaceElement.contains(type.second)) continue;
            result2.add(element);
        }
        return result2;
    }

    public static void iterateTypeHierarchy(@NotNull String typeName, @NotNull JSHierarchyProcessor processor, @NotNull PsiElement myContext) {
        if (typeName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(2);
        }
        if (myContext == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(3);
        }
        JSTypeEvaluateManager.iterateTypeHierarchy(typeName, processor, myContext, true, true, false);
    }

    public static void iterateTypeHierarchy(@NotNull String typeName, final @NotNull JSHierarchyProcessor processor, @NotNull PsiElement myContext, boolean processClasses, boolean stopAtClasses, boolean processTopClasses) {
        if (typeName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(5);
        }
        if (myContext == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(6);
        }
        if (processClasses && !JSTypeEvaluateManager.iterateTypeHierarchyFromJSClasses(typeName, processor, myContext, stopAtClasses, processTopClasses)) {
            return;
        }
        final HashSet visitedTypes = new HashSet();
        JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(myContext, Collections.singletonList(typeName), false, true, new NamespaceProcessor(){

            @Override
            public boolean process(String serializedType, VirtualFile file2) {
                if (!visitedTypes.contains(serializedType)) {
                    visitedTypes.add(serializedType);
                    processor.processNamespace(serializedType, file2);
                }
                return true;
            }
        }, (Processor<JSObjectLiteralExpression>)((Processor)expression -> {
            if (processor == null) {
                JSTypeEvaluateManager.$$$reportNull$$$0(27);
            }
            return processor.processObjectLiteral((JSObjectLiteralExpression)expression);
        }));
    }

    private static boolean iterateTypeHierarchyFromJSClasses(@NotNull String typeName, @NotNull JSHierarchyProcessor processor, @NotNull PsiElement myContext, boolean stopAtClasses, boolean processTopClasses) {
        JSClassResolver resolver;
        List<JSClass> classes;
        if (typeName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(8);
        }
        if (myContext == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(9);
        }
        if (!(classes = (resolver = JSDialectSpecificHandlersFactory.forElement(myContext).getClassResolver()).findClassesByQName(typeName, JSResolveUtil.getResolveScope(myContext))).isEmpty()) {
            HashSet<JSClass> visitedClasses = new HashSet<JSClass>();
            if (processTopClasses) {
                for (JSClass aClass : classes) {
                    if (!visitedClasses.add(aClass) || processor.processClass(aClass)) continue;
                    return false;
                }
            }
            boolean iterateTypeHierarchy = false;
            ArrayDeque<JSClass> parentClasses = new ArrayDeque<JSClass>(classes);
            while (!parentClasses.isEmpty()) {
                JSClass parentClass = (JSClass)parentClasses.removeFirst();
                iterateTypeHierarchy = iterateTypeHierarchy || JSCorePredefinedLibrariesProvider.isLibraryElement((PsiElement)parentClass);
                for (JSClass superClass : parentClass.getSupers()) {
                    if (!visitedClasses.add(superClass)) continue;
                    if (!processor.processClass(superClass)) {
                        return false;
                    }
                    parentClasses.add(superClass);
                }
            }
            if (!iterateTypeHierarchy) {
                return !stopAtClasses;
            }
        }
        return true;
    }

    public static boolean iterateTypeHierarchyFromBaseTypesIndex(@NotNull PsiElement context, @Nullable String type, @NotNull NamespaceProcessor namespaceProcessor) {
        if (context == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(10);
        }
        if (namespaceProcessor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(11);
        }
        return type != null && JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(context, Collections.singletonList(type), true, namespaceProcessor);
    }

    public static boolean iterateTypeHierarchyFromBaseTypesIndex(@NotNull PsiElement context, @NotNull Collection<String> initialTypes, boolean processObjectClass, @NotNull NamespaceProcessor namespaceProcessor) {
        if (context == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(12);
        }
        if (initialTypes == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(13);
        }
        if (namespaceProcessor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(14);
        }
        return JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(context, initialTypes, processObjectClass, true, namespaceProcessor, null);
    }

    public static boolean iterateTypeHierarchyFromBaseTypesIndex(@NotNull PsiElement context, @NotNull Collection<String> initialTypes, boolean processObjectClass, boolean withGrandparents, @NotNull NamespaceProcessor namespaceProcessor, @Nullable Processor<JSObjectLiteralExpression> elementsProcessor) {
        if (context == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(15);
        }
        if (initialTypes == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(16);
        }
        if (namespaceProcessor == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(17);
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        ArrayList<String> descendants = new ArrayList<String>(initialTypes);
        SmartList currentTypeBaseElements = new SmartList();
        THashMap visited = new THashMap();
        for (int at = 0; at != descendants.size(); ++at) {
            String currentTypeName = (String)descendants.get(at);
            List virtualFiles = (List)visited.get((Object)currentTypeName);
            if (virtualFiles != null) {
                JSResolveUtil.sortFiles(virtualFiles);
                for (VirtualFile file2 : virtualFiles) {
                    if (namespaceProcessor.process(currentTypeName, file2)) continue;
                    return false;
                }
                virtualFiles.clear();
            }
            if (at == 0 || withGrandparents) {
                boolean result2;
                currentTypeBaseElements.clear();
                String nsName = JSBaseTypesIndex.getTextForProcessingHierarchy(currentTypeName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Searching for " + nsName + " base types");
                }
                if (!(result2 = StubIndex.getInstance().processElements(JSBaseTypesIndex.KEY, (Object)nsName, context.getProject(), scope, JSElement.class, arg_0 -> JSTypeEvaluateManager.lambda$iterateTypeHierarchyFromBaseTypesIndex$1(nsName, visited, descendants, (List)currentTypeBaseElements, arg_0)))) {
                    return false;
                }
            }
            if (elementsProcessor == null) continue;
            for (JSObjectLiteralExpression element : currentTypeBaseElements) {
                if (elementsProcessor.process((Object)element)) continue;
                return false;
            }
        }
        if (processObjectClass && !visited.contains((Object)"Object") && !initialTypes.contains("Object")) {
            PsiFile containingFile = context.getContainingFile().getOriginalFile();
            return namespaceProcessor.process("Object", containingFile.getVirtualFile());
        }
        return true;
    }

    @NotNull
    public static TreeItem<String> buildSuperClassesHierarchy(@NotNull String type, @NotNull GlobalSearchScope scope) {
        if (type == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(19);
        }
        TreeItem root = new TreeItem((Object)type);
        THashSet visited = new THashSet();
        visited.add(type);
        JSTypeEvaluateManager.addSuperClasses((TreeItem<String>)root, (Set<String>)visited, scope);
        TreeItem treeItem = root;
        if (treeItem == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(20);
        }
        return treeItem;
    }

    private static void addSuperClasses(TreeItem<String> node, Set<String> visited, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(21);
        }
        String nsName = JSTypeUtils.getTypeMatchingNamespace((String)node.getData());
        StubIndex.getInstance().processElements(JSBaseTypesIndex.KEY, (Object)nsName, scope.getProject(), scope, JSElement.class, element -> {
            Collection baseTypes;
            JSElementIndexingData indexingData;
            JSElementIndexingData jSElementIndexingData = indexingData = element instanceof JSImplicitElementProvider ? ((JSImplicitElementProvider)element).getIndexingData() : null;
            if (indexingData != null && (baseTypes = indexingData.getBaseTypes()) != null) {
                for (Pair baseType : baseTypes) {
                    if (!nsName.equals(baseType.first)) continue;
                    node.addChild(new TreeItem(baseType.second));
                }
            }
            return true;
        });
        for (TreeItem child : node.getChildren()) {
            if (!visited.add((String)child.getData())) continue;
            JSTypeEvaluateManager.addSuperClasses((TreeItem<String>)child, visited, scope);
        }
    }

    @Nullable
    public static TreeItem<String> findSuperClass(@NotNull TreeItem<String> root, @NotNull String parentClassName) {
        JSType type;
        String rootQName;
        if (root == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(22);
        }
        if (parentClassName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(23);
        }
        String string = rootQName = (type = JSTypeUtils.createType((String)root.getData(), JSTypeSource.EXPLICITLY_DECLARED)) != null ? JSTypeUtils.getQualifiedNameMatchingType(type, true) : null;
        if (parentClassName.equals(rootQName)) {
            return root;
        }
        for (TreeItem child : root.getChildren()) {
            TreeItem<String> childSuper = JSTypeEvaluateManager.findSuperClass((TreeItem<String>)child, parentClassName);
            if (childSuper == null) continue;
            return childSuper;
        }
        return null;
    }

    @Nullable
    public static JSType expandTypedefs(@Nullable PsiElement context, @NotNull String typeName) {
        if (typeName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(24);
        }
        THashMap visited = new THashMap();
        THashSet notVisited = new THashSet();
        JSRecursiveTypeVisitor visitor = new JSRecursiveTypeVisitor((Map)visited, (Set)notVisited){
            final /* synthetic */ Map val$visited;
            final /* synthetic */ Set val$notVisited;
            {
                this.val$visited = map;
                this.val$notVisited = set;
            }

            public void visitJSTypeImpl(@NotNull JSType type) {
                String resolvedTypeText;
                if (type == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (type.getSource().isStrict() && !this.val$visited.containsKey(resolvedTypeText = type.getResolvedTypeText())) {
                    this.val$notVisited.add(resolvedTypeText);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/index/JSTypeEvaluateManager$3", "visitJSTypeImpl"));
            }
        };
        notVisited.add(typeName);
        while (!notVisited.isEmpty()) {
            String next = (String)notVisited.iterator().next();
            notVisited.remove(next);
            JSType value = JSTypeEvaluateManager.getTypedefValue(context, next);
            visited.put(next, value);
            if (value == null) continue;
            value.accept(visitor);
        }
        Ref substitutionsLeft = Ref.create((Object)30);
        Function mapping = arg_0 -> JSTypeEvaluateManager.lambda$expandTypedefs$3((Map)visited, substitutionsLeft, arg_0);
        JSType typedefValue = (JSType)visited.get(typeName);
        return typedefValue != null ? JSTypeUtils.applyCompositeMapping(typedefValue, (Function<JSType, JSType>)mapping) : null;
    }

    @Nullable
    public static JSType getTypedefValue(@Nullable PsiElement context, String typeName) {
        if (context == null) {
            return null;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        Ref associatedType = Ref.create(null);
        Ref associatedTypeSource = Ref.create(null);
        StubIndex.getInstance().processElements(JSTypedefIndex.KEY, (Object)typeName, context.getProject(), scope, JSElement.class, element -> {
            if (!(element instanceof JSImplicitElementProvider)) {
                LOG.error("only JSImplicitElementProviders should add info to typedef index");
                return true;
            }
            JSElementIndexingData data = ((JSImplicitElementProvider)element).getIndexingData();
            if (data == null) {
                LOG.error("JSElementIndexingData mustn't be null for element referenced in typedef index");
                return true;
            }
            Collection typedefs = data.getTypedefs();
            if (typedefs == null || typedefs.isEmpty()) {
                LOG.error("JSElementIndexingData.getTypedef() mustn't be null");
                return true;
            }
            for (Pair typedef : typedefs) {
                if (!typeName.equals(typedef.first)) continue;
                associatedType.set((Object)JSTypedefIndex.getTypeByIndexValue((String)typedef.second));
                JSElement sourceElement = element;
                Collection implicitElements = data.getImplicitElements();
                if (implicitElements != null) {
                    for (JSImplicitElement implicitElement : implicitElements) {
                        if (!((String)typedef.first).equals(implicitElement.getQualifiedName())) continue;
                        sourceElement = implicitElement;
                        break;
                    }
                }
                associatedTypeSource.set((Object)sourceElement);
            }
            return false;
        });
        if (!associatedType.isNull()) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)associatedTypeSource.get(), true);
            return JSTypeUtils.parseSerializedOrJSDocType((String)associatedType.get(), source);
        }
        return null;
    }

    public static boolean iterateSubclasses(@NotNull PsiElement context, @NotNull String typeName, NamespaceProcessor processor) {
        if (context == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(25);
        }
        if (typeName == null) {
            JSTypeEvaluateManager.$$$reportNull$$$0(26);
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        THashMap indexValues = new THashMap();
        Collection elements = StubIndex.getElements(JSSubclassIndex.KEY, (Object)typeName, (Project)context.getProject(), (GlobalSearchScope)scope, JSElement.class);
        for (JSElement element : elements) {
            Collection baseTypes;
            JSElementIndexingData indexingData = element instanceof JSImplicitElementProvider ? ((JSImplicitElementProvider)element).getIndexingData() : null;
            if (indexingData == null || (baseTypes = indexingData.getBaseTypes()) == null) continue;
            VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
            Set fileBaseTypes = (Set)indexValues.get(virtualFile);
            if (fileBaseTypes == null) {
                fileBaseTypes = new THashSet();
                indexValues.put(virtualFile, fileBaseTypes);
            }
            for (Pair baseType : baseTypes) {
                fileBaseTypes.add(baseType.first);
            }
        }
        Collection<VirtualFile> files = JSResolveUtil.sortFiles(indexValues.keySet());
        for (VirtualFile file2 : files) {
            for (String s : (Set)indexValues.get(file2)) {
                if (processor.process(s, file2)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isArrayType(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith("[]") || s.indexOf(91) != -1 || s.startsWith("...") || s.indexOf(60) != -1 && (s.startsWith("Vector") || s.startsWith("Array") || s.startsWith("Object"));
    }

    public static String getComponentType(String s) {
        JSType type;
        if (s.endsWith("[]")) {
            return s.substring(0, s.length() - 2);
        }
        if (s.startsWith("...")) {
            return s.substring(3);
        }
        int i = s.indexOf(91);
        if (i != -1) {
            return s.substring(i + 1);
        }
        if (s.indexOf(60) != -1 && (s.startsWith("Vector") || s.startsWith("Array") || s.startsWith("Object")) && (type = new JSTypeParser(s, JSTypeSource.EMPTY).parse()) instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            List<JSType> genericArguments = genericType.getArguments();
            JSType lastGenericType = genericArguments.get(genericArguments.size() - 1);
            return lastGenericType.getResolvedTypeText();
        }
        return s;
    }

    private static /* synthetic */ JSType lambda$expandTypedefs$3(Map visited, Ref substitutionsLeft, JSType type) {
        JSType typedefValue;
        if (type instanceof JSTypeImpl && (typedefValue = (JSType)visited.get(type.getResolvedTypeText())) != null && (Integer)substitutionsLeft.get() > 0) {
            substitutionsLeft.set((Object)((Integer)substitutionsLeft.get() - 1));
            return typedefValue;
        }
        return type;
    }

    private static /* synthetic */ boolean lambda$iterateTypeHierarchyFromBaseTypesIndex$1(String nsName, THashMap visited, List descendants, List currentTypeBaseElements, JSElement element) {
        VirtualFile file2 = element.getContainingFile().getVirtualFile();
        if (element instanceof JSImplicitElementProvider) {
            Collection baseTypes;
            JSElementIndexingData indexingData = ((JSImplicitElementProvider)element).getIndexingData();
            Collection collection = baseTypes = indexingData != null ? indexingData.getBaseTypes() : null;
            if (baseTypes != null) {
                for (Pair inheritance : baseTypes) {
                    List virtualFiles1;
                    if (!nsName.equals(inheritance.first)) continue;
                    String inherited = (String)inheritance.second;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found " + (String)inheritance.first + " extends " + (String)inheritance.second);
                    }
                    if ((virtualFiles1 = (List)visited.get((Object)inherited)) == null) {
                        virtualFiles1 = new SmartList();
                        visited.put((Object)inherited, (Object)virtualFiles1);
                        descendants.add(inherited);
                    }
                    if (virtualFiles1.contains(file2)) continue;
                    virtualFiles1.add(file2);
                }
            }
        } else if (element instanceof JSObjectLiteralExpression) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found base object literal for " + nsName);
            }
            currentTypeBaseElements.add((JSObjectLiteralExpression)element);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myContext";
                break;
            }
            case 10: 
            case 12: 
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceProcessor";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialTypes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSTypeEvaluateManager";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSTypeEvaluateManager";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSuperClassesHierarchy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findNearestExtendedJSTypes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "iterateTypeHierarchy";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "iterateTypeHierarchyFromJSClasses";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "iterateTypeHierarchyFromBaseTypesIndex";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildSuperClassesHierarchy";
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addSuperClasses";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findSuperClass";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "expandTypedefs";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "iterateSubclasses";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$iterateTypeHierarchy$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface NamespaceProcessor {
        public boolean process(String var1, VirtualFile var2);
    }
}

