/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSConsecutiveCommasInArrayLiteralInspection
extends JSInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.consecutive.commas.in.array.literal.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSConsecutiveCommasInArrayLiteralInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSArrayLiteralExpression(JSArrayLiteralExpression node) {
                PsiElement child = node.getFirstChild();
                while (child != null) {
                    ASTNode astNode;
                    PsiElement nextSibling = child.getNextSibling();
                    while (nextSibling instanceof PsiWhiteSpace || nextSibling instanceof PsiComment) {
                        nextSibling = nextSibling.getNextSibling();
                    }
                    if (nextSibling != null && (astNode = child.getNode()).getElementType() == JSElementTypes.EMPTY_EXPRESSION) {
                        ASTNode next;
                        for (next = astNode.getTreeNext(); next != null && next.getElementType() != JSTokenTypes.COMMA; next = next.getTreeNext()) {
                        }
                        if (next == null) continue;
                        holder.registerProblem((PsiElement)node, new TextRange(child.getStartOffsetInParent(), nextSibling.getStartOffsetInParent() + 1), JSBundle.message((String)"js.consecutive.commas.in.array.literal.inspection.message", (Object[])new Object[0]), new LocalQuickFix[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.remove.unneeded.comma.fix", false, astNode, next), new InsertUndefinedFix(child)});
                    }
                    child = nextSibling;
                }
            }
        };
        if (jSElementVisitor == null) {
            JSConsecutiveCommasInArrayLiteralInspection.$$$reportNull$$$0(1);
        }
        return jSElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class InsertUndefinedFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected InsertUndefinedFix(@Nullable PsiElement element) {
            super(element);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                InsertUndefinedFix.$$$reportNull$$$0(0);
            }
            if (file2 == null) {
                InsertUndefinedFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                InsertUndefinedFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                InsertUndefinedFix.$$$reportNull$$$0(3);
            }
            InsertUndefinedFix.replaceWithUndefined(startElement);
        }

        public static PsiElement replaceWithUndefined(@NotNull PsiElement startElement) {
            if (startElement == null) {
                InsertUndefinedFix.$$$reportNull$$$0(4);
            }
            ASTNode undefined = JSChangeUtil.createExpressionWithContext("undefined", startElement);
            assert (undefined != null);
            return startElement.replace(undefined.getPsi());
        }

        @NotNull
        public String getText() {
            String string = JSBundle.message((String)"js.consecutive.commas.in.array.literal.inspection.insert.undefined", (Object[])new Object[0]);
            if (string == null) {
                InsertUndefinedFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                InsertUndefinedFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection$InsertUndefinedFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSConsecutiveCommasInArrayLiteralInspection$InsertUndefinedFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceWithUndefined";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

