/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionExpressionToArrowFunctionQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    @NotNull
    private final SmartPsiElementPointer<JSFunctionExpression> myPointer;

    public JSFunctionExpressionToArrowFunctionQuickFix(@NotNull SmartPsiElementPointer<JSFunctionExpression> pointer) {
        if (pointer == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(0);
        }
        this.myPointer = pointer;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.to.arrow.function", (Object[])new Object[0]);
        if (string == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.to.arrow.function", (Object[])new Object[0]);
        if (string == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        JSFunctionExpression functionExpression;
        if (project == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(4);
        }
        if ((functionExpression = (JSFunctionExpression)this.myPointer.getElement()) == null || !functionExpression.isValid()) {
            return false;
        }
        if (JSPsiImplUtils.isArrowFunction((JSFunction)functionExpression) || PsiTreeUtil.findChildOfType((PsiElement)functionExpression, JSThisExpression.class) != null) {
            return false;
        }
        NameChecker nameChecker = new NameChecker(functionExpression);
        return nameChecker.check();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(5);
        }
        this.applyImpl();
    }

    private void applyImpl() {
        boolean wrapWithParenthesis;
        JSBlockStatement arrowFunctionBody;
        JSFunctionExpression functionExpression = (JSFunctionExpression)this.myPointer.getElement();
        if (functionExpression == null || !functionExpression.isValid()) {
            return;
        }
        NameChecker nameChecker = new NameChecker(functionExpression);
        if (!nameChecker.check()) {
            return;
        }
        nameChecker.rebindReferencesIfNeeded();
        JSBlockStatement functionExpressionBody = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)functionExpression, JSBlockStatement.class);
        String shortBodyText = functionExpressionBody == null ? null : JSFunctionExpressionToArrowFunctionQuickFix.getShortBodyText(functionExpressionBody);
        JSFunctionExpression arrowFunction = JSFunctionsRefactoringUtil.createArrowFunctionWithSameParameters((JSFunction)functionExpression, shortBodyText);
        if (shortBodyText == null && (arrowFunctionBody = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)arrowFunction, JSBlockStatement.class)) != null && functionExpressionBody != null) {
            JSChangeUtil.replaceStatement((JSStatement)arrowFunctionBody, (JSStatement)functionExpressionBody);
        }
        JSExpression expression = JSChangeUtil.replaceExpression((JSExpression)functionExpression, (JSExpression)((wrapWithParenthesis = functionExpression.getParent() instanceof JSReferenceExpression) ? JSChangeUtil.wrapInParentheses((JSExpression)arrowFunction) : arrowFunction));
        JSRefactoringUtil.reformatElementWithoutBody((PsiElement)expression, (PsiElement)expression);
    }

    private static String getShortBodyText(@NotNull JSBlockStatement block) {
        JSSourceElement statement;
        List elements;
        if (block == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(6);
        }
        if ((elements = ContainerUtil.filter((Object[])block.getChildren(), element -> JSChangeUtil.isSourceElementOrComment(element))).size() == 1 && elements.get(0) instanceof JSSourceElement && (statement = (JSSourceElement)elements.get(0)) instanceof JSReturnStatement && ((JSReturnStatement)statement).getExpression() != null) {
            JSExpression expression = ((JSReturnStatement)statement).getExpression();
            if (expression instanceof JSObjectLiteralExpression) {
                return "(" + expression.getText() + ")";
            }
            return expression == null ? "" : expression.getText();
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (project == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(7);
        }
        if (descriptor2 == null) {
            JSFunctionExpressionToArrowFunctionQuickFix.$$$reportNull$$$0(8);
        }
        this.applyImpl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getShortBodyText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class NameChecker {
        private static final Key<Pair<Boolean, String>> NOT_USED_OUTSIDE_ITSELF = Key.create((String)"JavaScript.JSFunctionExpression.To.Arrow.Function.Not.Used.Outside.Itself");
        private final JSFunctionExpression functionExpression;
        private String myNewNameIfRenameNeeded;

        public NameChecker(JSFunctionExpression functionExpression) {
            this.functionExpression = functionExpression;
        }

        public boolean check() {
            ASTNode nameNode = JSPsiImplUtils.findNameIdentifierOfFunction(this.functionExpression.getNode(), true);
            if (nameNode == null) {
                return true;
            }
            JSQualifiedNamedElement assignedTo = this.functionExpression.getElementAssignedTo();
            if (assignedTo != null && Comparing.equal((String)assignedTo.getName(), (String)nameNode.getText())) {
                return true;
            }
            Pair<Boolean, String> data = (Pair<Boolean, String>)this.functionExpression.getUserData(NOT_USED_OUTSIDE_ITSELF);
            if (data == null) {
                data = NameChecker.calculateNotUsedOutsideItself(this.functionExpression, assignedTo);
                this.functionExpression.putUserData(NOT_USED_OUTSIDE_ITSELF, data);
            }
            this.myNewNameIfRenameNeeded = (String)data.getSecond();
            return Boolean.TRUE.equals(data.getFirst());
        }

        private static Pair<Boolean, String> calculateNotUsedOutsideItself(@NotNull JSFunctionExpression functionExpression, @Nullable JSQualifiedNamedElement assignedTo) {
            Ref anyReferenceExists;
            Query search;
            boolean usageOutsideDefinition;
            if (functionExpression == null) {
                NameChecker.$$$reportNull$$$0(0);
            }
            boolean bl = usageOutsideDefinition = !(search = ReferencesSearch.search((PsiElement)functionExpression, (SearchScope)GlobalSearchScope.fileScope((PsiFile)functionExpression.getContainingFile()))).forEach(arg_0 -> NameChecker.lambda$calculateNotUsedOutsideItself$0(anyReferenceExists = new Ref((Object)false), functionExpression, arg_0));
            if (assignedTo == null) {
                return Pair.create((Object)((Boolean)anyReferenceExists.get() == false ? 1 : 0), null);
            }
            if (usageOutsideDefinition) {
                return Pair.create((Object)false, null);
            }
            if (((Boolean)anyReferenceExists.get()).booleanValue()) {
                return Pair.create((Object)true, (Object)assignedTo.getName());
            }
            return Pair.create((Object)true, null);
        }

        public void rebindReferencesIfNeeded() {
            if (this.myNewNameIfRenameNeeded != null && this.functionExpression.getElementAssignedTo() != null) {
                Collection references = ReferencesSearch.search((PsiElement)this.functionExpression, (SearchScope)GlobalSearchScope.fileScope((PsiFile)this.functionExpression.getContainingFile())).findAll();
                for (PsiReference reference : references) {
                    if (!(reference instanceof PsiElement)) continue;
                    reference.bindToElement((PsiElement)this.functionExpression.getElementAssignedTo());
                }
            }
        }

        private static /* synthetic */ boolean lambda$calculateNotUsedOutsideItself$0(Ref anyReferenceExists, @NotNull JSFunctionExpression functionExpression, PsiReference reference) {
            if (functionExpression == null) {
                NameChecker.$$$reportNull$$$0(1);
            }
            anyReferenceExists.set((Object)true);
            if (!(reference instanceof PsiElement)) {
                return true;
            }
            return PsiTreeUtil.isAncestor((PsiElement)functionExpression, (PsiElement)((PsiElement)reference), (boolean)false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "functionExpression";
            objectArray2[1] = "com/intellij/lang/javascript/inspections/JSFunctionExpressionToArrowFunctionQuickFix$NameChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateNotUsedOutsideItself";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$calculateNotUsedOutsideItself$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

