/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class JSUndefinedPropertyAssignmentInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUndefinedPropertyAssignmentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSUndefinedPropertyAssignmentInspection.$$$reportNull$$$0(1);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSDefinitionExpression(JSDefinitionExpression node) {
                PsiElement resolvedElement;
                if (!DialectDetector.isJavaScript((PsiElement)node)) {
                    return;
                }
                JSExpression expression = node.getExpression();
                if (!(expression instanceof JSReferenceExpression)) {
                    return;
                }
                JSReferenceExpression refExpr = (JSReferenceExpression)expression;
                JSExpression qualifier = refExpr.getQualifier();
                if (qualifier == null) {
                    return;
                }
                if (qualifier instanceof JSReferenceExpression && (!((resolvedElement = ((JSReferenceExpression)qualifier).resolve()) instanceof JSVariable) || resolvedElement instanceof ImplicitJSVariableImpl && "arguments".equals(((ImplicitJSVariableImpl)resolvedElement).getName()) || JSCorePredefinedLibrariesProvider.isLibraryElement(resolvedElement))) {
                    return;
                }
                if (qualifier instanceof JSThisExpression) {
                    return;
                }
                JSType type = JSCompositeTypeImpl.optimizeTypeIfComposite(JSTypeUtils.getValuableType(JSResolveUtil.getExpressionJSType(qualifier)));
                if (this.isExtensiblePredefinedType(type)) {
                    return;
                }
                PsiElement refExprResolve = refExpr.resolve();
                if (refExprResolve != node) {
                    return;
                }
                String property = refExpr.getReferenceName();
                if (property == null) {
                    return;
                }
                if (!(JSTypeUtils.isNewPropertiesDefinitionAllowed(type) || type instanceof JSRecordType && ((JSRecordType)type).hasProperty(property))) {
                    PsiElement refName = refExpr.getReferenceNameElement();
                    String message = JSBundle.message((String)"js.undefined.property.assignment.inspection.message", (Object[])new Object[]{property, type.getTypeText(JSType.TypeTextFormat.PRESENTABLE)});
                    holder.registerProblem((PsiElement)(refName == null ? node : refName), message, new LocalQuickFix[0]);
                }
            }

            private boolean isExtensiblePredefinedType(JSType type) {
                Ref found = Ref.create((Object)false);
                JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)it -> {
                    if (!(it instanceof JSTypeImpl)) {
                        return true;
                    }
                    String typeText = it.getTypeText(JSType.TypeTextFormat.SIMPLE);
                    if (BaseJSSymbolProcessor.isNamedGlobalType(typeText, ((JSTypeImpl)it).getJSContext()) || "HTMLElement".equals(typeText) || "Element".equals(typeText)) {
                        found.set((Object)true);
                    }
                    return true;
                }), type);
                return (Boolean)found.get();
            }
        };
        if (jSElementVisitor == null) {
            JSUndefinedPropertyAssignmentInspection.$$$reportNull$$$0(2);
        }
        return jSElementVisitor;
    }

    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.undefined.property.assignment.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSUndefinedPropertyAssignmentInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUndefinedPropertyAssignmentInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUndefinedPropertyAssignmentInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

