/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCreateSwitchBranchesIntention
extends JavaScriptIntention {
    private final String myText = JSBundle.message((String)"js.create.switch.cases", (Object[])new Object[0]);

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(1);
        }
        JSSwitchStatement statement = JSCreateSwitchBranchesIntention.findSwitch(element);
        JSType cases = JSCreateSwitchBranchesIntention.findTypeForCases(statement);
        assert (cases != null);
        List<String> variants = JSCreateSwitchBranchesIntention.getAllCaseVariants(cases, JSCreateSwitchBranchesIntention.getExistingVariants(statement), JSCodeStyleSettings.getQuote((PsiElement)statement));
        ContainerUtil.sort(variants);
        PsiElement lBrace = JSCreateSwitchBranchesIntention.findLBrace((JSElement)statement);
        if (lBrace == null) {
            String statementText = statement.getText() + "{}";
            statement = (JSSwitchStatement)JSChangeUtil.replaceStatement((JSStatement)statement, (JSStatement)((JSSwitchStatement)Objects.requireNonNull(JSChangeUtil.createStatementFromTextWithContext(statementText, (PsiElement)statement)).getPsi()));
            lBrace = JSCreateSwitchBranchesIntention.findLBrace((JSElement)statement);
        }
        for (String variant : ContainerUtil.reverse(variants)) {
            statement.addAfter((PsiElement)JSCreateSwitchBranchesIntention.createCaseClause(variant, (PsiElement)statement), lBrace);
        }
    }

    @Nullable
    private static PsiElement findLBrace(@NotNull JSElement holder) {
        if (holder == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(2);
        }
        for (PsiElement child = holder.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNode().getElementType() != JSTokenTypes.LBRACE) continue;
            return child;
        }
        return null;
    }

    private static JSCaseClause createCaseClause(@NotNull String variant, @NotNull PsiElement context) {
        if (variant == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(3);
        }
        if (context == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(4);
        }
        ASTNode statement = JSChangeUtil.createStatementFromTextWithContext("switch (q) {case " + variant + ": break; }", context);
        assert (statement != null);
        JSSwitchStatement psi = (JSSwitchStatement)statement.getPsi();
        assert (psi != null);
        return psi.getCaseClauses()[0];
    }

    @NotNull
    public static List<String> getAllCaseVariants(@Nullable JSType cases, @NotNull Set<JSType> existingVariants, @Nullable String quote) {
        if (existingVariants == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(5);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        if (cases instanceof JSStringLiteralTypeImpl) {
            if (existingVariants.stream().noneMatch(v -> v instanceof JSStringLiteralTypeImpl && Objects.equals(((JSStringLiteralTypeImpl)v).getLiteral(), ((JSStringLiteralTypeImpl)cases).getLiteral()))) {
                String literal = ((JSStringLiteralTypeImpl)cases).getLiteral();
                if (quote == null) {
                    quote = "\"";
                }
                StringBuilder buffer = new StringBuilder();
                JSStringUtil.escapeSimpleStringChars(literal, quote.charAt(0), true, false, false, buffer);
                result2.add(quote + buffer + quote);
            }
        } else if (cases instanceof JSResolvableType) {
            TypeScriptEnum enumeration;
            JSResolvedTypeInfo info = ((JSResolvableType)cases).resolveType();
            if (info.isEnumLiteral()) {
                if (existingVariants.stream().noneMatch(v -> v.isEquivalentTo(cases, null))) {
                    result2.add(cases.getTypeText(JSType.TypeTextFormat.CODE));
                }
            } else if (info.isEnum() && (enumeration = info.getDeclarationOfType(TypeScriptEnum.class)) != null) {
                for (JSField field : enumeration.getFields()) {
                    String name = field.getName();
                    if (name == null) continue;
                    JSTypeImpl enumLiteralType = JSNamedTypeFactory.createEnumLiteralType((JSResolvableType)cases, (JSFieldVariable)field);
                    if (!existingVariants.stream().noneMatch(v -> v.isEquivalentTo((JSType)enumLiteralType, null))) continue;
                    result2.add(enumLiteralType.getTypeText(JSType.TypeTextFormat.CODE));
                }
            }
        } else if (cases instanceof JSUnionType) {
            for (JSType type : ((JSUnionType)cases).getTypes()) {
                result2.addAll(JSCreateSwitchBranchesIntention.getAllCaseVariants(type, existingVariants, quote));
            }
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        JSSwitchStatement statement;
        if (project == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(7);
        }
        if (element == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(8);
        }
        return !JSCreateSwitchBranchesIntention.getAllCaseVariants(JSCreateSwitchBranchesIntention.findTypeForCases(statement = JSCreateSwitchBranchesIntention.findSwitch(element)), JSCreateSwitchBranchesIntention.getExistingVariants(statement), null).isEmpty();
    }

    private static Set<JSType> getExistingVariants(@Nullable JSSwitchStatement statement) {
        if (statement == null) {
            return Collections.emptySet();
        }
        HashSet existingTypes = ContainerUtil.newHashSet();
        for (JSCaseClause clause : statement.getCaseClauses()) {
            JSType type = JSResolveUtil.getExpressionJSType(clause.getCaseExpression());
            if (type == null) continue;
            existingTypes.add(type);
        }
        return existingTypes;
    }

    private static JSType findTypeForCases(@Nullable JSSwitchStatement statement) {
        if (statement == null) {
            return null;
        }
        JSExpression expression = statement.getSwitchExpression();
        if (expression == null) {
            return null;
        }
        JSType jsType = JSResolveUtil.getExpressionJSType(expression);
        return JSCreateSwitchBranchesIntention.expandTypeForSwitch(jsType);
    }

    public static JSType expandTypeForSwitch(@Nullable JSType jsType) {
        JSType type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(jsType);
        if (type instanceof JSTypeWithIncompleteSubstitution) {
            type = ((JSTypeWithIncompleteSubstitution)type).substituteCompletely();
        }
        return JSTypeUtils.getValuableType(type, true);
    }

    @Nullable
    private static JSSwitchStatement findSwitch(@NotNull PsiElement element) {
        JSExpression expression;
        if (element == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(9);
        }
        if (element instanceof LeafPsiElement) {
            JSSwitchStatement statement;
            IElementType elementType = ((LeafPsiElement)element).getElementType();
            if (elementType == JSTokenTypes.SWITCH_KEYWORD) {
                return (JSSwitchStatement)ObjectUtils.tryCast((Object)element.getParent(), JSSwitchStatement.class);
            }
            if (elementType == JSTokenTypes.RPAR && (statement = (JSSwitchStatement)ObjectUtils.tryCast((Object)element.getParent(), JSSwitchStatement.class)) != null) {
                return statement;
            }
        }
        for (expression = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSExpression.class); expression != null && expression.getParent() instanceof JSExpression; expression = (JSExpression)expression.getParent()) {
        }
        if (expression == null) {
            return null;
        }
        JSSwitchStatement parentSwitch = (JSSwitchStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, JSSwitchStatement.class);
        return parentSwitch != null && parentSwitch.getSwitchExpression() == expression ? parentSwitch : null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.myText;
        if (string == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            JSCreateSwitchBranchesIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingVariants";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSCreateSwitchBranchesIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSCreateSwitchBranchesIntention";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCaseVariants";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findLBrace";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCaseClause";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllCaseVariants";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findSwitch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

