/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.javascript.highlighting.IntentionAndInspectionFilter;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaScriptIntention
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JavaScriptIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JavaScriptIntention.$$$reportNull$$$0(1);
        }
        return IntentionAndInspectionFilter.isIntentionSupportedForElement(((Object)((Object)this)).getClass(), element);
    }

    @Nullable
    protected static <T extends JSNamedElement> T findParentNamedElement(@NotNull PsiElement element, @NotNull Class<T> elementClass) {
        JSNamedElement el;
        if (element == null) {
            JavaScriptIntention.$$$reportNull$$$0(2);
        }
        if (elementClass == null) {
            JavaScriptIntention.$$$reportNull$$$0(3);
        }
        if ((el = (JSNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, elementClass)) == null) {
            return null;
        }
        return (T)(JavaScriptIntention.isAcceptableRangeForNamedElement(element, el) ? el : null);
    }

    @Nullable
    protected static <T extends JSFieldVariable> T findParentVariable(@NotNull PsiElement element, @NotNull Class<T> elementClass) {
        PsiElement psiElement;
        if (element == null) {
            JavaScriptIntention.$$$reportNull$$$0(4);
        }
        if (elementClass == null) {
            JavaScriptIntention.$$$reportNull$$$0(5);
        }
        if ((psiElement = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSVarStatement.class, elementClass})) == null) {
            return null;
        }
        JSFieldVariable variable = (JSFieldVariable)ObjectUtils.tryCast((Object)psiElement, elementClass);
        if (variable != null) {
            return (T)(JavaScriptIntention.isAcceptableRangeForNamedElement(element, (JSNamedElement)variable) ? variable : null);
        }
        if (psiElement instanceof JSVarStatement) {
            JSFieldVariable firstVar = (JSFieldVariable)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])((JSVarStatement)psiElement).getDeclarations()), elementClass);
            return (T)(firstVar != null && JavaScriptIntention.isAcceptableRangeForNamedElement(element, (JSNamedElement)firstVar) ? firstVar : null);
        }
        return null;
    }

    private static boolean isAcceptableRangeForNamedElement(@NotNull PsiElement element, @NotNull JSNamedElement named) {
        if (element == null) {
            JavaScriptIntention.$$$reportNull$$$0(6);
        }
        if (named == null) {
            JavaScriptIntention.$$$reportNull$$$0(7);
        }
        int startOffset = element.getTextRange().getStartOffset();
        if (named.getNameIdentifier() != null && startOffset > named.getNameIdentifier().getTextRange().getEndOffset()) {
            return false;
        }
        if (named instanceof JSAttributeListOwner) {
            JSAttributeList attributeList = ((JSAttributeListOwner)named).getAttributeList();
            if (attributeList == null) {
                return true;
            }
            ES6Decorator decorator = (ES6Decorator)ArrayUtil.getLastElement((Object[])attributeList.getDecorators());
            if (decorator != null && startOffset <= decorator.getTextRange().getEndOffset()) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "named";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/intentions/JavaScriptIntention";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findParentNamedElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findParentVariable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableRangeForNamedElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

