/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConvertAliasToInterfaceIntention
extends JavaScriptIntention {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        TypeScriptTypeAlias alias;
        if (project == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(1);
        }
        if ((alias = TypeScriptConvertAliasToInterfaceIntention.getAlias(element)) == null) {
            return;
        }
        TypeScriptType declaration = alias.getTypeDeclaration();
        if (!(declaration instanceof TypeScriptObjectType)) {
            return;
        }
        String aliasName = alias.getName();
        if (aliasName == null) {
            return;
        }
        ASTNode aliasNode = alias.getNode();
        ASTNode interfaceNode = JSChangeUtil.createStatementFromTextWithContext("interface " + aliasName + " {}", element);
        TypeScriptConvertAliasToInterfaceIntention.findChildAndReplace(JSStubElementTypes.ATTRIBUTE_LISTS, aliasNode, interfaceNode);
        TypeScriptConvertAliasToInterfaceIntention.findChildAndReplace(TypeScriptElementTypes.OBJECT_TYPE, aliasNode, interfaceNode);
        aliasNode.getTreeParent().replaceChild(aliasNode, interfaceNode);
        CodeStyleManager.getInstance((Project)project).reformat(interfaceNode.getPsi(TypeScriptInterface.class));
    }

    static void findChildAndReplace(@NotNull TokenSet set, @NotNull ASTNode current, @NotNull ASTNode newElement) {
        if (set == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(2);
        }
        if (current == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(3);
        }
        if (newElement == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(4);
        }
        ASTNode aliasAttributeList = current.findChildByType(set);
        ASTNode interfaceAttributeList = newElement.findChildByType(set);
        TypeScriptConvertAliasToInterfaceIntention.replaceNodes(newElement, aliasAttributeList, interfaceAttributeList);
    }

    private static void findChildAndReplace(@NotNull IElementType element, @NotNull ASTNode current, @NotNull ASTNode newElement) {
        if (element == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(5);
        }
        if (current == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(6);
        }
        if (newElement == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(7);
        }
        ASTNode aliasAttributeList = current.findChildByType(element);
        ASTNode interfaceAttributeList = newElement.findChildByType(element);
        TypeScriptConvertAliasToInterfaceIntention.replaceNodes(newElement, aliasAttributeList, interfaceAttributeList);
    }

    private static void replaceNodes(@NotNull ASTNode newElement, ASTNode newNode, ASTNode oldNode) {
        if (newElement == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(8);
        }
        if (newNode != null && oldNode != null) {
            newElement.replaceChild(oldNode, newNode.copyElement());
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(9);
        }
        if (element == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(10);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        if (!(file2 instanceof JSFile) || !DialectDetector.isTypeScript(element)) {
            return false;
        }
        TypeScriptTypeAlias alias = TypeScriptConvertAliasToInterfaceIntention.getAlias(element);
        return alias != null && alias.getTypeDeclaration() instanceof TypeScriptObjectType;
    }

    @Nullable
    static TypeScriptTypeAlias getAlias(@NotNull PsiElement element) {
        TypeScriptTypeAlias alias;
        if (element == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(11);
        }
        if ((alias = (TypeScriptTypeAlias)PsiTreeUtil.getParentOfType((PsiElement)element, TypeScriptTypeAlias.class)) == null) {
            return null;
        }
        TypeScriptType declaration = alias.getTypeDeclaration();
        if (declaration == null || PsiTreeUtil.isAncestor((PsiElement)declaration, (PsiElement)element, (boolean)true)) {
            return null;
        }
        return alias;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"ts.convert.alias.to.interface.action.family.name", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"ts.convert.alias.to.interface.action.title", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptConvertAliasToInterfaceIntention.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/TypeScriptConvertAliasToInterfaceIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/TypeScriptConvertAliasToInterfaceIntention";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findChildAndReplace";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceNodes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAlias";
                break;
            }
            case 12: 
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

