/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TypeScriptParameterPropertyToFieldIntention
extends JavaScriptIntention
implements LowPriorityAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            TypeScriptParameterPropertyToFieldIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeScriptParameterPropertyToFieldIntention.$$$reportNull$$$0(1);
        }
        JSParameter param = (JSParameter)PsiTreeUtil.getParentOfType((PsiElement)element, JSParameter.class);
        assert (param != null);
        ASTNode newMember = JSChangeUtil.createClassMemberFromText(project, param.getText() + ";", DialectDetector.languageDialectOfElement(element));
        JSFunction f = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)param, JSFunction.class);
        assert (f != null);
        JSClass clazz = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)param, JSClass.class);
        assert (clazz != null);
        clazz.addBefore(newMember.getPsi(), (PsiElement)f);
        JSSourceElement[] body = f.getBody();
        assert (body.length == 1);
        assert (body[0] instanceof JSBlockStatement);
        JSBlockStatement blockStatement = (JSBlockStatement)body[0];
        JSStatement[] statements = blockStatement.getStatements();
        PsiElement assignment = JSChangeUtil.createStatementFromTextWithContext("this." + param.getName() + " = " + param.getName() + ";", (PsiElement)f).getPsi();
        PsiElement newElement = null;
        if (statements.length == 0) {
            newElement = blockStatement.addAfter(assignment, blockStatement.getFirstChild());
        } else {
            boolean superFound = false;
            for (JSStatement statement : statements) {
                JSExpression methodExpression;
                JSExpression expression;
                if (!(statement instanceof JSExpressionStatement) || !((expression = ((JSExpressionStatement)statement).getExpression()) instanceof JSCallExpression) || !((methodExpression = ((JSCallExpression)expression).getMethodExpression()) instanceof JSSuperExpression)) continue;
                superFound = true;
                newElement = blockStatement.addAfter(assignment, (PsiElement)statement);
            }
            if (!superFound) {
                newElement = blockStatement.addAfter(assignment, blockStatement.getFirstChild());
            }
        }
        assert (newElement != null);
        FormatFixer.create(newElement, FormatFixer.Mode.Reformat).fixFormat();
        JSAttributeListWrapper wrapperForParam = new JSAttributeListWrapper(param.getAttributeList(), project);
        wrapperForParam.removeAccessModifier();
        wrapperForParam.removeOriginalAttributes();
        wrapperForParam.overrideModifier(JSAttributeList.ModifierType.READONLY, false);
        wrapperForParam.applyTo((JSAttributeListOwner)param);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            TypeScriptParameterPropertyToFieldIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            TypeScriptParameterPropertyToFieldIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSParameter param = (JSParameter)PsiTreeUtil.getParentOfType((PsiElement)element, JSParameter.class);
        if (param == null || !DialectDetector.isTypeScript((PsiElement)param)) {
            return false;
        }
        PsiElement parent = param.getParent();
        if (!(parent instanceof JSParameterList)) {
            return false;
        }
        PsiElement parentParent = parent.getParent();
        if (!(parentParent instanceof JSFunction) || !((JSFunction)parentParent).isConstructor()) {
            return false;
        }
        JSAttributeList attributeList = param.getAttributeList();
        return attributeList != null && (attributeList.hasModifier(JSAttributeList.ModifierType.READONLY) || attributeList.getExplicitAccessType() != null);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"ts.convert.parameter.property.to.field", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptParameterPropertyToFieldIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"ts.convert.parameter.property.to.field", (Object[])new Object[0]);
        if (string == null) {
            TypeScriptParameterPropertyToFieldIntention.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/TypeScriptParameterPropertyToFieldIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/TypeScriptParameterPropertyToFieldIntention";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

