/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json;

import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.json.adapters.JSJsonPropertyAdapter;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSJsonLikePsiWalker
implements JsonLikePsiWalker {
    private final boolean myTopLevelArraysAllowed;

    public JSJsonLikePsiWalker(boolean allowed) {
        this.myTopLevelArraysAllowed = allowed;
    }

    public ThreeState isName(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof JSObjectLiteralExpression) {
            return ThreeState.YES;
        }
        if (parent instanceof JSProperty) {
            return PsiTreeUtil.isAncestor((PsiElement)((JSProperty)parent).getNameIdentifier(), (PsiElement)element, (boolean)false) ? ThreeState.YES : ThreeState.NO;
        }
        if (parent instanceof JSReferenceExpression) {
            if (((JSReferenceExpression)parent).getQualifier() != null) {
                return ThreeState.NO;
            }
            PsiElement parentParent = parent.getParent();
            return parentParent instanceof ES6Property && ((ES6Property)parentParent).isShorthanded() ? ThreeState.YES : ThreeState.NO;
        }
        return ThreeState.NO;
    }

    public boolean isPropertyWithValue(@NotNull PsiElement element) {
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(0);
        }
        return element instanceof JSProperty && ((JSProperty)element).getValue() != null;
    }

    public PsiElement goUpToCheckable(@NotNull PsiElement element) {
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(1);
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile) && !(current instanceof JSEmbeddedContent); current = current.getParent()) {
            if (!(current instanceof JSExpression) && !(current instanceof JSProperty)) continue;
            return current;
        }
        return null;
    }

    @Nullable
    public List<JsonSchemaVariantsTreeBuilder.Step> findPosition(@NotNull PsiElement element, boolean forceLastTransition) {
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(2);
        }
        ArrayList<JsonSchemaVariantsTreeBuilder.Step> steps = new ArrayList<JsonSchemaVariantsTreeBuilder.Step>();
        PsiElement current = element;
        while (!this.breakCondition(current)) {
            String propertyName;
            PsiElement position = current;
            if ((current = current.getParent()) instanceof JSArrayLiteralExpression) {
                JSArrayLiteralExpression array = (JSArrayLiteralExpression)current;
                JSExpression[] expressions = array.getExpressions();
                int idx = -1;
                for (int i = 0; i < expressions.length; ++i) {
                    JSExpression value = expressions[i];
                    if (!position.equals(value)) continue;
                    idx = i;
                    break;
                }
                steps.add(JsonSchemaVariantsTreeBuilder.Step.createArrayElementStep((int)idx));
                continue;
            }
            if (current instanceof JSProperty) {
                propertyName = StringUtil.notNullize((String)((JSProperty)current).getName());
                if (!((current = current.getParent()) instanceof JSObjectLiteralExpression)) {
                    return null;
                }
                if (position == element && !forceLastTransition) continue;
                steps.add(JsonSchemaVariantsTreeBuilder.Step.createPropertyStep((String)propertyName));
                continue;
            }
            if (current instanceof JSObjectLiteralExpression && position instanceof JSProperty) {
                if (position == element && !forceLastTransition) continue;
                propertyName = StringUtil.notNullize((String)((JSProperty)position).getName());
                steps.add(JsonSchemaVariantsTreeBuilder.Step.createPropertyStep((String)propertyName));
                continue;
            }
            if (this.breakCondition(current)) break;
            return null;
        }
        Collections.reverse(steps);
        return this.filterArray(steps);
    }

    private List<JsonSchemaVariantsTreeBuilder.Step> filterArray(List<JsonSchemaVariantsTreeBuilder.Step> steps) {
        if (steps.isEmpty()) {
            return steps;
        }
        if (!this.myTopLevelArraysAllowed && steps.get(0).isFromArray()) {
            return steps.subList(1, steps.size());
        }
        return steps;
    }

    public boolean isNameQuoted() {
        return false;
    }

    public boolean onlyDoubleQuotesForStringLiterals() {
        return false;
    }

    public boolean hasPropertiesBehindAndNoComma(@NotNull PsiElement element) {
        PsiElement current;
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = current = element instanceof JSProperty ? element : PsiTreeUtil.getParentOfType((PsiElement)element, JSProperty.class);
        while (current != null && current.getNode().getElementType() != JSTokenTypes.COMMA) {
            current = current.getNextSibling();
        }
        int commaOffset = current == null ? Integer.MAX_VALUE : current.getTextRange().getStartOffset();
        int offset = element.getTextRange().getStartOffset();
        JSObjectLiteralExpression object = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSObjectLiteralExpression.class);
        if (object != null) {
            for (JSProperty property : object.getProperties()) {
                int pOffset = property.getTextRange().getStartOffset();
                if (pOffset < offset || PsiTreeUtil.isAncestor((PsiElement)property, (PsiElement)element, (boolean)false)) continue;
                return pOffset < commaOffset;
            }
        }
        return false;
    }

    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement originalPosition, PsiElement computedPosition) {
        JSObjectLiteralExpression object;
        if (originalPosition == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(4);
        }
        if ((object = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)originalPosition, JSObjectLiteralExpression.class)) != null) {
            return Arrays.stream(object.getProperties()).filter(p -> p != null && p.getName() != null).map(p -> StringUtil.unquoteString((String)p.getName())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @Nullable
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement element) {
        JSProperty property;
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(5);
        }
        return (property = (JSProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JSProperty.class, (boolean)false)) == null ? null : new JSJsonPropertyAdapter(property);
    }

    private boolean breakCondition(PsiElement current) {
        return current instanceof PsiFile || current instanceof JSEmbeddedContent || JSJsonLikePsiWalker.isTerminalInStatement(current) || !this.myTopLevelArraysAllowed && current instanceof JSArrayLiteralExpression && JSJsonLikePsiWalker.isTerminalInStatement(current.getParent());
    }

    public static boolean isTerminalInStatement(PsiElement current) {
        return current instanceof JSStatement || current instanceof JSArgumentList || current instanceof JSVariable || current instanceof JSParenthesizedExpression && JSJsonLikePsiWalker.isParenthesisAroundObjectReturnedFromArrowFunction((JSParenthesizedExpression)current) || current instanceof JSAssignmentExpression && (current.getParent() instanceof JSStatement || current instanceof JSCommaExpression);
    }

    private static boolean isParenthesisAroundObjectReturnedFromArrowFunction(JSParenthesizedExpression parenthesis) {
        JSExpression inner = parenthesis.getInnerExpression();
        PsiElement parent = parenthesis.getParent();
        return inner instanceof JSObjectLiteralExpression && parent instanceof JSFunction && inner.equals(JSChangeUtil.getFunctionBody((JSFunction)parent));
    }

    public boolean isTopJsonElement(@NotNull PsiElement element) {
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(6);
        }
        return this.breakCondition(element);
    }

    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement element) {
        if (element == null) {
            JSJsonLikePsiWalker.$$$reportNull$$$0(7);
        }
        return element instanceof JSExpression ? JSJsonPropertyAdapter.createValueAdapterByType((JSExpression)element) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPosition";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/json/JSJsonLikePsiWalker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPropertyWithValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "goUpToCheckable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findPosition";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPropertiesBehindAndNoComma";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyNamesOfParentObject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getParentPropertyAdapter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isTopJsonElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createValueAdapter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

