/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.download;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.download.JSDownloadManager;
import com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider;
import com.intellij.lang.javascript.library.download.TypeScriptRelatedPackagesCollector;
import com.intellij.lang.javascript.library.download.TypeScriptRelatedPackagesStorage;
import com.intellij.lang.javascript.library.ui.JSScriptingContextProvider;
import com.intellij.lang.javascript.modules.PackageInstaller;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.packaging.PackageManagementService;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.rpc.CommandProcessorKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider;", "Lcom/intellij/openapi/roots/AdditionalLibraryRootsProvider;", "()V", "refreshed", "", "getAdditionalProjectLibraries", "", "Lcom/intellij/openapi/roots/SyntheticLibrary;", "project", "Lcom/intellij/openapi/project/Project;", "startRefresh", "", "directory", "Lcom/intellij/openapi/vfs/VirtualFile;", "LibraryCreator", "TypesSyntheticLibrary", "intellij.javascript.impl"})
public final class TypeScriptDefinitionFilesRootsProvider
extends AdditionalLibraryRootsProvider {
    private volatile boolean refreshed;
    public static final LibraryCreator LibraryCreator = new LibraryCreator(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        SyntheticLibrary delegate;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        VirtualFile directory;
        String it$iv$iv;
        String string;
        void $receiver$iv$iv2;
        Library[] $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
        JSLibraryManager jSLibraryManager = libraryManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)jSLibraryManager), (String)"libraryManager");
        ScriptingLibraryMappings mappings = jSLibraryManager.getLibraryMappings();
        LibraryTable libraryTable = libTable;
        Intrinsics.checkExpressionValueIsNotNull((Object)libraryTable, (String)"libTable");
        Library[] libraryArray = libraryTable.getLibraries();
        Intrinsics.checkExpressionValueIsNotNull((Object)libraryArray, (String)"libTable.libraries");
        Library[] libraryArray2 = $receiver$iv2 = libraryArray;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv2;
        int n = ((void)$receiver$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            String string2;
            void element$iv$iv$iv;
            void element$iv$iv;
            void it;
            void v3 = it = (element$iv$iv = (element$iv$iv$iv = $receiver$iv$iv$iv[i]));
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            String name = v3.getName();
            if (name != null && StringsKt.startsWith$default((String)name, (String)"@types/", (boolean)false, (int)2, null) && mappings.isAssociatedWithProject(name)) {
                String string3 = name;
                int n2 = "@types/".length();
                String string4 = string3.substring(n2);
                string2 = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string2 = null;
            }
            if (string2 == null) continue;
            it$iv$iv = string = string2;
            destination$iv$iv.add(it$iv$iv);
        }
        List fileNames = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (fileNames.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile2 = directory = virtualFile;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"directory");
        if (!virtualFile2.isValid()) {
            if (!this.refreshed) {
                this.startRefresh(directory, project);
            }
            return CollectionsKt.emptyList();
        }
        HashSet result2 = ContainerUtil.newHashSet((Iterable)fileNames);
        TypeScriptRelatedPackagesStorage storage = TypeScriptRelatedPackagesStorage.getStorage(project);
        if (storage != null) {
            Iterable $receiver$iv3 = fileNames;
            for (Object element$iv : $receiver$iv3) {
                String it = (String)element$iv;
                result2.addAll(storage.getRelatedPackageNames(directory, it));
            }
        }
        HashSet hashSet = result2;
        Intrinsics.checkExpressionValueIsNotNull((Object)hashSet, (String)"result");
        Iterable element$iv = $receiver$iv = (Iterable)hashSet;
        Collection destination$iv$iv2 = new ArrayList();
        void $receiver$iv$iv$iv2 = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv2) {
            Object element$iv$iv = element$iv$iv$iv;
            String it = (String)element$iv$iv;
            if (directory.findChild(it) == null) continue;
            it$iv$iv = string;
            destination$iv$iv2.add(it$iv$iv);
        }
        List files = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        if (files.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        SyntheticLibrary syntheticLibrary = delegate = SyntheticLibrary.newImmutableLibrary((Collection)files);
        Intrinsics.checkExpressionValueIsNotNull((Object)syntheticLibrary, (String)"delegate");
        return CollectionsKt.listOf((Object)((Object)new TypesSyntheticLibrary(syntheticLibrary)));
    }

    private final void startRefresh(VirtualFile directory, Project project) {
        this.refreshed = true;
        VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{directory});
        LocalFileSystem.getInstance().refreshFiles((Iterable)CollectionsKt.listOf((Object)directory), true, true, new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                if (this.$project.isDisposed()) {
                    return;
                }
                WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<E>(this){
                    final /* synthetic */ startRefresh.1 this$0;

                    public final void run() {
                        ProjectRootManagerEx.getInstanceEx((Project)this.this$0.$project).makeRootsChange(EmptyRunnable.getInstance(), false, true);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.$project = project;
            }
        });
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\u0013\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\u0010\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0013H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider$TypesSyntheticLibrary;", "Lcom/intellij/openapi/roots/SyntheticLibrary;", "Lcom/intellij/navigation/ItemPresentation;", "Lcom/intellij/pom/NavigatableWithText;", "delegateLibrary", "(Lcom/intellij/openapi/roots/SyntheticLibrary;)V", "canNavigate", "", "canNavigateToSource", "equals", "other", "", "getExcludeFileCondition", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getIcon", "Ljavax/swing/Icon;", "unused", "getLocationString", "", "getNavigateActionText", "focusEditor", "getPresentableText", "getSourceRoots", "", "hashCode", "", "navigate", "", "requestFocus", "intellij.javascript.impl"})
    public static final class TypesSyntheticLibrary
    extends SyntheticLibrary
    implements ItemPresentation,
    NavigatableWithText {
        private final SyntheticLibrary delegateLibrary;

        public void navigate(boolean requestFocus) {
        }

        public boolean canNavigate() {
            return false;
        }

        @Nullable
        public String getNavigateActionText(boolean focusEditor) {
            return null;
        }

        public boolean canNavigateToSource() {
            return false;
        }

        @Nullable
        public String getPresentableText() {
            return "@types";
        }

        @Nullable
        public String getLocationString() {
            return "";
        }

        @Nullable
        public Icon getIcon(boolean unused) {
            return null;
        }

        @NotNull
        public Collection<VirtualFile> getSourceRoots() {
            Collection collection = this.delegateLibrary.getSourceRoots();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"delegateLibrary.sourceRoots");
            return collection;
        }

        public boolean equals(@Nullable Object other) {
            return Intrinsics.areEqual((Object)this.delegateLibrary, (Object)other);
        }

        public int hashCode() {
            return this.delegateLibrary.hashCode();
        }

        @Nullable
        public Condition<VirtualFile> getExcludeFileCondition() {
            return getExcludeFileCondition.1.INSTANCE;
        }

        public TypesSyntheticLibrary(@NotNull SyntheticLibrary delegateLibrary) {
            Intrinsics.checkParameterIsNotNull((Object)delegateLibrary, (String)"delegateLibrary");
            this.delegateLibrary = delegateLibrary;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J4\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J*\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ<\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J6\u0010\u001b\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J,\u0010 \u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010!\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020\u001fH\u0002J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006$"}, d2={"Lcom/intellij/lang/javascript/library/download/TypeScriptDefinitionFilesRootsProvider$LibraryCreator;", "", "()V", "collectRelatedPackagesAndCreateLibrary", "Lcom/intellij/webcore/libraries/ScriptingLibraryModel;", "project", "Lcom/intellij/openapi/project/Project;", "description", "Lcom/intellij/util/download/DownloadableFileSetDescription;", "globalTypesDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "onLibraryCreated", "Ljava/lang/Runnable;", "createRequiredDirectories", "", "file", "Ljava/io/File;", "downloadByUrl", "", "notificationAreaComponent", "Ljava/awt/Component;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "downloadTypesLibrary", "downloadUsingNpm", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter;", "getCreateLibraryCallback", "Lcom/intellij/util/Function;", "", "getNameForLibrary", "", "logInstallingError", "message", "dialogTitle", "removeExistingPackageAndRelatedDirectories", "intellij.javascript.impl"})
    public static final class LibraryCreator {
        public final void downloadTypesLibrary(@NotNull Project project, @NotNull DownloadableFileSetDescription description, @Nullable Component notificationAreaComponent, @Nullable Runnable onLibraryCreated) {
            NodeJsLocalInterpreter nodeJsLocalInterpreter;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
            ApplicationManager.getApplication().assertIsDispatchThread();
            ModalityState modalityState = ModalityState.current();
            NodeJsInterpreterManager nodeJsInterpreterManager = NodeJsInterpreterManager.getInstance(project);
            Intrinsics.checkExpressionValueIsNotNull((Object)nodeJsInterpreterManager, (String)"NodeJsInterpreterManager.getInstance(project)");
            NodeJsInterpreter projectInterpreter = nodeJsInterpreterManager.getInterpreter();
            NodeJsInterpreter nodeJsInterpreter = projectInterpreter;
            if (!(nodeJsInterpreter instanceof NodeJsLocalInterpreter)) {
                nodeJsInterpreter = null;
            }
            if ((nodeJsLocalInterpreter = (NodeJsLocalInterpreter)nodeJsInterpreter) == null) {
                nodeJsLocalInterpreter = NodeJsLocalInterpreterManager.getInstance().detectMostRelevant();
            }
            NodeJsLocalInterpreter interpreter = nodeJsLocalInterpreter;
            this.removeExistingPackageAndRelatedDirectories(project, description);
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(interpreter, description, project, onLibraryCreated, notificationAreaComponent, modalityState){
                final /* synthetic */ NodeJsLocalInterpreter $interpreter;
                final /* synthetic */ DownloadableFileSetDescription $description;
                final /* synthetic */ Project $project;
                final /* synthetic */ Runnable $onLibraryCreated;
                final /* synthetic */ Component $notificationAreaComponent;
                final /* synthetic */ ModalityState $modalityState;

                public final void run() {
                    if (this.$interpreter != null && this.$interpreter.isValid()) {
                        ModalityState modalityState = this.$modalityState;
                        Intrinsics.checkExpressionValueIsNotNull((Object)modalityState, (String)"modalityState");
                        com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider$LibraryCreator.access$downloadUsingNpm(TypeScriptDefinitionFilesRootsProvider.LibraryCreator, this.$description, this.$project, this.$interpreter, this.$onLibraryCreated, this.$notificationAreaComponent, modalityState);
                    } else {
                        ModalityState modalityState = this.$modalityState;
                        Intrinsics.checkExpressionValueIsNotNull((Object)modalityState, (String)"modalityState");
                        com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider$LibraryCreator.access$downloadByUrl(TypeScriptDefinitionFilesRootsProvider.LibraryCreator, this.$description, this.$project, this.$onLibraryCreated, this.$notificationAreaComponent, modalityState);
                    }
                }
                {
                    this.$interpreter = nodeJsLocalInterpreter;
                    this.$description = downloadableFileSetDescription;
                    this.$project = project;
                    this.$onLibraryCreated = runnable;
                    this.$notificationAreaComponent = component;
                    this.$modalityState = modalityState;
                }
            });
        }

        private final void downloadUsingNpm(DownloadableFileSetDescription description, Project project, NodeJsLocalInterpreter interpreter, Runnable onLibraryCreated, Component notificationAreaComponent, ModalityState modalityState) {
            String globalTypesTargetPath = TypeScriptDefinitionFilesDirectory.getGlobalTypesTopDirectory();
            File file2 = new File(globalTypesTargetPath);
            if (!this.createRequiredDirectories(file2)) {
                String dialogTitle;
                String message = JSBundle.message((String)"npm.modules.install.global.types.directory.error", (Object[])new Object[0]);
                String string = dialogTitle = JSBundle.message((String)"npm.modules.install.global.types.dialog.title", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialogTitle");
                this.logInstallingError(project, notificationAreaComponent, message, string);
                return;
            }
            PackageManagementService.Listener listener2 = new PackageManagementService.Listener(project, notificationAreaComponent, description, onLibraryCreated){
                final /* synthetic */ Project $project;
                final /* synthetic */ Component $notificationAreaComponent;
                final /* synthetic */ DownloadableFileSetDescription $description;
                final /* synthetic */ Runnable $onLibraryCreated;

                public void operationStarted(@Nullable String packageName) {
                }

                public void operationFinished(@Nullable String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, errorDescription){
                        final /* synthetic */ downloadUsingNpm.listener.1 this$0;
                        final /* synthetic */ PackageManagementService.ErrorDescription $errorDescription;

                        public final void run() {
                            if (this.this$0.$project.isDisposed()) {
                                return;
                            }
                            if (this.$errorDescription != null) {
                                String message = JSBundle.message((String)"node.js.quickfix.install.node.module.error.prefix.text", (Object[])new Object[]{this.$errorDescription.getMessage()});
                                String dialogTitle = JSBundle.message((String)"node.js.quickfix.install.node.module.error.no.interpreter.title", (Object[])new Object[0]);
                                Project project = this.this$0.$project;
                                Component component = this.this$0.$notificationAreaComponent;
                                String string = dialogTitle;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dialogTitle");
                                com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider$LibraryCreator.access$logInstallingError(TypeScriptDefinitionFilesRootsProvider.LibraryCreator, project, component, message, string);
                                return;
                            }
                            String globalTypesDirectoryPath = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectoryPath();
                            File ioFile = new File(globalTypesDirectoryPath);
                            VirtualFile globalTypesDirectory2 = (VirtualFile)WriteAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<T, E>(ioFile){
                                final /* synthetic */ File $ioFile;

                                @Nullable
                                public final VirtualFile compute() {
                                    return VfsUtil.findFileByIoFile((File)this.$ioFile, (boolean)true);
                                }
                                {
                                    this.$ioFile = file2;
                                }
                            }));
                            if (globalTypesDirectory2 == null) {
                                return;
                            }
                            TypeScriptDefinitionFilesRootsProvider.LibraryCreator.collectRelatedPackagesAndCreateLibrary(this.this$0.$project, this.this$0.$description, globalTypesDirectory2, this.this$0.$onLibraryCreated);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$errorDescription = errorDescription;
                        }
                    });
                }
                {
                    this.$project = $captured_local_variable$0;
                    this.$notificationAreaComponent = $captured_local_variable$1;
                    this.$description = $captured_local_variable$2;
                    this.$onLibraryCreated = $captured_local_variable$3;
                }
            };
            PackageInstaller packageInstaller = new PackageInstaller(project, interpreter, "@types/" + description.getName(), null, file2, listener2, "--ignore-scripts");
            ApplicationManager.getApplication().invokeLater(new Runnable(project, packageInstaller){
                final /* synthetic */ Project $project;
                final /* synthetic */ PackageInstaller $packageInstaller;

                public final void run() {
                    if (this.$project.isDisposed()) {
                        return;
                    }
                    ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)this.$packageInstaller, (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)this.$packageInstaller));
                }
                {
                    this.$project = project;
                    this.$packageInstaller = packageInstaller;
                }
            }, modalityState);
        }

        private final void removeExistingPackageAndRelatedDirectories(Project project, DownloadableFileSetDescription description) {
            VirtualFile targetPackageDirectory;
            VirtualFile typesDirectory = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory();
            if (typesDirectory != null && typesDirectory.isValid() && (targetPackageDirectory = typesDirectory.findChild(description.getName())) != null && targetPackageDirectory.isValid()) {
                TypeScriptRelatedPackagesStorage typeScriptRelatedPackagesStorage = TypeScriptRelatedPackagesStorage.getStorage(project);
                if (typeScriptRelatedPackagesStorage == null) {
                    return;
                }
                TypeScriptRelatedPackagesStorage storage = typeScriptRelatedPackagesStorage;
                Collection<String> relatedPackageNames = storage.getRelatedPackageNames(typesDirectory, description.getName());
                WriteAction.run((ThrowableRunnable)new ThrowableRunnable<E>(relatedPackageNames, typesDirectory, targetPackageDirectory){
                    final /* synthetic */ Collection $relatedPackageNames;
                    final /* synthetic */ VirtualFile $typesDirectory;
                    final /* synthetic */ VirtualFile $targetPackageDirectory;

                    public final void run() {
                        VirtualFile it;
                        Iterable $receiver$iv$iv;
                        Collection collection = this.$relatedPackageNames;
                        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"relatedPackageNames");
                        Iterable $receiver$iv = collection;
                        Iterable iterable = $receiver$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            String string = (String)item$iv$iv;
                            Collection collection2 = destination$iv$iv;
                            VirtualFile virtualFile = this.$typesDirectory.findChild((String)it);
                            collection2.add(virtualFile);
                        }
                        $receiver$iv = (List)destination$iv$iv;
                        $receiver$iv$iv = $receiver$iv;
                        destination$iv$iv = new ArrayList<E>();
                        for (T element$iv$iv : $receiver$iv$iv) {
                            it = (VirtualFile)element$iv$iv;
                            if (!(it != null && it.isValid())) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $receiver$iv = (List)destination$iv$iv;
                        for (E element$iv : $receiver$iv) {
                            VirtualFile it2;
                            VirtualFile virtualFile = it2 = (VirtualFile)element$iv;
                            if (virtualFile == null) continue;
                            virtualFile.delete(null);
                        }
                        this.$targetPackageDirectory.delete(null);
                    }
                    {
                        this.$relatedPackageNames = collection;
                        this.$typesDirectory = virtualFile;
                        this.$targetPackageDirectory = virtualFile2;
                    }
                });
            }
        }

        @Nullable
        public final ScriptingLibraryModel collectRelatedPackagesAndCreateLibrary(@NotNull Project project, @NotNull DownloadableFileSetDescription description, @NotNull VirtualFile globalTypesDirectory2, @Nullable Runnable onLibraryCreated) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
            Intrinsics.checkParameterIsNotNull((Object)globalTypesDirectory2, (String)"globalTypesDirectory");
            Function<List<File>, ScriptingLibraryModel> callback = this.getCreateLibraryCallback(project, description, onLibraryCreated);
            String typesTargetPath = TypeScriptDefinitionFilesDirectory.getGlobalTypesTargetPath(description.getName());
            List<String> relatedPackages = new TypeScriptRelatedPackagesCollector(new File(typesTargetPath), globalTypesDirectory2).collectShortPackageNames();
            Collection collection = relatedPackages;
            if (!collection.isEmpty()) {
                TypeScriptRelatedPackagesStorage typeScriptRelatedPackagesStorage = TypeScriptRelatedPackagesStorage.getStorage(project);
                if (typeScriptRelatedPackagesStorage != null) {
                    typeScriptRelatedPackagesStorage.writeData(globalTypesDirectory2, description.getName(), (Collection<String>)relatedPackages);
                }
            }
            File packageFile = new File(typesTargetPath);
            return (ScriptingLibraryModel)callback.fun((Object)CollectionsKt.listOf((Object)packageFile));
        }

        private final void logInstallingError(Project project, Component notificationAreaComponent, String message, String dialogTitle) {
            CommandProcessorKt.getLOG().error("Error while installing @type " + StringUtil.notNullize((String)message));
            if (notificationAreaComponent != null) {
                Messages.showErrorDialog((Component)notificationAreaComponent, (String)message, (String)dialogTitle);
            } else {
                Messages.showErrorDialog((Project)project, (String)message, (String)dialogTitle);
            }
        }

        private final boolean createRequiredDirectories(File file2) {
            if (!file2.exists() && !FileUtil.createDirectory((File)file2)) {
                return false;
            }
            File nodeModulesDir = new File(file2, "node_modules");
            return nodeModulesDir.exists() || FileUtil.createDirectory((File)nodeModulesDir);
        }

        /*
         * WARNING - void declaration
         */
        private final void downloadByUrl(DownloadableFileSetDescription description, Project project, Runnable onLibraryCreated, Component notificationAreaComponent, ModalityState modalityState) {
            try {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                List list = description.getFiles();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"description.files");
                Iterable iterable = $receiver$iv = (Iterable)list;
                Collection destination$iv$iv = new ArrayList();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    DownloadableFileDescription it;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    DownloadableFileDescription downloadableFileDescription = it = (DownloadableFileDescription)element$iv$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)downloadableFileDescription, (String)"it");
                    if (downloadableFileDescription.getDownloadUrl() == null) continue;
                    String it$iv$iv = string;
                    destination$iv$iv.add(it$iv$iv);
                }
                List urls = (List)destination$iv$iv;
                Function<List<File>, ScriptingLibraryModel> callback = this.getCreateLibraryCallback(project, description, onLibraryCreated);
                ApplicationManager.getApplication().invokeLater(new Runnable(project, urls, notificationAreaComponent, callback, description){
                    final /* synthetic */ Project $project;
                    final /* synthetic */ List $urls;
                    final /* synthetic */ Component $notificationAreaComponent;
                    final /* synthetic */ Function $callback;
                    final /* synthetic */ DownloadableFileSetDescription $description;

                    public final void run() {
                        JSScriptingContextProvider.doDownload(this.$project, ContainerUtil.newArrayList((Iterable)ContainerUtil.newLinkedHashSet((Iterable)this.$urls)), "Downloading typings", this.$notificationAreaComponent, (Consumer<List<File>>)((Consumer)new Consumer<List<File>>(this){
                            final /* synthetic */ downloadByUrl.1 this$0;

                            public final void consume(List<File> it) {
                                this.this$0.$callback.fun(it);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }), new JSDownloadManager(this, TypeScriptDefinitionFilesDirectory.getGlobalTypesTargetPath(this.$description.getName()), null){
                            final /* synthetic */ downloadByUrl.1 this$0;

                            @NotNull
                            protected String getResultFileName(@NotNull String extension, boolean name) {
                                String fileName;
                                Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
                                String source = this.getActualSource();
                                String string = fileName = PathUtil.getFileName((String)source);
                                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
                                CharSequence charSequence = string;
                                return charSequence.length() > 0 ? fileName : extension;
                            }
                            {
                                this.this$0 = $outer;
                                super($super_call_param$1, $super_call_param$2);
                            }
                        });
                    }
                    {
                        this.$project = project;
                        this.$urls = list;
                        this.$notificationAreaComponent = component;
                        this.$callback = function;
                        this.$description = downloadableFileSetDescription;
                    }
                }, modalityState);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private final Function<List<File>, ScriptingLibraryModel> getCreateLibraryCallback(Project project, DownloadableFileSetDescription description, Runnable onLibraryCreated) {
            return (Function)new Function<List<? extends File>, ScriptingLibraryModel>(description, project, onLibraryCreated){
                final /* synthetic */ DownloadableFileSetDescription $description;
                final /* synthetic */ Project $project;
                final /* synthetic */ Runnable $onLibraryCreated;

                @Nullable
                public final ScriptingLibraryModel fun(List<? extends File> list) {
                    if (list.isEmpty()) {
                        return null;
                    }
                    return (ScriptingLibraryModel)WriteAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<T, E>(this){
                        final /* synthetic */ getCreateLibraryCallback.1 this$0;

                        @Nullable
                        public final ScriptingLibraryModel compute() {
                            ScriptingLibraryModel result2;
                            block1: {
                                ApplicationManager.getApplication().assertIsDispatchThread();
                                String libName = com.intellij.lang.javascript.library.download.TypeScriptDefinitionFilesRootsProvider$LibraryCreator.access$getNameForLibrary(TypeScriptDefinitionFilesRootsProvider.LibraryCreator, this.this$0.$description);
                                JSLibraryManager libraryManager = JSLibraryManager.getInstance(this.this$0.$project);
                                LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
                                if (libTable.getLibraryByName(libName) != null) {
                                    return null;
                                }
                                result2 = libraryManager.createLibrary(libName, VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, ArrayUtil.EMPTY_STRING_ARRAY, ScriptingLibraryModel.LibraryLevel.GLOBAL, false);
                                JSLibraryMappings mappings = JSLibraryMappings.getInstance(this.this$0.$project);
                                mappings.associate(null, libName, false);
                                libraryManager.commitChanges();
                                Runnable runnable = this.this$0.$onLibraryCreated;
                                if (runnable == null) break block1;
                                runnable.run();
                            }
                            return result2;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }));
                }
                {
                    this.$description = downloadableFileSetDescription;
                    this.$project = project;
                    this.$onLibraryCreated = runnable;
                }
            };
        }

        private final String getNameForLibrary(DownloadableFileSetDescription description) {
            return description.getVersionString() + "/" + description.getName();
        }

        private LibraryCreator() {
        }

        public static final /* synthetic */ void access$downloadUsingNpm(LibraryCreator $this, @NotNull DownloadableFileSetDescription description, @NotNull Project project, @NotNull NodeJsLocalInterpreter interpreter, @Nullable Runnable onLibraryCreated, @Nullable Component notificationAreaComponent, @NotNull ModalityState modalityState) {
            $this.downloadUsingNpm(description, project, interpreter, onLibraryCreated, notificationAreaComponent, modalityState);
        }

        public static final /* synthetic */ void access$downloadByUrl(LibraryCreator $this, @NotNull DownloadableFileSetDescription description, @NotNull Project project, @Nullable Runnable onLibraryCreated, @Nullable Component notificationAreaComponent, @NotNull ModalityState modalityState) {
            $this.downloadByUrl(description, project, onLibraryCreated, notificationAreaComponent, modalityState);
        }

        public static final /* synthetic */ void access$logInstallingError(LibraryCreator $this, @NotNull Project project, @Nullable Component notificationAreaComponent, @Nullable String message, @NotNull String dialogTitle) {
            $this.logInstallingError(project, notificationAreaComponent, message, dialogTitle);
        }

        @NotNull
        public static final /* synthetic */ String access$getNameForLibrary(LibraryCreator $this, @NotNull DownloadableFileSetDescription description) {
            return $this.getNameForLibrary(description);
        }

        public /* synthetic */ LibraryCreator(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

