/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class LinterUnsavedConfigFileManager {
    private static final Logger LOG = Logger.getInstance(LinterUnsavedConfigFileManager.class);
    private static final int SAVE_POSTPONE_TIMEOUT_MILLIS = 300;
    private final Project myProject;
    private final FileDocumentManager myDocumentManager;
    private final Map<VirtualFile, WatchedDocument> myWatchedDocumentsByFile;
    @NotNull
    private final Alarm myAlarm;
    private Runnable myUpdateRunnable;

    public LinterUnsavedConfigFileManager(@NotNull Project project, @NotNull FileDocumentManager documentManager) {
        if (project == null) {
            LinterUnsavedConfigFileManager.$$$reportNull$$$0(0);
        }
        if (documentManager == null) {
            LinterUnsavedConfigFileManager.$$$reportNull$$$0(1);
        }
        this.myWatchedDocumentsByFile = ContainerUtil.newHashMap();
        this.myProject = project;
        this.myDocumentManager = documentManager;
        this.myAlarm = new Alarm((Disposable)this.myProject);
        this.myUpdateRunnable = () -> {
            if (this.canSaveNow()) {
                this.doSaveFiles();
            } else {
                LOG.trace("Could not save now, rescheduling");
                this.myAlarm.addRequest(this.myUpdateRunnable, 300);
            }
        };
    }

    public boolean requestSaveIfNeeded(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            LinterUnsavedConfigFileManager.$$$reportNull$$$0(2);
        }
        Application application = ApplicationManager.getApplication();
        application.assertReadAccessAllowed();
        boolean hasModifiedConfigs = configs.stream().anyMatch(this::isFileModified);
        if (!hasModifiedConfigs) {
            return true;
        }
        application.invokeLater(() -> {
            if (configs == null) {
                LinterUnsavedConfigFileManager.$$$reportNull$$$0(5);
            }
            this.registerDocumentsToSave(configs);
            this.rescheduleSave();
        }, ModalityState.any(), this.myProject.getDisposed());
        return false;
    }

    private void registerDocumentsToSave(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            LinterUnsavedConfigFileManager.$$$reportNull$$$0(3);
        }
        configs.forEach(config2 -> {
            if (!this.isFileModified((VirtualFile)config2) || this.myWatchedDocumentsByFile.containsKey(config2)) {
                return;
            }
            Document document = this.myDocumentManager.getDocument(config2);
            if (document != null) {
                this.myWatchedDocumentsByFile.put((VirtualFile)config2, new WatchedDocument((VirtualFile)config2, document));
            } else {
                LOG.info("Could not find document for save for file: " + config2.getPath());
            }
        });
    }

    private void rescheduleSave() {
        if (this.myAlarm.isEmpty()) {
            LOG.trace("Scheduling save in 300");
            this.myAlarm.addRequest(this.myUpdateRunnable, 300);
        }
    }

    private void doSaveFiles() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myWatchedDocumentsByFile.values().stream().filter(item -> ((WatchedDocument)item).myFile.isValid()).forEach(item -> {
            LOG.debug("Saving " + ((WatchedDocument)item).myFile.getPath());
            this.myDocumentManager.saveDocument(((WatchedDocument)item).myDocument);
            item.stop();
        });
        this.myWatchedDocumentsByFile.clear();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    private boolean canSaveNow() {
        long currentTimeMillis = System.currentTimeMillis();
        return this.myWatchedDocumentsByFile.values().stream().allMatch(d -> currentTimeMillis - ((WatchedDocument)d).myLastModifiedMillis >= 300L);
    }

    private boolean isFileModified(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LinterUnsavedConfigFileManager.$$$reportNull$$$0(4);
        }
        return file2.isValid() && !file2.isDirectory() && this.myDocumentManager.isFileModified(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "requestSaveIfNeeded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerDocumentsToSave";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileModified";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$requestSaveIfNeeded$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class WatchedDocument
    implements DocumentListener {
        private final VirtualFile myFile;
        private final Document myDocument;
        private long myLastModifiedMillis;

        public WatchedDocument(@NotNull VirtualFile file2, @NotNull Document document) {
            if (file2 == null) {
                WatchedDocument.$$$reportNull$$$0(0);
            }
            if (document == null) {
                WatchedDocument.$$$reportNull$$$0(1);
            }
            this.myFile = file2;
            this.myDocument = document;
            this.myDocument.addDocumentListener((DocumentListener)this);
            this.myLastModifiedMillis = System.currentTimeMillis();
        }

        public void documentChanged(DocumentEvent e) {
            this.myLastModifiedMillis = System.currentTimeMillis();
        }

        public void stop() {
            this.myDocument.removeDocumentListener((DocumentListener)this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/linter/LinterUnsavedConfigFileManager$WatchedDocument";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

