/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterAnnotationsBuilder;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterStandardFixes;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.JSLinterWithInspectionExternalAnnotator;
import com.intellij.lang.javascript.linter.UntypedJSLinterConfigurable;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EsLintFixAction;
import com.intellij.lang.javascript.linter.eslint.EslintConfigurable;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintInspection;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintSuppressionUtil;
import com.intellij.lang.javascript.linter.eslint.service.ESLintLanguageService;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Convertor;
import icons.JavaScriptLanguageIcons;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintExternalAnnotator
extends JSLinterExternalAnnotator<EslintState> {
    private static final EslintExternalAnnotator INSTANCE_FOR_BATCH_INSPECTION = new EslintExternalAnnotator(false);

    @NotNull
    public static EslintExternalAnnotator getInstanceForBatchInspection() {
        EslintExternalAnnotator eslintExternalAnnotator = INSTANCE_FOR_BATCH_INSPECTION;
        if (eslintExternalAnnotator == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(0);
        }
        return eslintExternalAnnotator;
    }

    public EslintExternalAnnotator() {
        this(true);
    }

    public EslintExternalAnnotator(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @NotNull
    protected UntypedJSLinterConfigurable createSettingsConfigurable(@NotNull Project project) {
        if (project == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(1);
        }
        EslintConfigurable eslintConfigurable = new EslintConfigurable(project, true);
        if (eslintConfigurable == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(2);
        }
        return eslintConfigurable;
    }

    @Override
    protected Class<EslintConfiguration> getConfigurationClass() {
        return EslintConfiguration.class;
    }

    @Override
    protected Class<EslintInspection> getInspectionClass() {
        return EslintInspection.class;
    }

    @Override
    protected boolean acceptPsiFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(3);
        }
        return EslintExternalAnnotator.acceptPsiFileForEslintAnnotation(file2);
    }

    public static boolean acceptPsiFileForEslintAnnotation(@NotNull PsiFile file2) {
        if (file2 == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(4);
        }
        return file2 instanceof JSFile && JSUtils.isJavaScriptFile(file2) || JSLinterUtil.isPureHtmlFile(file2) || JSLinterUtil.isVueFile(file2) || TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(file2.getFileType());
    }

    @Override
    @Nullable
    public Icon getFileLevelAnnotationDefaultIcon() {
        return JavaScriptLanguageIcons.FileTypes.Eslint;
    }

    @Override
    @Nullable
    public JSLinterAnnotationResult<EslintState> annotate(@NotNull JSLinterInput<EslintState> input) {
        if (input == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(5);
        }
        ESLintLanguageService service = ESLintLanguageService.getInstance(input.getProject());
        return new EsLintExternalRunner(this.isOnTheFly(), false, service).execute(input);
    }

    @Override
    public void apply(@NotNull PsiFile file2, @Nullable JSLinterAnnotationResult<EslintState> annotationResult, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            EslintExternalAnnotator.$$$reportNull$$$0(7);
        }
        if (annotationResult == null) {
            return;
        }
        EslintConfigurable configurable = new EslintConfigurable(file2.getProject(), true);
        JSLinterStandardFixes fixes = new JSLinterStandardFixes().setEditSettingsAction(new JSLinterEditSettingsAction(configurable, JavaScriptLanguageIcons.FileTypes.Eslint)).setOtherFixes(Collections.singletonList(new EsLintFixAction().asIntentionAction())).setErrorToIntentionConverter((Convertor<JSLinterErrorBase, List<IntentionAction>>)((Convertor)o -> EslintSuppressionUtil.getSuppressionsForError(o, this.isOnTheFly())));
        new JSLinterAnnotationsBuilder<EslintState>(file2, annotationResult, holder, EslintInspection.getHighlightDisplayKey(), configurable, "ESLint: ", this.getInspectionClass(), fixes).setHighlightingGranularity(JSLinterWithInspectionExternalAnnotator.HighlightingGranularity.element).apply();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstanceForBatchInspection";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintExternalAnnotator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptPsiFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptPsiFileForEslintAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

