/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.importer;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.importer.EslintCodeStyleImporter;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import icons.JavaScriptLanguageIcons;
import org.jetbrains.annotations.NotNull;

public class EslintImportCodeStyleAction
extends AnAction {
    public static final String ACTION_ID = "EslintImportCodeStyle";

    public EslintImportCodeStyleAction() {
        super(JSBundle.message((String)"javascript.linter.import.translate.config.title", (Object[])new Object[0]), JSBundle.message((String)"javascript.linter.import.translate.config.title", (Object[])new Object[0]), JavaScriptLanguageIcons.FileTypes.Eslint);
    }

    public void update(AnActionEvent e) {
        DataContext context = e.getDataContext();
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        boolean enabledAndVisible = project != null && psiFile != null && (EslintUtil.isEslintConfigFile(psiFile) || EslintImportCodeStyleAction.isPackageJsonWithEslintConfigSection(psiFile));
        e.getPresentation().setEnabledAndVisible(enabledAndVisible);
    }

    private static boolean isPackageJsonWithEslintConfigSection(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            EslintImportCodeStyleAction.$$$reportNull$$$0(0);
        }
        VirtualFile vFile = psiFile.getVirtualFile();
        return PackageJsonUtil.isPackageJsonFile(psiFile) && vFile != null && PackageJsonUtil.getOrCreateData(vFile).getTopLevelProperties().contains("eslintConfig");
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext context = e.getDataContext();
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        assert (psiFile != null);
        new EslintCodeStyleImporter(false).importConfigFile(psiFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/linter/eslint/importer/EslintImportCodeStyleAction", "isPackageJsonWithEslintConfigSection"));
    }
}

