/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.macro.JSMacroUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class JSSuggestDefaultVariableKindMacro
extends Macro {
    public String getName() {
        return "jsSuggestDefaultVariableKind";
    }

    public String getPresentableName() {
        return JSBundle.message((String)"macro.js.suggest.default.variable.kind", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        if ("var" == null) {
            JSSuggestDefaultVariableKindMacro.$$$reportNull$$$0(0);
        }
        return "var";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        VarKindAllowed allowedVarKinds;
        if (params == null) {
            JSSuggestDefaultVariableKindMacro.$$$reportNull$$$0(1);
        }
        return new TextResult((allowedVarKinds = JSSuggestDefaultVariableKindMacro.getAllowedVarKinds(params, context)) == VarKindAllowed.OnlyVar ? "var" : (allowedVarKinds == VarKindAllowed.VarLet ? "let" : "const"));
    }

    private static VarKindAllowed getAllowedVarKinds(@NotNull Expression[] params, ExpressionContext context) {
        PsiElement element;
        if (params == null) {
            JSSuggestDefaultVariableKindMacro.$$$reportNull$$$0(2);
        }
        if ((element = context.getPsiElementAtStartOffset()) == null || !DialectDetector.isES6(element) && !DialectDetector.isTypeScript(element)) {
            return VarKindAllowed.OnlyVar;
        }
        if (params.length == 0) {
            return VarKindAllowed.VarLetConst;
        }
        return VarKindAllowed.VarLet;
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        VarKindAllowed allowed;
        if (params == null) {
            JSSuggestDefaultVariableKindMacro.$$$reportNull$$$0(3);
        }
        if ((allowed = JSSuggestDefaultVariableKindMacro.getAllowedVarKinds(params, context)) == VarKindAllowed.VarLetConst) {
            return new LookupElement[]{LookupElementBuilder.create((String)"const"), LookupElementBuilder.create((String)"let"), LookupElementBuilder.create((String)"var")};
        }
        if (allowed == VarKindAllowed.VarLet) {
            return new LookupElement[]{LookupElementBuilder.create((String)"let"), LookupElementBuilder.create((String)"var")};
        }
        return null;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return JSMacroUtil.isJSLikeContext(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/macro/JSSuggestDefaultVariableKindMacro";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/macro/JSSuggestDefaultVariableKindMacro";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateResult";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllowedVarKinds";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateLookupItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum VarKindAllowed {
        OnlyVar,
        VarLet,
        VarLetConst;

    }
}

