/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleNameInfo {
    @Nullable
    private final VirtualFile myModule;
    @NotNull
    private final VirtualFile myResolvedFile;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final String myQuote;

    public JSModuleNameInfo(@Nullable String path, @NotNull VirtualFile module, @NotNull PsiElement context) {
        if (module == null) {
            JSModuleNameInfo.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSModuleNameInfo.$$$reportNull$$$0(1);
        }
        this(path, module, module, context);
    }

    public JSModuleNameInfo(@Nullable String path, @Nullable VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedFile, @NotNull PsiElement context) {
        if (resolvedFile == null) {
            JSModuleNameInfo.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSModuleNameInfo.$$$reportNull$$$0(3);
        }
        this.myQuote = JSCodeStyleSettings.getQuote(context);
        this.myModuleName = JSModuleNameInfo.getModuleName(path, moduleFileOrDirectory, context);
        this.myModule = moduleFileOrDirectory;
        this.myResolvedFile = resolvedFile;
    }

    @NotNull
    public static String getModuleName(@Nullable String path, @Nullable VirtualFile moduleFileOrDirectory, @NotNull PsiElement context) {
        String extension;
        if (context == null) {
            JSModuleNameInfo.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmpty((String)path)) {
            if ("" == null) {
                JSModuleNameInfo.$$$reportNull$$$0(5);
            }
            return "";
        }
        boolean isFile = moduleFileOrDirectory == null || !moduleFileOrDirectory.isDirectory();
        String string = extension = isFile ? JSFileReference.findImplicitExtension(path) : null;
        if (extension == null) {
            String string2 = path;
            if (string2 == null) {
                JSModuleNameInfo.$$$reportNull$$$0(6);
            }
            return string2;
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
        if (settings.isUseExplicitJSExtension() && !ArrayUtil.contains((String)extension, (String[])TypeScriptFileImportsResolver.TS_EXTENSIONS)) {
            String string3 = path;
            if (string3 == null) {
                JSModuleNameInfo.$$$reportNull$$$0(7);
            }
            return string3;
        }
        String withoutExtension = StringUtil.trimEnd((String)path, (String)extension);
        String string4 = settings.isUseExplicitJSExtension() ? withoutExtension + ".js" : withoutExtension;
        if (string4 == null) {
            JSModuleNameInfo.$$$reportNull$$$0(8);
        }
        return string4;
    }

    public boolean isValid() {
        return !StringUtil.isEmpty((String)this.myModuleName);
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            JSModuleNameInfo.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.myQuote + this.getModuleName() + this.myQuote;
        if (string == null) {
            JSModuleNameInfo.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public VirtualFile getModuleFileOrDirectory() {
        VirtualFile virtualFile = this.myModule == null ? this.getResolvedFile() : this.myModule;
        if (virtualFile == null) {
            JSModuleNameInfo.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getResolvedFile() {
        VirtualFile virtualFile = this.myResolvedFile;
        if (virtualFile == null) {
            JSModuleNameInfo.$$$reportNull$$$0(12);
        }
        return virtualFile;
    }

    public String toString() {
        return this.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/JSModuleNameInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/JSModuleNameInfo";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleFileOrDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

