/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001:\u0002%&B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H$J;\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0004H$\u00a2\u0006\u0002\u0010\u0017J(\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0004H$J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u0019H\u0016J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0016\u00a8\u0006'"}, d2={"Lcom/intellij/lang/javascript/modules/JSModuleVisitor;", "Lcom/intellij/lang/javascript/psi/JSElementVisitor;", "()V", "createLiteralPointerBuilder", "Lcom/intellij/lang/javascript/modules/JSModuleVisitor$ModulePointerBuilder;", "argument", "Lcom/intellij/psi/PsiElement;", "createLiteralValueResolver", "Lcom/intellij/lang/javascript/modules/JSModuleVisitor$ImportResolver;", "Lcom/intellij/lang/javascript/psi/JSLiteralExpression;", "isAvailable", "", "element", "processImport", "", "literalElement", "quotedLiteralValue", "", "references", "", "Lcom/intellij/psi/PsiReference;", "importResolver", "pointerBuilder", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/psi/PsiReference;Lcom/intellij/lang/javascript/modules/JSModuleVisitor$ImportResolver;Lcom/intellij/lang/javascript/modules/JSModuleVisitor$ModulePointerBuilder;)V", "processRequire", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "visitES6FromClause", "fromClause", "Lcom/intellij/lang/ecmascript6/psi/ES6FromClause;", "visitES6ImportCall", "importCall", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportCall;", "visitJSCallExpression", "node", "visitTypeScriptImportStatement", "importStatement", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptImportStatement;", "ImportResolver", "ModulePointerBuilder", "intellij.javascript.impl"})
public abstract class JSModuleVisitor
extends JSElementVisitor {
    public void visitES6ImportCall(@NotNull ES6ImportCall importCall) {
        Intrinsics.checkParameterIsNotNull((Object)importCall, (String)"importCall");
        if (!this.isAvailable((PsiElement)importCall)) {
            return;
        }
        JSLiteralExpression argument = importCall.getStringArgument();
        if (argument == null) {
            return;
        }
        PsiElement psiElement = (PsiElement)argument;
        String string = argument.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"argument.text");
        PsiReference[] psiReferenceArray = argument.getReferences();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"argument.references");
        this.processImport(psiElement, string, psiReferenceArray, this.createLiteralValueResolver(argument), this.createLiteralPointerBuilder((PsiElement)argument));
    }

    public void visitTypeScriptImportStatement(@NotNull TypeScriptImportStatement importStatement) {
        Intrinsics.checkParameterIsNotNull((Object)importStatement, (String)"importStatement");
        if (!this.isAvailable((PsiElement)importStatement)) {
            return;
        }
        TypeScriptExternalModuleReference externalModuleReference = importStatement.getExternalModuleReference();
        if (externalModuleReference == null) {
            return;
        }
        Pair<String, PsiElement> literalWithText = JSPsiImplUtils.getChildStringLiteralWithText((PsiElement)externalModuleReference);
        if (literalWithText == null) {
            return;
        }
        PsiElement literalElement = (PsiElement)literalWithText.second;
        String quotedLiteralValue = (String)literalWithText.first;
        if (quotedLiteralValue == null) {
            return;
        }
        PsiElement psiElement = literalElement;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"literalElement");
        PsiReference[] psiReferenceArray = externalModuleReference.getReferences();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"externalModuleReference.references");
        this.processImport(psiElement, quotedLiteralValue, psiReferenceArray, new ImportResolver(externalModuleReference){
            final /* synthetic */ TypeScriptExternalModuleReference $externalModuleReference;

            @NotNull
            public Collection<PsiElement> resolveImportModules() {
                Collection<PsiElement> collection = JSFileReferencesUtil.resolveModuleReferences((PsiElement)this.$externalModuleReference);
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"JSFileReferencesUtil.res\u2026(externalModuleReference)");
                return collection;
            }
            {
                this.$externalModuleReference = $captured_local_variable$0;
            }
        }, this.createLiteralPointerBuilder(literalElement));
    }

    private final ImportResolver createLiteralValueResolver(JSLiteralExpression argument) {
        return new ImportResolver(argument){
            final /* synthetic */ JSLiteralExpression $argument;

            @NotNull
            public Collection<PsiElement> resolveImportModules() {
                Collection<PsiElement> collection = JSFileReferencesUtil.resolveModuleReferences((PsiElement)this.$argument);
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"JSFileReferencesUtil.res\u2026oduleReferences(argument)");
                return collection;
            }
            {
                this.$argument = $captured_local_variable$0;
            }
        };
    }

    public void visitES6FromClause(@NotNull ES6FromClause fromClause) {
        PsiElement literalElement;
        Pair<String, PsiElement> childStringLiteralWithText;
        Intrinsics.checkParameterIsNotNull((Object)fromClause, (String)"fromClause");
        if (!this.isAvailable((PsiElement)fromClause)) {
            return;
        }
        Pair<String, PsiElement> pair = childStringLiteralWithText = JSPsiImplUtils.getChildStringLiteralWithText((PsiElement)fromClause);
        Object object = literalElement = pair != null ? (PsiElement)pair.second : null;
        if (literalElement == null) {
            return;
        }
        String string = fromClause.getReferenceText();
        PsiElement psiElement = literalElement;
        JSModuleVisitor jSModuleVisitor = this;
        if (string == null) {
            String string2 = "Required value was null.";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String string3 = string;
        PsiReference[] psiReferenceArray = fromClause.getReferences();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiReferenceArray, (String)"fromClause.references");
        jSModuleVisitor.processImport(psiElement, string3, psiReferenceArray, new ImportResolver(fromClause){
            final /* synthetic */ ES6FromClause $fromClause;

            @NotNull
            public Collection<PsiElement> resolveImportModules() {
                Collection collection = this.$fromClause.resolveReferencedElements();
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"fromClause.resolveReferencedElements()");
                return collection;
            }
            {
                this.$fromClause = $captured_local_variable$0;
            }
        }, new ModulePointerBuilder(fromClause){
            final /* synthetic */ ES6FromClause $fromClause;

            @NotNull
            public InstallNodeModuleQuickFix.ModuleElement createPointer() {
                return new InstallNodeModuleQuickFix.ES6FromClauseModuleElement(this.$fromClause);
            }
            {
                this.$fromClause = $captured_local_variable$0;
            }
        });
    }

    public void visitJSCallExpression(@NotNull JSCallExpression node) {
        block5: {
            block4: {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                if (!this.isAvailable((PsiElement)node) || !node.isRequireCall()) break block4;
                JSExpression[] jSExpressionArray = node.getArguments();
                Intrinsics.checkExpressionValueIsNotNull((Object)jSExpressionArray, (String)"node.arguments");
                JSExpression[] jSExpressionArray2 = jSExpressionArray;
                if (!(jSExpressionArray2.length == 0)) break block5;
            }
            return;
        }
        JSExpression argument = node.getArguments()[0];
        if (!(argument instanceof JSLiteralExpression)) {
            return;
        }
        this.processRequire(node, (JSLiteralExpression)argument, this.createLiteralValueResolver((JSLiteralExpression)argument), this.createLiteralPointerBuilder((PsiElement)argument));
    }

    private final ModulePointerBuilder createLiteralPointerBuilder(PsiElement argument) {
        return new ModulePointerBuilder(argument){
            final /* synthetic */ PsiElement $argument;

            @NotNull
            public InstallNodeModuleQuickFix.ModuleElement createPointer() {
                return new InstallNodeModuleQuickFix.StringLiteralModuleElement(this.$argument);
            }
            {
                this.$argument = $captured_local_variable$0;
            }
        };
    }

    protected abstract boolean isAvailable(@NotNull PsiElement var1);

    protected abstract void processImport(@NotNull PsiElement var1, @NotNull String var2, @NotNull PsiReference[] var3, @NotNull ImportResolver var4, @NotNull ModulePointerBuilder var5);

    protected abstract void processRequire(@NotNull JSCallExpression var1, @NotNull JSLiteralExpression var2, @NotNull ImportResolver var3, @NotNull ModulePointerBuilder var4);

    protected JSModuleVisitor() {
    }

    @FunctionalInterface
    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&\u00a8\u0006\u0005"}, d2={"Lcom/intellij/lang/javascript/modules/JSModuleVisitor$ImportResolver;", "", "resolveImportModules", "", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.impl"})
    public static interface ImportResolver {
        @NotNull
        public Collection<PsiElement> resolveImportModules();
    }

    @FunctionalInterface
    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/intellij/lang/javascript/modules/JSModuleVisitor$ModulePointerBuilder;", "", "createPointer", "Lcom/intellij/lang/javascript/modules/InstallNodeModuleQuickFix$ModuleElement;", "intellij.javascript.impl"})
    public static interface ModulePointerBuilder {
        @NotNull
        public InstallNodeModuleQuickFix.ModuleElement createPointer();
    }
}

