/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.names;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.names.JSNamedEntityKind;
import com.intellij.lang.javascript.names.JSNamesSuggester;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNameSuggestionsUtil {
    @NonNls
    private static final String IMPL_SUFFIX = "Impl";
    @NonNls
    private static final String ELEMENT_SUFFIX = "Element";
    @NonNls
    private static final String KEY_SUFFIX = "Key";
    public static final String SPLIT_BY_CAMEL_CASE_REGEX = "(?<!^)(?=[A-Z])";

    @NotNull
    public static String getImplSuffix(Project project) {
        if (IMPL_SUFFIX == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(0);
        }
        return IMPL_SUFFIX;
    }

    @Contract(value="null, _ -> false")
    private static boolean isIdentifier(@Nullable String name, @Nullable PsiElement context) {
        if (name == null) {
            return false;
        }
        if ((name = QualifiedName.fromDottedString((String)name).getLastComponent()) == null) {
            return false;
        }
        JavascriptLanguage language = context == null ? JavascriptLanguage.INSTANCE : context.getLanguage();
        Project project = context == null ? null : context.getProject();
        return ((NamesValidator)LanguageNamesValidation.INSTANCE.forLanguage((Language)language)).isIdentifier(name, project);
    }

    @Nullable
    private static String generateNameFromJSTypeOrNull(@Nullable JSType type, @NotNull PsiElement context) {
        if (context == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(1);
        }
        if (type == null) {
            return null;
        }
        if (type instanceof JSAnyType) {
            return null;
        }
        if (type instanceof JSStringLiteralTypeImpl) {
            String literal = ((JSStringLiteralTypeImpl)type).getLiteral();
            if (literal.length() > 0 && StringUtil.isJavaIdentifierStart((char)literal.charAt(0))) {
                return literal;
            }
            return "s";
        }
        if (type instanceof JSIntType || type instanceof JSUintType) {
            return "i";
        }
        if (type instanceof JSStringType) {
            return "s";
        }
        if (type instanceof JSBooleanType) {
            return "b";
        }
        if (type instanceof JSPrimitiveFunctionType) {
            return "f";
        }
        String s = type.getTypeText(JSType.TypeTextFormat.CODE);
        if (!DialectDetector.isJavaScriptFamily(context) && "Class".equals(s)) {
            return "cls";
        }
        if (JSTypeUtils.getIndexableComponentType(type) != null || type instanceof JSGenericTypeImpl && ((JSGenericTypeImpl)type).getType() instanceof JSNamedType) {
            return JSNameSuggestionsUtil.getNameForComplexType(type, context);
        }
        return StringUtil.isEmpty((String)s) || !JSNameSuggestionsUtil.isIdentifier(s, context) ? null : s;
    }

    @Nullable
    private static String getNameForComplexType(@NotNull JSType type, @NotNull PsiElement context) {
        String s;
        if (type == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(3);
        }
        return StringUtil.isEmpty((String)(s = (String)ObjectUtils.coalesce((Object)JSNameSuggestionsUtil.getNameFromIterableType(type), (Object)JSNameSuggestionsUtil.getNameFromGenericType(type)))) || !JSNameSuggestionsUtil.isIdentifier(s, context) ? null : s;
    }

    @Nullable
    private static String getNameFromIterableType(@NotNull JSType type) {
        JSType arrayComponentOrNull;
        if (type == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(4);
        }
        if ((arrayComponentOrNull = JSTypeUtils.getIndexableComponentType(type)) != null) {
            return StringUtil.pluralize((String)arrayComponentOrNull.getTypeText(JSType.TypeTextFormat.CODE));
        }
        return null;
    }

    @Nullable
    private static String getNameFromGenericType(@NotNull JSType type) {
        JSGenericTypeImpl genericType;
        if (type == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(5);
        }
        JSGenericTypeImpl jSGenericTypeImpl = genericType = type instanceof JSGenericTypeImpl ? (JSGenericTypeImpl)type : null;
        if (genericType != null && genericType.getType() instanceof JSNamedType) {
            JSNamedType baseType = (JSNamedType)genericType.getType();
            List<JSType> arguments = genericType.getArguments();
            String baseText = baseType.getTypeText(JSType.TypeTextFormat.CODE);
            if (arguments.size() == 1 && arguments.get(0) instanceof JSNamedType) {
                return arguments.get(0).getTypeText(JSType.TypeTextFormat.CODE) + baseText;
            }
            return baseText;
        }
        return null;
    }

    @Nullable
    public static String generateVariableNameFromExpression(@NotNull JSExpression mainOccurrence, @Nullable PsiElement scope) {
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(6);
        }
        return JSNameSuggestionsUtil.generateVariableNameFromExpression(mainOccurrence, scope, false);
    }

    @Nullable
    public static String generateVariableNameFromExpression(@NotNull JSExpression mainOccurrence, @Nullable PsiElement scope, boolean avoidItemsFromTypes) {
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(7);
        }
        List<String> names = JSNameSuggestionsUtil.generateVariableNamesFromExpression(mainOccurrence, scope, "", Collections.emptyList(), JSNamedEntityKind.Variable, avoidItemsFromTypes);
        return (String)ContainerUtil.getFirstItem(names);
    }

    @NotNull
    public static List<String> generateVariableNamesFromExpression(@NotNull JSExpression mainOccurrence, @Nullable PsiElement scope, @NotNull Collection<String> existing) {
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(8);
        }
        if (existing == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(9);
        }
        List<String> list = JSNameSuggestionsUtil.generateVariableNamesFromExpression(mainOccurrence, scope, "", existing, JSNamedEntityKind.Variable);
        if (list == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public static List<String> generateVariableNamesFromExpression(@NotNull JSExpression mainOccurrence, @Nullable PsiElement scope, @NotNull String namePrefix, @NotNull Collection<String> existing, @NotNull JSNamedEntityKind entityKind) {
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(11);
        }
        if (namePrefix == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(12);
        }
        if (existing == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(13);
        }
        if (entityKind == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(14);
        }
        List<String> list = JSNameSuggestionsUtil.generateVariableNamesFromExpression(mainOccurrence, scope, namePrefix, existing, entityKind, false);
        if (list == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    public static List<String> generateVariableNamesFromExpression(@NotNull JSExpression mainOccurrence, @Nullable PsiElement scope, @NotNull String namePrefix, @NotNull Collection<String> existing, @NotNull JSNamedEntityKind entityKind, boolean avoidItemsFromTypes) {
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(16);
        }
        if (namePrefix == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(17);
        }
        if (existing == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(18);
        }
        if (entityKind == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(19);
        }
        LinkedHashSet results = ContainerUtil.newLinkedHashSet();
        Processor processor = s -> {
            if (mainOccurrence == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(94);
            }
            if (namePrefix == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(95);
            }
            if (existing == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(96);
            }
            if (StringUtil.isEmpty((String)s)) {
                return true;
            }
            for (String candidate : JSNameSuggestionsUtil.generateNamesFromQualifiedName(s, mainOccurrence instanceof JSIndexedPropertyAccessExpression)) {
                if (namePrefix.length() > 0) {
                    candidate = Character.isLetterOrDigit(namePrefix.charAt(namePrefix.length() - 1)) ? StringUtil.capitalize((String)candidate) : candidate;
                    candidate = namePrefix + candidate;
                }
                results.add(JSNameSuggestionsUtil.ensureUniqueVariableName(candidate, scope, existing, false));
            }
            return true;
        };
        JSNameSuggestionsUtil.processCandidates(mainOccurrence, (Processor<String>)processor, entityKind, avoidItemsFromTypes);
        ArrayList arrayList = ContainerUtil.newArrayList((Iterable)results);
        if (arrayList == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Nullable
    @Contract(value="null -> null")
    private static String normalizeTypeName(@Nullable String typeName) {
        if (typeName == null) {
            return null;
        }
        if (typeName.endsWith(IMPL_SUFFIX) && typeName.length() > IMPL_SUFFIX.length()) {
            return typeName.substring(0, typeName.length() - IMPL_SUFFIX.length());
        }
        return typeName;
    }

    @NotNull
    private static String getDefaultVariableNameForEntityKind(@NotNull JSNamedEntityKind entityKind) {
        if (entityKind == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(21);
        }
        switch (entityKind) {
            case Parameter: {
                if ("p" == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(22);
                }
                return "p";
            }
            case Field: {
                if ("field" == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(23);
                }
                return "field";
            }
            case Function: {
                if ("f" == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(24);
                }
                return "f";
            }
            case Variable: 
            case Accessor: {
                if ("x" == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(25);
                }
                return "x";
            }
            case Class: {
                if ("Class" == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(26);
                }
                return "Class";
            }
            case Interface: {
                if ("Interface" == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(27);
                }
                return "Interface";
            }
            case Enum: {
                if ("Enum" == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(28);
                }
                return "Enum";
            }
        }
        if ("obj" == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(29);
        }
        return "obj";
    }

    @NotNull
    public static List<String> generateVariableNamesFromType(@NotNull JSType type, @NotNull PsiElement scope, @NotNull Collection<String> existing) {
        String fromType;
        if (type == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(31);
        }
        if (existing == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(32);
        }
        if ((fromType = JSNameSuggestionsUtil.normalizeTypeName(JSNameSuggestionsUtil.generateNameFromJSTypeOrNull(type, scope))) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(33);
            }
            return list;
        }
        List list = ContainerUtil.map(JSNameSuggestionsUtil.generateNamesFromQualifiedName(fromType, false), nameCandidate -> {
            if (scope == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(92);
            }
            if (existing == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(93);
            }
            return JSNameSuggestionsUtil.ensureUniqueVariableName(nameCandidate, scope, existing, false);
        });
        if (list == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    public static List<String> generateNamesForType(@Nullable JSType jsType, @NotNull PsiElement scope) {
        if (scope == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(35);
        }
        if (jsType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(36);
            }
            return list;
        }
        String forComplexType = JSNameSuggestionsUtil.getNameForComplexType(jsType, scope);
        if (forComplexType == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(37);
            }
            return list;
        }
        HashSet existing = ContainerUtil.newHashSet();
        List list = ContainerUtil.map(JSNameSuggestionsUtil.generateNamesFromQualifiedName(forComplexType, false), s -> {
            if (scope == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(91);
            }
            return JSNameSuggestionsUtil.ensureUniqueVariableName(StringUtil.capitalize((String)s), scope, existing, false);
        });
        if (list == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(38);
        }
        return list;
    }

    @NotNull
    private static String generateDefaultName(@Nullable PsiElement element) {
        String nameFromContext = JSNameSuggestionsUtil.generateDefaultNameFromContext(element);
        String string = nameFromContext != null ? nameFromContext : JSNameSuggestionsUtil.getDefaultVariableNameForEntityKind(JSNameSuggestionsUtil.getEntityKind(element));
        if (string == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    @Contract(value="null, _ -> null")
    private static String evaluateCollectionItemName(@Nullable JSExpression collectionExpression, boolean forIn) {
        String item;
        if (collectionExpression == null) {
            return null;
        }
        List<String> names = JSNameSuggestionsUtil.generateVariableNamesFromExpression(collectionExpression, null, "", ContainerUtil.newArrayList(), JSNamedEntityKind.Variable, true);
        if (!forIn) {
            for (String name : names) {
                String unpluralize = StringUtil.unpluralize((String)name);
                if (unpluralize == null) continue;
                if ("int".equals(unpluralize) || "uint".equals(unpluralize)) {
                    return "i";
                }
                return unpluralize;
            }
        }
        if ((item = (String)ContainerUtil.getFirstItem(names)) != null) {
            return item + (forIn ? KEY_SUFFIX : ELEMENT_SUFFIX);
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    private static String generateDefaultNameFromContext(@Nullable PsiElement element) {
        List<String> names;
        JSType type;
        PsiElement forLoop;
        JSExpression initializer;
        if (element == null) {
            return null;
        }
        if (element instanceof JSVariable && (initializer = ((JSVariable)element).getInitializer()) != null) {
            return JSNameSuggestionsUtil.generateVariableNameFromExpression(initializer, null, true);
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSForStatement) {
            PsiElement lastChild;
            if (element.getNextSibling() instanceof PsiErrorElement && (lastChild = parent.getLastChild()) instanceof JSExpressionStatement) {
                return JSNameSuggestionsUtil.evaluateCollectionItemName(((JSExpressionStatement)lastChild).getExpression(), false);
            }
        } else if (parent instanceof JSVarStatement && (forLoop = parent.getParent()) instanceof JSForInStatement) {
            return JSNameSuggestionsUtil.evaluateCollectionItemName(((JSForInStatement)forLoop).getCollectionExpression(), !((JSForInStatement)forLoop).isForEach());
        }
        if (element instanceof JSVariable && (type = ((JSVariable)element).getType()) != null && (names = JSNameSuggestionsUtil.generateVariableNamesFromType(type, element, ContainerUtil.emptyList())).size() > 0) {
            return names.get(0);
        }
        return null;
    }

    @NotNull
    public static String generateUniqueVariableNameAtPlace(@Nullable PsiElement place) {
        PsiElement context = JSNameSuggestionsUtil.evaluateProperContext(place);
        String string = JSNameSuggestionsUtil.ensureUniqueVariableName(JSNameSuggestionsUtil.generateDefaultName(context), place, ContainerUtil.newHashSet(), false);
        if (string == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    public static String ensureUniqueVariableName(@NotNull String originalString, @Nullable PsiElement scope, @NotNull Collection<String> existing, boolean skipSearchInScope) {
        if (originalString == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(41);
        }
        if (existing == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(42);
        }
        String currentVariant = originalString;
        if ((skipSearchInScope || scope != null) && StringUtil.isJavaIdentifier((String)originalString)) {
            int cnt = 0;
            String originalStringWithoutTrailingNumbers = null;
            while (existing.contains(currentVariant) || !skipSearchInScope && !currentVariant.equals(scope.getText()) && (JSNameSuggestionsUtil.findExistingInScopeAndUp(currentVariant, scope) != null || !JSNameSuggestionsUtil.isIdentifier(currentVariant, scope))) {
                ++cnt;
                if (originalStringWithoutTrailingNumbers == null) {
                    int i;
                    originalStringWithoutTrailingNumbers = originalString;
                    int startedPos = i = originalStringWithoutTrailingNumbers.length() - 1;
                    while (i >= 0 && Character.isDigit(originalStringWithoutTrailingNumbers.charAt(i))) {
                        --i;
                    }
                    if (i >= 0 && startedPos != i) {
                        currentVariant = originalStringWithoutTrailingNumbers = originalStringWithoutTrailingNumbers.substring(0, i + 1);
                        --cnt;
                        continue;
                    }
                }
                currentVariant = originalStringWithoutTrailingNumbers + cnt;
            }
        }
        String string = currentVariant;
        if (string == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(43);
        }
        return string;
    }

    private static void processCandidates(@NotNull JSExpression mainOccurrence, @NotNull Processor<String> processor, @NotNull JSNamedEntityKind entityKind, boolean avoidItemsFromTypes) {
        XmlAttribute attribute;
        JSExpression arrayExpr;
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(44);
        }
        if (processor == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(45);
        }
        if (entityKind == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(46);
        }
        if (mainOccurrence instanceof JSParenthesizedExpression) {
            JSExpression expression = ((JSParenthesizedExpression)mainOccurrence).getInnerExpression();
            if (expression != null) {
                JSNameSuggestionsUtil.processCandidates(expression, processor, entityKind, avoidItemsFromTypes);
            }
            return;
        }
        if (mainOccurrence instanceof TypeScriptCastExpression) {
            JSExpression expression = ((TypeScriptCastExpression)mainOccurrence).getExpression();
            if (expression != null) {
                JSNameSuggestionsUtil.processCandidates(expression, processor, entityKind, avoidItemsFromTypes);
            }
            return;
        }
        THashSet reported = new THashSet();
        String someDefaultName = null;
        boolean typeHasHigherPriorityThanName = entityKind == JSNamedEntityKind.Parameter;
        JSType expressionType = JSResolveUtil.getExpressionJSType(mainOccurrence);
        if (mainOccurrence instanceof JSXmlLiteralExpression) {
            someDefaultName = mainOccurrence.getName();
        }
        if (mainOccurrence instanceof JSCallExpression) {
            typeHasHigherPriorityThanName = expressionType != null && !JSTypeUtils.isIndexableType(expressionType);
            someDefaultName = JSNameSuggestionsUtil.suggestNameFromCall(mainOccurrence, processor, (Set<String>)reported);
        } else if (mainOccurrence instanceof JSReferenceExpression) {
            JSReferenceExpression refExpr = (JSReferenceExpression)mainOccurrence;
            someDefaultName = JSNameSuggestionsUtil.trimPrefix(refExpr, JSNameSuggestionsUtil.getLastMeaningfulName(refExpr));
            if (refExpr.getParent() instanceof JSExpressionStatement) {
                JSNameSuggestionsUtil.addName(someDefaultName, processor, (Set<String>)reported);
                someDefaultName = null;
            }
        } else if (mainOccurrence instanceof JSFunctionExpression) {
            PsiElement ownNameId = ((JSFunctionExpression)mainOccurrence).getOwnNameIdentifier();
            if (ownNameId != null) {
                someDefaultName = ownNameId.getText();
            }
        } else if (mainOccurrence instanceof JSIndexedPropertyAccessExpression && (arrayExpr = ((JSIndexedPropertyAccessExpression)mainOccurrence).getQualifier()) != null) {
            for (String name : JSNameSuggestionsUtil.generateVariableNamesFromExpression(arrayExpr, null, "", ContainerUtil.newArrayList(), JSNamedEntityKind.Variable, avoidItemsFromTypes)) {
                String unpluralize = StringUtil.unpluralize((String)name);
                if (unpluralize == null) {
                    unpluralize = name + ELEMENT_SUFFIX;
                }
                JSNameSuggestionsUtil.addName(unpluralize, processor, (Set<String>)reported);
            }
        }
        PsiElement parent = mainOccurrence.getParent();
        if (parent instanceof JSArgumentList && entityKind != JSNamedEntityKind.Parameter) {
            JSResolveUtil.processParametersForUsedArgument(mainOccurrence, (JSArgumentList)parent, (Processor<JSParameterItem>)((Processor)arg_0 -> JSNameSuggestionsUtil.lambda$processCandidates$3(processor, (Set)reported, arg_0)));
        } else if (parent instanceof JSAssignmentExpression) {
            JSExpression expression;
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand instanceof JSDefinitionExpression && (expression = ((JSDefinitionExpression)lOperand).getExpression()) instanceof JSReferenceExpression) {
                String name;
                JSParameterItem parameter;
                JSReferenceExpression referenceExpression = (JSReferenceExpression)expression;
                PsiElement resolve = referenceExpression.resolve();
                if (resolve instanceof JSFunction && (parameter = JSResolveUtil.getParameterFromSetAccessor((JSFunctionItem)((JSFunction)resolve))) != null && !"value".equals(name = parameter.getName())) {
                    JSNameSuggestionsUtil.addName(name, processor, (Set<String>)reported);
                }
                String referencedName = referenceExpression.getReferenceName();
                JSNameSuggestionsUtil.addName(referencedName, processor, (Set<String>)reported);
            }
            if (lOperand != null && mainOccurrence == ((JSAssignmentExpression)parent).getROperand()) {
                for (String name : JSNameSuggestionsUtil.generateVariableNamesFromExpression(lOperand, null, "", ContainerUtil.newArrayList(), JSNamedEntityKind.Variable, avoidItemsFromTypes)) {
                    JSNameSuggestionsUtil.addName(name, processor, (Set<String>)reported);
                }
            }
        } else if (parent instanceof JSProperty) {
            String name = ((JSProperty)parent).getName();
            if (JSNameSuggestionsUtil.isIdentifier(name, (PsiElement)mainOccurrence)) {
                JSNameSuggestionsUtil.addName(name, processor, (Set<String>)reported);
            }
        } else if (JSPsiImplUtils.isEmbeddedExpressionContent(parent) && (attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)parent, XmlAttribute.class, (boolean)false, (Class[])new Class[]{JSSourceElement.class})) != null) {
            JSNameSuggestionsUtil.addName(attribute.getName(), processor, (Set<String>)reported);
        }
        if (parent instanceof JSInitializerOwner && parent instanceof JSNamedElement && JSNameSuggestionsUtil.getEntityKind(parent) != entityKind) {
            JSNameSuggestionsUtil.addName(((JSNamedElement)parent).getName(), processor, (Set<String>)reported);
        }
        if (!avoidItemsFromTypes && expressionType != null && JSTypeUtils.isIndexableType(expressionType)) {
            typeHasHigherPriorityThanName = true;
        }
        String typeString = JSNameSuggestionsUtil.normalizeTypeName(JSNameSuggestionsUtil.generateNameFromJSTypeOrNull(expressionType, (PsiElement)mainOccurrence));
        if (typeHasHigherPriorityThanName) {
            JSNameSuggestionsUtil.addName(typeString, processor, (Set<String>)reported);
            JSNameSuggestionsUtil.addName(someDefaultName, processor, (Set<String>)reported);
        } else {
            JSNameSuggestionsUtil.addName(someDefaultName, processor, (Set<String>)reported);
            JSNameSuggestionsUtil.addName(typeString, processor, (Set<String>)reported);
        }
    }

    @Nullable
    private static String suggestNameFromCall(@NotNull JSExpression mainOccurrence, @NotNull Processor<String> processor, @NotNull Set<String> reported) {
        JSExpression methodExpression;
        if (mainOccurrence == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(47);
        }
        if (processor == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(48);
        }
        if (reported == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(49);
        }
        if (!((methodExpression = ((JSCallExpression)mainOccurrence).getMethodExpression()) instanceof JSReferenceExpression)) {
            return null;
        }
        String referencedName = JSNameSuggestionsUtil.getLastMeaningfulName((JSReferenceExpression)methodExpression);
        if (mainOccurrence instanceof JSNewExpression) {
            JSReferenceExpression typeReference;
            ASTNode node = methodExpression.getNode().findChildByType(JSElementTypes.GENERIC_SIGNATURE);
            if (node != null && (typeReference = ((JSGenericSignature)node.getPsi()).getTypeReference()) != null) {
                String typeText = typeReference.getText();
                JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(typeText);
                referencedName = StringUtil.pluralize((String)(signature == null ? typeText : signature.elementType));
            }
            JSNameSuggestionsUtil.addName(referencedName, processor, reported);
        } else {
            String propertyName;
            String string = propertyName = referencedName != null ? JSDocumentationUtils.getPropertyName(referencedName) : null;
            if (propertyName != null) {
                JSNameSuggestionsUtil.addName(propertyName, processor, reported);
            } else {
                if ("$".equals(referencedName) || "get".equals(referencedName) || "set".equals(referencedName) || "require".equals(referencedName)) {
                    String value;
                    JSExpression[] arguments = ((JSCallExpression)mainOccurrence).getArguments();
                    if (arguments.length > 0 && arguments[0] instanceof JSLiteralExpression && (value = ((JSLiteralExpression)arguments[0]).getStringValue()) != null) {
                        int index;
                        int start = 0;
                        if (value.length() > 0 && !Character.isJavaIdentifierStart(value.charAt(0))) {
                            ++start;
                        }
                        for (index = start; index < value.length() && Character.isJavaIdentifierPart(value.charAt(index)); ++index) {
                        }
                        if (index > start) {
                            String name = value.substring(start, index);
                            if ("$".equals(referencedName)) {
                                name = "$" + name;
                            }
                            JSNameSuggestionsUtil.addName(name, processor, reported);
                        }
                    }
                    return referencedName;
                }
                return referencedName;
            }
        }
        return null;
    }

    private static void addName(@Nullable String name, @NotNull Processor<String> processor, @NotNull Set<String> reported) {
        if (processor == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(50);
        }
        if (reported == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(51);
        }
        if (name != null && reported.add(name)) {
            processor.process((Object)name);
        }
    }

    @NotNull
    private static JSNamedEntityKind getEntityKind(@Nullable PsiElement context) {
        if (context instanceof JSField) {
            JSNamedEntityKind jSNamedEntityKind = JSNamedEntityKind.Field;
            if (jSNamedEntityKind == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(52);
            }
            return jSNamedEntityKind;
        }
        if (context instanceof TypeScriptEnum) {
            JSNamedEntityKind jSNamedEntityKind = JSNamedEntityKind.Enum;
            if (jSNamedEntityKind == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(53);
            }
            return jSNamedEntityKind;
        }
        if (context instanceof JSClass) {
            JSNamedEntityKind jSNamedEntityKind = ((JSClass)context).isInterface() ? JSNamedEntityKind.Interface : JSNamedEntityKind.Class;
            if (jSNamedEntityKind == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(54);
            }
            return jSNamedEntityKind;
        }
        if (context instanceof JSFunction) {
            JSNamedEntityKind jSNamedEntityKind = JSNamedEntityKind.Function;
            if (jSNamedEntityKind == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(55);
            }
            return jSNamedEntityKind;
        }
        JSNamedEntityKind jSNamedEntityKind = JSNamedEntityKind.Variable;
        if (jSNamedEntityKind == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(56);
        }
        return jSNamedEntityKind;
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    private static PsiElement evaluateProperContext(@Nullable PsiElement place) {
        PsiElement context = place;
        if (context instanceof PsiWhiteSpace) {
            context = context.getParent();
        }
        if (context instanceof LeafPsiElement) {
            context = context.getParent();
        }
        if (context instanceof JSReferenceExpression) {
            context = context.getParent();
        }
        return context;
    }

    @NotNull
    private static String sanitizeJavaScriptIdentifier(@NotNull String name) {
        if (name == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(57);
        }
        StringBuilder result2 = new StringBuilder();
        boolean capitalize = false;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '$') {
                if (result2.length() == 0 && !Character.isJavaIdentifierStart(ch) && ch != '$') {
                    result2.append("_");
                }
                result2.append(capitalize ? Character.toUpperCase(ch) : ch);
                capitalize = false;
                continue;
            }
            capitalize = true;
        }
        String string = result2.toString();
        if (string == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(58);
        }
        return string;
    }

    @Nullable
    private static String getLastMeaningfulName(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(59);
        }
        while (referenceExpression != null) {
            String name = referenceExpression.getReferenceName();
            JSExpression qualifier = referenceExpression.getQualifier();
            if (!"bind".equals(name) || qualifier == null) {
                return name;
            }
            referenceExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)qualifier, JSReferenceExpression.class);
        }
        return null;
    }

    @NotNull
    private static List<String> generateNamesFromQualifiedName(@NotNull String s, boolean removePlural) {
        String singular;
        if (s == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(60);
        }
        ArrayList results = ContainerUtil.newArrayList();
        s = QualifiedName.fromDottedString((String)s).getLastComponent();
        assert (s != null);
        s = JSNameSuggestionsUtil.sanitizeJavaScriptIdentifier(s);
        if (removePlural && (singular = StringUtil.unpluralize((String)s)) != null) {
            s = singular;
        }
        for (String namePart : NameUtil.nameToWords((String)s)) {
            String name;
            if ("get".equals(namePart) || "set".equals(namePart) || "is".equals(namePart) || "create".equals(namePart) || !StringUtil.isJavaIdentifier((String)(name = StringUtil.toLowerCase((String)namePart) + s.substring(s.indexOf(namePart) + namePart.length())))) continue;
            results.add(name);
        }
        ArrayList arrayList = results;
        if (arrayList == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(61);
        }
        return arrayList;
    }

    @Nullable
    public static JSNamedElement findExistingInScopeAndUp(final @NotNull String name, final @NotNull PsiElement scope) {
        JSNamedElement element;
        if (name == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(62);
        }
        if (scope == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(63);
        }
        final Ref existing = new Ref();
        final Ref existingRef = new Ref();
        scope.accept((PsiElementVisitor)new JSElementVisitor(){

            public void visitJSFile(JSFile file2) {
                if (existing.isNull()) {
                    file2.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
                if (existing.isNull()) {
                    embeddedContent.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSElement(JSElement node) {
                if (existing.isNull()) {
                    node.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSClass(JSClass aClass) {
                if (name.equals(aClass.getName())) {
                    existing.set((Object)aClass);
                }
            }

            public void visitJSVariable(JSVariable node) {
                if (name.equals(node.getName())) {
                    existing.set((Object)node);
                }
                super.visitJSVariable(node);
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (JSResolveUtil.isExprInStrictTypeContext(node)) {
                    return;
                }
                if (name.equals(node.getReferenceName()) && node.getQualifier() == null) {
                    existingRef.set((Object)node);
                }
                super.visitJSReferenceExpression(node);
            }

            public void visitJSFunctionDeclaration(JSFunction node) {
                if (name.equals(node.getName())) {
                    existing.set((Object)node);
                }
                if (node == scope) {
                    super.visitJSFunctionDeclaration(node);
                }
            }
        });
        if (existing.isNull()) {
            SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(name, new ResolveResultSink(null, name));
            JSResolveUtil.treeWalkUp(processor, scope, null, scope);
            PsiElement resolved = (PsiElement)ContainerUtil.getFirstItem(JSResolveResult.toElements(processor.getResultsAsResolveResults()));
            if (resolved instanceof JSNamedElement && !(resolved instanceof JSClass)) {
                existing.set((Object)((JSNamedElement)resolved));
            }
            if (existing.isNull() && !existingRef.isNull()) {
                existing.set((Object)new ImplicitJSVariableImpl(name, (JSType)null, scope));
            }
        }
        return (element = (JSNamedElement)existing.get()) == scope ? null : element;
    }

    public static boolean matchesFileNameByCodeStyle(@NotNull JSNamedElement namedElement) {
        String elementName;
        if (namedElement == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(64);
        }
        if ((elementName = namedElement.getName()) == null) {
            return true;
        }
        PsiFile file2 = namedElement.getContainingFile();
        if (file2 == null) {
            return true;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        JSCodeStyleSettings codeStyleSettings = JSCodeStyleSettings.getSettings(file2);
        JSCodeStyleSettings.JSFileNameStyle fileNameStyle = codeStyleSettings.FILE_NAME_STYLE;
        if (fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.RELAXED) {
            return JSNameSuggestionsUtil.matchesFileNameRelaxed(elementName, virtualFile);
        }
        String suggestedName = JSNameSuggestionsUtil.suggestFileNameWithoutExtension(elementName, file2);
        return suggestedName.equals(virtualFile.getNameWithoutExtension());
    }

    public static boolean matchesFileNameRelaxed(@NotNull JSNamedElement namedElement) {
        if (namedElement == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(65);
        }
        String elementName = namedElement.getName();
        PsiFile file2 = namedElement.getContainingFile();
        if (file2 == null) {
            return true;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        return JSNameSuggestionsUtil.matchesFileNameRelaxed(elementName, virtualFile);
    }

    private static boolean matchesFileNameRelaxed(String elementName, VirtualFile virtualFile) {
        String fileName = virtualFile.getNameWithoutExtension();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (i == 0 && !StringUtil.isJavaIdentifierStart((char)c) || i != 0 && !StringUtil.isJavaIdentifierPart((char)c)) continue;
            b.append(c);
        }
        return b.toString().equalsIgnoreCase(elementName);
    }

    @Nullable
    public static String fileNameFromElementName(@NotNull JSNamedElement existingElement, @NotNull String newElementName) {
        JSNamesSuggester[] namesSuggesters;
        PsiFile file2;
        if (existingElement == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(66);
        }
        if (newElementName == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(67);
        }
        if ((file2 = existingElement.getContainingFile()) == null) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String fileExtension = virtualFile.getExtension();
        if (fileExtension == null) {
            return null;
        }
        for (JSNamesSuggester suggester : namesSuggesters = (JSNamesSuggester[])JSNamesSuggester.EP_NAME.getExtensions()) {
            String fileName = suggester.suggestFileName(existingElement, newElementName);
            if (fileName == null) continue;
            return fileName;
        }
        return JSNameSuggestionsUtil.suggestFileNameWithoutExtension(newElementName, file2);
    }

    @NotNull
    private static String suggestFileNameWithoutExtension(@NotNull String newElementName, @NotNull PsiFile file2) {
        boolean isMixed;
        if (newElementName == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(68);
        }
        if (file2 == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(69);
        }
        JSCodeStyleSettings codeStyleSettings = JSCodeStyleSettings.getSettings(file2);
        JSCodeStyleSettings.JSFileNameStyle fileNameStyle = codeStyleSettings.FILE_NAME_STYLE;
        if (fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.RELAXED) {
            fileNameStyle = JSNameSuggestionsUtil.tryDetectNamingStyle(file2);
        }
        if (fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.CAMEL_CASE) {
            String string = StringUtil.decapitalize((String)newElementName);
            if (string == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(70);
            }
            return string;
        }
        if (fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.PASCAL_CASE) {
            String string = StringUtil.capitalize((String)newElementName);
            if (string == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(71);
            }
            return string;
        }
        boolean isSnake = fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.SNAKE_CASE;
        boolean isLisp = fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.LISP_CASE;
        boolean bl = isMixed = fileNameStyle == JSCodeStyleSettings.JSFileNameStyle.MIXED;
        if (isSnake || isLisp || isMixed) {
            Object[] parts = newElementName.split(SPLIT_BY_CAMEL_CASE_REGEX);
            if (isSnake || isLisp) {
                String string = StringUtil.join((Object[])parts, StringUtil::toLowerCase, (String)(isSnake ? "_" : "-"));
                if (string == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(72);
                }
                return string;
            }
            if (parts.length == 1) {
                String string = StringUtil.toLowerCase((String)parts[0]);
                if (string == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(73);
                }
                return string;
            }
            Object[] allPartsSaveTheLast = (String[])Arrays.copyOf(parts, parts.length - 1);
            String string = StringUtil.join((Object[])allPartsSaveTheLast, StringUtil::toLowerCase, (String)"-") + "." + StringUtil.toLowerCase((String)parts[parts.length - 1]);
            if (string == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(74);
            }
            return string;
        }
        String string = JSNameSuggestionsUtil.capitalizeByConvention((PsiNamedElement)file2, newElementName);
        if (string == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(75);
        }
        return string;
    }

    @NotNull
    private static JSCodeStyleSettings.JSFileNameStyle tryDetectNamingStyle(@NotNull PsiFile file2) {
        String name;
        if (file2 == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(76);
        }
        if (StringUtil.isCapitalized((String)(name = file2.getName()))) {
            JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.PASCAL_CASE;
            if (jSFileNameStyle == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(77);
            }
            return jSFileNameStyle;
        }
        int underscore = name.indexOf(95);
        if (underscore > 0) {
            int lastUnderscore = name.lastIndexOf(95);
            if (underscore != lastUnderscore) {
                JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.SNAKE_CASE;
                if (jSFileNameStyle == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(78);
                }
                return jSFileNameStyle;
            }
            String lastPart = name.substring(lastUnderscore + 1);
            int ext = lastPart.lastIndexOf(46);
            if (ext >= 0) {
                lastPart = lastPart.substring(0, ext);
            }
            for (int i = 0; i < lastPart.length(); ++i) {
                char c = lastPart.charAt(i);
                if (Character.isDigit(c)) continue;
                JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.SNAKE_CASE;
                if (jSFileNameStyle == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(79);
                }
                return jSFileNameStyle;
            }
            JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.CAMEL_CASE;
            if (jSFileNameStyle == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(80);
            }
            return jSFileNameStyle;
        }
        if (name.indexOf(45) > 0) {
            int lastDot = name.lastIndexOf(46);
            if (name.substring(0, lastDot - 1).indexOf(46) > 0) {
                JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.MIXED;
                if (jSFileNameStyle == null) {
                    JSNameSuggestionsUtil.$$$reportNull$$$0(81);
                }
                return jSFileNameStyle;
            }
            JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.LISP_CASE;
            if (jSFileNameStyle == null) {
                JSNameSuggestionsUtil.$$$reportNull$$$0(82);
            }
            return jSFileNameStyle;
        }
        JSCodeStyleSettings.JSFileNameStyle jSFileNameStyle = JSCodeStyleSettings.JSFileNameStyle.RELAXED;
        if (jSFileNameStyle == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(83);
        }
        return jSFileNameStyle;
    }

    @NotNull
    public static String fileNameToElementName(@NotNull JSNamedElement namedElement, @NotNull String newFileName) {
        if (namedElement == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(84);
        }
        if (newFileName == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(85);
        }
        List words = ContainerUtil.map((Object[])FileUtil.getNameWithoutExtension((String)newFileName).split("\\W+"), StringUtil::capitalize);
        String string = JSNameSuggestionsUtil.capitalizeByConvention((PsiNamedElement)namedElement, StringUtil.join((Collection)words, (String)""));
        if (string == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(86);
        }
        return string;
    }

    private static String capitalizeByConvention(@NotNull PsiNamedElement namedElement, @NotNull String newName) {
        if (namedElement == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(87);
        }
        if (newName == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(88);
        }
        return StringUtil.isCapitalized((String)namedElement.getName()) ? StringUtil.capitalize((String)newName) : StringUtil.decapitalize((String)newName);
    }

    public static String trimPrefix(@NotNull JSReferenceExpression expression, String name) {
        PsiElement resolved;
        if (expression == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(89);
        }
        if ((resolved = expression.resolve()) instanceof JSVariable && JSUtils.getMemberContainingClass(resolved) != null) {
            JSCodeStyleSettings jsCodeStyleSettings = JSCodeStyleSettings.getSettings(resolved);
            return StringUtil.trimStart((String)name, (String)jsCodeStyleSettings.FIELD_PREFIX);
        }
        if (resolved instanceof JSFunction && JSPsiImplUtils.isGetterOrSetter((JSFunction)resolved)) {
            JSCodeStyleSettings jsCodeStyleSettings = JSCodeStyleSettings.getSettings((PsiElement)expression);
            return StringUtil.trimStart((String)name, (String)jsCodeStyleSettings.PROPERTY_PREFIX);
        }
        return name;
    }

    private static /* synthetic */ boolean lambda$processCandidates$3(@NotNull Processor processor, Set reported, JSParameterItem jsParameter) {
        if (processor == null) {
            JSNameSuggestionsUtil.$$$reportNull$$$0(90);
        }
        JSNameSuggestionsUtil.addName(jsParameter.getName(), (Processor<String>)processor, reported);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 76: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 76: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/names/JSNameSuggestionsUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 16: 
            case 44: 
            case 47: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainOccurrence";
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 32: 
            case 42: 
            case 93: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 12: 
            case 17: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePrefix";
                break;
            }
            case 14: 
            case 19: 
            case 21: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityKind";
                break;
            }
            case 31: 
            case 35: 
            case 63: 
            case 91: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalString";
                break;
            }
            case 45: 
            case 48: 
            case 50: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reported";
                break;
            }
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 64: 
            case 65: 
            case 84: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingElement";
                break;
            }
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 69: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFileName";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplSuffix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 76: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/names/JSNameSuggestionsUtil";
                break;
            }
            case 10: 
            case 15: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "generateVariableNamesFromExpression";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultVariableNameForEntityKind";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "generateVariableNamesFromType";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNamesForType";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefaultName";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueVariableNameAtPlace";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureUniqueVariableName";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityKind";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaScriptIdentifier";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "generateNamesFromQualifiedName";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestFileNameWithoutExtension";
                break;
            }
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "tryDetectNamingStyle";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "fileNameToElementName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateNameFromJSTypeOrNull";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNameForComplexType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromIterableType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNameFromGenericType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateVariableNameFromExpression";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateVariableNamesFromExpression";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultVariableNameForEntityKind";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "generateVariableNamesFromType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "generateNamesForType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "ensureUniqueVariableName";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "suggestNameFromCall";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addName";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaScriptIdentifier";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getLastMeaningfulName";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "generateNamesFromQualifiedName";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "findExistingInScopeAndUp";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "matchesFileNameByCodeStyle";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "matchesFileNameRelaxed";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "fileNameFromElementName";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "suggestFileNameWithoutExtension";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "tryDetectNamingStyle";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "fileNameToElementName";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeByConvention";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "trimPrefix";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processCandidates$3";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateNamesForType$2";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateVariableNamesFromType$1";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateVariableNamesFromExpression$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 57: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 76: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

