/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.ecmascript6.psi.ES6FunctionProperty;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSContextTypeEvaluator {
    @Nullable
    public static JSType getTypeByFunctionParamIndex(JSFunctionTypeImpl funcType, int paramIndex) {
        JSParameterTypeDecorator lastParam;
        List<JSParameterTypeDecorator> funcTypeParameters = funcType.getParameters();
        JSType parameterType = null;
        if (paramIndex < funcTypeParameters.size()) {
            parameterType = funcTypeParameters.get(paramIndex).getType();
        }
        JSParameterTypeDecorator jSParameterTypeDecorator = lastParam = funcTypeParameters.size() > 0 ? funcTypeParameters.get(funcTypeParameters.size() - 1) : null;
        if (lastParam != null && lastParam.isRest()) {
            parameterType = lastParam.getType();
        }
        return parameterType;
    }

    @Nullable
    public static JSType getParameterType(@NotNull JSParameterListElement parameter, @NotNull JSEvaluateContext evaluateContext, JSExpectedTypeKind expectedTypeKind) {
        JSNamespace initialization;
        JSParameter superParameter;
        JSFunction fun;
        if (parameter == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(0);
        }
        if (evaluateContext == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(1);
        }
        if ((fun = parameter.getDeclaringFunction()) == null) {
            return null;
        }
        if (parameter instanceof JSParameter && (superParameter = JSInheritanceUtil.findMatchedSuperParameter((JSParameter)parameter, fun)) != null) {
            return superParameter.getType();
        }
        Object parameterType = null;
        if (fun instanceof JSFunctionExpression || fun instanceof ES6FunctionProperty) {
            Collection types;
            JSType funcType;
            PsiElement parentOfFunction = fun.getParent();
            if (fun instanceof ES6FunctionProperty) {
                funcType = null;
                if (parentOfFunction instanceof JSObjectLiteralExpression) {
                    JSRecordType.PropertySignature propertySignature;
                    JSType parentType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSObjectLiteralExpression)parentOfFunction), expectedTypeKind);
                    String name = fun.getName();
                    if (parentType instanceof JSRecordType && name != null && (propertySignature = ((JSRecordType)parentType).findPropertySignature(name)) != null) {
                        funcType = propertySignature.getType();
                    }
                }
            } else {
                funcType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSFunctionExpression)fun), expectedTypeKind);
            }
            if (!(types = (Collection)JSTypeUtils.getFunctionType(funcType, false, (PsiElement)evaluateContext.getProcessedExpression()).collect(Collectors.toList())).isEmpty()) {
                int paramIndex;
                JSInitializerOwner outerParameter = JSDestructuringUtil.findDestructuringParent((JSElement)parameter, evaluateContext, (Condition<JSInitializerOwner>)((Condition)owner -> owner.getParent() instanceof JSParameterList));
                if (outerParameter == null) {
                    Logger.getInstance(JSContextTypeEvaluator.class).error("outerParameter not found: " + fun.getText());
                }
                JSParameterListElement[] parameters = fun.getParameters();
                for (paramIndex = 0; paramIndex < parameters.length && parameters[paramIndex] != outerParameter; ++paramIndex) {
                }
                if (paramIndex == parameters.length) {
                    Logger.getInstance(JSContextTypeEvaluator.class).error("paramIndex not found: " + fun.getText());
                }
                for (JSType type : types) {
                    JSExpression methodExpr;
                    JSType currentType;
                    if (!(type instanceof JSFunctionTypeImpl) || (currentType = JSContextTypeEvaluator.getTypeByFunctionParamIndex((JSFunctionTypeImpl)type, paramIndex)) == null) continue;
                    PsiElement callExpr = parentOfFunction.getParent();
                    if (callExpr instanceof JSCallExpression && (methodExpr = ((JSCallExpression)callExpr).getMethodExpression()) instanceof JSReferenceExpression) {
                        List<PsiElement> elements = JSResolveResult.toElements(((JSReferenceExpression)methodExpr).multiResolve(false));
                        PsiElement resolve = JSContextTypeEvaluator.findTypeArgumentsOwner(elements);
                        currentType = TypeScriptGenericTypesEvaluator.getInstance().evaluateGenerics(currentType, methodExpr, resolve);
                    }
                    parameterType = parameterType == null ? currentType : JSTypeUtils.getCommonType((JSType)parameterType, currentType, DialectDetector.dialectOfElement(callExpr), false);
                }
            }
            if (funcType != null && parameterType != null && funcType.getSource().isTypeScript() && !funcType.getSource().isStrict()) {
                parameterType = JSTypeUtils.copyWithStrict((JSType)parameterType, false);
            }
        }
        if (parameterType == null && fun instanceof JSFunctionExpression && fun.isAnonymousFunctionCall() && parameter instanceof JSParameter && (initialization = JSSymbolUtil.getParameterInitialization((JSParameter)parameter)) != null) {
            PsiElement sourceElement = initialization.getSource().getSourceElement();
            parameterType = sourceElement instanceof JSExpression && !initialization.isSourceStrict() ? JSResolveUtil.getExpressionJSType((JSExpression)sourceElement) : initialization;
        }
        return parameterType;
    }

    @Nullable
    private static PsiElement findTypeArgumentsOwner(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            JSContextTypeEvaluator.$$$reportNull$$$0(2);
        }
        PsiElement typeOwner = null;
        for (PsiElement element : elements) {
            TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(element);
            if (parameters.length <= 0) continue;
            if (typeOwner == null) {
                typeOwner = element;
                continue;
            }
            return null;
        }
        if (typeOwner != null) {
            return typeOwner;
        }
        return elements.size() > 1 ? null : (PsiElement)ContainerUtil.getFirstItem(elements, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/JSContextTypeEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getParameterType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findTypeArgumentsOwner";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

