/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.completion.JSKeywordsCompletionProvider;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSExpressionCodeFragmentImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSElementFactory {
    private static final Logger LOG = Logger.getInstance(JSElementFactory.class);

    private JSElementFactory() {
    }

    @NotNull
    public static JSExpressionCodeFragment createExpressionCodeFragment(@NotNull Project project, CharSequence text, @Nullable PsiElement context) {
        if (project == null) {
            JSElementFactory.$$$reportNull$$$0(0);
        }
        JSExpressionCodeFragment jSExpressionCodeFragment = JSElementFactory.createExpressionCodeFragment(project, text, context, true, null, null, TopLevelCompletion.YES, null);
        if (jSExpressionCodeFragment == null) {
            JSElementFactory.$$$reportNull$$$0(1);
        }
        return jSExpressionCodeFragment;
    }

    @NotNull
    public static JSExpressionCodeFragment createExpressionCodeFragment(@NotNull Project project, CharSequence text, @Nullable PsiElement context, @Nullable JSLanguageDialect dialect, @Nullable GlobalSearchScope resolveScope, @NotNull TopLevelCompletion topLevelCompletion, @Nullable JavaScriptParserBase.ForceContext forceContext) {
        if (project == null) {
            JSElementFactory.$$$reportNull$$$0(2);
        }
        if (topLevelCompletion == null) {
            JSElementFactory.$$$reportNull$$$0(3);
        }
        JSExpressionCodeFragment jSExpressionCodeFragment = JSElementFactory.createExpressionCodeFragment(project, text, context, true, dialect, resolveScope, topLevelCompletion, forceContext);
        if (jSExpressionCodeFragment == null) {
            JSElementFactory.$$$reportNull$$$0(4);
        }
        return jSExpressionCodeFragment;
    }

    @NotNull
    public static JSExpressionCodeFragment createExpressionCodeFragment(@NotNull Project project, CharSequence text, @Nullable PsiElement context, boolean physical, @Nullable JSLanguageDialect dialect, @Nullable GlobalSearchScope resolveScope, final @NotNull TopLevelCompletion topLevelCompletion, @Nullable JavaScriptParserBase.ForceContext forceContext) {
        if (project == null) {
            JSElementFactory.$$$reportNull$$$0(5);
        }
        if (topLevelCompletion == null) {
            JSElementFactory.$$$reportNull$$$0(6);
        }
        String name = "fragment." + (dialect != null ? dialect.getFileExtension() : JavaScriptSupportLoader.JAVASCRIPT.getDefaultExtension());
        JSExpressionCodeFragmentImpl codeFragment = new JSExpressionCodeFragmentImpl(project, name, text, physical, forceContext){

            @Override
            public List<?> getTopLevelVariants(PsiElement context) {
                switch (topLevelCompletion) {
                    case YES: {
                        return super.getTopLevelVariants(context);
                    }
                    case NO: {
                        return Collections.emptyList();
                    }
                    case LITERAL_VALUES: {
                        return Arrays.asList(JSKeywordsCompletionProvider.TYPE_LITERAL_VALUES);
                    }
                }
                assert (false) : "unknown completion type: " + (Object)((Object)topLevelCompletion);
                return null;
            }
        };
        codeFragment.forceResolveScope(resolveScope);
        codeFragment.setContext(context);
        JSExpressionCodeFragmentImpl jSExpressionCodeFragmentImpl = codeFragment;
        if (jSExpressionCodeFragmentImpl == null) {
            JSElementFactory.$$$reportNull$$$0(7);
        }
        return jSExpressionCodeFragmentImpl;
    }

    public static JSStatement replaceStatement(@NotNull JSStatement statement, @NonNls @NotNull String text) throws IncorrectOperationException {
        if (statement == null) {
            JSElementFactory.$$$reportNull$$$0(8);
        }
        if (text == null) {
            JSElementFactory.$$$reportNull$$$0(9);
        }
        return JSElementFactory.replaceStatement(statement, text, false);
    }

    public static JSStatement replaceStatement(@NotNull JSStatement statement, @NonNls @NotNull String text, boolean withComment) throws IncorrectOperationException {
        PsiComment comment;
        if (statement == null) {
            JSElementFactory.$$$reportNull$$$0(10);
        }
        if (text == null) {
            JSElementFactory.$$$reportNull$$$0(11);
        }
        String textWithComment = text;
        if (withComment && (comment = JSDocumentationUtils.findDocComment((PsiElement)statement)) instanceof JSDocComment) {
            StringBuilder sb = new StringBuilder();
            PsiComment current = comment;
            while (current instanceof PsiComment || current instanceof PsiWhiteSpace) {
                sb.append(current.getText());
                current = current.getNextSibling();
            }
            textWithComment = sb.toString() + text;
        }
        JSStatement newStatement = JSChangeUtil.createStatementPsiFromTextWithContext(textWithComment, (PsiElement)statement, JSStatement.class);
        newStatement = statement.replace(newStatement);
        JSElementFactory.reformat((PsiElement)newStatement);
        return newStatement;
    }

    public static void removeElement(PsiElement element) {
        FormatFixer ff = FormatFixer.create(element, FormatFixer.Mode.FirstLinebreak);
        element.delete();
        ff.fixFormat();
    }

    public static void reformat(@NotNull PsiElement statement) throws IncorrectOperationException {
        if (statement == null) {
            JSElementFactory.$$$reportNull$$$0(12);
        }
        if (!statement.isValid() || !(statement.getContainingFile() instanceof JSFile)) {
            return;
        }
        if (statement.getParent() == null) {
            return;
        }
        try {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)statement.getManager().getProject());
            codeStyleManager.reformatNewlyAddedElement(statement.getParent().getNode(), statement.getNode());
            codeStyleManager.reformat(statement);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            String text = "<null>";
            String parentText = "<null>";
            try {
                text = statement.getText();
                parentText = statement.getParent().getText();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOG.error("Error while reformatting", (Throwable)e, new String[]{String.format("Statement: [%s]", text), String.format("Parent: [%s]", parentText)});
        }
    }

    public static JSStatement addStatementsAfter(@NotNull JSStatement anchor, @NotNull String statementsText) {
        if (anchor == null) {
            JSElementFactory.$$$reportNull$$$0(13);
        }
        if (statementsText == null) {
            JSElementFactory.$$$reportNull$$$0(14);
        }
        ASTNode newStatementNode = JSChangeUtil.createStatementFromTextWithContext(statementsText, (PsiElement)anchor);
        ASTNode statementNode = anchor.getNode();
        ASTNode oldStatementParentNode = statementNode == null ? null : statementNode.getTreeNext();
        PsiElement parentNode = anchor.getParent();
        ASTNode newStatementParentNode = parentNode.getNode();
        if (newStatementParentNode == null || newStatementNode == null) {
            return null;
        }
        newStatementParentNode.addChildren(newStatementNode, null, oldStatementParentNode);
        JSElementFactory.reformat(newStatementNode.getPsi());
        return (JSStatement)newStatementNode.getPsi();
    }

    @Nullable
    public static JSExpression replaceExpression(@NotNull JSExpression expression, @NotNull String text) throws IncorrectOperationException {
        JSExpression newExpressionNode;
        if (expression == null) {
            JSElementFactory.$$$reportNull$$$0(15);
        }
        if (text == null) {
            JSElementFactory.$$$reportNull$$$0(16);
        }
        return (newExpressionNode = (JSExpression)JSInheritedLanguagesHelper.getConfigurableProvider((PsiElement)expression).createExpressionFromText(text, (PsiElement)expression)) != null ? JSElementFactory.replaceExpression(expression, newExpressionNode) : expression;
    }

    public static JSExpression replaceExpression(@NotNull JSExpression expression, @NotNull JSExpression newExpression) throws IncorrectOperationException {
        if (expression == null) {
            JSElementFactory.$$$reportNull$$$0(17);
        }
        if (newExpression == null) {
            JSElementFactory.$$$reportNull$$$0(18);
        }
        ASTNode newExpressionNode = newExpression.getNode();
        ASTNode oldExpressionNode = expression.getNode();
        PsiElement parentNode = expression.getParent();
        ASTNode grandParentNode = parentNode.getNode();
        if (grandParentNode == null || oldExpressionNode == null || newExpressionNode == null) {
            return null;
        }
        grandParentNode.replaceChild(oldExpressionNode, newExpressionNode);
        JSElementFactory.reformat(parentNode);
        return (JSExpression)newExpressionNode.getPsi();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSElementFactory";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelCompletion";
                break;
            }
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementsText";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSElementFactory";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpressionCodeFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionCodeFragment";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addStatementsAfter";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum TopLevelCompletion {
        YES,
        NO,
        LITERAL_VALUES;

    }
}

