/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContextualUnionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluationResult {
    @Nullable
    List<JSTypeEvaluationResultElement> myResults;

    @Nullable
    public JSType getType() {
        JSType type;
        if (this.myResults == null) {
            return null;
        }
        if (this.myResults.size() == 1) {
            return this.myResults.get(0).myType;
        }
        ArrayList<JSType> types = new ArrayList<JSType>(this.myResults.size());
        JSTypeSource typeSource = null;
        boolean isStrict = true;
        for (JSTypeEvaluationResultElement result2 : this.myResults) {
            type = result2.getType();
            if (type == null || type.getSource().isStrict()) continue;
            isStrict = false;
        }
        for (JSTypeEvaluationResultElement result2 : this.myResults) {
            type = result2.getType();
            if (type == null) continue;
            if (typeSource == null) {
                typeSource = JSTypeSourceFactory.copyTypeSource(type.getSource(), isStrict);
            }
            types.add(type);
        }
        return types.isEmpty() ? null : (types.size() == 1 ? (JSType)types.get(0) : (isStrict ? JSContextualUnionTypeImpl.getContextualUnionType(types, typeSource) : new JSCompositeTypeImpl(typeSource, (List<JSType>)types)));
    }

    @Contract(value="null, null, null, _ -> fail")
    public void addResultElement(@Nullable JSType type, @Nullable JSNamespace namespace, @Nullable PsiElement source, @Nullable JSEvaluationResultContext context) {
        if (this.myResults == null) {
            this.myResults = new SmartList();
        }
        JSEvaluationResultContext notNullContext = (JSEvaluationResultContext)ObjectUtils.notNull((Object)context, (Object)JSEvaluationResultContext.EMPTY);
        if (type != null) {
            List types = ContainerUtil.mapNotNull(this.myResults, element -> element.getType());
            List<JSType> newTypes = JSTypeUtils.addPossibleOption(types, type);
            for (JSType newType : newTypes) {
                this.myResults.add(new JSTypeEvaluationResultElement(newType, namespace, source, notNullContext));
            }
            return;
        }
        JSTypeEvaluationResultElement e = new JSTypeEvaluationResultElement(null, namespace, source, notNullContext);
        for (JSTypeEvaluationResultElement result2 : this.myResults) {
            if (!e.isEquivalentTo(result2)) continue;
            return;
        }
        this.myResults.add(e);
    }

    public boolean isEmpty() {
        return this.myResults == null || this.myResults.isEmpty();
    }

    @NotNull
    public List<JSTypeEvaluationResultElement> getResults() {
        List<JSTypeEvaluationResultElement> list = this.myResults != null ? this.myResults : Collections.emptyList();
        if (list == null) {
            JSTypeEvaluationResult.$$$reportNull$$$0(0);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/JSTypeEvaluationResult", "getResults"));
    }

    public static class JSTypeEvaluationResultElement {
        @Nullable
        private final JSType myType;
        @Nullable
        private final JSNamespace myNamespace;
        @Nullable
        private final PsiElement mySource;
        @NotNull
        private final JSEvaluationResultContext myEvaluationContext;

        private JSTypeEvaluationResultElement(@Nullable JSType type, @Nullable JSNamespace namespace, @Nullable PsiElement source, @NotNull JSEvaluationResultContext evaluationContext) {
            if (evaluationContext == null) {
                JSTypeEvaluationResultElement.$$$reportNull$$$0(0);
            }
            assert (type != null || namespace != null || source != null);
            this.myType = type;
            this.myNamespace = namespace;
            this.mySource = source;
            this.myEvaluationContext = evaluationContext;
        }

        @Nullable
        public JSType getType() {
            return this.myType;
        }

        @Nullable
        public JSNamespace getNamespace() {
            return this.myNamespace;
        }

        @Nullable
        public PsiElement getSource() {
            return this.mySource;
        }

        @NotNull
        public JSEvaluationResultContext getEvaluationContext() {
            JSEvaluationResultContext jSEvaluationResultContext = this.myEvaluationContext;
            if (jSEvaluationResultContext == null) {
                JSTypeEvaluationResultElement.$$$reportNull$$$0(1);
            }
            return jSEvaluationResultContext;
        }

        public boolean isEquivalentTo(@NotNull JSTypeEvaluationResultElement other) {
            if (other == null) {
                JSTypeEvaluationResultElement.$$$reportNull$$$0(2);
            }
            if (this.myType == null ? other.myType != null : other.myType == null || !this.myType.getTypeText(JSType.TypeTextFormat.SIMPLE).equals(other.myType.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
                return false;
            }
            if (this.myNamespace == null ? other.myNamespace != null : other.myNamespace == null || !this.myNamespace.isEquivalentTo((JSType)other.myNamespace, new ProcessingContext())) {
                return false;
            }
            if (!ComparatorUtil.equalsNullable((Object)this.mySource, (Object)other.mySource)) {
                return false;
            }
            return this.myEvaluationContext.isEquivalentTo(other.myEvaluationContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluationContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/JSTypeEvaluationResult$JSTypeEvaluationResultElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/JSTypeEvaluationResult$JSTypeEvaluationResultElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEvaluationContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isEquivalentTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

