/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.controlflow;

import com.intellij.codeInsight.controlflow.ControlFlow;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInsight.controlflow.impl.ControlFlowImpl;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class JSControlFlowService
implements Disposable {
    public static final ControlFlowImpl EMPTY = new ControlFlowImpl(new Instruction[0]);
    private static final Logger LOGGER = Logger.getInstance(JSControlFlowService.class);
    @NotNull
    private final AtomicReference<ConcurrentMap<JSElement, ControlFlow>> myControlFlows;

    @NotNull
    public static JSControlFlowService getService(@NotNull Project project) {
        JSControlFlowService service;
        if (project == null) {
            JSControlFlowService.$$$reportNull$$$0(0);
        }
        JSControlFlowService jSControlFlowService = (service = (JSControlFlowService)ServiceManager.getService((Project)project, JSControlFlowService.class)) == null ? new JSControlFlowService(project) : service;
        if (jSControlFlowService == null) {
            JSControlFlowService.$$$reportNull$$$0(1);
        }
        return jSControlFlowService;
    }

    public JSControlFlowService(@NotNull Project project) {
        if (project == null) {
            JSControlFlowService.$$$reportNull$$$0(2);
        }
        this.myControlFlows = new AtomicReference<ConcurrentMap>(ContainerUtil.createConcurrentWeakKeySoftValueMap());
        LowMemoryWatcher.register(this::dispose, (Disposable)project);
    }

    @NotNull
    public ControlFlow getControlFlow(@NotNull JSElement scope) {
        if (scope == null) {
            JSControlFlowService.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ConcurrentMap<JSElement, ControlFlow> map = this.myControlFlows.get();
        ControlFlow flow = (ControlFlow)map.get(scope);
        if (flow != null) {
            ControlFlow controlFlow = flow;
            if (controlFlow == null) {
                JSControlFlowService.$$$reportNull$$$0(4);
            }
            return controlFlow;
        }
        try {
            flow = JSDialectSpecificHandlersFactory.forElement((PsiElement)scope).getControlFlow(scope);
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            LOGGER.error(e.getMessage(), (Throwable)e, new String[]{scope.getText()});
            flow = EMPTY;
        }
        map.putIfAbsent(scope, flow);
        ControlFlow controlFlow = flow;
        if (controlFlow == null) {
            JSControlFlowService.$$$reportNull$$$0(5);
        }
        return controlFlow;
    }

    public void resetFlow(@NotNull JSElement scope) {
        if (scope == null) {
            JSControlFlowService.$$$reportNull$$$0(6);
        }
        ConcurrentMap<JSElement, ControlFlow> map = this.myControlFlows.get();
        map.remove(scope);
    }

    public void dispose() {
        ConcurrentMap<JSElement, ControlFlow> flowMap = this.myControlFlows.get();
        this.myControlFlows.compareAndSet(flowMap, ContainerUtil.createConcurrentWeakKeySoftValueMap());
    }

    public static boolean isControlFlowScope(@NotNull PsiElement currentElement) {
        if (currentElement == null) {
            JSControlFlowService.$$$reportNull$$$0(7);
        }
        return currentElement instanceof JSExecutionScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/controlflow/JSControlFlowService";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/controlflow/JSControlFlowService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getControlFlow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resetFlow";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isControlFlowScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

