/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ReferenceListStub;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSReferenceListImpl;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ReferenceListImpl
extends JSReferenceListImpl<ES6ReferenceListStub>
implements ES6ReferenceList {
    public static final Key<ParameterizedCachedValue<ClassExpressionResolve, JSReferenceListMember>> CACHE_KEY = Key.create((String)"ES6.Ref.list");
    public static final ClassExpressionResolve NO_CONSTRUCTOR = ES6ReferenceListImpl.create(ES6ReferenceList.Errors.NO_CONSTRUCTOR);
    public static final ClassExpressionResolve CIRCLE_ERROR = ES6ReferenceListImpl.create(ES6ReferenceList.Errors.CIRCLE);
    public static final ParameterizedCachedValueProvider<ClassExpressionResolve, JSReferenceListMember> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<ClassExpressionResolve, JSReferenceListMember>(){

        public CachedValueProvider.Result<ClassExpressionResolve> compute(@NotNull JSReferenceListMember member) {
            if (member == null) {
                1.$$$reportNull$$$0(0);
            }
            return CachedValueProvider.Result.create((Object)ES6ReferenceListImpl.resolveReferenceListMemberNoCache(member), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl$1", "compute"));
        }
    };

    @NotNull
    private static ClassExpressionResolve create(@Nullable ES6ReferenceList.Errors constructorError) {
        ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(ContainerUtil.emptyList(), constructorError);
        if (classExpressionResolve == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(0);
        }
        return classExpressionResolve;
    }

    @NotNull
    private static ClassExpressionResolve resolveMemberType(@NotNull JSReferenceListMember member, @Nullable PsiElement expression, @Nullable JSType type, @NotNull Collection<JSClass> directClassesAndInterfaces) {
        if (member == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(1);
        }
        if (directClassesAndInterfaces == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(2);
        }
        if ((type = JSTypeUtils.getValuableType(type)) instanceof JSNamedType && ES6ReferenceListImpl.isCycleDefs(type, expression)) {
            ClassExpressionResolve classExpressionResolve = CIRCLE_ERROR;
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(3);
            }
            return classExpressionResolve;
        }
        if (DialectDetector.isES6((PsiElement)member) && !directClassesAndInterfaces.isEmpty()) {
            ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(directClassesAndInterfaces, ES6ReferenceList.Errors.NO_ERROR);
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(4);
            }
            return classExpressionResolve;
        }
        if (type != null) {
            ClassExpressionResolve classExpressionResolve = ES6ReferenceListImpl.resolveConstructorSignatures(type, (PsiElement)member, directClassesAndInterfaces);
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(5);
            }
            return classExpressionResolve;
        }
        ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(directClassesAndInterfaces, null);
        if (classExpressionResolve == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(6);
        }
        return classExpressionResolve;
    }

    public static boolean isCycleDefs(@NotNull JSType type, @Nullable PsiElement expressionToResolve) {
        PsiElement parentClass;
        if (type == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(7);
        }
        if (expressionToResolve == null) {
            return false;
        }
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(type);
        PsiElement refList = PsiTreeUtil.getParentOfType((PsiElement)expressionToResolve, JSReferenceList.class);
        return refList != null && ES6ReferenceListImpl.matchCycleDefs(elements, parentClass = refList.getParent(), ContainerUtil.newHashSet());
    }

    public ES6ReferenceListImpl(ASTNode node) {
        super(node);
    }

    public ES6ReferenceListImpl(ES6ReferenceListStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public JSClass[] getReferencedClassesImpl() {
        JSClass[] jSClassArray = (JSClass[])StreamEx.of(this.getResolvedExpressions()).flatMap(el -> ((Collection)el.second).stream()).toArray((Object[])JSClass.EMPTY_ARRAY);
        if (jSClassArray == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(8);
        }
        return jSClassArray;
    }

    @NotNull
    private static Collection<JSClass> getClassesForTypes(@NotNull ClassExpressionResolve classExpressionResolve) {
        JSType type;
        if (classExpressionResolve == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(9);
        }
        if ((type = classExpressionResolve.constructorType) == null || JSTypeUtils.hasGenericParameter(type)) {
            List<JSClass> list = Collections.emptyList();
            if (list == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        Collection<JSFunctionType> types = classExpressionResolve.constructorFunctions;
        if (types.isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (JSFunctionType functionType : types) {
            Collection<JSType> expanded = ES6ReferenceListImpl.getExpandedReturnTypes(functionType);
            for (JSType returnType : expanded) {
                Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(returnType);
                for (PsiElement psiElement : elements) {
                    if (!(psiElement instanceof JSClass)) continue;
                    result2.add((JSClass)psiElement);
                }
            }
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @Nullable
    private static Pair<JSType, Collection<JSClass>> getTypeWithSourceClass(@NotNull PsiElement element) {
        if (element == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(13);
        }
        JSType type = null;
        if (element instanceof JSExpression) {
            JSTypeEvaluationResult typeResult = JSTypeEvaluator.getExpressionType((JSExpression)element);
            if (typeResult != null) {
                type = typeResult.getType();
                List possibleClasses = ((StreamEx)StreamEx.of(typeResult.getResults()).map(el -> el.getSource()).filter(el -> el instanceof JSClass)).map(el -> (JSClass)el).toList();
                return Pair.create((Object)type, (Object)possibleClasses);
            }
        } else {
            type = JSTypeUtils.getTypeOfElement(element);
        }
        return type == null ? null : Pair.create((Object)type, null);
    }

    @NotNull
    public static ClassExpressionResolve resolveReferenceListMember(@NotNull JSReferenceListMember member) {
        ClassExpressionResolve result2;
        if (member == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(14);
        }
        ClassExpressionResolve classExpressionResolve = (result2 = (ClassExpressionResolve)RecursionManager.doPreventingRecursion((Object)member, (boolean)false, () -> {
            if (member == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(41);
            }
            return (ClassExpressionResolve)CachedValuesManager.getManager((Project)member.getProject()).getParameterizedCachedValue((UserDataHolder)member, CACHE_KEY, CACHED_VALUE_PROVIDER, false, (Object)member);
        })) == null ? CIRCLE_ERROR : result2;
        if (classExpressionResolve == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(15);
        }
        return classExpressionResolve;
    }

    @NotNull
    private static ClassExpressionResolve resolveReferenceListMemberNoCache(@NotNull JSReferenceListMember member) {
        if (member == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(16);
        }
        JSImportHandler handler = ES6ReferenceListImpl.getImportHandler((PsiElement)member);
        String text = member.getReferenceText();
        if (text != null) {
            Collection<? extends PsiElement> resolved = handler.resolveObjectOrTypeName(text, (PsiElement)member);
            Collection<Object> classes = StreamEx.of(resolved).map(obj -> (JSClass)ObjectUtils.tryCast((Object)obj, JSClass.class)).nonNull().toList();
            if (classes.isEmpty() || classes.stream().anyMatch(el -> !el.isInterface())) {
                if (classes.isEmpty() && !DialectDetector.isTypeScript((PsiElement)member)) {
                    classes = ES6ReferenceListImpl.resolveDirectlyToClasses(text, (PsiElement)member);
                }
                if (classes.size() > 0) {
                    ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(classes, null);
                    if (classExpressionResolve == null) {
                        ES6ReferenceListImpl.$$$reportNull$$$0(17);
                    }
                    return classExpressionResolve;
                }
            }
            if (!resolved.isEmpty()) {
                List types = (List)((StreamEx)StreamEx.of(resolved).filter(el -> !(el instanceof JSClass))).map(JSTypeUtils::getTypeOfElement).map(JSTypeUtils::getValuableType).nonNull().collect(Collectors.toList());
                JSType type = JSIntersectionTypeImpl.getIntersectionType(types, JSTypeSourceFactory.createTypeSource((PsiElement)member, true));
                ClassExpressionResolve classExpressionResolve = ES6ReferenceListImpl.resolveMemberType(member, null, type, classes);
                if (classExpressionResolve == null) {
                    ES6ReferenceListImpl.$$$reportNull$$$0(18);
                }
                return classExpressionResolve;
            }
            if (!DialectDetector.isTypeScript((PsiElement)member)) {
                ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(ContainerUtil.emptyList(), null);
                if (classExpressionResolve == null) {
                    ES6ReferenceListImpl.$$$reportNull$$$0(19);
                }
                return classExpressionResolve;
            }
        }
        ClassExpressionResolve classExpressionResolve = ES6ReferenceListImpl.resolveExpression(member);
        if (classExpressionResolve == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(20);
        }
        return classExpressionResolve;
    }

    private static ClassExpressionResolve resolveExpression(@NotNull JSReferenceListMember member) {
        JSExpression expressionToResolve;
        Pair<JSType, Collection<JSClass>> typeWithSourceClasses;
        if (member == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(21);
        }
        if ((typeWithSourceClasses = ES6ReferenceListImpl.getTypeWithSourceClass((PsiElement)(expressionToResolve = member.getExpression()))) == null) {
            return NO_CONSTRUCTOR;
        }
        return ES6ReferenceListImpl.resolveMemberType(member, (PsiElement)expressionToResolve, (JSType)typeWithSourceClasses.first, (Collection)typeWithSourceClasses.second);
    }

    @NotNull
    public static ClassExpressionResolve resolveConstructorSignatures(@Nullable JSType type, @NotNull PsiElement typeArgumentsOwner, @NotNull Collection<JSClass> directClassesAndInterfaces) {
        List<JSFunctionType> notMixins;
        if (typeArgumentsOwner == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(22);
        }
        if (directClassesAndInterfaces == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(23);
        }
        if (type == null) {
            ClassExpressionResolve classExpressionResolve = NO_CONSTRUCTOR;
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(24);
            }
            return classExpressionResolve;
        }
        Object forFunctionTypes = (type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) instanceof JSGenericTypeImpl ? type.asRecordType() : type;
        Collection allFunctionTypes = JSTypeUtils.getFunctionType(forFunctionTypes, true, typeArgumentsOwner).collect(Collectors.toList());
        if (allFunctionTypes.isEmpty()) {
            ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(type, ContainerUtil.emptyList(), directClassesAndInterfaces, ES6ReferenceList.Errors.NO_CONSTRUCTOR);
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(25);
            }
            return classExpressionResolve;
        }
        List<JSType> argumentsForExpression = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(TypeScriptPsiUtil.getNestedTypeArguments(typeArgumentsOwner), null);
        ArrayList functionTypes = ContainerUtil.newArrayList();
        int argSize = argumentsForExpression.size();
        for (JSType constructorType : allFunctionTypes) {
            JSType returnType;
            JSFunctionType functionType = constructorType instanceof JSFunctionType ? (JSFunctionType)constructorType : null;
            if (functionType == null || (returnType = ES6ReferenceListImpl.getExpandedReturnType(functionType)) == null || argSize != ES6ReferenceListImpl.getParameterListSize(constructorType)) continue;
            functionTypes.add(functionType);
        }
        if (functionTypes.isEmpty()) {
            ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(type, ContainerUtil.emptyList(), directClassesAndInterfaces, ES6ReferenceList.Errors.NO_COUNT_TYPE_ARGUMENTS);
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(26);
            }
            return classExpressionResolve;
        }
        if (functionTypes.size() > 1 && (notMixins = ES6ReferenceListImpl.excludeMixins(functionTypes)).size() > 1) {
            JSType item = ES6ReferenceListImpl.getExpandedReturnType(notMixins.get(0));
            assert (item != null);
            boolean isFirst = true;
            ProcessingContext context = JSTypeComparingContextService.getProcessingContextWithCache(typeArgumentsOwner);
            for (JSFunctionType jsType : notMixins) {
                if (isFirst) {
                    isFirst = false;
                    continue;
                }
                if (TypeScriptTypeRelations.areTypesComparable(item, ES6ReferenceListImpl.getExpandedReturnType(jsType), context)) continue;
                ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(type, functionTypes, directClassesAndInterfaces, ES6ReferenceList.Errors.MANY_CONSTRUCTORS_WITH_DIFF_TYPES);
                if (classExpressionResolve == null) {
                    ES6ReferenceListImpl.$$$reportNull$$$0(27);
                }
                return classExpressionResolve;
            }
        }
        ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(type, functionTypes, directClassesAndInterfaces, ES6ReferenceList.Errors.NO_ERROR);
        if (classExpressionResolve == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(28);
        }
        return classExpressionResolve;
    }

    @Nullable
    private static JSType getExpandedReturnType(@NotNull JSFunctionType type) {
        if (type == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(29);
        }
        JSType returnType = type.getReturnType();
        return TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(returnType);
    }

    @NotNull
    public static Collection<JSType> getExpandedReturnTypes(@NotNull JSFunctionType type) {
        List<JSType> types;
        JSType preProcessed;
        JSType returnType;
        if (type == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(30);
        }
        if ((returnType = ES6ReferenceListImpl.getExpandedReturnType(type)) instanceof JSIntersectionTypeImpl && (preProcessed = JSIntersectionTypeImpl.getIntersectionType(types = ((JSIntersectionTypeImpl)returnType).getTypes(), returnType.getSource())) instanceof JSIntersectionTypeImpl) {
            List<JSType> list = ((JSIntersectionTypeImpl)preProcessed).getTypes();
            if (list == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(31);
            }
            return list;
        }
        Set<JSType> set = Collections.singleton(returnType);
        if (set == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(32);
        }
        return set;
    }

    @NotNull
    private static List<JSFunctionType> excludeMixins(@NotNull Collection<JSFunctionType> functionTypes) {
        if (functionTypes == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(33);
        }
        List list = ((StreamEx)StreamEx.of(functionTypes).filter(current -> !ES6ReferenceListImpl.isMixinConstructor(current))).toList();
        if (list == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(34);
        }
        return list;
    }

    public static boolean isMixinConstructor(@NotNull JSFunctionType functionType) {
        List parameters;
        if (functionType == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(35);
        }
        if ((parameters = functionType.getParameters()).size() != 1) {
            return false;
        }
        JSParameterTypeDecorator decorator = (JSParameterTypeDecorator)parameters.get(0);
        if (!decorator.isRest()) {
            return false;
        }
        JSType decoratorType = decorator.getType();
        return decoratorType == null || decoratorType instanceof JSAnyType;
    }

    private static int getParameterListSize(@NotNull JSType constructorType) {
        PsiElement sourceElement;
        if (constructorType == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(36);
        }
        if (!((sourceElement = constructorType.getSource().getSourceElement()) instanceof TypeScriptTypeParameterListOwner)) {
            return 0;
        }
        TypeScriptTypeParameterListOwner owner = (TypeScriptTypeParameterListOwner)sourceElement;
        TypeScriptTypeParameterList list = owner.getTypeParameterList();
        if (list == null) {
            return 0;
        }
        return list.getTypeParameters().length;
    }

    private static boolean matchCycleDefs(@NotNull Collection<? extends PsiElement> elements, @Nullable PsiElement toFind, @NotNull Collection<PsiElement> visited) {
        if (elements == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(37);
        }
        if (visited == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(38);
        }
        if (!elements.isEmpty() && toFind != null) {
            for (PsiElement psiElement : elements) {
                Object[] classes;
                JSClass jsClass;
                if (!visited.add(psiElement)) {
                    return true;
                }
                if (psiElement.isEquivalentTo(toFind)) {
                    return true;
                }
                if (!(psiElement instanceof JSClass) || (jsClass = (JSClass)psiElement).isInterface() || (classes = jsClass.getSuperClasses()).length <= 0 || !ES6ReferenceListImpl.matchCycleDefs(ContainerUtil.newArrayList((Object[])classes), toFind, visited)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<Pair<JSReferenceListMember, Collection<JSClass>>> getResolvedExpressions() {
        JSReferenceListMember[] members = this.getMembers();
        if (members.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(39);
            }
            return list;
        }
        List resolvedList = ContainerUtil.newSmartList();
        for (JSReferenceListMember member : members) {
            ClassExpressionResolve resolve = ES6ReferenceListImpl.resolveReferenceListMember(member);
            resolvedList.add(Pair.create((Object)member, resolve.getDirectOrTypeClasses()));
        }
        List list = resolvedList;
        if (list == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(40);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl";
                break;
            }
            case 1: 
            case 14: 
            case 16: 
            case 21: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directClassesAndInterfaces";
                break;
            }
            case 7: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classExpressionResolve";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArgumentsOwner";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionTypes";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructorType";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveMemberType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedClassesImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesForTypes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferenceListMember";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferenceListMemberNoCache";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveConstructorSignatures";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandedReturnTypes";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeMixins";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveMemberType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCycleDefs";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getClassesForTypes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithSourceClass";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceListMember";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceListMemberNoCache";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveExpression";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveConstructorSignatures";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedReturnType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getExpandedReturnTypes";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "excludeMixins";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isMixinConstructor";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getParameterListSize";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "matchCycleDefs";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveReferenceListMember$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ClassExpressionResolve {
        @Nullable
        public final JSType constructorType;
        @NotNull
        public final Collection<JSFunctionType> constructorFunctions;
        @NotNull
        public final Collection<JSClass> directClassesAndInterfaces;
        @Nullable
        public final ES6ReferenceList.Errors constructorError;
        private final AtomicNotNullLazyValue<Collection<JSClass>> classesFromConstructors;

        public ClassExpressionResolve(@NotNull Collection<JSClass> directClassesAndInterfaces, @Nullable ES6ReferenceList.Errors constructorError) {
            if (directClassesAndInterfaces == null) {
                ClassExpressionResolve.$$$reportNull$$$0(0);
            }
            this(null, ContainerUtil.emptyList(), directClassesAndInterfaces, constructorError);
        }

        public ClassExpressionResolve(@Nullable JSType constructorType, @NotNull Collection<JSFunctionType> constructorFunctions, @NotNull Collection<JSClass> directClassesAndInterfaces, @Nullable ES6ReferenceList.Errors constructorError) {
            if (constructorFunctions == null) {
                ClassExpressionResolve.$$$reportNull$$$0(1);
            }
            if (directClassesAndInterfaces == null) {
                ClassExpressionResolve.$$$reportNull$$$0(2);
            }
            this.classesFromConstructors = AtomicNotNullLazyValue.createValue(() -> ES6ReferenceListImpl.getClassesForTypes(this));
            this.constructorType = constructorType;
            this.constructorFunctions = constructorFunctions;
            this.directClassesAndInterfaces = directClassesAndInterfaces;
            this.constructorError = constructorError;
        }

        public boolean hasError() {
            return this.constructorError != null && this.constructorError != ES6ReferenceList.Errors.NO_ERROR;
        }

        @NotNull
        public Collection<JSClass> getDirectOrTypeClasses() {
            if (this.constructorError == ES6ReferenceList.Errors.CIRCLE) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    ClassExpressionResolve.$$$reportNull$$$0(3);
                }
                return list;
            }
            HashSet objects = ContainerUtil.newHashSet();
            objects.addAll(this.directClassesAndInterfaces);
            objects.addAll((Collection)this.classesFromConstructors.getValue());
            HashSet hashSet = objects;
            if (hashSet == null) {
                ClassExpressionResolve.$$$reportNull$$$0(4);
            }
            return hashSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directClassesAndInterfaces";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructorFunctions";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl$ClassExpressionResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl$ClassExpressionResolve";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectOrTypeClasses";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

