/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSParenthesizedExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSCallExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCallExpressionImpl
extends JSImplicitElementProviderImpl<JSCallExpressionStub>
implements JSCallExpression,
StubBasedPsiElement<JSCallExpressionStub> {
    public JSCallExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSCallExpressionImpl(JSCallExpressionStub stub) {
        super(stub, (IStubElementType)JSStubElementTypes.CALL_EXPRESSION);
    }

    public JSExpression getMethodExpression() {
        ASTNode node = JSCallExpressionImpl.getMethodExpression(this.getNode());
        return node != null ? (JSExpression)node.getPsi() : null;
    }

    @Nullable
    public static ASTNode getMethodExpression(@NotNull ASTNode callExpression) {
        if (callExpression == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(0);
        }
        return callExpression.findChildByType(JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
    }

    public JSExpression getStubSafeMethodExpression() {
        JSCallExpressionStub stub = (JSCallExpressionStub)this.getGreenStub();
        if (stub != null) {
            if (!stub.keepsMethodExpression()) {
                return null;
            }
            StubElement initializerStub = StubTreeUtil.findChildStubByType(stub, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
            return initializerStub != null ? (JSExpression)initializerStub.getPsi() : null;
        }
        return this.getMethodExpression();
    }

    @Nullable
    public JSArgumentList getArgumentList() {
        ASTNode argumentList = JSCallExpressionImpl.getArgumentList(this.getNode());
        return argumentList != null ? (JSArgumentList)argumentList.getPsi() : null;
    }

    @Nullable
    public static ASTNode getArgumentList(@NotNull ASTNode callExpressionNode) {
        if (callExpressionNode == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(1);
        }
        return callExpressionNode.findChildByType(JSExtendedLanguagesTokenSetProvider.ARGUMENT_LISTS);
    }

    @NotNull
    public JSExpression[] getArguments() {
        JSExpression[] jSExpressionArray = JSCallExpressionImpl.notNullArguments(this);
        if (jSExpressionArray == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(2);
        }
        return jSExpressionArray;
    }

    static JSExpression[] notNullArguments(JSCallExpression jsCallExpression) {
        JSArgumentList argumentList = jsCallExpression.getArgumentList();
        return argumentList != null ? argumentList.getArguments() : JSExpression.EMPTY_ARRAY;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSCallExpression((JSCallExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }

    @Override
    @NotNull
    public JSElementIndexingData calculateIndexingData() {
        JSElementIndexingDataImpl indexingData = new JSElementIndexingDataImpl();
        JSExpression methodExpression = this.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            JSExpression[] arguments;
            JSReferenceExpression referenceExpression = (JSReferenceExpression)methodExpression;
            JSExpression qualifier = referenceExpression.getQualifier();
            String calledMethodName = referenceExpression.getReferenceName();
            JSFunction scopeFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)this, JSFunction.class);
            Ref extensionContext = Ref.create((Object)JSContext.UNKNOWN);
            if ("call".equals(calledMethodName) && qualifier instanceof JSReferenceExpression && scopeFunction != null && !(scopeFunction instanceof JSFunctionExpression)) {
                arguments = this.getArguments();
                String scopeFunctionName = scopeFunction.getName();
                JSQualifiedName qualifiedName = JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)qualifier));
                if (arguments.length == 1 && arguments[0] instanceof JSThisExpression && scopeFunctionName != null && qualifiedName != null) {
                    indexingData.addBaseType(scopeFunctionName, qualifiedName.getQualifiedName());
                }
            } else if (JSSymbolUtil.symbolSeemsToBeExtensionFunction(calledMethodName) && (JSSymbolUtil.isExtendCall(qualifier, calledMethodName, (Ref<JSContext>)extensionContext) || qualifier == null && scopeFunction == null || JSSymbolUtil.isExtendCallOutsideFunction(qualifier, calledMethodName, (Ref<JSContext>)extensionContext) && scopeFunction == null)) {
                arguments = this.getArguments();
                JSReferenceExpression nsRef = arguments.length >= 2 && arguments[0] instanceof JSReferenceExpression ? (JSReferenceExpression)arguments[0] : null;
                JSReferenceExpression baseNsRef = arguments.length >= 2 && arguments[1] instanceof JSReferenceExpression ? (JSReferenceExpression)arguments[1] : null;
                JSNamespace ns = null;
                if (arguments.length >= 2 && arguments[0] instanceof JSReferenceExpression && !(arguments[1] instanceof JSReferenceExpression)) {
                    PsiElement nodeParent = this.getParent();
                    if (nodeParent instanceof JSAssignmentExpression) {
                        JSExpression assignedTo = ((JSDefinitionExpression)((JSAssignmentExpression)nodeParent).getLOperand()).getExpression();
                        if (assignedTo instanceof JSReferenceExpression) {
                            baseNsRef = nsRef;
                            nsRef = (JSReferenceExpression)assignedTo;
                        }
                    } else if (nodeParent instanceof JSVariable) {
                        baseNsRef = nsRef;
                        String name = ((JSVariable)nodeParent).getName();
                        if (name != null) {
                            ns = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(name, null), (JSContext)extensionContext.get(), nodeParent, false);
                        }
                    }
                }
                if (ns == null && nsRef != null) {
                    ns = JSStubIndexingUtils.getNamespaceFromReferenceExpression(nsRef, (JSContext)extensionContext.get());
                }
                if (ns != null && baseNsRef != null) {
                    JSNamespace baseNs = JSStubIndexingUtils.getNamespaceFromReferenceExpression(baseNsRef, (JSContext)extensionContext.get());
                    JSStubIndexingUtils.processExtendCall(ns, baseNs, indexingData);
                }
            }
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions((PsiElement)this)) {
            handler.processCallExpression(this, indexingData);
        }
        JSElementIndexingDataImpl jSElementIndexingDataImpl = indexingData;
        if (jSElementIndexingDataImpl == null) {
            JSCallExpressionImpl.$$$reportNull$$$0(4);
        }
        return jSElementIndexingDataImpl;
    }

    public static boolean shouldCreateStub(ASTNode node) {
        String calledMethodName;
        ASTNode lastChildNode;
        ASTNode methodExpression = node.getFirstChildNode();
        while (methodExpression != null && methodExpression.getElementType() == JSElementTypes.PARENTHESIZED_EXPRESSION) {
            methodExpression = JSParenthesizedExpressionImpl.getInnerExpression(methodExpression);
        }
        if (methodExpression != null && methodExpression.getElementType() == JSElementTypes.REFERENCE_EXPRESSION ? (lastChildNode = methodExpression.getLastChildNode()) != null && ("call".equals(calledMethodName = lastChildNode.getText()) || JSSymbolUtil.symbolSeemsToBeExtensionFunction(calledMethodName)) : methodExpression != null && JSElementTypes.FUNCTION_EXPRESSIONS.contains(methodExpression.getElementType())) {
            return true;
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getExtensions(node)) {
            if (!handler.shouldCreateStubForCallExpression(node)) continue;
            return true;
        }
        return false;
    }

    public boolean isRequireCall() {
        JSCallExpressionStub stub = (JSCallExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isRequireCall();
        }
        return CommonJSUtil.calculateIsRequireCall(this);
    }

    public boolean isDefineCall() {
        JSCallExpressionStub stub = (JSCallExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.isDefineCall();
        }
        return JSAmdPsiUtil.isDefineCall(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpressionNode";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSCallExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSCallExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateIndexingData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMethodExpression";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentList";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

