/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.json.psi.impl.JSStringLiteralEscaper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSImplicitElementProviderImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.literal.JSLiteralImplicitElementProvidersRegistry;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSLiteralExpressionStub;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLiteralExpressionImpl
extends JSImplicitElementProviderImpl<JSLiteralExpressionStub>
implements JSLiteralExpression,
StubBasedPsiElement<JSLiteralExpressionStub>,
PsiLanguageInjectionHost {
    public static final String BIG_INT_SUFFIX = "n";
    public static final BigInteger INT_MAX_VALUE_AS_BIGINT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final int MAX_LITERAL_PROCESSING_SIZE = 4096;
    private static final Key<ParameterizedCachedValue<PsiReference[], JSLiteralExpressionImpl>> REFERENCES_KEY = new Key("js.literal.expression.references");
    private static final ParameterizedCachedValueProvider<PsiReference[], JSLiteralExpressionImpl> REFERENCES_PROVIDER = new ParameterizedCachedValueProvider<PsiReference[], JSLiteralExpressionImpl>(){

        @NotNull
        public CachedValueProvider.Result<PsiReference[]> compute(JSLiteralExpressionImpl param) {
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)param.createRefs(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            if (result2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl$1", "compute"));
        }
    };
    private static final Key<ParameterizedCachedValue<JSLiteralExpressionKind, JSLiteralExpressionImpl>> CACHE_KEY_EXACT = Key.create((String)"JSLiteralExpressionImpl.getExpressionKind.exact");
    protected static final Key<ParameterizedCachedValue<JSLiteralExpressionKind, JSLiteralExpressionImpl>> CACHE_KEY_SIMPLE = Key.create((String)"JSLiteralExpressionImpl.getExpressionKind.simple");
    private static final ParameterizedCachedValueProvider<JSLiteralExpressionKind, JSLiteralExpressionImpl> PROVIDER_EXACT = new ParameterizedCachedValueProvider<JSLiteralExpressionKind, JSLiteralExpressionImpl>(){

        @NotNull
        public CachedValueProvider.Result<JSLiteralExpressionKind> compute(JSLiteralExpressionImpl p) {
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)JSLiteralExpressionImpl.getExpressionKindImpl(p, true), (Object[])new Object[]{p});
            if (result2 == null) {
                3.$$$reportNull$$$0(0);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl$3", "compute"));
        }
    };
    protected static final ParameterizedCachedValueProvider<JSLiteralExpressionKind, JSLiteralExpressionImpl> PROVIDER_SIMPLE = new ParameterizedCachedValueProvider<JSLiteralExpressionKind, JSLiteralExpressionImpl>(){

        @NotNull
        public CachedValueProvider.Result<JSLiteralExpressionKind> compute(JSLiteralExpressionImpl p) {
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)JSLiteralExpressionImpl.getExpressionKindImpl(p, false), (Object[])new Object[]{p});
            if (result2 == null) {
                4.$$$reportNull$$$0(0);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl$4", "compute"));
        }
    };

    public JSLiteralExpressionImpl(ASTNode node) {
        super(node);
    }

    public JSLiteralExpressionImpl(@NotNull JSLiteralExpressionStub stub) {
        if (stub == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        super(stub, (IStubElementType)JSStubElementTypes.LITERAL_EXPRESSION);
    }

    protected JSLiteralExpressionImpl(@NotNull JSLiteralExpressionStub stub, IStubElementType type) {
        if (stub == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        super(stub, type);
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = (PsiReference[])CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, REFERENCES_KEY, REFERENCES_PROVIDER, false, (Object)this);
        if (psiReferenceArray == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return psiReferenceArray;
    }

    private PsiReference[] createRefs() {
        if (this.hasInjections()) {
            return PsiReference.EMPTY_ARRAY;
        }
        JSElementIndexingData indexingData = this.getIndexingData();
        if (indexingData != null && !ContainerUtil.isEmpty((Collection)indexingData.getImplicitElements())) {
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] result2 = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (result2.length == 0 && this.getTextLength() < 4096) {
            JSReferenceSet refSet = new JSReferenceSet((PsiElement)this);
            refSet.update(this.getText(), 0);
            return refSet.getReferences();
        }
        return result2;
    }

    private boolean hasInjections() {
        Ref result2 = new Ref();
        InjectedLanguageManager.getInstance((Project)this.getProject()).enumerate((PsiElement)this, (injectedPsi, places) -> result2.set((Object)true));
        return Boolean.TRUE == result2.get();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(3);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSLiteralExpression((JSLiteralExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean isValidHost() {
        return this.isQuotedLiteral() || this.isRegExpLiteral();
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        ASTNode valueNode = this.getNode().getFirstChildNode();
        assert (valueNode instanceof LeafElement);
        ((LeafElement)valueNode).replaceWithText(text);
        return this;
    }

    @NotNull
    public LiteralTextEscaper<JSLiteralExpressionImpl> createLiteralTextEscaper() {
        JSStringLiteralEscaper<JSLiteralExpressionImpl> jSStringLiteralEscaper = new JSStringLiteralEscaper<JSLiteralExpressionImpl>(this){

            protected boolean isRegExpLiteral() {
                return ((JSLiteralExpressionImpl)this.myHost).isRegExpLiteral();
            }

            public boolean isOneLine() {
                return !(JSLiteralExpressionImpl.this instanceof JSStringTemplateExpression);
            }
        };
        if (jSStringLiteralEscaper == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        return jSStringLiteralEscaper;
    }

    public static boolean isQuotedLiteral(ASTNode node) {
        return node.getElementType() == JSStubElementTypes.LITERAL_EXPRESSION && node.findChildByType(JSTokenTypes.STRING_LITERALS) != null;
    }

    @NotNull
    private String getNumericLiteralText(@NotNull String text) {
        int endIndex;
        JSLiteralExpressionKind kind;
        if (text == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        if (!(kind = this.getExpressionKind(true)).isNumeric()) {
            String string = text;
            if (string == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        int n = endIndex = kind.isBigInteger() ? text.length() - 1 : text.length();
        if (kind.isBin() || kind.isHex() || kind == JSLiteralExpressionKind.OCT || kind == JSLiteralExpressionKind.OCT_BIGINT) {
            String string = text.substring(2, endIndex);
            if (string == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (kind == JSLiteralExpressionKind.OBSOLETE_OCT) {
            String string = text.substring(1, endIndex);
            if (string == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = text.substring(0, endIndex);
        if (string == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public JSLiteralExpressionKind getExpressionKind(boolean computeExactNumericKind) {
        JSLiteralExpressionKind result2 = (JSLiteralExpressionKind)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, CACHE_KEY_SIMPLE, PROVIDER_SIMPLE, false, (Object)this);
        if (!result2.isNumeric() || !computeExactNumericKind) {
            JSLiteralExpressionKind jSLiteralExpressionKind = result2;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(11);
            }
            return jSLiteralExpressionKind;
        }
        JSLiteralExpressionKind jSLiteralExpressionKind = (JSLiteralExpressionKind)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, CACHE_KEY_EXACT, PROVIDER_EXACT, false, (Object)this);
        if (jSLiteralExpressionKind == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(12);
        }
        return jSLiteralExpressionKind;
    }

    @NotNull
    private static JSLiteralExpressionKind getExpressionKindImpl(@NotNull JSLiteralExpressionImpl literalExpression, boolean computeExactNumericKind) {
        ASTNode node;
        if (literalExpression == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(13);
        }
        if ((node = literalExpression.getNode()).findChildByType(JSTokenTypes.BOOLEAN_LITERALS) != null) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.BOOLEAN;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(14);
            }
            return jSLiteralExpressionKind;
        }
        if (node.findChildByType(JSTokenTypes.NUMERIC_LITERAL) != null) {
            if (!computeExactNumericKind) {
                JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.OTHER_NUMERIC;
                if (jSLiteralExpressionKind == null) {
                    JSLiteralExpressionImpl.$$$reportNull$$$0(15);
                }
                return jSLiteralExpressionKind;
            }
            String text = literalExpression.getText();
            for (Map.Entry<Condition<String>, JSLiteralExpressionKind> entry : JSStringUtil.NUMERIC_MATCHERS.entrySet()) {
                if (!entry.getKey().value((Object)text)) continue;
                JSLiteralExpressionKind value = entry.getValue();
                JSLiteralExpressionKind jSLiteralExpressionKind = StringUtil.endsWith((CharSequence)text, (CharSequence)BIG_INT_SUFFIX) ? value.toBigInt() : value;
                if (jSLiteralExpressionKind == null) {
                    JSLiteralExpressionImpl.$$$reportNull$$$0(16);
                }
                return jSLiteralExpressionKind;
            }
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.OTHER_NUMERIC;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(17);
            }
            return jSLiteralExpressionKind;
        }
        if (JSLiteralExpressionImpl.isQuotedLiteral(node)) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.QUOTED;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(18);
            }
            return jSLiteralExpressionKind;
        }
        if (node.findChildByType(JSTokenTypes.REGEXP_LITERAL) != null) {
            JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.REGEXP;
            if (jSLiteralExpressionKind == null) {
                JSLiteralExpressionImpl.$$$reportNull$$$0(19);
            }
            return jSLiteralExpressionKind;
        }
        JSLiteralExpressionKind jSLiteralExpressionKind = JSLiteralExpressionKind.UNKNOWN;
        if (jSLiteralExpressionKind == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(20);
        }
        return jSLiteralExpressionKind;
    }

    public JSExpression replace(JSExpression other) {
        return JSChangeUtil.replaceExpression((JSExpression)this, other);
    }

    @Override
    @Nullable
    public JSElementIndexingData calculateIndexingData() {
        return JSLiteralImplicitElementProvidersRegistry.calculateIndexingData(this);
    }

    @Nullable
    public String getValueAsPropertyName() {
        String text = this.getText();
        if (this.isQuotedLiteral() && ((text = this.getStringValue()) == null || !StringUtil.isJavaIdentifier((String)text))) {
            text = null;
        }
        return text;
    }

    @Nullable
    public Object getValue() {
        String expressionText = this.getText();
        if (StringUtil.isEmpty((String)expressionText)) {
            return null;
        }
        JSLiteralExpressionKind kind = this.getExpressionKind(true);
        if (kind.isNumeric()) {
            try {
                double t;
                if (kind.isBigInteger()) {
                    int radix = 10;
                    if (kind.isHex()) {
                        radix = 16;
                    }
                    if (kind.isOct()) {
                        radix = 8;
                    }
                    if (kind.isBin()) {
                        radix = 2;
                    }
                    String numberValue = this.getNumericLiteralText(expressionText);
                    numberValue = StringUtil.replace((String)numberValue, (String)"_", (String)"");
                    return new BigInteger(numberValue, radix);
                }
                Double numericValue = JSNumberParser.tryParseNumericValue(expressionText, true);
                if (numericValue != null && !numericValue.isInfinite() && !numericValue.isNaN() && numericValue > -9.223372036854776E18 && numericValue < 9.223372036854776E18 && numericValue.equals(t = Math.ceil(numericValue))) {
                    return numericValue.longValue();
                }
                return numericValue;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        if (kind == JSLiteralExpressionKind.BOOLEAN) {
            return null != this.findChildByType(JSTokenTypes.TRUE_KEYWORD);
        }
        if (kind == JSLiteralExpressionKind.QUOTED) {
            return this.getStringValue();
        }
        return expressionText;
    }

    @Nullable
    public String getStringValue() {
        JSLiteralExpressionKind kind = this.getExpressionKind(false);
        if (kind.isNumeric() || kind == JSLiteralExpressionKind.BOOLEAN || kind == JSLiteralExpressionKind.XML) {
            return null;
        }
        String expressionText = this.getText();
        if (StringUtil.isEmpty((String)expressionText)) {
            return null;
        }
        if (this.isQuotedLiteral()) {
            return JSStringUtil.unquoteAndUnescapeStringLiteralValue(expressionText);
        }
        return expressionText;
    }

    @Nullable
    public String getSignificantValue() {
        JSLiteralExpressionStub stub = (JSLiteralExpressionStub)this.getGreenStub();
        if (stub != null) {
            return stub.getSignificantValue();
        }
        FrameworkIndexingHandler[] extensions = FrameworkIndexingHandler.getExtensions((PsiElement)this);
        for (int i = 0; i < extensions.length; ++i) {
            if (!extensions[i].hasSignificantValue(this)) continue;
            return this.getText();
        }
        return null;
    }

    public static boolean isNullExpression(@NotNull ASTNode literalExpression) {
        if (literalExpression == null) {
            JSLiteralExpressionImpl.$$$reportNull$$$0(21);
        }
        return literalExpression.findChildByType(JSTokenTypes.NULL_KEYWORD) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumericLiteralText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionKind";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionKindImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNumericLiteralText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionKindImpl";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isNullExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

