/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceSet;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSReferenceSetElement
implements PsiPolyVariantReference,
LocalQuickFixProvider {
    @NotNull
    protected final String myCanonicalText;
    @NotNull
    protected final TextRange myRangeInElement;
    protected final JSReferenceSet mySet;

    protected JSReferenceSetElement(@NotNull JSReferenceSet set, @NotNull String s, @NotNull TextRange rangeInElement) {
        if (set == null) {
            JSReferenceSetElement.$$$reportNull$$$0(0);
        }
        if (s == null) {
            JSReferenceSetElement.$$$reportNull$$$0(1);
        }
        if (rangeInElement == null) {
            JSReferenceSetElement.$$$reportNull$$$0(2);
        }
        this.mySet = set;
        this.myCanonicalText = s;
        this.myRangeInElement = rangeInElement;
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.mySet.element;
        if (psiElement == null) {
            JSReferenceSetElement.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = this.myRangeInElement;
        if (textRange == null) {
            JSReferenceSetElement.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Nullable
    public final PsiElement resolve() {
        Object[] resolveResults = this.multiResolve(false);
        if (resolveResults.length == 1) {
            return resolveResults[0].getElement();
        }
        if (resolveResults.length == 0) {
            return null;
        }
        int validElements = 0;
        PsiElement lastValid = null;
        for (ResolveResult resolveResult : resolveResults) {
            if (!resolveResult.isValidResult()) continue;
            ++validElements;
            lastValid = resolveResult.getElement();
        }
        if (validElements > 1) {
            return null;
        }
        if (validElements == 1) {
            return lastValid;
        }
        ResolveResult element = (ResolveResult)ArrayUtil.getLastElement((Object[])resolveResults);
        return element != null ? element.getElement() : null;
    }

    @NotNull
    public final ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiFile file2 = this.mySet.element.getContainingFile();
        ResolveResult[] resolveResultArray = JSResolveUtil.resolve(file2, this, (reference, __) -> reference.doResolve(), incompleteCode);
        if (resolveResultArray == null) {
            JSReferenceSetElement.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    @NotNull
    protected abstract ResolveResult[] doResolve();

    @NotNull
    public String getCanonicalText() {
        String string = this.myCanonicalText;
        if (string == null) {
            JSReferenceSetElement.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return JSReferenceSetElement.handleContentChange(this.getElement(), this.getRangeInElement(), newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        String qName;
        if (element == null) {
            JSReferenceSetElement.$$$reportNull$$$0(7);
        }
        if ((qName = JSPsiImplUtils.getQNameForMove(this.getElement(), element)) != null) {
            JSReferenceSetElement.handleContentChange(this.getElement(), new TextRange(this.mySet.myReferences[0].getRangeInElement().getStartOffset(), this.getRangeInElement().getEndOffset()), qName);
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (element instanceof PsiNamedElement || element instanceof XmlAttributeValue) {
            return JSReferenceUtil.isReferenceTo(this, this.myCanonicalText, element);
        }
        return false;
    }

    public boolean isPrimary() {
        return this.mySet.getReferences()[0] == this;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            JSReferenceSetElement.$$$reportNull$$$0(8);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Nullable
    public PsiReference getQualifier() {
        if (this.isPrimary()) {
            return null;
        }
        PsiReference qualifier = null;
        for (PsiReference reference : this.mySet.getReferences()) {
            if (reference == this) {
                return qualifier;
            }
            qualifier = reference;
        }
        return qualifier;
    }

    public boolean isSoft() {
        return this.mySet.isSoft();
    }

    public LocalQuickFix[] getQuickFixes() {
        return this.mySet.myLocalQuickFixProvider == null ? LocalQuickFix.EMPTY_ARRAY : this.mySet.myLocalQuickFixProvider.getQuickFixes();
    }

    @NotNull
    public JSQualifiedName getQualifiedName() {
        JSQualifiedNameImpl qName = null;
        for (PsiReference ref : this.mySet.myReferences) {
            qName = JSQualifiedNameImpl.create(ref.getCanonicalText(), qName);
            if (ref == this) break;
        }
        assert (qName != null) : this;
        JSQualifiedNameImpl jSQualifiedNameImpl = qName;
        if (jSQualifiedNameImpl == null) {
            JSReferenceSetElement.$$$reportNull$$$0(9);
        }
        return jSQualifiedNameImpl;
    }

    public void processLocalVariants(SinkResolveProcessor<?> processor) {
    }

    private static PsiElement handleContentChange(PsiElement elt, TextRange range, String newElementName) {
        return ElementManipulators.getManipulator((PsiElement)elt).handleContentChange(elt, range, newElementName);
    }

    @NotNull
    public JSReferenceSet getSet() {
        JSReferenceSet jSReferenceSet = this.mySet;
        if (jSReferenceSet == null) {
            JSReferenceSetElement.$$$reportNull$$$0(10);
        }
        return jSReferenceSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSReferenceSetElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

