/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSContextLevel;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.JSHierarchyProcessor;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTaggedResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeInfo;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSExtendingTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSSymbolProcessor {
    public static final Set<String> GLOBAL_OBJECT_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"window", "global", "GLOBAL"});
    public static final Set<String> GLOBAL_TYPE_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"Window"});
    public static final String HTML_ELEMENT_TYPE_NAME = "HTMLElement";
    protected final boolean ecmal4;
    protected final boolean typescript;
    @NotNull
    protected final JSTypeInfo myTypeInfo;
    @NotNull
    protected final PsiElement myContext;
    @NotNull
    protected final PsiFile myTargetFile;
    @Nullable
    protected final VirtualFile myTargetVirtualFile;
    @NotNull
    private final NotNullLazyValue<List<JSQualifiedName>> myContextScopesCache;
    protected boolean myCheckFileLevelAccess;
    @Nullable
    protected VirtualFile myCurrentFile;
    public static final String[] TS_EXCLUDED = new String[]{"HTMLElementTagNameMap", "DocumentEventMap", "HTMLElementEventMap", "WindowEventMap", "SVGMatrix", "WebKitCSSMatrix", "DOMMatrix", "DOMMatrixReadOnly", "DOMMatrix2DInit"};
    protected boolean myAddOnlyCompleteMatches;
    protected boolean myAddOnlyCompleteMatchesSet;

    public static boolean isNamedGlobalType(@NotNull String typeString, @NotNull JSContext context) {
        if (typeString == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(1);
        }
        return GLOBAL_TYPE_NAMES.contains(typeString) && context != JSContext.STATIC || GLOBAL_OBJECT_NAMES.contains(typeString);
    }

    protected BaseJSSymbolProcessor(@NotNull PsiFile targetFile, @NotNull PsiElement context) {
        if (targetFile == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(2);
        }
        if (context == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(3);
        }
        this.myTargetFile = targetFile;
        this.myTargetVirtualFile = targetFile.getVirtualFile();
        this.myContext = context;
        this.myTypeInfo = this.createTypeInfo(this.initGlobalStatusHint(context));
        this.myContextScopesCache = NotNullLazyValue.createValue(() -> JSVisibilityUtil.calculateContextNames(this.getContext()));
        DialectOptionHolder holder = DialectDetector.dialectOfElement(context);
        this.ecmal4 = holder != null && holder.isECMA4;
        this.typescript = holder != null && holder.isTypeScript;
        for (FrameworkIndexingHandler handler : (FrameworkIndexingHandler[])FrameworkIndexingHandler.EP_NAME.getExtensions()) {
            handler.addContextType(this.myTypeInfo, context);
        }
    }

    protected JSTypeInfo createTypeInfo(@NotNull JSTypeInfo.GlobalStatusHint globalStatusHint) {
        if (globalStatusHint == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(4);
        }
        return new JSTypeInfo(globalStatusHint);
    }

    @NotNull
    protected JSTypeInfo.GlobalStatusHint initGlobalStatusHint(@Nullable PsiElement context) {
        boolean withinWithStatement;
        JSExpression contextRefQualifier;
        JSExpression jSExpression = contextRefQualifier = context instanceof JSReferenceExpression ? ((JSReferenceExpression)context).getQualifier() : null;
        if (contextRefQualifier instanceof JSCallExpression || contextRefQualifier instanceof JSIndexedPropertyAccessExpression || contextRefQualifier instanceof JSReferenceExpression || contextRefQualifier instanceof JSThisExpression || contextRefQualifier instanceof JSSuperExpression) {
            JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.NONGLOBAL;
            if (globalStatusHint == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(5);
            }
            return globalStatusHint;
        }
        boolean bl = withinWithStatement = PsiTreeUtil.getParentOfType((PsiElement)context, JSWithStatement.class) != null;
        if (context instanceof JSReferenceExpression && contextRefQualifier == null && !withinWithStatement && JSResolveUtil.getRealRefExprQualifier((JSReferenceExpression)context) == null) {
            JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.GLOBAL;
            if (globalStatusHint == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(6);
            }
            return globalStatusHint;
        }
        JSTypeInfo.GlobalStatusHint globalStatusHint = JSTypeInfo.GlobalStatusHint.UNKNOWN;
        if (globalStatusHint == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(7);
        }
        return globalStatusHint;
    }

    protected void updateTypeInfoFromThis(@Nullable JSNamespace ns) {
        if (ns != null && JSTypeUtils.isStrictType((JSType)ns)) {
            this.setAddOnlyCompleteMatches(true);
        } else {
            this.myTypeInfo.setForcedUnknownContext();
        }
    }

    public void addTypeHierarchy(@NotNull JSNamespace namespace) {
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(8);
        }
        this.myTypeInfo.addNamespace(namespace, true);
        this.addSupers(namespace);
    }

    public void addSupers(@NotNull JSNamespace namespace) {
        JSQualifiedName name;
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(9);
        }
        if ((name = namespace.getQualifiedName()) == null) {
            return;
        }
        JSContext staticOrInstance = namespace.getJSContext();
        final boolean isStrict = namespace.isSourceStrict();
        SmartList parentClasses = new SmartList();
        JSHierarchyProcessor processor = new JSHierarchyProcessor((List)parentClasses, staticOrInstance){
            final /* synthetic */ List val$parentClasses;
            final /* synthetic */ JSContext val$staticOrInstance;
            {
                this.val$parentClasses = list;
                this.val$staticOrInstance = jSContext;
            }

            @Override
            public boolean processNamespace(String serializedType, VirtualFile file2) {
                JSNamespace baseNs = JSBaseTypesIndex.deserializeHierarchyElement(serializedType, isStrict);
                if (baseNs == null || baseNs instanceof JSObjectType) {
                    return true;
                }
                if (baseNs.getQualifiedName() != null) {
                    this.val$parentClasses.add(baseNs);
                }
                return true;
            }

            @Override
            public boolean processClass(JSClass clazz) {
                String name = clazz.getQualifiedName();
                if ("Object".equals(name)) {
                    return true;
                }
                if (name != null) {
                    JSNamespace namespace = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromQualifiedName(name), this.val$staticOrInstance, null, true);
                    this.val$parentClasses.add(namespace);
                }
                return true;
            }

            @Override
            public boolean processObjectLiteral(JSObjectLiteralExpression objectLiteral) {
                return BaseJSSymbolProcessor.this.processObjectLiteral(objectLiteral);
            }
        };
        String typeString = JSBaseTypesIndex.getTextForProcessingHierarchy((JSType)namespace);
        JSTypeEvaluateManager.iterateTypeHierarchy(typeString, processor, this.myContext);
        for (JSNamespace parentClass : this.addGenericArgumentsForParentClasses(namespace, (List<JSNamespace>)parentClasses)) {
            this.myTypeInfo.addNamespace(parentClass, false);
        }
    }

    protected boolean processObjectLiteral(@NotNull JSObjectLiteralExpression objectLiteral) {
        if (objectLiteral == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(10);
        }
        return true;
    }

    @NotNull
    protected List<JSNamespace> addGenericArgumentsForParentClasses(@NotNull JSNamespace namespace, @NotNull List<JSNamespace> parentClasses) {
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(11);
        }
        if (parentClasses == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(12);
        }
        List<JSNamespace> list = parentClasses;
        if (list == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(13);
        }
        return list;
    }

    public abstract String getRequiredName();

    public boolean addOnlyCompleteMatches() {
        return this.myAddOnlyCompleteMatches;
    }

    public void setAddOnlyCompleteMatches(boolean addOnlyCompleteMatches) {
        this.setAddOnlyCompleteMatches(addOnlyCompleteMatches, false);
    }

    protected void forceSetAddOnlyCompleteMatches() {
        this.setAddOnlyCompleteMatches(true, true);
    }

    public void setAddOnlyCompleteMatches(boolean addOnlyCompleteMatches, boolean forced) {
        if (!forced && this.myAddOnlyCompleteMatchesSet) {
            return;
        }
        this.myAddOnlyCompleteMatchesSet = true;
        this.myAddOnlyCompleteMatches = addOnlyCompleteMatches;
    }

    protected final boolean isGlobalNS(@Nullable JSQualifiedName namespace, boolean includeGlobalObjects) {
        return BaseJSSymbolProcessor.isGlobalNS(namespace, this.typescript, includeGlobalObjects);
    }

    public static boolean isGlobalNS(@Nullable JSQualifiedName namespace, boolean isTypeScript, boolean includeGlobalObjects) {
        if (namespace == null) {
            return true;
        }
        if (isTypeScript) {
            return false;
        }
        String name = namespace.getName();
        return includeGlobalObjects && (GLOBAL_OBJECT_NAMES.contains(name) || GLOBAL_TYPE_NAMES.contains(name)) && namespace.getParent() == null;
    }

    @Contract(value="null -> true")
    public static boolean isGlobalNS(@Nullable JSQualifiedName namespace) {
        if (namespace == null) {
            return true;
        }
        String name = namespace.getName();
        if (name.isEmpty()) {
            return true;
        }
        return namespace.getParent() == null && (GLOBAL_OBJECT_NAMES.contains(name) || GLOBAL_TYPE_NAMES.contains(name));
    }

    public boolean acceptsFile(PsiFile file2) {
        this.myCurrentFile = file2.getViewProvider().getVirtualFile();
        boolean currentFileEcma = file2.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        return this.ecmal4 == currentFileEcma;
    }

    protected boolean isFromRelevantFileOrDirectory() {
        return Comparing.equal((Object)this.myTargetVirtualFile, (Object)this.myCurrentFile);
    }

    public boolean toCheckFileLevelAccess() {
        return this.myCheckFileLevelAccess;
    }

    protected final void initCheckFileLevelAccess() {
        if (!this.myTypeInfo.isNonGlobalStatusHint() && this.myTargetFile instanceof JSFile) {
            PsiElement resolve;
            JSExpression qualifier;
            this.myCheckFileLevelAccess = true;
            if (this.myContext instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)this.myContext).getQualifier()) instanceof JSReferenceExpression && ((resolve = ((JSReferenceExpression)qualifier).resolve()) == null || resolve instanceof JSParameter || !resolve.getContainingFile().getOriginalFile().isEquivalentTo((PsiElement)this.myTargetFile))) {
                this.myCheckFileLevelAccess = false;
            }
        }
    }

    @Nullable
    public String isAcceptable(@NotNull JSPsiElementBase element) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(14);
        }
        if (JSResolveUtil.isIllegalPlaceForPrivate((PsiElement)element, this.myContext)) {
            if (this.myContext instanceof JSReferenceExpression && ((JSReferenceExpression)this.myContext).getQualifier() instanceof JSThisExpression) {
                return "javascript.private.member.is.not.accessible.without.sharp.message";
            }
            return null;
        }
        if (!this.toCheckFileLevelAccess()) {
            return null;
        }
        JSNamespace jsNamespace = element.getJSNamespace();
        JSQualifiedName namespace = jsNamespace.getQualifiedName();
        boolean isCommonJSExported = CommonJSUtil.isExportNamespace(jsNamespace);
        if (namespace != null && !isCommonJSExported) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        if (element.getContext() instanceof JSDocComment && file2.equals(this.myContext.getContainingFile())) {
            return null;
        }
        if (!(file2 instanceof JSFile) || ((JSFile)file2).getModuleStatus() == JSFile.ModuleStatus.NONE || ((JSFile)file2).getModuleStatus() == JSFile.ModuleStatus.MAYBE_COMMONJS || !element.isNamespaceExplicitlyDeclared() && !element.isExportedWithDefault() || element instanceof TypeScriptGlobalModuleExportDeclaration) {
            return null;
        }
        if (this.myContext instanceof JSReferenceExpression && BaseJSSymbolProcessor.isExportedElement(element, isCommonJSExported)) {
            if (((JSReferenceExpression)this.myContext).getQualifier() == null) {
                return "javascript.element.need.to.be.imported";
            }
            return null;
        }
        if (jsNamespace.isLocal()) {
            return null;
        }
        return "javascript.element.need.to.be.exported";
    }

    private static boolean isExportedElement(@NotNull JSPsiElementBase element, boolean isCommonJSExported) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(15);
        }
        return (DialectDetector.isES6((PsiElement)element) || DialectDetector.isTypeScript((PsiElement)element)) && (element.isExported() || element.isExportedWithDefault()) || isCommonJSExported;
    }

    protected void tryAddFunctionType(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(16);
        }
        if (JSTypeUtils.hasFunctionType(type, false, this.myContext) || source instanceof TypeScriptClass && type instanceof JSNamedType && ((JSNamedType)type).isStaticOrInstance() == JSContext.STATIC) {
            this.myTypeInfo.addNamespace("Function", false, JSContext.INSTANCE, type.getSource().isStrict());
        }
    }

    protected boolean isStrictTypingPossible(@Nullable PsiElement source, @NotNull JSType type) {
        if (type == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(17);
        }
        return !(source != JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT || type instanceof JSObjectType || type instanceof JSAnyType || type instanceof TypeScriptIndexedAccessJSTypeImpl && !this.typescript || type instanceof JSRecordType && !((JSRecordType)type).hasMembers() && !this.typescript || type instanceof TypeScriptNeverJSTypeImpl || type instanceof JSGenericParameterImpl || type instanceof TypeScriptMappedJSTypeImpl && !((TypeScriptMappedJSTypeImpl)type).canBeSubstituted() || type instanceof JSGenericTypeImpl && !this.isStrictGenericType((JSGenericTypeImpl)type));
    }

    private boolean isStrictGenericType(@NotNull JSGenericTypeImpl type) {
        if (type == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(18);
        }
        if (this.typescript) {
            return true;
        }
        if (type.getType() instanceof JSObjectType) {
            return false;
        }
        for (JSType jsType : type.getArguments()) {
            if (!(jsType instanceof JSGenericParameterImpl)) continue;
            return false;
        }
        return true;
    }

    static boolean isValidType(String parameterType) {
        return parameterType != null && !parameterType.isEmpty();
    }

    protected void addPackageScope(@Nullable JSClass jsClass, @Nullable PsiElement expression) {
        String packageQualifier = JSResolveUtil.findPackageStatementQualifier(expression);
        if (packageQualifier != null) {
            this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(packageQualifier);
        } else if (jsClass != null) {
            int index;
            String qName = jsClass.getQualifiedName();
            if (qName != null && !qName.equals(jsClass.getName()) && (index = qName.lastIndexOf(46)) > 0) {
                this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(qName.substring(0, index));
            }
        } else {
            String s = ActionScriptResolveUtil.findPackageForMxml(expression);
            if (BaseJSSymbolProcessor.isValidType(s)) {
                this.myTypeInfo.buildIndexListFromQNameAndCorrectQName(s);
            }
        }
    }

    protected void addNamespace(@NotNull JSNamespace namespace, boolean isTopClassInHierarchy) {
        if (namespace == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(19);
        }
        this.myTypeInfo.addNamespace(namespace, isTopClassInHierarchy);
    }

    public static String addIndexListFromQName(@NotNull String type, List<String> list) {
        if (type == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(20);
        }
        QualifiedName qName = StringUtil.isQuotedString((String)type) ? QualifiedName.fromComponents((String[])new String[]{type}) : QualifiedName.fromDottedString((String)type);
        list.addAll(qName.getComponents());
        return type;
    }

    protected List<JSQualifiedName> getContextScopeNames() {
        return (List)this.myContextScopesCache.getValue();
    }

    @NotNull
    public PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    @NotNull
    public JSTypeInfo getTypeInfo() {
        JSTypeInfo jSTypeInfo = this.myTypeInfo;
        if (jSTypeInfo == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(22);
        }
        return jSTypeInfo;
    }

    @NotNull
    protected MatchType isAcceptableQualifiedItem(@NotNull JSPsiElementBase element, @NotNull Ref<Integer> typeHierarchyLevel, @NotNull Ref<Boolean> isAccessibleRef) {
        boolean isGlobalIncludeGlobalObjects;
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(23);
        }
        if (typeHierarchyLevel == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(24);
        }
        if (isAccessibleRef == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(25);
        }
        if (JSResolveUtil.isIllegalPlaceForPrivate((PsiElement)element, this.myContext)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(26);
            }
            return matchType;
        }
        JSQualifiedName namespace = this.getElementNamespace(element);
        boolean isElementLocal = element.getJSNamespace().isLocal();
        boolean isNamespaceExplicitlyDeclared = element.isNamespaceExplicitlyDeclared();
        boolean isGlobal = this.isGlobalNS(namespace, false);
        boolean bl = isGlobalIncludeGlobalObjects = isGlobal || this.isGlobalNS(namespace, true);
        if (isGlobal && BaseJSSymbolProcessor.isPrivate(element) && !this.isFromRelevantFileOrDirectory()) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(27);
            }
            return matchType;
        }
        if (isGlobalIncludeGlobalObjects && BaseJSSymbolProcessor.isPrivate(element) && !this.isFromRelevantFileOrDirectory()) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(28);
            }
            return matchType;
        }
        if (this.myTypeInfo.isNonGlobalStatusHint() && isNamespaceExplicitlyDeclared && (isGlobal || isGlobalIncludeGlobalObjects && !(this instanceof WalkUpResolveProcessor) || (element instanceof JSVariable || element instanceof JSFunction && !(element instanceof JSFunctionExpression)) && this.isGlobalNS(namespace, true))) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(29);
            }
            return matchType;
        }
        if (this.myTypeInfo.isGlobalStatusHint() && isNamespaceExplicitlyDeclared && (isElementLocal || !BaseJSSymbolProcessor.isGlobalNS(namespace, this.typescript, true))) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(30);
            }
            return matchType;
        }
        Ref contextLevelRef = Ref.create(null);
        MatchType result2 = this.iterateContextLevels(element, (Ref<JSContextLevel>)contextLevelRef, namespace);
        JSContextLevel contextLevel = (JSContextLevel)contextLevelRef.get();
        if (contextLevel != null) {
            typeHierarchyLevel.set((Object)contextLevel.myRelativeLevel);
            this.updateAccessible(element, isAccessibleRef, contextLevel);
        }
        if (result2 != null) {
            MatchType matchType = result2;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(31);
            }
            return matchType;
        }
        if (isNamespaceExplicitlyDeclared && isElementLocal && namespace == null) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(32);
            }
            return matchType;
        }
        if (this.myTypeInfo.isGlobalStatusHint() && (JSPsiImplUtils.isClassMember((PsiElement)element) || element instanceof JSProperty)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(33);
            }
            return matchType;
        }
        if (isNamespaceExplicitlyDeclared && isGlobalIncludeGlobalObjects && this.myTypeInfo.isGlobalStatusHint()) {
            MatchType matchType = MatchType.COMPLETE;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(34);
            }
            return matchType;
        }
        if (namespace != null && !this.typescript && BaseJSSymbolProcessor.isTSExcludedMap(namespace)) {
            MatchType matchType = MatchType.NOMATCH;
            if (matchType == null) {
                BaseJSSymbolProcessor.$$$reportNull$$$0(35);
            }
            return matchType;
        }
        MatchType matchType = MatchType.PARTIAL;
        if (matchType == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(36);
        }
        return matchType;
    }

    private void updateAccessible(@NotNull JSPsiElementBase element, @NotNull Ref<Boolean> isAccessibleRef, @NotNull JSContextLevel contextLevel) {
        JSAttributeList.AccessType accessType;
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(37);
        }
        if (isAccessibleRef == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(38);
        }
        if (contextLevel == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(39);
        }
        if ((accessType = this.getElementAccessType(element)) == JSAttributeList.AccessType.PRIVATE || accessType == JSAttributeList.AccessType.PROTECTED) {
            List<JSQualifiedName> scopeNames = this.getContextScopeNames();
            boolean withinScope = false;
            for (JSContextLevel level : this.myTypeInfo.myContextLevels) {
                if (level.myRelativeLevel == 0) {
                    withinScope = false;
                }
                if (!withinScope && scopeNames.contains(level.myNamespace.getQualifiedName())) {
                    withinScope = true;
                }
                if (level != contextLevel) continue;
                PsiFile file1 = element.getContainingFile();
                PsiFile file2 = this.myContext.getContainingFile();
                if (file1 == null || file2 == null) break;
                boolean isAccessible = JSVisibilityUtil.isAccessible(element, accessType, contextLevel.myRelativeLevel == 0, withinScope, file1.isEquivalentTo((PsiElement)file2));
                isAccessibleRef.set((Object)isAccessible);
                break;
            }
        }
    }

    @NotNull
    protected JSAttributeList.AccessType getElementAccessType(@NotNull JSPsiElementBase element) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(40);
        }
        JSAttributeList.AccessType accessType = element.getAccessType();
        if (accessType == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(41);
        }
        return accessType;
    }

    private static boolean isTSExcludedMap(JSQualifiedName namespace) {
        String qualifiedName = namespace.getQualifiedName();
        for (String map : TS_EXCLUDED) {
            if (!qualifiedName.equals(map)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private MatchType iterateContextLevels(@NotNull JSPsiElementBase element, @NotNull Ref<JSContextLevel> contextLevelRef, JSQualifiedName namespace) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(42);
        }
        if (contextLevelRef == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(43);
        }
        JSContext elementStaticOrInstance = element.getJSContext();
        boolean jsContextMismatched = false;
        for (JSContextLevel contextLevel : this.myTypeInfo.myContextLevels) {
            JSQualifiedName currentNs;
            if (!contextLevel.isElementInScope((PsiElement)element, this.myTargetFile)) continue;
            JSQualifiedName currentContextNamespace = contextLevel.myNamespace.getQualifiedName();
            if (currentContextNamespace == null && contextLevel.myNamespace.isSourceStrict() && element instanceof JSProperty && namespace == null && !element.getJSNamespace().isSourceStrict()) continue;
            for (currentNs = namespace; currentContextNamespace != null && currentNs != null && currentContextNamespace.getName().equals(currentNs.getName()); currentNs = currentNs.getParent(), currentContextNamespace = currentContextNamespace.getParent()) {
            }
            if (currentContextNamespace != null || currentNs != null) continue;
            if (!contextLevel.myNamespace.getJSContext().isCompatibleWith(elementStaticOrInstance)) {
                jsContextMismatched = true;
                continue;
            }
            if (jsContextMismatched && contextLevel.myNamespace.getJSContext() == JSContext.UNKNOWN) continue;
            contextLevelRef.set((Object)contextLevel);
            return contextLevel.myRelativeLevel == 0 && elementStaticOrInstance != JSContext.UNKNOWN && contextLevel.myNamespace.getJSContext() != JSContext.UNKNOWN ? MatchType.COMPLETE_WITH_CONTEXT : MatchType.COMPLETE;
        }
        return jsContextMismatched ? MatchType.NOMATCH : null;
    }

    private JSQualifiedName getElementNamespace(@NotNull JSPsiElementBase element) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(44);
        }
        PsiElement parent = element.getContext();
        return this.ecmal4 && parent instanceof JSClass ? JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)((JSClass)parent)) : element.getJSNamespace().getQualifiedName();
    }

    private static boolean isPrivate(@NotNull JSPsiElementBase element) {
        if (element == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(45);
        }
        return element.getAccessType() == JSAttributeList.AccessType.PRIVATE;
    }

    @Contract(value="null -> null")
    public static JSExpression getOriginalQualifier(@Nullable JSExpression rawqualifier) {
        if (rawqualifier == null) {
            return null;
        }
        JSExpression element = (JSExpression)CompletionUtilCoreImpl.getOriginalElement((PsiElement)rawqualifier);
        return element != null ? element : rawqualifier;
    }

    protected static boolean isCompleteOrWithContextMatchType(@Nullable MatchType matchType) {
        return matchType == MatchType.COMPLETE_WITH_CONTEXT || matchType == MatchType.COMPLETE;
    }

    protected void addResolveResultTags(@NotNull EnumSet<JSTaggedResolveResult.ResolveResultTag> tags, @Nullable PsiElement element) {
        JSType type;
        if (tags == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(46);
        }
        if (element instanceof JSElementBase && this.isJavaScriptCoreLibraryElement(element)) {
            if (((JSElementBase)element).getNamespace() == null) {
                tags.add(JSTaggedResolveResult.ResolveResultTag.HAS_JSDOC);
            }
            return;
        }
        if (element instanceof JSElementBase && ((JSElementBase)element).hasJSDoc()) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.HAS_JSDOC);
        }
        if (element instanceof JSTypeOwner && (type = ((JSTypeOwner)element).getType()) != null && type.getSource().isExplicitlyDeclared() && DialectDetector.isJavaScript(element)) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.HAS_JSDOC);
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).getTypeString() != null) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.HAS_JSDOC);
        }
        if (element instanceof JSImplicitElement && ((JSImplicitElement)element).hasMinorImportance() || element != null && BaseJSSymbolProcessor.isTooBigForHighlighting(element.getContainingFile().getViewProvider().getVirtualFile()) || BaseJSSymbolProcessor.isFromMinifiedFile(element)) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.MINOR_IMPORTANCE);
        }
        if (element instanceof JSDefinitionExpression && !((JSDefinitionExpression)element).isDeclaration()) {
            tags.add(JSTaggedResolveResult.ResolveResultTag.IS_ASSIGNMENT);
        }
    }

    public static boolean isTooBigForHighlighting(@NotNull VirtualFile file2) {
        if (file2 == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(47);
        }
        return !(file2 instanceof LightVirtualFile) && file2.getLength() > (long)PersistentFSConstants.getMaxIntellisenseFileSize();
    }

    private static boolean isFromMinifiedFile(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        PsiFile file2 = element.getContainingFile();
        return file2 instanceof JSFile && ((JSFile)file2).isMinified();
    }

    protected void addReferenceNamespace(@NotNull JSReferenceExpression qualifier, boolean isTopClassInHierarchy) {
        JSNamespace ns;
        if (qualifier == null) {
            BaseJSSymbolProcessor.$$$reportNull$$$0(48);
        }
        if ((ns = JSSymbolUtil.createNamespaceFromReferenceExpression(qualifier, JSContext.STATIC, true)) != null) {
            this.myTypeInfo.addNamespace(ns, isTopClassInHierarchy);
        }
    }

    protected boolean isJavaScriptCoreLibraryElement(@Nullable PsiElement sourceElement) {
        return !this.typescript && sourceElement != JSTypeEvaluator.EXPLICIT_TYPE_MARKER_ELEMENT && JSCorePredefinedLibrariesProvider.isLibraryElement(sourceElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalStatusHint";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectLiteral";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClasses";
                break;
            }
            case 14: 
            case 15: 
            case 23: 
            case 37: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeHierarchyLevel";
                break;
            }
            case 25: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isAccessibleRef";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLevel";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextLevelRef";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "initGlobalStatusHint";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "addGenericArgumentsForParentClasses";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeInfo";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "isAcceptableQualifiedItem";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementAccessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNamedGlobalType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTypeInfo";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 41: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addTypeHierarchy";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addSupers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processObjectLiteral";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addGenericArgumentsForParentClasses";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isExportedElement";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryAddFunctionType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypingPossible";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isStrictGenericType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addNamespace";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addIndexListFromQName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableQualifiedItem";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "updateAccessible";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getElementAccessType";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "iterateContextLevels";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getElementNamespace";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isPrivate";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addResolveResultTags";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isTooBigForHighlighting";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addReferenceNamespace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public abstract class JSTypeProcessorBase
    implements JSTypeProcessor {
        private boolean hasUnknownElement;

        protected void evaluateQualifier(@NotNull JSExpression qualifier, @NotNull JSExpression originalQualifier) {
            JSNamespace namespace;
            if (qualifier == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(0);
            }
            if (originalQualifier == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(1);
            }
            JSTypeEvaluator.evaluateTypes(originalQualifier, this);
            if ((this.hasUnknownElement || !BaseJSSymbolProcessor.this.myAddOnlyCompleteMatches || BaseJSSymbolProcessor.this.myTypeInfo.isEmpty()) && (namespace = JSSymbolUtil.evaluateNamespaceLocally(qualifier)) != null) {
                BaseJSSymbolProcessor.this.myTypeInfo.addNamespace(namespace, false);
            }
        }

        @Override
        public void processResolvedElement(@NotNull PsiElement element, @NotNull JSEvaluationResultContext evaluateContext) {
            if (element == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(2);
            }
            if (evaluateContext == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(3);
            }
            if (!(!(element instanceof PsiFile) || element instanceof JSFile && ((JSFile)element).referencesImportInDefaultExport())) {
                BaseJSSymbolProcessor.this.setAddOnlyCompleteMatches(true);
            }
        }

        private boolean isTopLevelJSCoreLibraryElement(@Nullable PsiElement sourceElement) {
            if (!(BaseJSSymbolProcessor.this.myContext instanceof JSReferenceExpression)) {
                return false;
            }
            JSExpression qualifier = ((JSReferenceExpression)BaseJSSymbolProcessor.this.myContext).getQualifier();
            return qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() == null && BaseJSSymbolProcessor.this.isJavaScriptCoreLibraryElement(sourceElement);
        }

        @Override
        public void setUnknownElement(@NotNull PsiElement element) {
            if (element == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(4);
            }
            this.hasUnknownElement = true;
        }

        protected void addFullQualifierAsNamespace(@Nullable PsiElement qualifier, @NotNull JSType type) {
            if (type == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(5);
            }
            if (qualifier instanceof JSExpression) {
                JSNamespace namespace;
                PsiElement element = type.getSource().getSourceElement();
                if (this.isStrictTypeScriptInJSContext(type) && this.isTopLevelJSCoreLibraryElement(element) && (namespace = JSSymbolUtil.evaluateReferencedNamespace((JSExpression)qualifier, true)) != null) {
                    BaseJSSymbolProcessor.this.myTypeInfo.addNamespace(namespace, true);
                }
            }
        }

        protected boolean isStrictTypeScriptInJSContext(@NotNull JSType type) {
            if (type == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(6);
            }
            return !BaseJSSymbolProcessor.this.typescript && type.isTypeScript() && type.isSourceStrict();
        }

        protected final void processCandidate(@NotNull JSType type, @NotNull JSEvaluateContext context, @Nullable PsiElement source) {
            if (type == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(7);
            }
            if (context == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(8);
            }
            if (context.ensureProcessed(type, context)) {
                return;
            }
            this.updateResolveStrictness(type, source);
            if (type instanceof JSRecordType) {
                JSExpression qualifier;
                JSTypeSource typeSource = type.getSource();
                PsiElement sourceElement = typeSource.getSourceElement();
                if (sourceElement instanceof JSDocComment) {
                    sourceElement = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)sourceElement);
                }
                if (sourceElement instanceof JSQualifiedNamedElement) {
                    JSQualifiedNameImpl qName = JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)((JSQualifiedNamedElement)sourceElement));
                    BaseJSSymbolProcessor.this.myTypeInfo.addType(JSNamedTypeFactory.createNamespace(qName, JSContext.STATIC, sourceElement, false), true);
                }
                BaseJSSymbolProcessor.this.myTypeInfo.addBaseObjectType();
                BaseJSSymbolProcessor.this.myTypeInfo.setTypeWasProcessed();
                if (BaseJSSymbolProcessor.this.myContext instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)BaseJSSymbolProcessor.this.myContext).getQualifier()) instanceof JSReferenceExpression && this.isTopLevelJSCoreLibraryElement(typeSource.getSourceElement())) {
                    BaseJSSymbolProcessor.this.addReferenceNamespace((JSReferenceExpression)qualifier, true);
                }
            } else if (type instanceof JSExtendingTypeImpl) {
                this.process(((JSExtendingTypeImpl)type).getType(), context, source);
                JSNamespace mixedType = JSTypeUtils.getNamespaceMatchingType(((JSExtendingTypeImpl)type).getParentType(), false);
                if (mixedType != null) {
                    BaseJSSymbolProcessor.this.myTypeInfo.addNamespace(mixedType, false);
                    BaseJSSymbolProcessor.this.addSupers(mixedType);
                }
            }
            this.applyTypeToState(type, source);
            if (type instanceof JSAnyType || type instanceof JSGenericParameterImpl) {
                return;
            }
            JSNamespace namespace = JSTypeUtils.getNamespaceMatchingType(type, this.isMakeAddedNamespaceStrict());
            if (namespace == null) {
                return;
            }
            BaseJSSymbolProcessor.this.addTypeHierarchy(namespace);
            BaseJSSymbolProcessor.this.tryAddFunctionType(type, source);
        }

        protected boolean isMakeAddedNamespaceStrict() {
            return false;
        }

        protected void applyTypeToState(JSType type, PsiElement source) {
            if (type instanceof JSAnyType) {
                this.setUnknownElement(BaseJSSymbolProcessor.this.myContext);
            }
        }

        private void updateResolveStrictness(@NotNull JSType type, @Nullable PsiElement source) {
            if (type == null) {
                JSTypeProcessorBase.$$$reportNull$$$0(9);
            }
            JSTypeSource typeSource = type.getSource();
            if (BaseJSSymbolProcessor.this.typescript && typeSource.isStrict() || BaseJSSymbolProcessor.this.isStrictTypingPossible(source, type) && (BaseJSSymbolProcessor.this.typescript || !this.isTopLevelJSCoreLibraryElement(typeSource.getSourceElement()))) {
                BaseJSSymbolProcessor.this.setAddOnlyCompleteMatches(true);
            } else if (typeSource.isTypeScript()) {
                this.allowPartialResults();
            }
        }

        protected void allowPartialResults() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalQualifier";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluateContext";
                    break;
                }
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/BaseJSSymbolProcessor$JSTypeProcessorBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluateQualifier";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processResolvedElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setUnknownElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addFullQualifierAsNamespace";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isStrictTypeScriptInJSContext";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processCandidate";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateResolveStrictness";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum MatchType {
        COMPLETE_WITH_CONTEXT,
        COMPLETE,
        PARTIAL,
        NOMATCH;

    }
}

