/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationResultContext;
import com.intellij.lang.javascript.psi.resolve.context.JSApplyContextElement;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEvaluateContext
implements JSEvaluationResultContext {
    @Nullable
    public final PsiFile targetFile;
    private PsiElement source;
    private JSReferenceExpression myProcessedExpression;
    private final Deque<JSApplyContextElement> myJSElementsToApply;
    private boolean myTypeIsGuessed;
    private boolean myAstAccessAllowed = true;
    private final Set<Pair<JSResolvedTypeId, Integer>> visitedTypes = new THashSet();

    public JSEvaluateContext(@Nullable PsiFile targetFile) {
        this.targetFile = targetFile;
        this.myJSElementsToApply = new ArrayDeque<JSApplyContextElement>(5);
    }

    @NotNull
    public static JSEvaluateContext fromEvaluationResultContext(@NotNull JSEvaluationResultContext context) {
        if (context == null) {
            JSEvaluateContext.$$$reportNull$$$0(0);
        }
        if (context instanceof JSEvaluateContext) {
            JSEvaluateContext jSEvaluateContext = (JSEvaluateContext)context;
            if (jSEvaluateContext == null) {
                JSEvaluateContext.$$$reportNull$$$0(1);
            }
            return jSEvaluateContext;
        }
        JSEvaluateContext result2 = new JSEvaluateContext(null);
        for (JSApplyContextElement element : context.getJSElementsToApply()) {
            result2.pushJSElementToApply(element);
        }
        result2.setTypeIsGuessed(context.isTypeGuessed());
        JSEvaluateContext jSEvaluateContext = result2;
        if (jSEvaluateContext == null) {
            JSEvaluateContext.$$$reportNull$$$0(2);
        }
        return jSEvaluateContext;
    }

    @Nullable
    public JSReferenceExpression getProcessedExpression() {
        return this.myProcessedExpression;
    }

    public void setProcessedExpression(@Nullable JSReferenceExpression processedExpression) {
        this.myProcessedExpression = processedExpression;
    }

    public PsiElement getSource() {
        return this.source;
    }

    public void setSource(PsiElement source) {
        this.source = source;
    }

    @NotNull
    public JSApplyContextElement popJSElementToApply() {
        JSApplyContextElement jSApplyContextElement = this.myJSElementsToApply.pop();
        if (jSApplyContextElement == null) {
            JSEvaluateContext.$$$reportNull$$$0(3);
        }
        return jSApplyContextElement;
    }

    @Override
    @Nullable
    public JSApplyContextElement peekJSElementToApply() {
        return this.myJSElementsToApply.peek();
    }

    public void pushJSElementToApply(@NotNull JSApplyContextElement elementToApply) {
        if (elementToApply == null) {
            JSEvaluateContext.$$$reportNull$$$0(4);
        }
        this.myJSElementsToApply.push(elementToApply);
    }

    public void processWithJSElementToApply(@NotNull JSApplyContextElement elementToApply, @NotNull Runnable runnable) {
        if (elementToApply == null) {
            JSEvaluateContext.$$$reportNull$$$0(5);
        }
        if (runnable == null) {
            JSEvaluateContext.$$$reportNull$$$0(6);
        }
        this.myJSElementsToApply.push(elementToApply);
        runnable.run();
        this.myJSElementsToApply.pop();
    }

    public static void processWithJSElementToApply(@NotNull JSApplyContextElement elementToApply, @NotNull JSEvaluationResultContext evaluateContext, @NotNull Consumer<JSEvaluationResultContext> consumer) {
        if (elementToApply == null) {
            JSEvaluateContext.$$$reportNull$$$0(7);
        }
        if (evaluateContext == null) {
            JSEvaluateContext.$$$reportNull$$$0(8);
        }
        if (consumer == null) {
            JSEvaluateContext.$$$reportNull$$$0(9);
        }
        JSEvaluateContext context = JSEvaluateContext.fromEvaluationResultContext(evaluateContext);
        context.pushJSElementToApply(elementToApply);
        consumer.consume((Object)context);
        context.popJSElementToApply();
    }

    public void processWithoutTopJSElementToApply(@NotNull Runnable runnable) {
        if (runnable == null) {
            JSEvaluateContext.$$$reportNull$$$0(10);
        }
        JSApplyContextElement pop = this.myJSElementsToApply.pop();
        try {
            runnable.run();
        }
        finally {
            this.myJSElementsToApply.push(pop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processWithoutTopJSElementToApply(@NotNull Processor<JSApplyContextElement> processor) {
        if (processor == null) {
            JSEvaluateContext.$$$reportNull$$$0(11);
        }
        JSApplyContextElement pop = this.myJSElementsToApply.pop();
        try {
            boolean bl = processor.process((Object)pop);
            return bl;
        }
        finally {
            this.myJSElementsToApply.push(pop);
        }
    }

    @Override
    public boolean isJSElementsToApplyEmpty() {
        return this.myJSElementsToApply.isEmpty();
    }

    @Override
    public boolean isTypeGuessed() {
        return this.myTypeIsGuessed;
    }

    public void setTypeIsGuessed(boolean typeIsGuessed) {
        this.myTypeIsGuessed = typeIsGuessed;
    }

    @NotNull
    public Deque<JSApplyContextElement> getJSElementsToApply() {
        Deque<JSApplyContextElement> deque = this.myJSElementsToApply;
        if (deque == null) {
            JSEvaluateContext.$$$reportNull$$$0(12);
        }
        return deque;
    }

    public void withCombinedContext(@NotNull JSEvaluationResultContext context, @NotNull Runnable runnable) {
        if (context == null) {
            JSEvaluateContext.$$$reportNull$$$0(13);
        }
        if (runnable == null) {
            JSEvaluateContext.$$$reportNull$$$0(14);
        }
        int sizeBefore = this.myJSElementsToApply.size();
        boolean typeIsGuessedBefore = this.myTypeIsGuessed;
        for (JSApplyContextElement element : context.getJSElementsToApply()) {
            this.pushJSElementToApply(element);
        }
        this.setTypeIsGuessed(this.myTypeIsGuessed || context.isTypeGuessed());
        runnable.run();
        while (this.myJSElementsToApply.size() > sizeBefore) {
            this.popJSElementToApply();
        }
        this.setTypeIsGuessed(typeIsGuessedBefore);
    }

    @Override
    public boolean isEquivalentTo(JSEvaluationResultContext other) {
        return JSEvaluationResultContext.JSEvaluationResultContextImpl.areEvaluationContextsEquivalent(this, other);
    }

    public boolean ensureProcessed(@NotNull JSType type, @NotNull JSEvaluationResultContext evaluationContext) {
        if (type == null) {
            JSEvaluateContext.$$$reportNull$$$0(15);
        }
        if (evaluationContext == null) {
            JSEvaluateContext.$$$reportNull$$$0(16);
        }
        PsiElement localScope = type instanceof JSNamespace ? ((JSNamespace)type).getLocalScope() : null;
        int localScopeHashCode = localScope != null ? localScope.hashCode() : 0;
        return !this.visitedTypes.add((Pair<JSResolvedTypeId, Integer>)Pair.create((Object)type.getResolvedTypeId(), (Object)localScopeHashCode));
    }

    public boolean isAstAccessAllowed() {
        return this.myAstAccessAllowed;
    }

    public void withAstAccessForbidden(@NotNull Runnable runnable) {
        if (runnable == null) {
            JSEvaluateContext.$$$reportNull$$$0(17);
        }
        boolean wasAllowed = this.myAstAccessAllowed;
        this.myAstAccessAllowed = false;
        runnable.run();
        this.myAstAccessAllowed = wasAllowed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToApply";
                break;
            }
            case 6: 
            case 10: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluateContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fromEvaluationResultContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "popJSElementToApply";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSElementsToApply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromEvaluationResultContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "pushJSElementToApply";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processWithJSElementToApply";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processWithoutTopJSElementToApply";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "withCombinedContext";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "ensureProcessed";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "withAstAccessForbidden";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum JSEvaluationPlace {
        PARAMETER_TYPE,
        CONTEXTUAL_TYPE,
        TYPE_GUARD,
        TYPEOF_TYPE,
        CLASS_REFERENCE_LIST,
        TS_TYPEOF_TYPE,
        EXTERNAL_MODULE_FROM_TYPE,
        EXTERNAL_MODULE,
        EXPORTED_ELEMENT,
        CALL_FUNCTION,
        DEFAULT,
        QUALIFIER,
        FORCE_EVALUATE_TYPE,
        REFERENCE_EXPRESSION,
        RESOLVE_OVERLOADS;

    }
}

