/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSGenericParameterApplierImpl
extends JSGenericParameterImpl {
    private final boolean myWidenLiterals;
    @NotNull
    private final JSGenericParameterImpl myOriginalType;

    public JSGenericParameterApplierImpl(@NotNull JSGenericParameterImpl type, boolean widenLiterals) {
        if (type == null) {
            JSGenericParameterApplierImpl.$$$reportNull$$$0(0);
        }
        super(type.getGenericId(), type.getSource());
        this.myOriginalType = type;
        JSType constraintType = type instanceof TypeScriptGenericParameterImpl ? type.getConstraintType() : null;
        this.myWidenLiterals = widenLiterals && !JSTypeUtils.containsLiteralOrEnumOrPrimitiveTypes(constraintType);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        Boolean suspendEvaluation;
        if (elementType == null) {
            JSGenericParameterApplierImpl.$$$reportNull$$$0(1);
        }
        if (processingContext == null) {
            JSGenericParameterApplierImpl.$$$reportNull$$$0(2);
        }
        if ((suspendEvaluation = (Boolean)processingContext.get(JSGenericTypesEvaluator.ourSuspendGenericEvaluation)) == Boolean.TRUE) {
            return true;
        }
        MultiMap genericArgumentsMap = (MultiMap)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
        if (genericArgumentsMap != null && !super.isEquivalentToImpl(elementType, processingContext, true)) {
            genericArgumentsMap.putValue((Object)this.getGenericId(), (Object)(this.myWidenLiterals ? JSTypeUtils.expandEnumLiteralIfNeeded(JSTypeUtils.widenLiteralTypes(elementType)) : elementType));
            if (this.isContravariant()) {
                processingContext.put(JSGenericTypesEvaluator.ourHadContravariantGenerics, (Object)true);
            }
        }
        return true;
    }

    @Override
    @Nullable
    public JSType getConstraintType() {
        return this.myOriginalType.getConstraintType();
    }

    private boolean isContravariant() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (!(sourceElement instanceof TypeScriptType)) {
            return true;
        }
        return PsiTreeUtil.getContextOfType((PsiElement)sourceElement, (Class[])new Class[]{TypeScriptFunctionType.class}) != null;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        boolean areEqual;
        if (type == null) {
            JSGenericParameterApplierImpl.$$$reportNull$$$0(3);
        }
        if (!allowResolve) {
            return false;
        }
        if (type instanceof JSGenericParameterImpl && (areEqual = super.isEquivalentToImpl(type, processingContext, true))) {
            return true;
        }
        if (processingContext == null) {
            return false;
        }
        Boolean suspendEvaluation = (Boolean)processingContext.get(JSGenericTypesEvaluator.ourSuspendGenericEvaluation);
        if (suspendEvaluation == Boolean.TRUE) {
            return false;
        }
        MultiMap genericArgumentsMap = (MultiMap)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
        if (genericArgumentsMap != null) {
            genericArgumentsMap.putValue((Object)this.myOriginalType.getGenericId(), (Object)type);
            if (this.isContravariant()) {
                processingContext.put(JSGenericTypesEvaluator.ourHadContravariantGenerics, (Object)true);
            }
        }
        return false;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return ((Object)((Object)this)).hashCode();
    }

    @Override
    protected boolean resolvedEquals(@Nullable JSType rType) {
        return rType == this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericParameterApplierImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEquivalentToImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

