/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSGenericParameterApplierImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericTypesEvaluator {
    public static final Key<MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType>> ourGenericArgumentsMapKey = Key.create((String)"generic.arguments");
    public static final Key<Boolean> ourSuspendGenericEvaluation = Key.create((String)"generic.suspend.evaluation");
    public static final Key<Boolean> ourHadContravariantGenerics = Key.create((String)"generic.had.contravariant");
    public static final JSGenericTypesEvaluator NO_OP = new JSGenericTypesEvaluator(){

        @Override
        @Nullable
        public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @NotNull GenericEvaluationContext context) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            return type;
        }

        @Override
        @NotNull
        public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, @NotNull JSExpression methodExpression) {
            if (type == null) {
                1.$$$reportNull$$$0(1);
            }
            if (qualifier == null) {
                1.$$$reportNull$$$0(2);
            }
            if (methodExpression == null) {
                1.$$$reportNull$$$0(3);
            }
            JSType jSType = type;
            if (jSType == null) {
                1.$$$reportNull$$$0(4);
            }
            return jSType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodExpression";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator$1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "evaluateGenericsFromQualifier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluateGenerics";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluateGenericsFromQualifier";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    protected JSGenericTypesEvaluator() {
    }

    public final JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, new GenericEvaluationContext());
    }

    public final JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, int paramToSkip) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, new GenericEvaluationContext(null, paramToSkip));
    }

    @Nullable
    @Contract(value="!null, _, _, _ -> !null")
    public final JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @Nullable GenericErrorReporter reporter) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, new GenericEvaluationContext(reporter, -1));
    }

    @Nullable
    @Contract(value="!null, _, _, _ -> !null")
    public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @NotNull GenericEvaluationContext context) {
        JSExpression qualifier;
        JSFunctionItem functionItem;
        if (context == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(0);
        }
        if (!this.canHaveGenericParameters(type)) {
            return type;
        }
        if (resolvedFunction != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolvedFunction, (PsiElement)methodExpression, false)) != null) {
            resolvedFunction = functionItem;
        }
        Function.Mono<JSType> qualifierEvaluator = Functions.id();
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            qualifierEvaluator = this.getQualifierGenericsEvaluator(type, qualifier, methodExpression, resolvedFunction);
        }
        type = (JSType)qualifierEvaluator.fun((Object)type);
        if (methodExpression != null && resolvedFunction != null) {
            if (context.inferCallGenerics) {
                PsiElement parent = methodExpression.getParent();
                if (parent instanceof JSCallExpression) {
                    JSTypeSubstitutor substitutor = this.inferGenericTypesForCall(resolvedFunction, (JSCallExpression)parent, context.reporter, context.paramToSkip);
                    type = JSTypeUtils.applyGenericArguments(type, substitutor, context.reporter);
                }
                if (parent instanceof ES6TaggedTemplateExpression) {
                    ES6TaggedTemplateExpression taggedTemplate = (ES6TaggedTemplateExpression)parent;
                    JSTypeSubstitutor substitutor = this.inferGenericTypesForTaggedTemplateCall(resolvedFunction, taggedTemplate, context.reporter, context.paramToSkip);
                    type = JSTypeUtils.applyGenericArguments(type, substitutor, context.reporter);
                }
            } else {
                type = JSTypeUtils.applyGenericArguments(type, JSGenericTypesEvaluator.getSubstitutorForDefaultParameters(resolvedFunction), context.reporter);
            }
            type = (JSType)qualifierEvaluator.fun((Object)type);
        }
        return type;
    }

    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForExplicitThisParameterType(@NotNull Getter<? extends JSType> qualifierType, @Nullable PsiElement resolvedFunction) {
        if (qualifierType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        if (!(resolvedFunction instanceof TypeScriptFunction)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(2);
            }
            return jSTypeSubstitutor;
        }
        JSType definedType = ((TypeScriptFunction)resolvedFunction).getExplicitThisType();
        if (JSTypeUtils.hasGenericParameter(definedType)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluator.findAndIntersectGenericsTypeValues((JSType)qualifierType.get(), definedType, resolvedFunction);
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(3);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(4);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected Function.Mono<JSType> getQualifierGenericsEvaluator(@NotNull JSType startType, @NotNull JSExpression qualifier, @NotNull JSExpression methodExpression, @Nullable PsiElement resolvedFunction) {
        if (startType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(5);
        }
        if (qualifier == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(6);
        }
        if (methodExpression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(7);
        }
        Function.Mono mono = type -> {
            if (qualifier == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(95);
            }
            return JSGenericTypesEvaluator.evaluateJSGenericsFromQualifier(type, qualifier);
        };
        if (mono == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(8);
        }
        return mono;
    }

    @NotNull
    protected static JSTypeSubstitutor getDefaultTypeSubstitutor(@NotNull PsiElement typeParametersOwner, @NotNull JSCallExpression expression) {
        if (typeParametersOwner == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(9);
        }
        if (expression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(10);
        }
        if (JSTypeUtils.hasTypeArguments(expression)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(11);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluator.getSubstitutorForDefaultParameters(typeParametersOwner);
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(12);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static JSTypeSubstitutor getSubstitutorForDefaultParameters(@NotNull PsiElement typeParametersOwner) {
        if (typeParametersOwner == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(13);
        }
        if (!(typeParametersOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(14);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(typeParametersOwner);
        if (parameters.length == 0) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(15);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        for (TypeScriptTypeParameter parameter : parameters) {
            String name = parameter.getName();
            if (name == null) continue;
            TypeScriptTypeParser.TypeParameterGenericId id = TypeScriptTypeParser.getTypeParameterId(parameter);
            JSType type = JSGenericTypesEvaluator.getTypeParameterDefaultType(parameter);
            substitutor.put((JSTypeSubstitutor.JSTypeGenericId)id, type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(16);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected static Set<String> getGenericNames(@Nullable PsiElement resolvedFunction) {
        if (resolvedFunction instanceof TypeScriptTypeParameterListOwner) {
            TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(resolvedFunction);
            Set<String> set = Arrays.stream(parameters).map(p -> p.getName()).collect(Collectors.toSet());
            if (set == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(17);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(18);
        }
        return set;
    }

    protected static void addGenericDependencyFromType(final @NotNull Set<String> names, final @NotNull MultiMap<Integer, String> results, final int ownName, @Nullable JSType type) {
        if (names == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(19);
        }
        if (results == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(20);
        }
        if (type == null) {
            return;
        }
        type.accept(new JSRecursiveTypeVisitor(){

            public void visitJSType(@NotNull JSType type) {
                if (type == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (type instanceof JSGenericParameterImpl && names.contains(((JSGenericParameterImpl)type).getName())) {
                    results.putValue((Object)ownName, (Object)((JSGenericParameterImpl)type).getName());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator$2", "visitJSType"));
            }
        });
    }

    @NotNull
    protected static Integer[] reorderByDependencies(int argumentsLength, @NotNull List<JSType> parameterTypes, @NotNull Set<String> names) {
        if (parameterTypes == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(21);
        }
        if (names == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(22);
        }
        Integer[] result2 = new Integer[argumentsLength];
        MultiMap results = new MultiMap();
        for (int i = 0; i < argumentsLength; ++i) {
            result2[i] = i;
            if (i >= parameterTypes.size()) continue;
            JSGenericTypesEvaluator.addGenericDependencyFromType(names, (MultiMap<Integer, String>)results, i, parameterTypes.get(i));
        }
        Arrays.sort(result2, (r1, r2) -> {
            Collection all1 = results.get(r1);
            Collection all2 = results.get(r2);
            return all1.stream().anyMatch(i -> all2.contains(i)) ? -1 : 1;
        });
        if (result2 == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(23);
        }
        return result2;
    }

    @NotNull
    protected static JSType getTypeParameterDefaultType(@NotNull TypeScriptTypeParameter parameter) {
        TypeScriptType defaultType;
        if (parameter == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(24);
        }
        if ((defaultType = parameter.getDefault()) == null) {
            defaultType = parameter.getTypeConstraint();
        }
        JSType jSType = defaultType == null ? JSAnyType.get((PsiElement)parameter, true) : TypeScriptTypeParser.buildTypeFromTypeScript((JSTypeDeclaration)defaultType);
        if (jSType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    @Contract(value="null->false")
    protected boolean canHaveGenericParameters(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        return !(type instanceof JSAnyType) && !(type instanceof JSSpecialNamedTypeImpl) && !(type instanceof JSNullType) && !(type instanceof JSUndefinedType) && !(type instanceof JSVoidType);
    }

    @NotNull
    protected JSTypeSubstitutor inferGenericTypesForCall(@NotNull PsiElement resolvedFunction, @NotNull JSCallExpression callExpression, @Nullable GenericErrorReporter reporter) {
        if (resolvedFunction == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(26);
        }
        if (callExpression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(27);
        }
        JSTypeSubstitutor jSTypeSubstitutor = this.inferGenericTypesForCall(resolvedFunction, callExpression, reporter, -1);
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(28);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected JSTypeSubstitutor inferGenericTypesForCall(@NotNull PsiElement resolvedFunction, @NotNull JSCallExpression callExpression, @Nullable GenericErrorReporter reporter, int paramToSkip) {
        if (resolvedFunction == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(29);
        }
        if (callExpression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(30);
        }
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        result2.putAll(JSGenericTypesEvaluator.getDefaultTypeSubstitutor(resolvedFunction, callExpression));
        if (resolvedFunction instanceof JSFunctionItem) {
            JSExpression[] arguments = callExpression.getArguments();
            List<JSType> parameterTypes = JSGenericTypesEvaluator.getParameterTypesForInference(((JSFunctionItem)resolvedFunction).getParameters(), 0, arguments.length);
            result2.putAll(this.getTypeSubstitutorForReturnType(resolvedFunction, callExpression));
            MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> genericArguments = this.inferGenericArgumentsFromCall(parameterTypes, arguments, paramToSkip, resolvedFunction);
            result2.putAll(JSGenericTypesEvaluator.intersectGenericsForCall(genericArguments, resolvedFunction, reporter));
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(31);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutorForReturnType(@NotNull PsiElement resolvedFunction, @NotNull JSCallExpression callExpression) {
        JSType returnType;
        JSFunction function;
        PsiElement typeElement;
        if (resolvedFunction == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(32);
        }
        if (callExpression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(33);
        }
        if (resolvedFunction instanceof JSFunction && (typeElement = (function = (JSFunction)resolvedFunction).getReturnTypeElement()) != null && JSTypeUtils.hasGenericParameter(returnType = function.getReturnType())) {
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)callExpression, JSExpectedTypeKind.CONTEXTUAL);
            JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluator.findAndIntersectGenericsTypeValues(expectedType, returnType, resolvedFunction);
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(34);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(35);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected JSTypeSubstitutor inferGenericTypesForTaggedTemplateCall(@NotNull PsiElement resolvedFunction, @NotNull ES6TaggedTemplateExpression template, @Nullable GenericErrorReporter reporter, int paramToSkip) {
        if (resolvedFunction == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(36);
        }
        if (template == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(37);
        }
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        result2.putAll(JSGenericTypesEvaluator.getSubstitutorForDefaultParameters(resolvedFunction));
        if (resolvedFunction instanceof JSFunctionItem) {
            JSStringTemplateExpression templateExpression = template.getTemplateExpression();
            JSExpression[] arguments = templateExpression != null ? templateExpression.getArguments() : JSExpression.EMPTY_ARRAY;
            List<JSType> parameterTypes = JSGenericTypesEvaluator.getParameterTypesForInference(((JSFunctionItem)resolvedFunction).getParameters(), 1, arguments.length);
            int callArgumentToSkip = paramToSkip == -1 ? -1 : paramToSkip - 1;
            MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> genericArguments = this.inferGenericArgumentsFromCall(parameterTypes, arguments, callArgumentToSkip, resolvedFunction);
            result2.putAll(JSGenericTypesEvaluator.intersectGenericsForCall(genericArguments, resolvedFunction, reporter));
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(38);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static List<JSType> getParameterTypesForInference(@NotNull JSParameterItem[] parameters, int formalParametersToSkip, int argumentsLength) {
        int i;
        if (parameters == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(39);
        }
        List parameterTypes = ContainerUtil.newSmartList();
        JSType restParameterType = null;
        for (i = 0; i < parameters.length; ++i) {
            if (i < formalParametersToSkip) continue;
            JSParameterItem parameter = parameters[i];
            JSType parameterType = parameter.getType();
            parameterTypes.add(parameterType);
            if (!parameter.isRest()) continue;
            restParameterType = parameterType;
        }
        if (restParameterType != null && argumentsLength > parameterTypes.size()) {
            for (i = parameterTypes.size(); i < argumentsLength; ++i) {
                parameterTypes.add(restParameterType);
            }
        }
        List list = parameterTypes;
        if (list == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(40);
        }
        return list;
    }

    private static JSTypeSubstitutor intersectGenericsForCall(@NotNull MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> map, @NotNull PsiElement context, @Nullable GenericErrorReporter reporter) {
        if (map == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(41);
        }
        if (context == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(42);
        }
        JSTypeSubstitutor result2 = JSGenericTypesEvaluator.intersectGenerics(map, context, reporter);
        for (Map.Entry entry : map.entrySet()) {
            Collection types;
            JSTypeSubstitutor.JSTypeGenericId key = (JSTypeSubstitutor.JSTypeGenericId)entry.getKey();
            if (!result2.containsId(key) || (types = (Collection)entry.getValue()) == null || !types.stream().allMatch(t -> t instanceof JSLiteralType)) continue;
            result2.put(key, (JSType)(types.size() == 1 ? (JSType)types.iterator().next() : new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource(context, true), ContainerUtil.newArrayList((Iterable)types))));
        }
        return result2;
    }

    @NotNull
    protected static JSTypeSubstitutor intersectGenerics(@NotNull MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> map, @Nullable PsiElement context, @Nullable GenericErrorReporter reporter) {
        if (map == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(43);
        }
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        ProcessingContext processingContext = context == null ? null : JSTypeComparingContextService.getProcessingContextWithCache(context);
        for (Map.Entry entry : map.entrySet()) {
            Collection rawTypes = (Collection)entry.getValue();
            assert (rawTypes.size() > 0);
            JSTypeSubstitutor.JSTypeGenericId parameterName = (JSTypeSubstitutor.JSTypeGenericId)entry.getKey();
            JSGenericTypesEvaluator.addTypesForParameter(rawTypes, parameterName, result2, processingContext, reporter);
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(44);
        }
        return jSTypeSubstitutor;
    }

    private static void addTypesForParameter(@NotNull Collection<JSType> rawTypes, @NotNull JSTypeSubstitutor.JSTypeGenericId parameterId, @NotNull JSTypeSubstitutor result2, @Nullable ProcessingContext processingContext, @Nullable GenericErrorReporter reporter) {
        if (rawTypes == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(45);
        }
        if (parameterId == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(46);
        }
        if (result2 == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(47);
        }
        if (rawTypes.size() == 0) {
            return;
        }
        if (rawTypes.size() == 1) {
            result2.put(parameterId, (JSType)ContainerUtil.getFirstItem(rawTypes));
            return;
        }
        boolean hasImplicitly = JSGenericTypesEvaluator.checkImplicitFlags(rawTypes);
        List typesWithoutGenerics = rawTypes.stream().filter(el -> !(el instanceof JSGenericParameterImpl) && el != null && !JSCompositeTypeBaseImpl.isNullOrUndefinedType(el)).collect(Collectors.toList());
        Collection<Object> typesToIntersect = typesWithoutGenerics.isEmpty() ? rawTypes : typesWithoutGenerics;
        JSType type = JSGenericTypesEvaluator.intersectTypes(typesToIntersect, processingContext);
        if (type != null) {
            result2.put(parameterId, type);
            return;
        }
        if (hasImplicitly) {
            return;
        }
        if (typesWithoutGenerics.size() > 0) {
            result2.put(parameterId, (JSType)typesWithoutGenerics.get(0));
            if (reporter != null && typesWithoutGenerics.size() > 1) {
                reporter.error("typescript.validation.cannot.find.best.common.type");
            }
        }
    }

    private static boolean checkImplicitFlags(@NotNull Collection<JSType> types) {
        if (types == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(48);
        }
        boolean hasImplicitly = false;
        for (JSType type : types) {
            JSType valuableType = JSTypeUtils.getValuableType(type);
            if (valuableType != null && valuableType.isSourceStrict()) continue;
            hasImplicitly = true;
            break;
        }
        return hasImplicitly;
    }

    @Nullable
    private static JSType intersectTypes(@NotNull Collection<JSType> types, @Nullable ProcessingContext context) {
        if (types == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(49);
        }
        ArrayList sortedTypes = ContainerUtil.newArrayList(types);
        ContainerUtil.sort((List)sortedTypes, Comparator.comparing(el -> el instanceof JSLiteralType && ((JSLiteralType)el).canBeWidened() ? 1 : 0));
        JSType firstNamed = null;
        for (JSType type : sortedTypes) {
            JSType currentType;
            JSTypeSource source;
            if (firstNamed == null && type instanceof JSNamedType) {
                firstNamed = type;
            }
            if (type == null || (source = type.getSource()).isTypeScript() && !(currentType = JSTypeUtils.getValuableType(type)).getSource().isStrict()) continue;
            boolean result2 = true;
            for (JSType jsType : types) {
                if (jsType == type || type.isDirectlyAssignableType(jsType, context)) continue;
                result2 = false;
                break;
            }
            if (!result2) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public final MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> inferGenericArgumentsFromCall(@NotNull List<JSType> parameterTypes, @NotNull JSExpression[] arguments, int callArgumentToSkip, @Nullable PsiElement resolvedFunction) {
        if (parameterTypes == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(50);
        }
        if (arguments == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(51);
        }
        List<Supplier<JSType>> argumentProviders = Arrays.stream(arguments).map(el -> () -> callArgumentToSkip == -1 ? TypeScriptGenericTypesEvaluator.getParameterExpressionType(el, false) : JSGenericTypesEvaluator.getContextualParameterType(el, resolvedFunction)).collect(Collectors.toList());
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> multiMap = this.inferGenericArgumentsFromCall(parameterTypes, argumentProviders, callArgumentToSkip, resolvedFunction);
        if (multiMap == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(52);
        }
        return multiMap;
    }

    private static JSType getContextualParameterType(@NotNull JSExpression expression, @Nullable PsiElement resolvedFunction) {
        if (expression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(53);
        }
        if (resolvedFunction == null) {
            return TypeScriptGenericTypesEvaluator.getParameterExpressionType(expression, false);
        }
        return TypeScriptSignatureChooser.mapContextualTypeForOverload(TypeScriptGenericTypesEvaluator.getParameterExpressionType(expression, true), resolvedFunction);
    }

    @NotNull
    public MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> inferGenericArgumentsFromCall(@NotNull List<JSType> parameterTypes, @NotNull List<Supplier<JSType>> arguments, int callArgumentToSkip, @Nullable PsiElement resolvedFunction) {
        if (parameterTypes == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(54);
        }
        if (arguments == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(55);
        }
        Set<String> names = JSGenericTypesEvaluator.getGenericNames(resolvedFunction);
        Integer[] newIndices = JSGenericTypesEvaluator.reorderByDependencies(arguments.size(), parameterTypes, names);
        MultiMap genericArguments = MultiMap.createSmart();
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        ProcessingContext processingContext = JSTypeComparingContextService.getProcessingContextWithCache(resolvedFunction);
        processingContext.put(ourGenericArgumentsMapKey, (Object)genericArguments);
        for (int i = 0; i < arguments.size(); ++i) {
            JSType constraintType;
            int j = newIndices[i];
            if (j == callArgumentToSkip) continue;
            if (j >= parameterTypes.size()) break;
            JSType paramType = parameterTypes.get(j);
            if (paramType instanceof JSTypeofTypeImpl) {
                paramType = paramType.substitute();
            }
            if (!substitutor.isEmpty()) {
                paramType = JSTypeUtils.applyGenericArguments(paramType, substitutor, true);
            }
            if (!JSTypeUtils.hasGenericParameter(paramType)) continue;
            JSType exprType = JSGenericTypesEvaluator.getArgType(arguments, j);
            boolean matchedTuples = false;
            if (paramType instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)paramType).getConstraintType()) != null && JSTypeUtils.isIterableCollectionType(constraintType)) {
                ArrayList types = ContainerUtil.newArrayList();
                for (int k = i; k < arguments.size(); ++k) {
                    types.add(0, JSTypeUtils.widenLiteralTypes(JSGenericTypesEvaluator.getArgType(arguments, newIndices[k])));
                }
                JSGenericTypesEvaluator.matchGenericTypes(processingContext, new JSTupleTypeImpl(paramType.getSource(), types, true, -1), paramType, resolvedFunction);
                matchedTuples = true;
            }
            if (!matchedTuples) {
                JSGenericTypesEvaluator.matchGenericTypes(processingContext, exprType, paramType, resolvedFunction);
            }
            for (Map.Entry entry : genericArguments.entrySet()) {
                JSTypeSubstitutor.JSTypeGenericId key = (JSTypeSubstitutor.JSTypeGenericId)entry.getKey();
                Collection types = (Collection)entry.getValue();
                if (types.size() != 1) continue;
                substitutor.put(key, (JSType)types.iterator().next());
            }
            if (matchedTuples) break;
        }
        MultiMap multiMap = genericArguments;
        if (multiMap == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(56);
        }
        return multiMap;
    }

    @Nullable
    private static JSType getArgType(@NotNull List<Supplier<JSType>> arguments, int index) {
        JSType exprType;
        if (arguments == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(57);
        }
        if ((exprType = arguments.get(index).get()) != null && exprType.isTypeScript()) {
            PsiElement sourceElement = exprType.getSource().getSourceElement();
            exprType = sourceElement != null ? TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(sourceElement, exprType) : exprType;
        }
        return exprType;
    }

    @NotNull
    protected static JSTypeSubstitutor findAndIntersectGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType, @Nullable PsiElement context) {
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> generics = JSGenericTypesEvaluator.findGenericsTypeValues(exprType, paramType, context);
        if (!generics.isEmpty()) {
            JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluator.intersectGenerics(generics, context, null);
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(58);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(59);
        }
        return jSTypeSubstitutor;
    }

    protected static MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> findGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType, @Nullable PsiElement context) {
        if (exprType == null || paramType == null) {
            return MultiMap.empty();
        }
        MultiMap genericArguments = MultiMap.createSmart();
        ProcessingContext processingContext = JSTypeComparingContextService.getProcessingContextWithCache(context);
        processingContext.put(ourGenericArgumentsMapKey, (Object)genericArguments);
        JSGenericTypesEvaluator.matchGenericTypes(processingContext, exprType, paramType, null);
        return genericArguments;
    }

    public static void matchGenericTypes(@NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType, @Nullable PsiElement invokedElement) {
        if (processingContext == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(60);
        }
        if (paramType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(61);
        }
        JSType returnType = null;
        if (invokedElement instanceof JSFunctionItem) {
            returnType = ((JSFunctionItem)invokedElement).getReturnType();
        }
        List<JSGenericParameterImpl> topLevelParamGenerics = JSGenericTypesEvaluator.getTopLevelGenerics(paramType);
        List<JSGenericParameterImpl> topLevelReturnGenerics = JSGenericTypesEvaluator.getTopLevelGenerics(returnType);
        paramType = JSTypeUtils.applyCompositeMapping(paramType, (Function<JSType, JSType>)((Function)type -> {
            if (!(type instanceof JSGenericParameterImpl)) {
                return type;
            }
            JSGenericParameterImpl genericParameter = (JSGenericParameterImpl)((Object)type);
            boolean widenLiterals = topLevelParamGenerics.stream().anyMatch(p -> p.isEquivalentTo(genericParameter, null)) && topLevelReturnGenerics.stream().noneMatch(p -> p.isEquivalentTo(genericParameter, null));
            return new JSGenericParameterApplierImpl(genericParameter, widenLiterals);
        }));
        paramType.isDirectlyAssignableType(exprType, processingContext);
    }

    @NotNull
    private static List<JSGenericParameterImpl> getTopLevelGenerics(@Nullable JSType paramType) {
        ArrayList topLevelGenerics = ContainerUtil.newArrayList();
        JSTypeUtils.processExpandedType((Processor<JSType>)((Processor)t -> {
            if (t instanceof JSGenericParameterImpl) {
                topLevelGenerics.add((JSGenericParameterImpl)((Object)t));
            }
            return true;
        }), paramType);
        ArrayList arrayList = topLevelGenerics;
        if (arrayList == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(62);
        }
        return arrayList;
    }

    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, @NotNull JSExpression methodExpression) {
        if (type == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(63);
        }
        if (qualifier == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(64);
        }
        if (methodExpression == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(65);
        }
        JSType jSType = (JSType)this.getQualifierGenericsEvaluator(type, qualifier, methodExpression, null).fun((Object)type);
        if (jSType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(66);
        }
        return jSType;
    }

    @NotNull
    private static JSType evaluateJSGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier) {
        JSType qualifierType;
        if (type == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(67);
        }
        if (qualifier == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(68);
        }
        if (type.getSource().isTypeScript()) {
            JSType jSType = type;
            if (jSType == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(69);
            }
            return jSType;
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        List<String> javaScriptGenericParameters = null;
        JSQualifiedName qualifiedName = null;
        PsiElement namespaceElement = sourceElement;
        if (namespaceElement instanceof JSParameter) {
            namespaceElement = ((JSParameter)namespaceElement).getDeclaringFunction();
        }
        if (namespaceElement instanceof JSPsiElementBase && namespaceElement.isValid()) {
            PsiFile file2 = namespaceElement.getContainingFile();
            for (qualifiedName = ((JSPsiElementBase)namespaceElement).getNamespace(); qualifiedName != null && (javaScriptGenericParameters = JSGenericsIndex.findGenericParameters(qualifiedName.getQualifiedName(), file2)) == null; qualifiedName = qualifiedName.getParent()) {
            }
            if (javaScriptGenericParameters != null) {
                type = JSGenericTypesEvaluator.convertNamedTypesToGenericParameters(type, javaScriptGenericParameters);
            }
        }
        if (JSTypeUtils.hasGenericParameter(type) && javaScriptGenericParameters != null && (qualifierType = JSResolveUtil.getExpressionJSType((PsiElement)qualifier, JSEvaluateContext.JSEvaluationPlace.QUALIFIER)) != null) {
            qualifierType = JSTypeUtils.unwrapDecorations(qualifierType);
            JSTypeSubstitutor typeArguments = JSGenericTypesEvaluator.findTypeArgumentsForClassInHierarchy(qualifierType, qualifiedName, sourceElement);
            JSType jSType = JSTypeUtils.applyGenericArguments(type, typeArguments);
            if (jSType == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(70);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(71);
        }
        return jSType;
    }

    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutorFromQualifierType(@NotNull JSType qualifierType, @Nullable PsiElement sourceElement, @Nullable PsiElement place) {
        if (qualifierType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(72);
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(73);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static JSType convertNamedTypesToGenericParameters(@NotNull JSType type, @NotNull List<String> javaScriptGenericParameters) {
        if (type == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(74);
        }
        if (javaScriptGenericParameters == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(75);
        }
        List<String> genericParameters = javaScriptGenericParameters;
        JSType jSType = type = JSTypeUtils.applyCompositeMapping(type, (Function<JSType, JSType>)((Function)type1 -> {
            if (type1 instanceof JSTypeImpl && genericParameters.contains(type1.getTypeText())) {
                return new JSGenericParameterImpl(type1.getTypeText(), type1.getSource());
            }
            return type1;
        }));
        if (jSType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(76);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor findTypeArgumentsForClassInHierarchy(@NotNull JSType genericType, @NotNull JSQualifiedName parentClassNamespace, @NotNull PsiElement scopeElement) {
        String qName;
        if (genericType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(77);
        }
        if (parentClassNamespace == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(78);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(79);
        }
        if ((qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true)) == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(80);
            }
            return jSTypeSubstitutor;
        }
        String parentClassName = parentClassNamespace.getQualifiedName();
        if (parentClassName.equals(qName)) {
            List<String> genericParameters = JSGenericsIndex.findGenericParameters(parentClassName, scopeElement.getContainingFile());
            if (genericParameters == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluator.$$$reportNull$$$0(81);
                }
                return jSTypeSubstitutor;
            }
            List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
            if (arguments == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluator.$$$reportNull$$$0(82);
                }
                return jSTypeSubstitutor;
            }
            JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.putForJSGenerics(genericParameters.get(i), arguments.get(i));
            }
            JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(83);
            }
            return jSTypeSubstitutor;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        JSTypeSubstitutor typeArguments = JSGenericTypesEvaluator.getTypeArgumentsMap(genericType, scope);
        JSTypeSubstitutor jSTypeSubstitutor = JSGenericTypesEvaluator.applyTypeSubstitutorUpToParentClass(qName, parentClassName, scopeElement, typeArguments);
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(84);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor applyTypeSubstitutorUpToParentClass(@NotNull String qName, @NotNull String parentClassName, @NotNull PsiElement scopeElement, @NotNull JSTypeSubstitutor typeArguments) {
        if (qName == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(85);
        }
        if (parentClassName == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(86);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(87);
        }
        if (typeArguments == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(88);
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        TreeItem<String> root = JSTypeEvaluateManager.buildSuperClassesHierarchy(qName, scope);
        ArrayList<Object> pathToSuperClass = new ArrayList<Object>();
        for (TreeItem parentClass = JSTypeEvaluateManager.findSuperClass(root, parentClassName); parentClass != null && parentClass != root; parentClass = parentClass.getParent()) {
            pathToSuperClass.add(0, parentClass.getData());
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(scopeElement, true);
        for (String string : pathToSuperClass) {
            JSType type = JSTypeUtils.createType(string, typeSource);
            if (type == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluator.$$$reportNull$$$0(89);
                }
                return jSTypeSubstitutor;
            }
            type = JSTypeUtils.applyGenericArguments(type, typeArguments);
            typeArguments = JSGenericTypesEvaluator.getTypeArgumentsMap(type, scope);
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(90);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeArgumentsMap(@NotNull JSType genericType, @NotNull GlobalSearchScope scope) {
        if (genericType == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(91);
        }
        if (scope == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(92);
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true);
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        if (qName == null || arguments == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluator.$$$reportNull$$$0(93);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
        List<String> genericParameters = JSGenericsIndex.findGenericParameters(qName, scope);
        if (genericParameters != null) {
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.putForJSGenerics(genericParameters.get(i), arguments.get(i));
            }
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(94);
        }
        return jSTypeSubstitutor;
    }

    @Contract(value="null -> false")
    public static boolean isGenericProcessingInProgress(@Nullable ProcessingContext context) {
        return context != null && context.get(ourGenericArgumentsMapKey) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 44: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 93: 
            case 94: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 44: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 93: 
            case 94: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 44: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startType";
                break;
            }
            case 6: 
            case 64: 
            case 68: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParametersOwner";
                break;
            }
            case 10: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 21: 
            case 50: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 26: 
            case 29: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFunction";
                break;
            }
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawTypes";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterId";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 51: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramType";
                break;
            }
            case 63: 
            case 67: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaScriptGenericParameters";
                break;
            }
            case 77: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassNamespace";
                break;
            }
            case 79: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassName";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForExplicitThisParameterType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierGenericsEvaluator";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeSubstitutor";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForDefaultParameters";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericNames";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "reorderByDependencies";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterDefaultType";
                break;
            }
            case 28: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericTypesForCall";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForReturnType";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericTypesForTaggedTemplateCall";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypesForInference";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectGenerics";
                break;
            }
            case 52: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericArgumentsFromCall";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndIntersectGenericsTypeValues";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelGenerics";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateGenericsFromQualifier";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateJSGenericsFromQualifier";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorFromQualifierType";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNamedTypesToGenericParameters";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenerics";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForExplicitThisParameterType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 44: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 93: 
            case 94: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierGenericsEvaluator";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeSubstitutor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForDefaultParameters";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addGenericDependencyFromType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reorderByDependencies";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterDefaultType";
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericTypesForCall";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForReturnType";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericTypesForTaggedTemplateCall";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypesForInference";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "intersectGenericsForCall";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "intersectGenerics";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addTypesForParameter";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "checkImplicitFlags";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "intersectTypes";
                break;
            }
            case 50: 
            case 51: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericArgumentsFromCall";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getContextualParameterType";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getArgType";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "matchGenericTypes";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "evaluateGenericsFromQualifier";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "evaluateJSGenericsFromQualifier";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorFromQualifierType";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "convertNamedTypesToGenericParameters";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsMap";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getQualifierGenericsEvaluator$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 44: 
            case 52: 
            case 56: 
            case 58: 
            case 59: 
            case 62: 
            case 66: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 76: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 89: 
            case 90: 
            case 93: 
            case 94: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface GenericErrorReporter {
        public void error(@NotNull String var1);
    }

    public static class GenericEvaluationContext {
        public final int paramToSkip;
        @Nullable
        public final GenericErrorReporter reporter;
        public final boolean inferCallGenerics;

        public GenericEvaluationContext(@Nullable GenericErrorReporter reporter, int paramToSkip) {
            this(reporter, paramToSkip, true);
        }

        public GenericEvaluationContext() {
            this(null, -1, true);
        }

        public GenericEvaluationContext(@Nullable GenericErrorReporter reporter, int paramToSkip, boolean inferCallGenerics) {
            this.paramToSkip = paramToSkip;
            this.reporter = reporter;
            this.inferCallGenerics = inferCallGenerics;
        }
    }
}

