/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSHierarchyProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeHelper {
    protected JSTypeHelper() {
    }

    public boolean areNamedTypesAssignable(@NotNull JSNamedType lOpType, @NotNull JSNamedType rOpType, @NotNull ProcessingContext processingContext) {
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(0);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(1);
        }
        if (processingContext == null) {
            JSTypeHelper.$$$reportNull$$$0(2);
        }
        String lOpQualifiedName = JSTypeUtils.getQualifiedNameMatchingType(lOpType, true);
        String rOpQualifiedName = JSTypeUtils.getQualifiedNameMatchingType(rOpType, true);
        if (lOpQualifiedName == null || rOpQualifiedName == null) {
            return lOpQualifiedName == rOpQualifiedName;
        }
        PsiFile context = rOpType.getSource().getScope();
        if ("Iterable".equals(lOpQualifiedName) && JSTypeHelper.isBuiltInIterable(rOpQualifiedName)) {
            return true;
        }
        if (context == null) {
            return lOpQualifiedName.equals(rOpQualifiedName);
        }
        final Collection<String> possibleLNames = JSTypeHelper.getPossibleTypeNames(lOpType, lOpQualifiedName);
        if (possibleLNames.contains(rOpQualifiedName)) {
            return true;
        }
        final Ref result2 = Ref.create((Object)false);
        JSTypeEvaluateManager.iterateTypeHierarchy(rOpQualifiedName, new JSHierarchyProcessor(){
            final Set<String> visited = new THashSet();

            @Override
            public boolean processNamespace(String serializedType, VirtualFile file2) {
                String qName = JSTypeUtils.getTypeMatchingNamespace(serializedType);
                return this.processQName(qName);
            }

            @Override
            public boolean processClass(JSClass clazz) {
                String qName = clazz.getQualifiedName();
                if (qName == null) {
                    return true;
                }
                if (!this.processQName(qName)) {
                    return false;
                }
                String name = clazz.getName();
                if (name == null || qName.equals(name)) {
                    return true;
                }
                PsiElement moduleCandidate = clazz.getContext();
                if (ES6PsiUtil.isExternalModule(moduleCandidate)) {
                    return this.processQName(name);
                }
                return true;
            }

            private boolean processQName(@Nullable String qName) {
                if (qName == null) {
                    return true;
                }
                if (this.visited.add(qName) && possibleLNames.contains(qName)) {
                    result2.set((Object)true);
                    return false;
                }
                return true;
            }

            @Override
            public boolean processObjectLiteral(JSObjectLiteralExpression objectLiteral) {
                return true;
            }
        }, (PsiElement)context, true, false, true);
        return (Boolean)result2.get();
    }

    @NotNull
    private static Collection<String> getPossibleTypeNames(@NotNull JSNamedType type, @NotNull String qName) {
        PsiElement module;
        String className;
        JSResolvedTypeInfo info;
        JSClass jsClass;
        String text;
        if (type == null) {
            JSTypeHelper.$$$reportNull$$$0(3);
        }
        if (qName == null) {
            JSTypeHelper.$$$reportNull$$$0(4);
        }
        if (Objects.equals(text = type.getTypeText(), qName)) {
            List<String> list = Collections.singletonList(qName);
            if (list == null) {
                JSTypeHelper.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (type.isTypeScript() && type instanceof JSResolvableType && (jsClass = (info = ((JSResolvableType)((Object)type)).resolveType()).getDeclarationOfType(JSClass.class)) != null && (className = jsClass.getName()) != null && ES6PsiUtil.isExternalModule(module = jsClass.getContext())) {
            THashSet tHashSet = ContainerUtil.newTroveSet((Object[])new String[]{qName, className});
            if (tHashSet == null) {
                JSTypeHelper.$$$reportNull$$$0(6);
            }
            return tHashSet;
        }
        Set<String> set = Collections.singleton(qName);
        if (set == null) {
            JSTypeHelper.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static boolean isBuiltInIterable(String rOpQualifiedName) {
        return "Set".equals(rOpQualifiedName) || "WeakSet".equals(rOpQualifiedName) || "Array".equals(rOpQualifiedName);
    }

    public boolean isAssignableToNamedType(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @NotNull ProcessingContext processingContext) {
        JSGenericParameterImpl genericParameter;
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(8);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(9);
        }
        if (processingContext == null) {
            JSTypeHelper.$$$reportNull$$$0(10);
        }
        if ((rOpType instanceof JSPrimitiveFunctionType || rOpType instanceof JSFunctionTypeImpl) && lOpType.inheritsFunction()) {
            return true;
        }
        if (rOpType instanceof JSNamedType) {
            return this.areNamedTypesAssignable(lOpType, (JSNamedType)rOpType, processingContext);
        }
        if (rOpType instanceof JSGenericTypeImpl) {
            return lOpType.isDirectlyAssignableType(((JSGenericTypeImpl)rOpType).getType(), processingContext);
        }
        if (rOpType instanceof JSNullType) {
            return true;
        }
        if (rOpType instanceof JSArrayTypeImpl) {
            return this.isAssignableToNamedType(lOpType, ((JSArrayTypeImpl)rOpType).asGenericType(), processingContext);
        }
        if (rOpType instanceof JSRecordType) {
            return this.substituteLeftTypeAndCheckAssignable(lOpType, rOpType, processingContext).isAssignable();
        }
        if (rOpType instanceof JSGenericParameterImpl && (genericParameter = (JSGenericParameterImpl)rOpType).getConstraintType() != null) {
            return lOpType.isDirectlyAssignableType(genericParameter, processingContext);
        }
        return false;
    }

    protected JSTypeCastUtil.AssignableResult substituteLeftTypeAndCheckAssignable(@NotNull JSTypeImpl lOpType, @NotNull JSType rOpType, @NotNull ProcessingContext processingContext) {
        JSRecordType lOpResolvedType;
        if (lOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(11);
        }
        if (rOpType == null) {
            JSTypeHelper.$$$reportNull$$$0(12);
        }
        if (processingContext == null) {
            JSTypeHelper.$$$reportNull$$$0(13);
        }
        if (lOpType.isJavaScript() && lOpType.canBeWidened()) {
            return JSTypeCastUtil.AssignableResult.NOT_SURE;
        }
        Object object = lOpResolvedType = lOpType.isJavaScript() ? lOpType.asRecordType() : lOpType.substitute();
        if (lOpResolvedType == JSTypeCastUtil.NO_RECORD_TYPE) {
            return JSTypeCastUtil.AssignableResult.NOT_SURE;
        }
        if (lOpResolvedType != lOpType) {
            return JSTypeCastUtil.toStrictAssignable(lOpResolvedType.isDirectlyAssignableType(rOpType, processingContext));
        }
        return JSTypeCastUtil.AssignableResult.NOT_SURE;
    }

    @Nullable
    public JSType getTypeForIndexing(@Nullable JSExpression expression, @NotNull PsiElement context) {
        JSType constant;
        if (context == null) {
            JSTypeHelper.$$$reportNull$$$0(14);
        }
        if (expression == null) {
            return new JSUndefinedType(JSTypeSourceFactory.createTypeSource(context, true, false));
        }
        if (expression instanceof JSLiteralExpression && (constant = JSTypeEvaluator.getTypeFromConstant(expression)) != null) {
            return constant;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lOpType";
                break;
            }
            case 1: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOpType";
                break;
            }
            case 2: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeHelper";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeHelper";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleTypeNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areNamedTypesAssignable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleTypeNames";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableToNamedType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "substituteLeftTypeAndCheckAssignable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForIndexing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

