/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitMemberForComputedPropertyImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveStatus;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSinkResolveStatus;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptImplicitMemberForComputedProperty;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.validation.UnusedImportsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveResultSink
extends ResultSink {
    private static final Logger LOG = Logger.getInstance(ResolveResultSink.class);
    private final String myName;
    private List<JSSinkResolveStatus> myResolveStatus;
    private final boolean myAcceptAllResults;
    @Nullable
    private Set<PsiElement> myCandidateResults;

    public ResolveResultSink(@Nullable PsiElement place, @NotNull String name) {
        if (name == null) {
            ResolveResultSink.$$$reportNull$$$0(0);
        }
        this(place, name, false);
    }

    public ResolveResultSink(@Nullable PsiElement place, @NotNull String name, boolean acceptAllResults) {
        if (name == null) {
            ResolveResultSink.$$$reportNull$$$0(1);
        }
        super(place);
        this.myName = name;
        this.myAcceptAllResults = acceptAllResults;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public PsiElement getResult() {
        PsiElement completeResult = this.getCompleteResult();
        if (completeResult != null) {
            return completeResult;
        }
        return (PsiElement)ContainerUtil.getFirstItem((List)this.myResults);
    }

    @Nullable
    public PsiElement getCompleteResult() {
        if (this.myResults == null) {
            return null;
        }
        LOG.assertTrue(this.myResults.size() == this.myResolveStatus.size(), (Object)(this.myResults.size() + " != " + this.myResolveStatus.size()));
        for (int i = 0; i < this.myResults.size(); ++i) {
            if (!this.myResolveStatus.get((int)i).myIsComplete) continue;
            return (PsiElement)this.myResults.get(i);
        }
        return null;
    }

    @Nullable
    public JSResolveResult getCandidateResult() {
        if (this.myResults == null) {
            return null;
        }
        LOG.assertTrue(this.myResults.size() == this.myResolveStatus.size(), (Object)(this.myResults.size() + " != " + this.myResolveStatus.size()));
        for (int i = 0; i < this.myResults.size(); ++i) {
            if (this.myResolveStatus.get((int)i).myIsComplete) continue;
            return new JSResolveResult((PsiElement)this.myResults.get(i), null, this.myResolveStatus.get(i).getResolveProblem());
        }
        return null;
    }

    @Override
    public List<PsiElement> getResults() {
        if (this.myResults == null) {
            return null;
        }
        LOG.assertTrue(this.myResults.size() == this.myResolveStatus.size(), (Object)(this.myResults.size() + " != " + this.myResolveStatus.size()));
        boolean hasCandidateResult = false;
        boolean hasCompleteResult = false;
        for (int i = 0; i < this.myResults.size(); ++i) {
            if (this.myResolveStatus.get((int)i).myIsComplete) {
                hasCompleteResult = true;
                continue;
            }
            hasCandidateResult = true;
        }
        List results = this.myResults;
        if (hasCompleteResult && hasCandidateResult) {
            results = new SmartList();
            for (int i = 0; i < this.myResults.size(); ++i) {
                if (!this.myResolveStatus.get((int)i).myIsComplete) continue;
                results.add(this.myResults.get(i));
            }
        }
        return results;
    }

    @Override
    public boolean accepts(PsiElement element) {
        if (element instanceof PsiNamedElement && (this.myName.equals(ResolveProcessor.getName(element)) ? element instanceof ES6ExportSpecifier : !ResolveResultSink.isAcceptableForComputedPropertyName(element))) {
            return false;
        }
        if (element instanceof ES6ImportExportSpecifier && !this.myName.equals(((ES6ImportExportSpecifier)element).getReferenceName())) {
            return false;
        }
        if (element instanceof ES6ExportDefaultAssignment && !this.myName.equals("default")) {
            return false;
        }
        return super.accepts(element);
    }

    @Contract(value="null -> false")
    public static boolean isAcceptableForComputedPropertyName(@Nullable PsiElement element) {
        if (!(element instanceof JSComputedPropertyNameOwner)) {
            return false;
        }
        ES6ComputedName computedPropertyName = ((JSComputedPropertyNameOwner)element).getComputedPropertyName();
        return computedPropertyName != null && computedPropertyName.getExpressionAsPropertyName() == null;
    }

    private ThreeState isAccurateComputedNameMatch(@Nullable PsiElement element) {
        if (!(element instanceof JSComputedPropertyNameOwner)) {
            return ThreeState.UNSURE;
        }
        ES6ComputedName computedPropertyName = ((JSComputedPropertyNameOwner)element).getComputedPropertyName();
        if (computedPropertyName == null) {
            return ThreeState.UNSURE;
        }
        JSType type = TypeScriptLiteralKeyUtil.getTypeForComputedPropExpression(computedPropertyName);
        if (type instanceof JSStringLiteralTypeImpl) {
            String literal = ((JSStringLiteralTypeImpl)type).getLiteral();
            if (this.myName.equals(literal)) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        if (type instanceof JSNumberLiteralTypeImpl) {
            String string = ((JSNumberLiteralTypeImpl)type).getValueAsString();
            if (this.myName.equals(string)) {
                return ThreeState.YES;
            }
            return ThreeState.NO;
        }
        return ThreeState.UNSURE;
    }

    @Override
    public boolean addResult(PsiElement element, ResolveState state, SinkResolveProcessor resolveProcessor) {
        ReadWriteAccessDetector.Access expressionAccess;
        JSFunction fun;
        int previousResultsSize;
        List<PsiElement> results = super.getResults();
        int n = previousResultsSize = results != null ? results.size() : 0;
        if (this.myAcceptAllResults) {
            this.doAddResult(element, state, resolveProcessor);
            return true;
        }
        boolean stopProcessing = true;
        PsiElement elementForPropertyProcessing = element;
        if (element instanceof JSProperty) {
            elementForPropertyProcessing = ((JSProperty)element).tryGetFunctionInitializer();
        }
        if (this.place != null && elementForPropertyProcessing instanceof JSFunction && ((fun = (JSFunction)elementForPropertyProcessing).isGetProperty() || fun.isSetProperty()) && (expressionAccess = JSReadWriteAccessDetector.ourInstance.getExpressionAccess(this.place)) == ReadWriteAccessDetector.Access.ReadWrite) {
            PsiElement psiElement;
            if (previousResultsSize == 0) {
                stopProcessing = false;
            }
            if (previousResultsSize == 1 && (psiElement = results.get(0)) instanceof JSFunction) {
                JSFunction prevFun = (JSFunction)psiElement;
                if (prevFun.isGetProperty() && fun.isGetProperty()) {
                    return true;
                }
                if (prevFun.isSetProperty() && fun.isSetProperty()) {
                    return true;
                }
            }
            if (previousResultsSize == 2) {
                return true;
            }
        }
        if (ResolveResultSink.isAcceptableForComputedPropertyName(element)) {
            ThreeState match = this.isAccurateComputedNameMatch(element);
            if (match == ThreeState.UNSURE) {
                if (DialectDetector.isTypeScript(element)) {
                    this.doAddResult((PsiElement)new TypeScriptImplicitMemberForComputedPropertyImpl(this.myName, null, element, true), state, resolveProcessor);
                    return true;
                }
                stopProcessing = false;
            } else {
                if (match == ThreeState.NO) {
                    return true;
                }
                if (this.myResults != null) {
                    List toRemove = this.myResults.stream().filter(r -> ResolveResultSink.isAcceptableForComputedPropertyName(r)).collect(Collectors.toList());
                    for (PsiElement item : toRemove) {
                        int index = this.myResults.indexOf(item);
                        this.myResults.remove(index);
                        this.myResolveStatus.remove(index);
                    }
                }
            }
        }
        this.doAddResult(element, state, resolveProcessor);
        return !stopProcessing;
    }

    private void doAddResult(PsiElement element, ResolveState state, SinkResolveProcessor resolveProcessor) {
        super.addResult(element, state, resolveProcessor);
        if (this.myResolveStatus == null) {
            this.myResolveStatus = new SmartList();
        }
        this.myResolveStatus.add(this.getResolveStatus(element, state, resolveProcessor));
    }

    private JSSinkResolveStatus getResolveStatus(PsiElement element, @Nullable ResolveState state, SinkResolveProcessor resolveProcessor) {
        JSElement importElement;
        JSElement jSElement = importElement = state != null ? (JSElement)state.get(JSResolveResult.IMPORT_KEY) : null;
        if (this.isActionScript()) {
            return this.checkQualifiedNameHasNecessaryImport(element, importElement, resolveProcessor);
        }
        return new JSSinkResolveStatus(importElement, true, null, state == null ? null : (JSTypeSubstitutor)state.get(JSResolveResult.GENERICS));
    }

    @NotNull
    private JSSinkResolveStatus checkQualifiedNameHasNecessaryImport(PsiElement element, JSElement importElement, SinkResolveProcessor resolveProcessor) {
        PsiElement placeTopParent;
        String resolveProblem = null;
        if (importElement == null && this.isActionScript() && (element instanceof JSClass || element instanceof JSFunction || element instanceof JSVariable || element instanceof JSNamespaceDeclaration) && (placeTopParent = resolveProcessor.getPlaceTopParent()) instanceof JSReferenceExpression && !(placeTopParent.getParent() instanceof JSImportStatement)) {
            String qName;
            if (placeTopParent.getParent() instanceof JSNewExpression && element instanceof JSFunction && ((JSFunction)element).isConstructor()) {
                element = element.getParent();
            }
            String string = qName = element instanceof JSQualifiedNamedElement ? ((JSQualifiedNamedElement)element).getQualifiedName() : null;
            if (qName != null && qName.indexOf(46) != -1 && !JSResolveUtil.getPackageName(element).equals(JSResolveUtil.getPackageNameFromPlace(this.place)) && !UnusedImportsUtil.isSomeNodeThatShouldNotHaveImportsWhenQualified((JSReferenceExpression)placeTopParent, element)) {
                boolean noImportNoResolve;
                SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(this.myName, new ResolveResultSink(null, this.myName)){

                    @Override
                    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (state == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (element instanceof JSQualifiedNamedElement) {
                            if (!qName.equals(((JSQualifiedNamedElement)element).getQualifiedName())) {
                                return true;
                            }
                        } else {
                            return true;
                        }
                        return super.execute(element, state);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "state";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink$1";
                        objectArray[2] = "execute";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                processor.putUserData(ResolveProcessor.ASKING_FOR_QUALIFIED_IMPORT, qName);
                PsiNamedElement importOwner = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)placeTopParent, (Class[])new Class[]{JSFunction.class, JSFile.class, JSPackageStatement.class, JSClass.class});
                if (importOwner != null) {
                    PsiElement elt = PsiTreeUtil.getChildOfAnyType((PsiElement)importOwner, (Class[])new Class[]{PsiWhiteSpace.class});
                    if (elt == null) {
                        elt = importOwner.getFirstChild();
                    }
                    JSResolveUtil.treeWalkUp(processor, (PsiElement)importOwner, elt, this.place);
                }
                boolean bl = noImportNoResolve = processor.getResult() == null;
                if (noImportNoResolve) {
                    resolveProblem = "javascript.qualified.name.is.not.imported.message";
                } else {
                    ResolveResult[] resultsAsResolveResults = ((ResolveResultSink)processor.getResultSink()).getResultsAsResolveResults();
                    if (resultsAsResolveResults.length != 0) {
                        importElement = ((JSResolveResult)resultsAsResolveResults[0]).getActionScriptImport();
                    }
                }
            }
        }
        JSSinkResolveStatus jSSinkResolveStatus = new JSSinkResolveStatus(importElement, true, resolveProblem, null);
        if (jSSinkResolveStatus == null) {
            ResolveResultSink.$$$reportNull$$$0(2);
        }
        return jSSinkResolveStatus;
    }

    @NotNull
    public ResolveResult[] getResultsAsResolveResults() {
        if (this.myResults == null || this.myResults.isEmpty()) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                ResolveResultSink.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResultArray = (ResolveResult[])this.getFilteredResults().stream().map(p -> p.resolveResult).toArray(ResolveResult[]::new);
        if (resolveResultArray == null) {
            ResolveResultSink.$$$reportNull$$$0(4);
        }
        return resolveResultArray;
    }

    @Nullable
    public static ResolveResult[] resolveImportExportSpecifiers(PsiElement element) {
        ResolveResult[] newResults;
        if (element instanceof ES6ImportExportSpecifier) {
            ResolveResult[] results = ((ES6ImportExportSpecifier)element).multiResolve(false);
            return results.length == 0 ? null : results;
        }
        if (element instanceof ES6ImportExportSpecifierAlias) {
            ResolveResult[] newResults2 = ResolveResultSink.getResultsForSpecifierAlias((ES6ImportExportSpecifierAlias)element);
            if (newResults2 != null) {
                return newResults2;
            }
        } else if (element instanceof ES6ImportedBinding && (newResults = ResolveResultSink.getResultsForImportedBinding((JSNamedElement)element)) != null) {
            return newResults;
        }
        return null;
    }

    @Nullable
    private static ResolveResult[] getResultsForImportedBinding(@NotNull JSNamedElement element) {
        List<Object> elements;
        String initializerReference;
        PsiElement psiElement;
        Collection referencedElements;
        if (element == null) {
            ResolveResultSink.$$$reportNull$$$0(5);
        }
        if ((referencedElements = ((ES6ImportedBinding)element).findReferencedElements()).size() == 1 && (psiElement = (PsiElement)referencedElements.iterator().next()) instanceof JSExportAssignment && (initializerReference = ((JSExportAssignment)psiElement).getInitializerReference()) != null && (elements = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(initializerReference, psiElement)).size() > 0) {
            ResolveResult[] newResults;
            if (elements.size() > 1 && elements.stream().allMatch(e -> e instanceof TypeScriptFunction)) {
                elements = elements.stream().filter(e -> !((TypeScriptFunction)e).isOverloadImplementation()).collect(Collectors.toList());
            }
            if ((newResults = ResolveResultSink.createAliasElementsFromResult(element, (ResolveResult[])elements.stream().map(e -> new JSResolveResult((PsiElement)e)).toArray(ResolveResult[]::new))) != null) {
                return newResults;
            }
        }
        return null;
    }

    @Nullable
    private static ResolveResult[] getResultsForSpecifierAlias(@NotNull ES6ImportExportSpecifierAlias element) {
        ResolveResult[] newResults;
        ES6ImportExportSpecifier specifier;
        if (element == null) {
            ResolveResultSink.$$$reportNull$$$0(6);
        }
        if ((specifier = element.findSpecifierElement()) != null && (newResults = ResolveResultSink.createAliasElementsFromResult((JSNamedElement)element, specifier.multiResolve(false))) != null) {
            return newResults;
        }
        return null;
    }

    @Nullable
    private static ResolveResult[] createAliasElementsFromResult(@NotNull JSNamedElement element, @NotNull ResolveResult[] results) {
        String name;
        if (element == null) {
            ResolveResultSink.$$$reportNull$$$0(7);
        }
        if (results == null) {
            ResolveResultSink.$$$reportNull$$$0(8);
        }
        if ((name = element.getName()) != null && results.length > 1) {
            return TypeScriptImplicitOverloadedAliasElement.wrapElements(results, name, element);
        }
        return null;
    }

    @Nullable
    @Contract(value="null -> null")
    private static List<PsiElement> mergeElementsIfNeeded(@Nullable List<PsiElement> elements) {
        JSRecordType.IndexSignature indexer;
        if (elements == null || elements.size() == 0 || !elements.stream().allMatch(e -> e instanceof TypeScriptImplicitMemberForComputedProperty && ((TypeScriptImplicitMemberForComputedProperty)e).isTemporary())) {
            return elements;
        }
        TypeScriptImplicitMemberForComputedProperty element = (TypeScriptImplicitMemberForComputedProperty)elements.get(0);
        String name = element.getName();
        if (name == null) {
            return elements;
        }
        PsiElement explicitElement = element.getExplicitElement();
        if (explicitElement == null) {
            return elements;
        }
        PsiElement parent = explicitElement.getParent();
        if (!(parent instanceof JSObjectLiteralExpression)) {
            return elements;
        }
        JSType type = JSResolveUtil.getExpressionJSType((JSExpression)parent);
        if (type instanceof JSRecordType && (indexer = ((JSRecordType)type).findIndexer(JSRecordType.IndexSignatureKind.STRING)) != null) {
            return ContainerUtil.createMaybeSingletonList((Object)((Object)new TypeScriptImplicitMemberForComputedPropertyImpl(name, indexer.getMemberType(), parent, false)));
        }
        return elements;
    }

    @NotNull
    public List<JSResolveResultForSymbolProcessor> getFilteredResults() {
        int i;
        List<PsiElement> processorResults = ResolveResultSink.mergeElementsIfNeeded(super.getResults());
        if (processorResults == null || processorResults.isEmpty()) {
            List<JSResolveResultForSymbolProcessor> list = Collections.emptyList();
            if (list == null) {
                ResolveResultSink.$$$reportNull$$$0(9);
            }
            return list;
        }
        SmartList results = new SmartList();
        THashSet completeResults = new THashSet();
        for (i = 0; i < processorResults.size(); ++i) {
            PsiElement processorResult = processorResults.get(i);
            JSSinkResolveStatus resolveStatus = this.myResolveStatus.get(i);
            if (!resolveStatus.myIsComplete || resolveStatus.getResolveProblem() != null || !completeResults.add(Pair.create((Object)processorResult, (Object)resolveStatus))) continue;
            ResolveResultSink.fillResults(processorResult, resolveStatus, this.getNestingLevelForResultElement(processorResult, i), (List<JSResolveResultForSymbolProcessor>)results);
        }
        if (results.isEmpty()) {
            for (i = 0; i < processorResults.size(); ++i) {
                JSSinkResolveStatus resolveStatus = this.myResolveStatus.get(i);
                if (resolveStatus.myIsComplete && resolveStatus.getResolveProblem() == null) continue;
                PsiElement element = processorResults.get(i);
                ResolveResultSink.fillResults(element, resolveStatus, this.getNestingLevelForResultElement(element, i), (List<JSResolveResultForSymbolProcessor>)results);
            }
        }
        SmartList smartList = results;
        if (smartList == null) {
            ResolveResultSink.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private static void fillResults(@NotNull PsiElement element, @NotNull JSSinkResolveStatus sinkResolveStatus, int nestingLevel, @NotNull List<JSResolveResultForSymbolProcessor> outResults) {
        Object[] resolvedImports;
        if (element == null) {
            ResolveResultSink.$$$reportNull$$$0(11);
        }
        if (sinkResolveStatus == null) {
            ResolveResultSink.$$$reportNull$$$0(12);
        }
        if (outResults == null) {
            ResolveResultSink.$$$reportNull$$$0(13);
        }
        if ((resolvedImports = ResolveResultSink.resolveImportExportSpecifiers(element)) != null && resolvedImports.length > 0 && resolvedImports[0].isValidResult()) {
            JSElement importElement = element instanceof JSElement ? (JSElement)element : null;
            outResults.addAll(ContainerUtil.map((Object[])resolvedImports, r -> {
                if (sinkResolveStatus == null) {
                    ResolveResultSink.$$$reportNull$$$0(14);
                }
                JSResolveResult first = new JSResolveResult(r.getElement(), new JSResolveStatus(importElement, sinkResolveStatus.getResolveProblem(), sinkResolveStatus.getTypeSubstitutor()));
                return new JSResolveResultForSymbolProcessor(first, true, nestingLevel);
            }));
        } else {
            JSResolveResult first = new JSResolveResult(element, sinkResolveStatus.myResolveStatus);
            outResults.add(new JSResolveResultForSymbolProcessor(first, sinkResolveStatus.myIsComplete, nestingLevel));
        }
    }

    @Override
    public void addCandidateResult(PsiElement element, boolean isCompleteMatch, @Nullable String problemKey) {
        if (this.myCandidateResults == null) {
            this.myCandidateResults = new THashSet();
        }
        if (!this.myCandidateResults.add(element)) {
            return;
        }
        super.addResult(element, null, null);
        if (this.myResolveStatus == null) {
            this.myResolveStatus = new SmartList();
        }
        this.myResolveStatus.add(new JSSinkResolveStatus(null, isCompleteMatch, problemKey, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sinkResolveStatus";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/ResolveResultSink";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "checkQualifiedNameHasNecessaryImport";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultsAsResolveResults";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResultsForImportedBinding";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResultsForSpecifierAlias";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAliasElementsFromResult";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fillResults";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillResults$8";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class JSResolveResultForSymbolProcessor {
        final ResolveResult resolveResult;
        final boolean isCompleteMatch;
        final int nestingLevel;

        public JSResolveResultForSymbolProcessor(ResolveResult resolveResult, boolean isCompleteMatch, int nestingLevel) {
            this.resolveResult = resolveResult;
            this.isCompleteMatch = isCompleteMatch;
            this.nestingLevel = nestingLevel;
        }
    }
}

