/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeResolvedHashCodeUtil;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure,
JSFunctionType {
    @NotNull
    private final List<JSParameterTypeDecorator> myParameters;
    @Nullable
    private final JSType myThisType;
    @Nullable
    private final JSType myNewType;
    @Nullable
    private final JSType myReturnType;

    public JSFunctionTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSParameterTypeDecorator> parameters, @Nullable JSType returnType) {
        if (source == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(1);
        }
        this(source, parameters, returnType, null, null);
    }

    public JSFunctionTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSParameterTypeDecorator> parameters, @Nullable JSType returnType, @Nullable JSType thisType, @Nullable JSType newType) {
        if (source == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(3);
        }
        super(source);
        this.myParameters = Collections.unmodifiableList(parameters);
        this.myReturnType = returnType;
        this.myThisType = thisType;
        this.myNewType = newType;
    }

    public JSFunctionTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(4);
        }
        if (inputStream == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(5);
        }
        super(source);
        this.myParameters = JSTypeSerializer.PARAMETER_LIST.read(source, inputStream);
        this.myThisType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
        this.myNewType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
        this.myReturnType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(6);
        }
        super.serialize(outputStream);
        JSTypeSerializer.PARAMETER_LIST.write(this.myParameters, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myThisType, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myNewType, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myReturnType, outputStream);
    }

    @NotNull
    public final String getTypeText(JSType.TypeTextFormat format) {
        String string = this.getTypeText(format, true);
        if (string == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return Objects.hash(((Object)((Object)this)).getClass(), JSTypeResolvedHashCodeUtil.getResolvedHashCodeSafe(this.getNewType()), JSTypeResolvedHashCodeUtil.getResolvedHashCodeSafe(this.getThisType()), JSTypeResolvedHashCodeUtil.getResolvedHashCodeSafe(this.getReturnType()), JSTypeResolvedHashCodeUtil.getResolvedHashCodeForDecorators(this.getParameters()));
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format, boolean defaultPresentation) {
        boolean typeScriptCodeFormat;
        if (format == JSType.TypeTextFormat.CODE && this.isEcma()) {
            if ("Function" == null) {
                JSFunctionTypeImpl.$$$reportNull$$$0(8);
            }
            return "Function";
        }
        boolean bl = typeScriptCodeFormat = (format == JSType.TypeTextFormat.CODE || format == JSType.TypeTextFormat.PRESENTABLE) && this.isTypeScript();
        if (format == JSType.TypeTextFormat.RESOLVED) {
            if ("Function" == null) {
                JSFunctionTypeImpl.$$$reportNull$$$0(9);
            }
            return "Function";
        }
        StringBuilder builder = new StringBuilder();
        if (!typeScriptCodeFormat && defaultPresentation) {
            builder.append("function");
        }
        builder.append("(");
        String prefix = "";
        if (this.myThisType != null) {
            builder.append("this:");
            JSFunctionTypeImpl.appendAndWrapIfNeed(builder, this.myThisType, format);
            prefix = ", ";
        }
        if (this.myNewType != null && !typeScriptCodeFormat) {
            builder.append(prefix);
            builder.append("new:");
            JSFunctionTypeImpl.appendAndWrapIfNeed(builder, this.myNewType, format);
            prefix = ", ";
        }
        int pIndex = 1;
        for (JSParameterTypeDecorator decorator : this.myParameters) {
            JSType parameter = this.getParameterType(decorator, format);
            builder.append(prefix);
            if (typeScriptCodeFormat) {
                if (decorator.isRest()) {
                    builder.append("...");
                }
                builder.append(this.getParameterName(pIndex++));
                if (decorator.isOptional()) {
                    builder.append("?");
                }
                if (parameter == null) {
                    prefix = ", ";
                    continue;
                }
                builder.append(": ");
            }
            if (decorator.isRest()) {
                assert (parameter != null);
                if (typeScriptCodeFormat) {
                    builder.append(parameter.getTypeText(format));
                    if (!(parameter instanceof JSTupleType) && !(parameter instanceof JSGenericTypeImpl)) {
                        builder.append("[]");
                    }
                } else {
                    builder.append("...[");
                    builder.append(parameter.getTypeText(format));
                    builder.append("]");
                }
            } else {
                if (parameter == null) {
                    parameter = JSAnyType.getWithLanguage(this.getSource().getLanguage(), false);
                }
                JSFunctionTypeImpl.appendAndWrapIfNeed(builder, parameter, format);
            }
            if (decorator.isOptional() && !typeScriptCodeFormat) {
                builder.append("=");
            }
            prefix = ", ";
        }
        builder.append(")");
        JSType returnType = this.myReturnType;
        if (returnType == null && typeScriptCodeFormat && defaultPresentation) {
            returnType = JSAnyType.getWithLanguage(this.getSource().getLanguage(), true);
        }
        if (returnType != null) {
            builder.append(typeScriptCodeFormat && defaultPresentation ? " => " : this.getTypeSeparator());
            JSFunctionTypeImpl.appendAndWrapIfNeed(builder, returnType, format);
        }
        String string = builder.toString();
        if (string == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public List<Pair<String, JSParameterTypeDecorator>> getParametersWithName() {
        ArrayList result2 = ContainerUtil.newArrayList();
        int i = 1;
        for (JSParameterTypeDecorator decorator : this.getParameters()) {
            result2.add(Pair.create((Object)this.getParameterName(i++), (Object)decorator));
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public List<Pair<String, JSParameterTypeDecorator>> getParametersWithNameOrGenerated() {
        ArrayList result2 = ContainerUtil.newArrayList();
        int i = 1;
        for (JSParameterTypeDecorator decorator : this.getParameters()) {
            String name = this.getParameterName(i);
            result2.add(Pair.create((Object)(!StringUtil.isEmpty((String)name) ? name : "p" + i), (Object)decorator));
            ++i;
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @Nullable
    protected JSType getParameterType(@NotNull JSParameterTypeDecorator decorator, @NotNull JSType.TypeTextFormat format) {
        JSType parameter;
        if (decorator == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(13);
        }
        if (format == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(14);
        }
        if ((parameter = decorator.getType()) == null) {
            parameter = JSAnyType.get((PsiElement)this.getScope(), false);
        }
        return parameter;
    }

    @Nullable
    protected String getParameterName(int index) {
        return null;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(15);
        }
        if (processingContext == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(16);
        }
        if (elementType instanceof JSFunctionTypeImpl) {
            JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)elementType;
            if (this.isTypeScript()) {
                JSRecordType recordType = this.asRecordType();
                return recordType.isDirectlyAssignableType(elementType, processingContext);
            }
            if (this.myThisType != null && functionType.myThisType != null && !this.myThisType.isDirectlyAssignableType(functionType.myThisType, processingContext)) {
                return false;
            }
            if (this.myNewType != null && functionType.myNewType != null && !this.myNewType.isDirectlyAssignableType(functionType.myNewType, processingContext)) {
                return false;
            }
            if (this.myReturnType != null && functionType.myReturnType != null && !this.myReturnType.isDirectlyAssignableType(functionType.myReturnType, processingContext)) {
                return false;
            }
            return JSTypeUtils.areArgumentsAssignable(functionType.getParameters(), this.getParameters(), processingContext, true, true, false);
        }
        if (elementType instanceof JSRecordType) {
            JSRecordType recordType = (JSRecordType)elementType;
            for (JSRecordType.CallSignature typeMember : recordType.getCallSignatures()) {
                if (typeMember.hasNew() || !this.isDirectlyAssignableType((JSType)typeMember.getFunctionType(), processingContext)) continue;
                return true;
            }
            return false;
        }
        if (elementType instanceof JSTypeImpl || elementType instanceof JSGenericTypeImpl) {
            JSType resolvedElementType;
            if (elementType instanceof JSTypeImpl && ((JSTypeImpl)elementType).inheritsFunction()) {
                return true;
            }
            if (this.isTypeScript() && (resolvedElementType = elementType.substitute()) != elementType) {
                return this.isDirectlyAssignableType(resolvedElementType, processingContext);
            }
        } else if (elementType instanceof JSPrimitiveFunctionType || elementType instanceof JSNullType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private static void appendAndWrapIfNeed(@NotNull StringBuilder builder, @NotNull JSType type, @NotNull JSType.TypeTextFormat format) {
        boolean isNeedWrap;
        if (builder == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(17);
        }
        if (type == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(18);
        }
        if (format == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(19);
        }
        if (isNeedWrap = type instanceof JSUnionOrIntersectionType) {
            builder.append("(");
        }
        builder.append(type.getTypeText(format));
        if (isNeedWrap) {
            builder.append(")");
        }
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(20);
        }
        if (type instanceof JSFunctionTypeImpl) {
            JSFunctionTypeImpl functionType = (JSFunctionTypeImpl)type;
            if (this.myThisType != null && !this.myThisType.isEquivalentTo(functionType.getThisType(), processingContext, allowResolve)) {
                return false;
            }
            if (this.myNewType != null && !this.myNewType.isEquivalentTo(functionType.getNewType(), processingContext, allowResolve)) {
                return false;
            }
            if (this.myReturnType != null && !this.myReturnType.isEquivalentTo(functionType.getReturnType(), processingContext, allowResolve)) {
                return false;
            }
            Iterator<JSParameterTypeDecorator> iterator = functionType.getParameters().iterator();
            for (JSParameterTypeDecorator p : this.getParameters()) {
                if (!iterator.hasNext()) {
                    return false;
                }
                JSParameterTypeDecorator next = iterator.next();
                JSType paramType = p.getType();
                if (p.isOptional() == next.isOptional() && p.isRest() == next.isRest() && p.isExplicitlyDeclared() == next.isExplicitlyDeclared() && (paramType != null || next.getType() == null) && (paramType == null || paramType.isEquivalentTo(next.getType(), processingContext, allowResolve))) continue;
                return false;
            }
            return !iterator.hasNext();
        }
        return false;
    }

    @NotNull
    public List<JSParameterTypeDecorator> getParameters() {
        List<JSParameterTypeDecorator> list = this.myParameters;
        if (list == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public final JSFunctionType copyWithReturnType(@NotNull JSType newReturnType) {
        if (newReturnType == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(22);
        }
        if (newReturnType.isEquivalentTo(this.myReturnType, null)) {
            JSFunctionTypeImpl jSFunctionTypeImpl = this;
            if (jSFunctionTypeImpl == null) {
                JSFunctionTypeImpl.$$$reportNull$$$0(23);
            }
            return jSFunctionTypeImpl;
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = this.createType(this.getSource(), (Function<JSType, JSType>)Functions.id(), this.myParameters, this.myNewType, newReturnType, this.myThisType, true);
        if (jSFunctionTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(24);
        }
        return jSFunctionTypeImpl;
    }

    @Nullable
    public JSType getThisType() {
        return this.myThisType;
    }

    @Nullable
    public JSType getNewType() {
        return this.myNewType;
    }

    @Nullable
    public JSType getReturnType() {
        return this.myReturnType;
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSFunctionType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        if (this.myNewType != null) {
            this.myNewType.accept(visitor);
        }
        if (this.myReturnType != null) {
            this.myReturnType.accept(visitor);
        }
        if (this.myThisType != null) {
            this.myThisType.accept(visitor);
        }
        for (JSParameterTypeDecorator parameter : this.myParameters) {
            JSType type = parameter.getType();
            if (type == null) continue;
            type.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(25);
        }
        JSType oldNewType = this.getNewType();
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(oldNewType, childTransform);
        JSType oldReturnType = this.getReturnType();
        JSType returnType = JSTypeUtils.transformTypeHierarchySafe(oldReturnType, childTransform);
        JSType oldThis = this.getThisType();
        JSType thisType = JSTypeUtils.transformTypeHierarchySafe(oldThis, childTransform);
        boolean hasChangedParameterDecorator = false;
        ArrayList<JSParameterTypeDecorator> newParameters = new ArrayList<JSParameterTypeDecorator>();
        for (JSParameterTypeDecorator p : this.getParameters()) {
            JSType newParamType;
            JSType oldParamType = p.getType();
            if (oldParamType == (newParamType = JSTypeUtils.transformTypeHierarchySafe(oldParamType, childTransform))) {
                newParameters.add(p);
                continue;
            }
            newParameters.add(new JSParameterTypeDecoratorImpl(newParamType, p.isOptional(), p.isRest(), p.isExplicitlyDeclared()));
            hasChangedParameterDecorator = true;
        }
        boolean hasChanges = hasChangedParameterDecorator || oldNewType != newType || oldReturnType != returnType || oldThis != thisType;
        JSFunctionTypeImpl jSFunctionTypeImpl = this.createType(this.getSource(), childTransform, newParameters, newType, returnType, thisType, hasChanges);
        if (jSFunctionTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(26);
        }
        return jSFunctionTypeImpl;
    }

    @NotNull
    protected JSFunctionTypeImpl createType(@NotNull JSTypeSource newSource, @NotNull Function<JSType, JSType> childTransform, @NotNull List<JSParameterTypeDecorator> newParameters, @Nullable JSType newType, @Nullable JSType returnType, @Nullable JSType thisType, boolean hasChanges) {
        if (newSource == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(27);
        }
        if (childTransform == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(28);
        }
        if (newParameters == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(29);
        }
        if (!hasChanges) {
            JSFunctionTypeImpl jSFunctionTypeImpl = this;
            if (jSFunctionTypeImpl == null) {
                JSFunctionTypeImpl.$$$reportNull$$$0(30);
            }
            return jSFunctionTypeImpl;
        }
        if (returnType instanceof JSFreshObjectLiteralType) {
            returnType = ((JSFreshObjectLiteralType)returnType).removeFreshness();
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(newSource, newParameters, returnType, thisType, newType);
        if (jSFunctionTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(31);
        }
        return jSFunctionTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(32);
        }
        JSFunctionTypeImpl jSFunctionTypeImpl = new JSFunctionTypeImpl(source, this.getParameters(), this.getReturnType(), this.getThisType(), this.getNewType());
        if (jSFunctionTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(33);
        }
        return jSFunctionTypeImpl;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordTypeImpl.CallSignatureImpl callSignature = new JSRecordTypeImpl.CallSignatureImpl(false, this);
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), Collections.singletonList(callSignature));
        if (jSRecordTypeImpl == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(34);
        }
        return jSRecordTypeImpl;
    }

    @Nullable
    public JSQualifiedName getQualifiedName() {
        return JSQualifiedNameImpl.create("Function", null);
    }

    @NotNull
    public String getDefaultValue() {
        StringBuilder function = new StringBuilder("function(");
        int i = 1;
        for (JSParameterTypeDecorator parameter : this.getParameters()) {
            function.append("p").append(i);
            JSType type = parameter.getType();
            if (type != null && DialectDetector.hasFeature((PsiElement)this.getSource().getScope(), JSLanguageFeature.TYPES)) {
                String typeText = type.getTypeText(JSType.TypeTextFormat.CODE);
                function.append(": ").append(typeText);
            }
            function.append(",");
            ++i;
        }
        JSType returnT = this.getReturnType();
        String returnType = returnT != null && !(returnT instanceof JSVoidType) && !(returnT instanceof JSAnyType) ? "return " + JSTypeUtils.defaultValueOfType(returnT) + ";" : "";
        String string = StringUtil.trimEnd((String)function.toString(), (String)",") + "){" + returnType + "}";
        if (string == null) {
            JSFunctionTypeImpl.$$$reportNull$$$0(35);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newReturnType";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSFunctionTypeImpl";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersWithName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersWithNameOrGenerated";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithReturnType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendAndWrapIfNeed";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "copyWithReturnType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 23: 
            case 24: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

