/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.types.JSTypeResolvedHashCodeUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeSubstitutorType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeofTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import gnu.trove.TIntObjectHashMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenericTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure {
    @NotNull
    private final JSType myType;
    @NotNull
    private final NotNullLazyValue<List<JSType>> myArgumentsLazy;
    @NotNull
    private final List<JSType> myOriginalArguments;
    @NotNull
    private final JSTypeSubstitutor myOuterArguments;

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @Nullable JSTypeSubstitutor outer) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(1);
        }
        this(source, type, (List<JSType>)ContainerUtil.immutableList((Object[])new JSType[0]), (JSTypeSubstitutor)ObjectUtils.coalesce((Object)outer, (Object)JSTypeSubstitutor.EMPTY));
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull JSType argument) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(2);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(3);
        }
        if (argument == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(4);
        }
        this(source, type, (List<JSType>)ContainerUtil.immutableList((Object[])new JSType[]{argument}), JSTypeSubstitutor.EMPTY);
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, List<JSType> arguments) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(5);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(6);
        }
        this(source, type, arguments, JSTypeSubstitutor.EMPTY);
    }

    protected JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(7);
        }
        if (inputStream == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(8);
        }
        this(source, JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream), JSTypeSerializer.TYPES_SERIALIZER.read(source, inputStream), JSTypeSubstitutor.EMPTY);
    }

    public JSGenericTypeImpl(@NotNull JSTypeSource source, @NotNull JSType type, @NotNull List<JSType> arguments, @NotNull JSTypeSubstitutor outer) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(9);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(10);
        }
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(11);
        }
        if (outer == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(12);
        }
        super(source);
        this.myType = type;
        this.myOriginalArguments = ContainerUtil.immutableList(arguments);
        this.myArgumentsLazy = NotNullLazyValue.createValue(this::computeActualArguments);
        this.myOuterArguments = outer;
    }

    @NotNull
    private ImmutableList<JSType> computeActualArguments() {
        ImmutableList immutableList = ContainerUtil.immutableList(JSGenericTypeImpl.fixArguments(this.myOriginalArguments, this.myType));
        if (immutableList == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(13);
        }
        return immutableList;
    }

    @NotNull
    private static List<JSType> fixArguments(@NotNull List<JSType> arguments, @NotNull JSType type) {
        if (arguments == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(14);
        }
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(15);
        }
        ArrayList newArgs = ContainerUtil.newArrayListWithCapacity((int)arguments.size());
        PsiElement sourceElement = type.getSource().getSourceElement();
        List typeParameterNames = null;
        if (sourceElement instanceof TypeScriptTypeParameterListOwner) {
            typeParameterNames = Arrays.stream(((TypeScriptTypeParameterListOwner)sourceElement).getTypeParameters()).map(p -> p.getName()).collect(Collectors.toList());
        }
        TIntObjectHashMap toInsert = new TIntObjectHashMap();
        for (JSType arg : arguments) {
            if (arg instanceof JSNamedTypeSubstitutorType) {
                int index;
                if (typeParameterNames == null || (index = typeParameterNames.indexOf(((JSNamedTypeSubstitutorType)arg).getGenericName())) == -1) continue;
                toInsert.put(index, (Object)((JSNamedTypeSubstitutorType)arg).getRealType());
                continue;
            }
            newArgs.add(arg);
        }
        int[] keys = toInsert.keys();
        Arrays.sort(keys);
        for (int key : keys) {
            if (key < newArgs.size()) continue;
            newArgs.add(toInsert.get(key));
        }
        ArrayList arrayList = newArgs;
        if (arrayList == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(17);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myType, outputStream);
        JSTypeSerializer.TYPES_SERIALIZER.write(this.myOriginalArguments, outputStream);
    }

    @Override
    public void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSGenericType((JSType)this);
    }

    @Override
    public void acceptChildren(JSRecursiveTypeVisitor visitor) {
        this.myType.accept(visitor);
        for (JSType argument : this.getArguments()) {
            argument.accept(visitor);
        }
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        StringBuilder builder = new StringBuilder();
        if (!this.isTypeScript()) {
            boolean wrapInBraces = JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
            if (wrapInBraces) {
                builder.append("(");
            }
            builder.append(this.myType.getTypeText(format));
            if (wrapInBraces) {
                builder.append(")");
            }
            if (this.getSource().getLanguage() == JSTypeSource.SourceLanguage.AS) {
                builder.append('.');
            }
            this.appendArgumentTypeText(format, builder);
        } else {
            boolean isNestedFunctionType = this.myType instanceof JSFunctionTypeImpl;
            if (isNestedFunctionType) {
                this.appendArgumentTypeText(format, builder);
                builder.append(this.myType.getTypeText(format));
            } else {
                builder.append(this.myType.getTypeText(format));
                this.appendArgumentTypeText(format, builder);
            }
        }
        String string = builder.toString();
        if (string == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        int arguments = JSTypeResolvedHashCodeUtil.getResolvedHashCode(this.getArguments());
        int desc = Objects.hash(((Object)((Object)this)).getClass(), this.getType().resolvedHashCode(), arguments);
        JSTypeSubstitutor outer = this.getOuterArguments();
        if (outer.isEmpty()) {
            return desc;
        }
        int outerKeys = JSTypeResolvedHashCodeUtil.getHashCode(outer.keys());
        int outerValues = JSTypeResolvedHashCodeUtil.getResolvedHashCode(outer.types());
        return Objects.hash(desc, outerKeys, outerValues);
    }

    private void appendArgumentTypeText(@NotNull JSType.TypeTextFormat format, @NotNull StringBuilder builder) {
        if (format == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(19);
        }
        if (builder == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(20);
        }
        builder.append("<");
        String prefix = "";
        for (JSType argument : this.myOriginalArguments) {
            builder.append(prefix);
            builder.append(argument.getTypeText(format));
            prefix = ", ";
        }
        builder.append(">");
    }

    @Override
    @Nullable
    public JSClass resolveClass() {
        return this.myType.resolveClass();
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(21);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(22);
        }
        if (this.isTypeScript()) {
            return this.isDirectAssignableTypeInTypeScript(elementType, processingContext);
        }
        if (elementType instanceof JSGenericTypeImpl) {
            if (!this.myType.isDirectlyAssignableType(((JSGenericTypeImpl)elementType).myType, processingContext)) {
                return false;
            }
            List<JSType> elementTypeArgs = ((JSGenericTypeImpl)elementType).getArguments();
            ListIterator<JSType> iterator = elementTypeArgs.listIterator();
            boolean allArgumentsEquivalent = true;
            for (JSType argument : this.getArguments()) {
                allArgumentsEquivalent &= iterator.hasNext() && this.jsOrASGenericsCompatible(argument, iterator.next(), processingContext);
            }
            return allArgumentsEquivalent && !iterator.hasNext();
        }
        if (JSGenericTypeImpl.isGenericActionScriptVectorType(this) && !(elementType instanceof JSNullType) && !(elementType instanceof JSAnyType)) {
            return false;
        }
        if (elementType instanceof JSArrayTypeImpl) {
            return this.isDirectlyAssignableType(((JSArrayTypeImpl)elementType).asGenericType(), processingContext);
        }
        if (elementType instanceof JSTypeofTypeImpl) {
            return this.isDirectlyAssignableType(elementType.substitute(), processingContext);
        }
        return this.myType.isDirectlyAssignableType(elementType, processingContext);
    }

    private boolean isDirectAssignableTypeInTypeScript(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult type;
        JSType typedef;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(23);
        }
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        if (elementType instanceof JSTypeImpl && (typedef = ((JSTypeImpl)elementType).getTypedef(null, processingContext)) != null) {
            elementType = typedef;
        }
        if (elementType instanceof JSTupleType) {
            return this.isDirectlyAssignableType(((JSTupleType)elementType).toArrayType(true), processingContext);
        }
        if (elementType instanceof JSArrayType) {
            elementType = ((JSArrayType)elementType).asGenericType();
        } else {
            JSType resolved;
            if (elementType instanceof JSCompositeTypeImpl) {
                JSCompositeTypeImpl composite = (JSCompositeTypeImpl)elementType;
                boolean isAssignable = true;
                for (JSType type2 : composite.getTypes()) {
                    if (this.isDirectlyAssignableType(type2, processingContext)) continue;
                    isAssignable = false;
                    break;
                }
                return isAssignable;
            }
            if (elementType instanceof JSRecordType && this != (resolved = this.substitute())) {
                return resolved.isDirectlyAssignableType(elementType, processingContext);
            }
        }
        if ((elementType instanceof JSGenericTypeImpl || elementType instanceof JSNamedType) && (type = this.isDirectlyAssignableGenericType(elementType, processingContext)).isStrict()) {
            return type.isAssignable();
        }
        JSType elemType = elementType;
        JSType resolved = this.substitute();
        if (resolved != this) {
            JSResolvedTypeId rTypeNestedId = (elementType instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)elementType).getType() : elementType).getResolvedTypeId();
            JSResolvedTypeId lTypeNestedId = this.getType().getResolvedTypeId();
            ProcessingContext finalProcessingContext = processingContext;
            return JSRecursiveTypeUtil.computeWithRecursiveTypes(lTypeNestedId, rTypeNestedId, JSRecursiveTypeUtil.GENERICS_SUBSTITUTION, processingContext, (Getter<Boolean>)((Getter)() -> resolved.isDirectlyAssignableType(elemType, finalProcessingContext)));
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result2;
        if (elementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(24);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(25);
        }
        if ((result2 = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result2;
            if (assignableResult == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(26);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.myType.isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(27);
        }
        return assignableResult;
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(28);
        }
        if (type instanceof JSGenericTypeImpl) {
            if (!this.myType.isEquivalentTo(((JSGenericTypeImpl)type).myType, processingContext, allowResolve)) {
                return false;
            }
            return JSGenericTypeImpl.areGenericArgumentsAssignable(this, (JSGenericTypeImpl)type, processingContext, true, allowResolve) == JSTypeCastUtil.AssignableResult.ASSIGNABLE;
        }
        return false;
    }

    private boolean jsOrASGenericsCompatible(@NotNull JSType type1, @NotNull JSType type2, @Nullable ProcessingContext processingContext) {
        if (type1 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(29);
        }
        if (type2 == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(30);
        }
        if (type1.isEquivalentTo(type2, processingContext)) {
            return true;
        }
        if (this.isEcma()) {
            return false;
        }
        if ("Array".equals(JSTypeUtils.getQualifiedNameMatchingType(this.myType, false))) {
            return type1.isDirectlyAssignableType(type2, processingContext);
        }
        return type1.isDirectlyAssignableType(type2, processingContext) || type2.isDirectlyAssignableType(type1, processingContext);
    }

    private JSTypeCastUtil.AssignableResult isDirectlyAssignableGenericType(@NotNull JSType rElementType, @NotNull ProcessingContext processingContext) {
        boolean isSameMainType;
        boolean isGenericType;
        JSType rMainType;
        if (rElementType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(31);
        }
        if (processingContext == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(32);
        }
        if (rElementType instanceof JSNamedType) {
            rMainType = rElementType;
            isGenericType = false;
        } else if (rElementType instanceof JSGenericTypeImpl) {
            rMainType = ((JSGenericTypeImpl)rElementType).myType;
            isGenericType = true;
        } else {
            return JSTypeCastUtil.AssignableResult.NOT_SURE;
        }
        boolean bl = isSameMainType = isGenericType && this.myType.isEquivalentTo(rMainType, processingContext);
        if (isSameMainType) {
            JSTypeCastUtil.AssignableResult assignableResult = JSGenericTypeImpl.areGenericArgumentsAssignable(this, (JSGenericTypeImpl)rElementType, processingContext, false, true);
            if (assignableResult.isAssignable() || !assignableResult.isStrict()) {
                return JSTypeCastUtil.AssignableResult.ASSIGNABLE;
            }
            if (this.myType instanceof JSPrimitiveArrayType && rMainType instanceof JSPrimitiveArrayType) {
                return JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
            }
        } else if (rMainType instanceof JSNamedType && this.myType instanceof JSNamedType) {
            Collection<? extends PsiElement> lOpElements = TypeScriptTypeParser.resolveElementsByType(this.myType);
            Collection<? extends PsiElement> rOpElements = TypeScriptTypeParser.resolveElementsByType(rMainType);
            for (PsiElement psiElement : lOpElements) {
                for (PsiElement psiElement2 : rOpElements) {
                    JSClass lParent;
                    JSClass rChild;
                    if (!(psiElement instanceof JSClass) || !(psiElement2 instanceof JSClass) || !JSInheritanceUtil.isParentClass(rChild = (JSClass)psiElement2, lParent = (JSClass)psiElement, false)) continue;
                    TypeScriptTypeParameterList lParameters = ((TypeScriptTypeParameterListOwner)lParent).getTypeParameterList();
                    JSTypeCastUtil.AssignableResult result2 = JSTypeCastUtil.AssignableResult.NOT_SURE;
                    if (lParameters != null) {
                        JSGenericTypeImpl guessedType;
                        JSTypeSource source = rMainType.getSource();
                        ArrayList rawGenerics = ContainerUtil.newArrayList();
                        for (TypeScriptTypeParameter parameter : lParameters.getTypeParameters()) {
                            String name = parameter.getName();
                            TypeScriptGenericParameterImpl toCheck = new TypeScriptGenericParameterImpl(TypeScriptTypeParser.getTypeParameterId(parameter), source, null);
                            if (name == null) continue;
                            rawGenerics.add(toCheck);
                        }
                        List<JSType> typeArgumentsList = isGenericType ? ((JSGenericTypeImpl)rElementType).getArguments() : ContainerUtil.emptyList();
                        JSType type = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(rChild, typeArgumentsList, lParent, guessedType = new JSGenericTypeImpl(rMainType.getSource(), rMainType, rawGenerics));
                        if (type instanceof JSGenericTypeImpl) {
                            result2 = JSGenericTypeImpl.areGenericArgumentsAssignable(this, (JSGenericTypeImpl)type, processingContext, false, true);
                        }
                    }
                    return result2;
                }
            }
        }
        return JSTypeCastUtil.AssignableResult.NOT_SURE;
    }

    private static JSTypeCastUtil.AssignableResult areGenericArgumentsAssignable(@NotNull JSGenericTypeImpl lType, @NotNull JSGenericTypeImpl rType, @Nullable ProcessingContext processingContext, boolean checkEquivalent, boolean allowResolve) {
        if (lType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(33);
        }
        if (rType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(34);
        }
        Iterator<JSType> iterator = rType.getArguments().iterator();
        for (JSType lArgument : lType.getArguments()) {
            if (!iterator.hasNext()) {
                return JSTypeCastUtil.AssignableResult.NOT_SURE;
            }
            JSType rArgument = iterator.next();
            if (!(checkEquivalent ? !lArgument.isEquivalentTo(rArgument, processingContext, allowResolve) : !lArgument.isDirectlyAssignableType(rArgument, processingContext))) continue;
            return JSTypeCastUtil.AssignableResult.NOT_ASSIGNABLE;
        }
        return iterator.hasNext() ? JSTypeCastUtil.AssignableResult.NOT_SURE : JSTypeCastUtil.AssignableResult.ASSIGNABLE;
    }

    public static boolean isGenericActionScriptVectorType(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSGenericTypeImpl && type.getSource().isEcma()) {
            JSGenericTypeImpl genericType = (JSGenericTypeImpl)type;
            String typeText = genericType.myType.getResolvedTypeText();
            return "Vector".equals(typeText) && genericType.getArguments().size() == 1;
        }
        return false;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(35);
        }
        return jSType;
    }

    @NotNull
    public List<JSType> getArguments() {
        List list = (List)this.myArgumentsLazy.getValue();
        if (list == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(36);
        }
        return list;
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(37);
        }
        JSType oldType = this.getType();
        JSType newType = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform);
        List<JSType> oldArgs = this.getArguments();
        List newArgs = ContainerUtil.map(oldArgs, type -> {
            if (childTransform == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(47);
            }
            return JSTypeUtils.transformTypeHierarchySafe(type, childTransform);
        });
        JSTypeSubstitutor oldOuterArgs = this.getOuterArguments();
        JSTypeSubstitutor newOuterArgs = null;
        boolean hasNewOuters = false;
        if (!oldOuterArgs.isEmpty()) {
            newOuterArgs = oldOuterArgs.transformValues(el -> {
                if (childTransform == null) {
                    JSGenericTypeImpl.$$$reportNull$$$0(46);
                }
                return JSTypeUtils.transformTypeHierarchySafe(el, childTransform);
            });
            boolean bl = hasNewOuters = oldOuterArgs != newOuterArgs;
        }
        if (!hasNewOuters && ContainerUtil.equalsIdentity(oldArgs, (List)newArgs) && oldType == newType) {
            JSGenericTypeImpl jSGenericTypeImpl = this;
            if (jSGenericTypeImpl == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(38);
            }
            return jSGenericTypeImpl;
        }
        if (newOuterArgs == null) {
            newOuterArgs = JSTypeSubstitutor.EMPTY;
        }
        if (newType instanceof JSGenericTypeImpl) {
            JSGenericTypeImpl newGenericType = (JSGenericTypeImpl)newType;
            JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(this.getSource(), newGenericType.getType(), newGenericType.getArguments(), newOuterArgs);
            if (jSGenericTypeImpl == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(39);
            }
            return jSGenericTypeImpl;
        }
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(this.getSource(), newType, newArgs, newOuterArgs);
        if (jSGenericTypeImpl == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(40);
        }
        return jSGenericTypeImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(41);
        }
        JSGenericTypeImpl jSGenericTypeImpl = new JSGenericTypeImpl(source, this.getType(), this.getArguments(), this.getOuterArguments());
        if (jSGenericTypeImpl == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(42);
        }
        return jSGenericTypeImpl;
    }

    @Override
    @NotNull
    public JSType substitute() {
        JSType type = this.getType();
        if (type instanceof TypeScriptGenericThisTypeImpl) {
            JSType jSType = new JSGenericTypeImpl(this.getSource(), type.substitute(), this.getArguments(), this.getOuterArguments()).substitute();
            if (jSType == null) {
                JSGenericTypeImpl.$$$reportNull$$$0(43);
            }
            return jSType;
        }
        JSType jSType = JSTypeImpl.expandTypeOrBuildRecordTypeWithCache(this);
        if (jSType == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(44);
        }
        return jSType;
    }

    @NotNull
    public JSTypeSubstitutor getOuterArguments() {
        JSTypeSubstitutor jSTypeSubstitutor = this.myOuterArguments;
        if (jSTypeSubstitutor == null) {
            JSGenericTypeImpl.$$$reportNull$$$0(45);
        }
        return jSTypeSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: 
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outer";
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 22: 
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rElementType";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 37: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSGenericTypeImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "computeActualArguments";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "fixArguments";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getOuterArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fixArguments";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendArgumentTypeText";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableTypeInTypeScript";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "jsOrASGenericsCompatible";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableGenericType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "areGenericArgumentsAssignable";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyTypeHierarchy$3";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$copyTypeHierarchy$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 16: 
            case 18: 
            case 26: 
            case 27: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

