/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSNumberLiteralTypeImpl
extends JSNumberType
implements JSPrimitiveLiteralType<Double> {
    private final double myLiteral;
    private final boolean myCanBeWidened;
    @Nullable
    private final String myValueAsString;

    /*
     * WARNING - void declaration
     */
    public JSNumberLiteralTypeImpl(double literal, boolean canBeWidened, @NotNull JSTypeSource source, @Nullable String string) {
        void valueAsString;
        if (source == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myCanBeWidened = canBeWidened;
        this.myValueAsString = valueAsString;
    }

    public JSNumberLiteralTypeImpl(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        if (inputStream == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(2);
        }
        super(typeSource, inputStream);
        this.myCanBeWidened = JSTypeSerializer.readBoolean(inputStream);
        String value = JSTypeSerializer.readString(inputStream);
        Double aDouble = JSNumberParser.tryParseNumericValue(value, false);
        this.myLiteral = aDouble != null ? aDouble : 0.0;
        this.myValueAsString = value;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myCanBeWidened, outputStream);
        JSTypeSerializer.writeString(this.getValueAsString(), outputStream);
    }

    @NotNull
    public String getValueAsString() {
        String string = this.myValueAsString != null ? this.myValueAsString : Double.toString(this.myLiteral);
        if (string == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public Double getLiteral() {
        return this.myLiteral;
    }

    @Override
    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String stringVal;
        if (format == JSType.TypeTextFormat.RESOLVED) {
            if ("Number" == null) {
                JSNumberLiteralTypeImpl.$$$reportNull$$$0(5);
            }
            return "Number";
        }
        String string = stringVal = this.myValueAsString != null ? this.myValueAsString : Double.toString(this.myLiteral);
        if (format == JSType.TypeTextFormat.PRESENTABLE || format == JSType.TypeTextFormat.CODE) {
            String string2 = this.isTypeScript() && (!this.canBeWidened() || format != JSType.TypeTextFormat.CODE) ? stringVal : "number";
            if (string2 == null) {
                JSNumberLiteralTypeImpl.$$$reportNull$$$0(6);
            }
            return string2;
        }
        String string3 = "Number(" + stringVal + ")";
        if (string3 == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        return string3;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        if (processingContext == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        if (elementType instanceof JSNumberLiteralTypeImpl && this.getSource().isStrict() && !this.myCanBeWidened) {
            return this.myLiteral == ((JSNumberLiteralTypeImpl)elementType).myLiteral;
        }
        if (!this.myCanBeWidened && elementType instanceof JSNumberType) {
            return false;
        }
        if (!this.myCanBeWidened && elementType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType.isEnumLiteral()) {
                TypeScriptEnumField field = resolvedType.getDeclarationOfType(TypeScriptEnumField.class);
                if (field == null) {
                    return false;
                }
                EnumConstantValue value = field.getConstantValue();
                Double numericValue = value.getNumericValue();
                return numericValue != null && numericValue == this.myLiteral;
            }
            if (resolvedType.isEnum()) {
                return false;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(10);
        }
        return type instanceof JSNumberLiteralTypeImpl && this.myLiteral == ((JSNumberLiteralTypeImpl)type).myLiteral;
    }

    @Override
    @NotNull
    public JSType asPrimitiveType() {
        JSType jSType = JSNamedType.createType("number", this.getSource(), this.getTypeContext());
        if (jSType == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSNumberLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(12);
        }
        JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = new JSNumberLiteralTypeImpl(this.getLiteral(), this.myCanBeWidened, source, this.myValueAsString);
        if (jSNumberLiteralTypeImpl == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(13);
        }
        return jSNumberLiteralTypeImpl;
    }

    @Override
    public boolean canBeWidened() {
        return this.myCanBeWidened;
    }

    @Override
    @NotNull
    public JSLiteralType copyWithCanBeWidened(boolean canBeWidened) {
        JSNumberLiteralTypeImpl jSNumberLiteralTypeImpl = new JSNumberLiteralTypeImpl(this.myLiteral, canBeWidened, this.getSource(), this.myValueAsString);
        if (jSNumberLiteralTypeImpl == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(14);
        }
        return jSNumberLiteralTypeImpl;
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        String string = this.getValueAsString();
        if (string == null) {
            JSNumberLiteralTypeImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSNumberLiteralTypeImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSNumberLiteralTypeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAsString";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "asPrimitiveType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithCanBeWidened";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

