/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecordTypeCache {
    @NotNull
    private final ConcurrentMap<JSResolvedTypeId, JSRecordType> myCache = ContainerUtil.createConcurrentWeakKeySoftValueMap();

    @NotNull
    public JSRecordType buildRecordType(@NotNull JSType type, @NotNull PsiElement context) {
        JSResolvedTypeId id;
        JSRecordType recordType;
        if (type == null) {
            JSRecordTypeCache.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSRecordTypeCache.$$$reportNull$$$0(1);
        }
        if ((recordType = (JSRecordType)this.myCache.get(id = type.getResolvedTypeId())) != null) {
            JSRecordType jSRecordType = JSRecordTypeCache.copyWithStrict(type, recordType);
            if (jSRecordType == null) {
                JSRecordTypeCache.$$$reportNull$$$0(2);
            }
            return jSRecordType;
        }
        JSRecordType candidate = JSRecordTypeCache.buildRecordTypeNoCache(type, context);
        if (candidate == null) {
            Object object = type.isJavaScript() ? JSTypeCastUtil.NO_RECORD_TYPE : new JSRecordTypeImpl(type.getSource(), ContainerUtil.emptyList());
            if (object == null) {
                JSRecordTypeCache.$$$reportNull$$$0(3);
            }
            return object;
        }
        JSRecordType oldResult = this.myCache.putIfAbsent(id, candidate);
        JSRecordType jSRecordType = oldResult == null ? candidate : JSRecordTypeCache.copyWithStrict(type, oldResult);
        if (jSRecordType == null) {
            JSRecordTypeCache.$$$reportNull$$$0(4);
        }
        return jSRecordType;
    }

    @NotNull
    private static JSRecordType copyWithStrict(@NotNull JSType original, @NotNull JSRecordType recordType) {
        if (original == null) {
            JSRecordTypeCache.$$$reportNull$$$0(5);
        }
        if (recordType == null) {
            JSRecordTypeCache.$$$reportNull$$$0(6);
        }
        if (recordType == JSTypeCastUtil.NO_RECORD_TYPE) {
            JSRecordType jSRecordType = recordType;
            if (jSRecordType == null) {
                JSRecordTypeCache.$$$reportNull$$$0(7);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = (JSRecordType)recordType.copyWithStrict(original.isSourceStrict());
        if (jSRecordType == null) {
            JSRecordTypeCache.$$$reportNull$$$0(8);
        }
        return jSRecordType;
    }

    @Nullable
    private static JSRecordType buildRecordTypeNoCache(@NotNull JSType type, @NotNull PsiElement element) {
        if (type == null) {
            JSRecordTypeCache.$$$reportNull$$$0(9);
        }
        if (element == null) {
            JSRecordTypeCache.$$$reportNull$$$0(10);
        }
        Object id = JSRecordTypeCache.getIdForPreventingRecursion(type);
        return (JSRecordType)RecursionManager.doPreventingRecursion((Object)id, (boolean)false, () -> {
            if (type == null) {
                JSRecordTypeCache.$$$reportNull$$$0(17);
            }
            if (element == null) {
                JSRecordTypeCache.$$$reportNull$$$0(18);
            }
            JSType substitute = type.substitute();
            ProgressManager.checkCanceled();
            if (substitute != type) {
                return substitute.asRecordType();
            }
            Collection<? extends PsiElement> resolvedElements = JSRecordTypeCache.resolveElementsForRecordType(type, element);
            if (type.isJavaScript() && (resolvedElements.isEmpty() || type instanceof JSObjectType)) {
                return JSTypeCastUtil.NO_RECORD_TYPE;
            }
            return TypeScriptTypeParser.buildResolvedType(resolvedElements, type);
        });
    }

    @NotNull
    private static Object getIdForPreventingRecursion(@NotNull JSType type) {
        if (type == null) {
            JSRecordTypeCache.$$$reportNull$$$0(11);
        }
        if (type instanceof JSGenericTypeImpl) {
            Pair pair = Pair.create((Object)((JSGenericTypeImpl)type).getType().getResolvedTypeId(), type.getClass());
            if (pair == null) {
                JSRecordTypeCache.$$$reportNull$$$0(12);
            }
            return pair;
        }
        JSResolvedTypeId jSResolvedTypeId = type.getResolvedTypeId();
        if (jSResolvedTypeId == null) {
            JSRecordTypeCache.$$$reportNull$$$0(13);
        }
        return jSResolvedTypeId;
    }

    @NotNull
    private static Collection<? extends PsiElement> resolveElementsForRecordType(@NotNull JSType type, @NotNull PsiElement element) {
        if (type == null) {
            JSRecordTypeCache.$$$reportNull$$$0(14);
        }
        if (element == null) {
            JSRecordTypeCache.$$$reportNull$$$0(15);
        }
        Collection<? extends PsiElement> collection = JSImportHandlingUtil.resolveElementsByType(type, element);
        if (collection == null) {
            JSRecordTypeCache.$$$reportNull$$$0(16);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeCache";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 10: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeCache";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildRecordType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrict";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdForPreventingRecursion";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsForRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyWithStrict";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeNoCache";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIdForPreventingRecursion";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsForRecordType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$buildRecordTypeNoCache$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

