/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeResolvedHashCodeUtil;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeAssignableErrorMessage;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.recordImpl.CallSignatureCommonImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.IndexSignatureCommonImpl;
import com.intellij.lang.javascript.psi.types.recordImpl.PropertySignatureCommonImpl;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectIntHashMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRecordTypeImpl
extends JSTypeBaseImpl
implements JSRecordType,
JSType.CompositeStructure {
    @NotNull
    private final List<JSRecordType.TypeMember> myAllTypeMembers;
    @NotNull
    private final List<JSRecordType.CallSignature> myCallSignatures;
    @Nullable
    private final JSRecordType.IndexSignature myStringIndexer;
    @Nullable
    private final JSRecordType.IndexSignature myNumericIndexer;
    @NotNull
    private final Map<String, JSRecordType.PropertySignature> myProperties;
    private final boolean myIsWeakType;
    private final boolean myHasOverloadedProps;

    public JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> typeMembers) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(0);
        }
        if (typeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(1);
        }
        this(source, typeMembers, true);
    }

    protected JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(3);
        }
        this(source, JSTypeSerializer.TYPE_MEMBERS_SERIALIZER.read(source, inputStream));
    }

    public JSRecordTypeImpl(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> typeMembers, boolean removeFreshness) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(4);
        }
        if (typeMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(5);
        }
        super(source);
        THashMap nameToPropertySignature = ContainerUtil.newTroveMap();
        ArrayList allMembers = ContainerUtil.newArrayListWithCapacity((int)typeMembers.size());
        JSRecordType.IndexSignature stringIndex = null;
        JSRecordType.IndexSignature numericIndex = null;
        ArrayList callSignatures = null;
        TObjectIntHashMap propertyIndices = new TObjectIntHashMap();
        boolean isPossiblyWeak = true;
        boolean hasOverloads = false;
        int positionInAllMembers = -1;
        for (JSRecordType.TypeMember member : typeMembers) {
            if (member instanceof JSRecordType.PropertySignature) {
                String name;
                JSRecordType.PropertySignature storedSignature;
                JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)member;
                if (removeFreshness) {
                    propertySignature = JSRecordTypeImpl.removePropertyTypeFreshness(propertySignature);
                    member = propertySignature;
                }
                if (!propertySignature.isOptional()) {
                    isPossiblyWeak = false;
                }
                if ((storedSignature = (JSRecordType.PropertySignature)nameToPropertySignature.get(name = propertySignature.getMemberName())) != null) {
                    JSRecordType.PropertySignature mergedSignature = JSRecordTypeImpl.mergeSignatures(name, propertySignature, storedSignature, source);
                    int index = propertyIndices.get((Object)name);
                    allMembers.set(index, mergedSignature);
                    nameToPropertySignature.put(name, mergedSignature);
                    if (mergedSignature == storedSignature) continue;
                    hasOverloads = true;
                    continue;
                }
                nameToPropertySignature.put(name, propertySignature);
                propertyIndices.put((Object)name, positionInAllMembers + 1);
            } else {
                if (member instanceof JSRecordType.IndexSignature) {
                    JSRecordType.IndexSignatureKind kind = ((JSRecordType.IndexSignature)member).getIndexSignatureKind();
                    switch (kind) {
                        case NUMERIC: {
                            numericIndex = (JSRecordType.IndexSignature)member;
                            break;
                        }
                        case STRING: {
                            stringIndex = (JSRecordType.IndexSignature)member;
                            break;
                        }
                    }
                } else if (member instanceof JSRecordType.CallSignature) {
                    if (callSignatures == null) {
                        callSignatures = ContainerUtil.newArrayList();
                    }
                    callSignatures.add((JSRecordType.CallSignature)member);
                }
                isPossiblyWeak = false;
            }
            ++positionInAllMembers;
            allMembers.add(member);
        }
        this.myIsWeakType = isPossiblyWeak && !allMembers.isEmpty();
        this.myStringIndexer = stringIndex;
        this.myNumericIndexer = numericIndex;
        this.myCallSignatures = callSignatures == null ? ContainerUtil.emptyList() : Collections.unmodifiableList(callSignatures);
        this.myAllTypeMembers = Collections.unmodifiableList(allMembers);
        this.myProperties = Collections.unmodifiableMap(nameToPropertySignature);
        this.myHasOverloadedProps = hasOverloads;
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(6);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_MEMBERS_SERIALIZER.write(this.myAllTypeMembers, outputStream);
    }

    @NotNull
    private static JSRecordType.PropertySignature mergeSignatures(@NotNull String name, @NotNull JSRecordType.PropertySignature newSignature, @NotNull JSRecordType.PropertySignature stored, @NotNull JSTypeSource source) {
        boolean isOptional;
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(7);
        }
        if (newSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(8);
        }
        if (stored == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(9);
        }
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(10);
        }
        boolean bl = isOptional = newSignature.isOptional() && stored.isOptional();
        if (stored instanceof JSCompositeFunctionPropertySignatureImpl) {
            JSRecordType.PropertySignature propertySignature = JSRecordTypeImpl.addPropertyToCompositeFunctions(name, (JSCompositeFunctionPropertySignatureImpl)stored, newSignature, source, isOptional);
            if (propertySignature == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(11);
            }
            return propertySignature;
        }
        if (newSignature instanceof JSCompositeFunctionPropertySignatureImpl) {
            JSRecordType.PropertySignature propertySignature = JSRecordTypeImpl.addPropertyToCompositeFunctions(name, (JSCompositeFunctionPropertySignatureImpl)newSignature, stored, source, isOptional);
            if (propertySignature == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(12);
            }
            return propertySignature;
        }
        if (!(stored.getType() instanceof JSFunctionTypeImpl)) {
            JSRecordType.PropertySignature propertySignature = stored;
            if (propertySignature == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(13);
            }
            return propertySignature;
        }
        JSCompositeFunctionPropertySignatureImpl jSCompositeFunctionPropertySignatureImpl = new JSCompositeFunctionPropertySignatureImpl(name, ContainerUtil.newArrayList((Object[])new JSRecordType.PropertySignature[]{stored, newSignature}), isOptional, source);
        if (jSCompositeFunctionPropertySignatureImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(14);
        }
        return jSCompositeFunctionPropertySignatureImpl;
    }

    @NotNull
    private static JSRecordType.PropertySignature addPropertyToCompositeFunctions(@NotNull String name, @NotNull JSCompositeFunctionPropertySignatureImpl composite, @NotNull JSRecordType.PropertySignature newProperty, @NotNull JSTypeSource source, boolean isOptional) {
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(15);
        }
        if (composite == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(16);
        }
        if (newProperty == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(17);
        }
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(18);
        }
        List<JSRecordType.PropertySignature> members = composite.getMembers();
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)(members.size() + 1));
        list.addAll(members);
        if (newProperty instanceof JSCompositeFunctionPropertySignatureImpl) {
            list.addAll(((JSCompositeFunctionPropertySignatureImpl)newProperty).getMembers());
        } else {
            list.add(newProperty);
        }
        JSCompositeFunctionPropertySignatureImpl jSCompositeFunctionPropertySignatureImpl = new JSCompositeFunctionPropertySignatureImpl(name, list, isOptional, source);
        if (jSCompositeFunctionPropertySignatureImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(19);
        }
        return jSCompositeFunctionPropertySignatureImpl;
    }

    @NotNull
    private static JSRecordType.PropertySignature removePropertyTypeFreshness(@NotNull JSRecordType.PropertySignature propertySignature) {
        JSType type;
        if (propertySignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(20);
        }
        if (!((type = propertySignature.getType()) instanceof JSFreshObjectLiteralType)) {
            JSRecordType.PropertySignature propertySignature2 = propertySignature;
            if (propertySignature2 == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(21);
            }
            return propertySignature2;
        }
        PropertySignatureImpl propertySignatureImpl = new PropertySignatureImpl(propertySignature.getMemberName(), (JSType)((JSFreshObjectLiteralType)type).removeFreshness(), propertySignature.isOptional(), propertySignature.getMemberSource());
        if (propertySignatureImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(22);
        }
        return propertySignatureImpl;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        StringBuilder builder = new StringBuilder("{");
        boolean useTypeScriptRecordTypeFormat = format == JSType.TypeTextFormat.CODE && this.isTypeScript();
        String prefix = "";
        String nextPrefix = useTypeScriptRecordTypeFormat ? "; " : ", ";
        String separator = this.getTypeSeparator();
        char quote = this.getQuote();
        for (JSRecordType.TypeMember typeMember : this.myAllTypeMembers) {
            builder.append(prefix);
            typeMember.appendMemberPresentation(format, builder, separator, quote);
            prefix = nextPrefix;
        }
        builder.append("}");
        String string = builder.toString();
        if (string == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    protected char getQuote() {
        String quote = JSSymbolPresentationProvider.getDefaultQuote(this.getSource().getSourceElement());
        return quote.charAt(0);
    }

    @Override
    protected final boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(24);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(25);
        }
        if (JSRecordTypeImpl.canSubstitute(elementType)) {
            JSType substitute = elementType.substitute();
            if (elementType != substitute) {
                return this.isDirectlyAssignableType(substitute, processingContext);
            }
            elementType = JSRecordTypeImpl.convertToRecordTypeIfPossible(elementType);
        }
        if (elementType instanceof JSArrayType) {
            elementType = JSRecordTypeImpl.convertToRecordTypeIfPossible(((JSArrayType)elementType).asGenericType());
        }
        if (elementType instanceof JSRecordType) {
            return this.isDirectlyAssignableRecordType((JSRecordType)elementType, processingContext);
        }
        if (elementType instanceof JSObjectType) {
            return true;
        }
        if (!this.hasMembers() && elementType.isJavaScript()) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @NotNull
    private static JSType convertToRecordTypeIfPossible(@NotNull JSType elementType) {
        JSRecordType recordTypeCandidate;
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(26);
        }
        Object object = (recordTypeCandidate = elementType.asRecordType()) == JSTypeCastUtil.NO_RECORD_TYPE ? elementType : recordTypeCandidate;
        if (object == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(27);
        }
        return object;
    }

    protected static boolean canSubstitute(@NotNull JSType elementType) {
        if (elementType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(28);
        }
        if (elementType instanceof JSFunctionTypeImpl) {
            return true;
        }
        return elementType instanceof JSNamedType || elementType instanceof JSGenericTypeImpl;
    }

    private static boolean isObject(@NotNull JSRecordType recordType) {
        PsiElement sourceElement;
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(29);
        }
        return (sourceElement = recordType.getSource().getSourceElement()) instanceof TypeScriptInterface && "Object".equals(((TypeScriptInterface)sourceElement).getQualifiedName());
    }

    private boolean isDirectlyAssignableRecordType(@NotNull JSRecordType recordType, @NotNull ProcessingContext processingContext) {
        boolean rTypeWithCallSignatures;
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(30);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(31);
        }
        List rTypeCallSignatures = recordType.getCallSignatures();
        boolean hasMembers = recordType.hasMembers();
        boolean bl = rTypeWithCallSignatures = !rTypeCallSignatures.isEmpty();
        if (!this.checkWeakTypeCondition(recordType, hasMembers)) {
            return false;
        }
        if (!this.checkSubtypingCondition(recordType, processingContext)) {
            return false;
        }
        if (!this.checkCallSignatureExistence(rTypeWithCallSignatures, processingContext)) {
            return false;
        }
        if (!this.checkStringIndexerTypes(recordType, processingContext)) {
            return false;
        }
        if (!this.checkNumericIndexerTypes(recordType, processingContext)) {
            return false;
        }
        if (!this.checkPropertyTypes(recordType, rTypeWithCallSignatures, processingContext)) {
            return false;
        }
        return this.checkCallSignatureTypes(processingContext, rTypeCallSignatures);
    }

    private boolean checkWeakTypeCondition(@NotNull JSRecordType recordType, boolean hasMembers) {
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(32);
        }
        if (this.myIsWeakType && hasMembers && !JSRecordTypeImpl.isObject(recordType)) {
            Set rNames = recordType.getPropertyNames();
            Set<String> lNames = this.myProperties.keySet();
            if (lNames.stream().noneMatch(rNames::contains)) {
                return false;
            }
        }
        return true;
    }

    private boolean checkCallSignatureExistence(boolean rTypeWithCallSignatures, @NotNull ProcessingContext processingContext) {
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(33);
        }
        if (!this.myCallSignatures.isEmpty() && !rTypeWithCallSignatures) {
            JSTypeAssignableErrorMessage.addMessageToContext((String)"javascript.no.call.signatures", (ProcessingContext)processingContext);
            return false;
        }
        return true;
    }

    private boolean checkPropertyTypes(@NotNull JSRecordType recordType, boolean hasCallSignatures, @NotNull ProcessingContext processingContext) {
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(34);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(35);
        }
        JSTypeSource source = recordType.getSource();
        JSUndefinedType undefinedType = null;
        JSRecordType additionalMembers = null;
        List toCheck = null;
        for (JSRecordType.PropertySignature lProperty : this.getProperties()) {
            String lPropName = lProperty.getMemberName();
            JSRecordType.PropertySignature rProperty = recordType.findPropertySignature(lPropName);
            if (rProperty != null && rProperty.isOptional() && !lProperty.isOptional() && this.isTypeScript()) {
                return false;
            }
            if (rProperty == null && !lProperty.isOptional()) {
                if (source.getLanguage() == JSTypeSource.SourceLanguage.JS) {
                    if (undefinedType == null) {
                        undefinedType = new JSUndefinedType(source);
                    }
                    if (JSRecordTypeImpl.isUndefinedProperty(lProperty, undefinedType, processingContext)) continue;
                }
                if (hasCallSignatures) {
                    if (additionalMembers == null) {
                        additionalMembers = TypeScriptUtil.getFunctionTypeMembers(this.getSource().getSourceElement());
                    }
                    if (additionalMembers != null && this.checkFunctionInterfaceProperties(processingContext, additionalMembers, lProperty)) continue;
                }
                return false;
            }
            if (rProperty == null) continue;
            if (toCheck == null) {
                toCheck = ContainerUtil.newArrayList();
            }
            toCheck.add(context -> this.checkPropertySignatureAssignable(lProperty, rProperty, context));
        }
        if (toCheck != null) {
            for (PropertyTypeChecker checker : toCheck) {
                if (checker.check(processingContext)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkCallSignatureTypes(@NotNull ProcessingContext processingContext, @NotNull List<JSRecordType.CallSignature> callSignatures) {
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(36);
        }
        if (callSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(37);
        }
        for (JSRecordType.CallSignature lCallSignature : this.myCallSignatures) {
            if (this.checkCallSignaturesAssignable(lCallSignature, callSignatures, processingContext)) continue;
            return false;
        }
        return true;
    }

    private boolean checkStringIndexerTypes(@NotNull JSRecordType recordType, @NotNull ProcessingContext processingContext) {
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(38);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(39);
        }
        if (this.myStringIndexer == null) {
            return true;
        }
        JSRecordType.IndexSignature stringIndexSignature = recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING);
        JSType memberType = this.myStringIndexer.getMemberType();
        if (stringIndexSignature != null) {
            return memberType.isDirectlyAssignableType(stringIndexSignature.getMemberType(), processingContext);
        }
        return JSRecordTypeImpl.isObjectLiteralType(recordType) && !JSRecordTypeImpl.hasPropertyNotAssignableToIndexer(recordType, p -> true, this.myStringIndexer, processingContext);
    }

    private boolean checkNumericIndexerTypes(@NotNull JSRecordType recordType, @NotNull ProcessingContext processingContext) {
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(40);
        }
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(41);
        }
        if (this.myNumericIndexer == null) {
            return true;
        }
        JSRecordType.IndexSignature stringIndexSignature = recordType.findIndexer(JSRecordType.IndexSignatureKind.STRING);
        JSRecordType.IndexSignature numericIndexSignature = recordType.findIndexer(JSRecordType.IndexSignatureKind.NUMERIC);
        JSType memType = this.myNumericIndexer.getMemberType();
        if (numericIndexSignature != null) {
            return memType.isDirectlyAssignableType(numericIndexSignature.getMemberType(), processingContext);
        }
        if (stringIndexSignature != null) {
            if (!memType.isDirectlyAssignableType(stringIndexSignature.getMemberType(), processingContext)) {
                return false;
            }
            if (JSRecordTypeImpl.isObjectLiteralType(recordType) && JSRecordTypeImpl.hasPropertyNotAssignableToIndexer(recordType, p -> true, this.myNumericIndexer, processingContext)) {
                return false;
            }
        } else if (!JSRecordTypeImpl.isObjectLiteralType(recordType) || JSRecordTypeImpl.hasPropertyNotAssignableToIndexer(recordType, JSRecordTypeImpl::isNumericallyNamedProperty, this.myNumericIndexer, processingContext)) {
            return false;
        }
        return true;
    }

    private boolean checkSubtypingCondition(@NotNull JSRecordType recordType, @Nullable ProcessingContext processingContext) {
        boolean subtyping;
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(42);
        }
        boolean bl = subtyping = processingContext != null && processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) != null;
        if (subtyping) {
            Set<String> currentNames = this.myProperties.keySet();
            HashSet recordTypeProps = ContainerUtil.newHashSet((Iterable)recordType.getPropertyNames());
            recordTypeProps.removeAll(currentNames);
            if (recordTypeProps.size() > 0) {
                return false;
            }
        }
        return true;
    }

    private static boolean isNumericallyNamedProperty(@NotNull JSRecordType.PropertySignature p) {
        String memberName;
        if (p == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(43);
        }
        return JSStringUtil.isNumericValueStart(memberName = p.getMemberName(), false) && JSNumberParser.tryParseNumericValue(memberName, false) != null;
    }

    private static boolean isObjectLiteralType(@NotNull JSRecordType type) {
        PsiElement sourceElement;
        if (type == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(44);
        }
        return (sourceElement = type.getSource().getSourceElement()) instanceof JSObjectLiteralExpression || sourceElement instanceof TypeScriptObjectType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasPropertyNotAssignableToIndexer(@NotNull JSRecordType recordType, @NotNull Predicate<JSRecordType.PropertySignature> propertyFilter, @NotNull JSRecordType.IndexSignature typeMember, @Nullable ProcessingContext processingContext) {
        if (recordType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(45);
        }
        if (propertyFilter == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(46);
        }
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(47);
        }
        JSType memberType = typeMember.getMemberType();
        MultiMap originalGenericArgumentsMap = null;
        MultiMap newGenericArgumentsMap = MultiMap.createSmart();
        if (processingContext != null) {
            originalGenericArgumentsMap = (MultiMap)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
        }
        if (originalGenericArgumentsMap != null) {
            processingContext.put(JSGenericTypesEvaluator.ourGenericArgumentsMapKey, (Object)newGenericArgumentsMap);
        }
        boolean result2 = true;
        try {
            result2 = recordType.getProperties().stream().filter(propertyFilter).map(v -> v.getType()).anyMatch(t -> t != null && !memberType.isDirectlyAssignableType(t, processingContext));
        }
        finally {
            if (originalGenericArgumentsMap != null) {
                processingContext.put(JSGenericTypesEvaluator.ourGenericArgumentsMapKey, (Object)originalGenericArgumentsMap);
                if (!result2) {
                    for (JSTypeSubstitutor.JSTypeGenericId key : newGenericArgumentsMap.keySet()) {
                        Collection items = newGenericArgumentsMap.get((Object)key);
                        originalGenericArgumentsMap.putValue((Object)key, (Object)JSCompositeTypeImpl.optimizeTypeIfComposite(new JSCompositeTypeImpl(JSTypeSource.EXPLICITLY_DECLARED, ContainerUtil.newArrayList((Iterable)items))));
                    }
                }
            }
        }
        return result2;
    }

    private static boolean isUndefinedProperty(@NotNull JSRecordType.PropertySignature typeMember, @NotNull JSType undefinedType, @Nullable ProcessingContext processingContext) {
        JSType propertyType;
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(48);
        }
        if (undefinedType == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(49);
        }
        return (propertyType = typeMember.getType()) == null || undefinedType.isDirectlyAssignableType(propertyType, processingContext);
    }

    private boolean checkPropertySignatureAssignable(@NotNull JSRecordType.PropertySignature signature, @NotNull JSRecordType.PropertySignature otherSignature, @Nullable ProcessingContext processingContext) {
        if (signature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(50);
        }
        if (otherSignature == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(51);
        }
        if (signature.isEquivalentTo((JSRecordType.TypeMember)otherSignature, false)) {
            return true;
        }
        JSType type = signature.getType();
        JSType otherType = otherSignature.getType();
        return this.skipTypeChecking(type) || this.skipTypeChecking(otherType) || type.isDirectlyAssignableType(otherType, processingContext);
    }

    private boolean checkCallSignaturesAssignable(@NotNull JSRecordType.CallSignature typeMember, @NotNull List<JSRecordType.CallSignature> callSignatures, @Nullable ProcessingContext processingContext) {
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(52);
        }
        if (callSignatures == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(53);
        }
        for (JSRecordType.CallSignature callSignature : callSignatures) {
            if (!typeMember.isEquivalentTo((JSRecordType.TypeMember)callSignature, false)) continue;
            return true;
        }
        for (JSRecordType.CallSignature callSignature : callSignatures) {
            JSFunctionTypeImpl otherFunctionType;
            JSFunctionTypeImpl functionType;
            if (typeMember.hasNew() != callSignature.hasNew() || !this.checkFunctionsArgumentsAndReturnType(functionType = (JSFunctionTypeImpl)typeMember.getFunctionType(), otherFunctionType = (JSFunctionTypeImpl)callSignature.getFunctionType(), processingContext)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFunctionsArgumentsAndReturnType(@NotNull JSFunctionTypeImpl functionType, @NotNull JSFunctionTypeImpl otherFunctionType, @Nullable ProcessingContext processingContext) {
        boolean bl;
        block12: {
            JSType otherReturnType;
            JSType returnType;
            boolean oldCallEnv;
            block10: {
                boolean bl2;
                block11: {
                    block8: {
                        boolean bl3;
                        block9: {
                            if (functionType == null) {
                                JSRecordTypeImpl.$$$reportNull$$$0(54);
                            }
                            if (otherFunctionType == null) {
                                JSRecordTypeImpl.$$$reportNull$$$0(55);
                            }
                            oldCallEnv = false;
                            if (processingContext != null) {
                                oldCallEnv = processingContext.get(JSTypeBaseImpl.CALL_ENV_KEY) == Boolean.TRUE;
                                processingContext.put(JSTypeBaseImpl.CALL_ENV_KEY, (Object)true);
                            }
                            try {
                                if (JSTypeUtils.areArgumentsAssignable(functionType.getParameters(), otherFunctionType.getParameters(), processingContext, true, !this.isTypeScript(), this.isTypeScript())) break block8;
                                bl3 = false;
                                if (processingContext == null) break block9;
                                processingContext.put(JSTypeBaseImpl.CALL_ENV_KEY, (Object)(oldCallEnv ? Boolean.valueOf(true) : null));
                            }
                            catch (Throwable throwable) {
                                if (processingContext != null) {
                                    processingContext.put(JSTypeBaseImpl.CALL_ENV_KEY, (Object)(oldCallEnv ? Boolean.valueOf(true) : null));
                                }
                                throw throwable;
                            }
                        }
                        return bl3;
                    }
                    returnType = functionType.getReturnType();
                    otherReturnType = otherFunctionType.getReturnType();
                    if (returnType != null && !(returnType instanceof JSVoidType)) break block10;
                    bl2 = true;
                    if (processingContext == null) break block11;
                    processingContext.put(JSTypeBaseImpl.CALL_ENV_KEY, (Object)(oldCallEnv ? Boolean.valueOf(true) : null));
                }
                return bl2;
            }
            bl = returnType.isDirectlyAssignableType(otherReturnType, processingContext);
            if (processingContext == null) break block12;
            processingContext.put(JSTypeBaseImpl.CALL_ENV_KEY, (Object)(oldCallEnv ? Boolean.valueOf(true) : null));
        }
        return bl;
    }

    private boolean checkFunctionInterfaceProperties(@NotNull ProcessingContext processingContext, @NotNull JSRecordType functionRecord, @NotNull JSRecordType.PropertySignature typeMember) {
        JSRecordType.PropertySignature signature;
        if (processingContext == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(56);
        }
        if (functionRecord == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(57);
        }
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(58);
        }
        if ((signature = functionRecord.findPropertySignature(typeMember.getMemberName())) == null) {
            return false;
        }
        if (JSRecordTypeImpl.checkSources(typeMember, (JSRecordType.TypeMember)signature)) {
            return true;
        }
        return this.checkPropertySignatureAssignable(typeMember, signature, processingContext);
    }

    private static boolean checkSources(@NotNull JSRecordType.PropertySignature typeMember, @NotNull JSRecordType.TypeMember member) {
        if (typeMember == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(59);
        }
        if (member == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(60);
        }
        JSRecordType.MemberSource source = member.getMemberSource();
        PsiElement memberSource = source.getSingleElement();
        JSRecordType.MemberSource typeMemberSource = typeMember.getMemberSource();
        return memberSource != null && memberSource.isEquivalentTo(typeMemberSource.getSingleElement()) || typeMember.isEquivalentTo(member, true);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(61);
        }
        if (!(type instanceof JSRecordType)) {
            return false;
        }
        JSRecordType otherType = (JSRecordType)type;
        List otherMembers = otherType.getTypeMembers();
        List<JSRecordType.TypeMember> members = this.getTypeMembers();
        return JSRecordTypeImpl.areMembersEqual(otherMembers, members, allowResolve);
    }

    protected static boolean areMembersEqual(@NotNull List<JSRecordType.TypeMember> otherMembers, @NotNull List<JSRecordType.TypeMember> members, boolean allowResolve) {
        if (otherMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(62);
        }
        if (members == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(63);
        }
        if (otherMembers.size() != members.size()) {
            return false;
        }
        for (int i = 0; i < members.size(); ++i) {
            JSRecordType.TypeMember member;
            JSRecordType.TypeMember otherMember = otherMembers.get(i);
            if (otherMember.isEquivalentTo(member = members.get(i), allowResolve)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<JSRecordType.TypeMember> getTypeMembers() {
        List<JSRecordType.TypeMember> list = this.myAllTypeMembers;
        if (list == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(64);
        }
        return list;
    }

    public final boolean hasProperty(@NotNull String name) {
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(65);
        }
        return this.myProperties.containsKey(name);
    }

    public final boolean hasIndexers() {
        return this.myStringIndexer != null || this.myNumericIndexer != null;
    }

    @NotNull
    public final List<JSRecordType.CallSignature> getCallSignatures() {
        List<JSRecordType.CallSignature> list = this.myCallSignatures;
        if (list == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(66);
        }
        return list;
    }

    @NotNull
    public final Set<String> getPropertyNames() {
        Set<String> set = this.myProperties.keySet();
        if (set == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(67);
        }
        return set;
    }

    @NotNull
    public final Collection<JSRecordType.PropertySignature> getProperties() {
        Collection<JSRecordType.PropertySignature> collection = this.myProperties.values();
        if (collection == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(68);
        }
        return collection;
    }

    public final boolean hasMembers() {
        return !this.myAllTypeMembers.isEmpty();
    }

    public final boolean hasProperties() {
        return !this.myProperties.isEmpty();
    }

    @Nullable
    public final JSRecordType.PropertySignature findPropertySignature(@NotNull String name) {
        if (name == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(69);
        }
        return this.myProperties.get(name);
    }

    @Override
    public final void accept(JSRecursiveTypeVisitor visitor) {
        visitor.visitJSRecordType((JSType)this);
    }

    private boolean skipTypeChecking(@Nullable JSType type) {
        return type == null || this.isTypeScript() && !type.getSource().isStrict();
    }

    @Override
    public final void acceptChildren(JSRecursiveTypeVisitor visitor) {
        for (JSRecordType.TypeMember typeMember : this.myAllTypeMembers) {
            typeMember.acceptChildren(visitor);
        }
    }

    @Override
    @NotNull
    protected final JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(70);
        }
        List<JSRecordType.TypeMember> oldMembers = this.getTypeMembers();
        ArrayList<JSRecordType.TypeMember> newMembers = new ArrayList<JSRecordType.TypeMember>();
        JSTypeSource appliedTypeSource = this.getSource();
        boolean shouldCleanSource = appliedTypeSource.getSourceElement() == null;
        for (JSRecordType.TypeMember member : oldMembers) {
            newMembers.add(member.copyTypeHierarchy(childTransform, shouldCleanSource));
        }
        if (ContainerUtil.equalsIdentity(oldMembers, newMembers)) {
            JSRecordTypeImpl jSRecordTypeImpl = this;
            if (jSRecordTypeImpl == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(71);
            }
            return jSRecordTypeImpl;
        }
        JSRecordTypeImpl jSRecordTypeImpl = this.createInstance(this.getSource(), newMembers, true);
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(72);
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    protected JSRecordTypeImpl createInstance(@NotNull JSTypeSource source, @NotNull List<JSRecordType.TypeMember> newMembers, boolean membersChanged) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(73);
        }
        if (newMembers == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(74);
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(source, newMembers);
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(75);
        }
        return jSRecordTypeImpl;
    }

    @Override
    @NotNull
    protected final JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(76);
        }
        JSRecordTypeImpl jSRecordTypeImpl = this.createInstance(source, this.getMembersWithNewSource(source), false);
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(77);
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    protected final List<JSRecordType.TypeMember> getMembersWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(78);
        }
        List<JSRecordType.TypeMember> members = this.getTypeMembers();
        if (!this.myHasOverloadedProps) {
            List<JSRecordType.TypeMember> list = members;
            if (list == null) {
                JSRecordTypeImpl.$$$reportNull$$$0(79);
            }
            return list;
        }
        ArrayList newMembers = ContainerUtil.newArrayListWithCapacity((int)members.size());
        for (JSRecordType.TypeMember member : members) {
            JSCompositeFunctionPropertySignatureImpl propertySignature;
            if (member instanceof JSCompositeFunctionPropertySignatureImpl && ((propertySignature = (JSCompositeFunctionPropertySignatureImpl)member).getTypeSource() == JSTypeSource.EMPTY || source == JSTypeSource.EMPTY)) {
                newMembers.add(propertySignature.copyWithNewSource(source));
                continue;
            }
            newMembers.add(member);
        }
        ArrayList arrayList = newMembers;
        if (arrayList == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(80);
        }
        return arrayList;
    }

    @Nullable
    public final JSRecordType.IndexSignature findIndexer(@NotNull JSRecordType.IndexSignatureKind kind) {
        if (kind == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(81);
        }
        switch (kind) {
            case STRING: {
                return this.myStringIndexer;
            }
            case NUMERIC: {
                return this.myNumericIndexer;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordTypeImpl jSRecordTypeImpl = this;
        if (jSRecordTypeImpl == null) {
            JSRecordTypeImpl.$$$reportNull$$$0(82);
        }
        return jSRecordTypeImpl;
    }

    @Override
    protected int resolvedHashCodeImpl() {
        return JSTypeResolvedHashCodeUtil.getResolvedHashCodeForMembers(this.getTypeMembers());
    }

    public final boolean isWeak() {
        return this.myIsWeakType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 82: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 82: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMembers";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 7: 
            case 15: 
            case 65: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSignature";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stored";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composite";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProperty";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySignature";
                break;
            }
            case 24: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 25: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 41: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 38: 
            case 40: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 37: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSignatures";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 44: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyFilter";
                break;
            }
            case 47: 
            case 48: 
            case 52: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMember";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "undefinedType";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherSignature";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherFunctionType";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionRecord";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherMembers";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMembers";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSignatures";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "addPropertyToCompositeFunctions";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "removePropertyTypeFreshness";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToRecordTypeIfPossible";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeMembers";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallSignatures";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersWithNewSource";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "mergeSignatures";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 82: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyToCompositeFunctions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyTypeFreshness";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "convertToRecordTypeIfPossible";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "canSubstitute";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isObject";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableRecordType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkWeakTypeCondition";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignatureExistence";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertyTypes";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignatureTypes";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkStringIndexerTypes";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "checkNumericIndexerTypes";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkSubtypingCondition";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isNumericallyNamedProperty";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isObjectLiteralType";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "hasPropertyNotAssignableToIndexer";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isUndefinedProperty";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertySignatureAssignable";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkCallSignaturesAssignable";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionsArgumentsAndReturnType";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionInterfaceProperties";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "checkSources";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToImpl";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "areMembersEqual";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "hasProperty";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "findPropertySignature";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getMembersWithNewSource";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "findIndexer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 64: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 72: 
            case 75: 
            case 77: 
            case 79: 
            case 80: 
            case 82: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class PropertySignatureImpl
    implements PropertySignatureCommonImpl {
        @NotNull
        private final String name;
        @Nullable
        private final JSType type;
        private final boolean optional;
        @NotNull
        private final JSRecordType.MemberSource mySource;

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, @Nullable PsiElement singleSource) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(0);
            }
            this(name, type, optional, JSRecordMemberSourceFactory.createSource(singleSource));
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional, @NotNull JSRecordType.MemberSource source) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(1);
            }
            if (source == null) {
                PropertySignatureImpl.$$$reportNull$$$0(2);
            }
            this.name = name;
            this.type = type;
            this.optional = optional;
            this.mySource = source;
        }

        public PropertySignatureImpl(@NotNull String name, @Nullable JSType type, boolean optional) {
            if (name == null) {
                PropertySignatureImpl.$$$reportNull$$$0(3);
            }
            this(name, type, optional, JSRecordMemberSourceFactory.createEmptySource());
        }

        @NotNull
        public String getMemberName() {
            String string = this.name;
            if (string == null) {
                PropertySignatureImpl.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nullable
        public JSType getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        @NotNull
        public JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = this.mySource;
            if (memberSource == null) {
                PropertySignatureImpl.$$$reportNull$$$0(5);
            }
            return memberSource;
        }

        public String toString() {
            return "PropertySignatureImpl@" + this.name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$PropertySignatureImpl";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class IndexSignatureImpl
    implements IndexSignatureCommonImpl {
        @Nullable
        private final JSType parameterType;
        @Nullable
        private final JSType type;
        @NotNull
        private final JSRecordType.MemberSource mySource;

        public IndexSignatureImpl(@Nullable JSType parameterType, @Nullable JSType type, @Nullable PsiElement singleSource) {
            this(parameterType, type, JSRecordMemberSourceFactory.createSource(singleSource));
        }

        public IndexSignatureImpl(@Nullable JSType parameterType, @Nullable JSType type, @NotNull JSRecordType.MemberSource source) {
            if (source == null) {
                IndexSignatureImpl.$$$reportNull$$$0(0);
            }
            this.mySource = source;
            this.parameterType = parameterType;
            this.type = type;
        }

        @NotNull
        public final JSType getMemberParameterType() {
            Object object = this.parameterType != null ? this.parameterType : JSAnyType.get(null, false);
            if (object == null) {
                IndexSignatureImpl.$$$reportNull$$$0(1);
            }
            return object;
        }

        @NotNull
        public JSRecordType.IndexSignatureKind getIndexSignatureKind() {
            JSRecordType.IndexSignatureKind indexSignatureKind = IndexSignatureImpl.getIndexerKindFromType(this.getMemberParameterType());
            if (indexSignatureKind == null) {
                IndexSignatureImpl.$$$reportNull$$$0(2);
            }
            return indexSignatureKind;
        }

        @NotNull
        public final JSType getMemberType() {
            Object object = this.type != null ? this.type : JSAnyType.get(null, false);
            if (object == null) {
                IndexSignatureImpl.$$$reportNull$$$0(3);
            }
            return object;
        }

        @NotNull
        public final JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = this.mySource;
            if (memberSource == null) {
                IndexSignatureImpl.$$$reportNull$$$0(4);
            }
            return memberSource;
        }

        @NotNull
        public static JSRecordType.IndexSignatureKind getIndexerKindFromType(@Nullable JSType memberParameterType) {
            if (memberParameterType instanceof JSStringType) {
                JSRecordType.IndexSignatureKind indexSignatureKind = JSRecordType.IndexSignatureKind.STRING;
                if (indexSignatureKind == null) {
                    IndexSignatureImpl.$$$reportNull$$$0(5);
                }
                return indexSignatureKind;
            }
            if (memberParameterType instanceof JSNumberType) {
                JSRecordType.IndexSignatureKind indexSignatureKind = JSRecordType.IndexSignatureKind.NUMERIC;
                if (indexSignatureKind == null) {
                    IndexSignatureImpl.$$$reportNull$$$0(6);
                }
                return indexSignatureKind;
            }
            JSRecordType.IndexSignatureKind indexSignatureKind = JSRecordType.IndexSignatureKind.UNKNOWN;
            if (indexSignatureKind == null) {
                IndexSignatureImpl.$$$reportNull$$$0(7);
            }
            return indexSignatureKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$IndexSignatureImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberParameterType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexSignatureKind";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndexerKindFromType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class CallSignatureImpl
    implements CallSignatureCommonImpl {
        private final boolean hasNew;
        @NotNull
        private final JSFunctionType functionType;

        public CallSignatureImpl(boolean hasNew, @NotNull JSFunctionType functionType) {
            if (functionType == null) {
                CallSignatureImpl.$$$reportNull$$$0(0);
            }
            this.hasNew = hasNew;
            this.functionType = functionType;
        }

        public boolean hasNew() {
            return this.hasNew;
        }

        @NotNull
        public JSFunctionType getFunctionType() {
            JSFunctionType jSFunctionType = this.functionType;
            if (jSFunctionType == null) {
                CallSignatureImpl.$$$reportNull$$$0(1);
            }
            return jSFunctionType;
        }

        @NotNull
        public JSRecordType.MemberSource getMemberSource() {
            JSRecordType.MemberSource memberSource = JSRecordMemberSourceFactory.createSource(this.functionType.getSource().getSourceElement());
            if (memberSource == null) {
                CallSignatureImpl.$$$reportNull$$$0(2);
            }
            return memberSource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "functionType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSRecordTypeImpl$CallSignatureImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunctionType";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMemberSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface PropertyTypeChecker {
        public boolean check(@NotNull ProcessingContext var1);
    }
}

