/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTupleTypeImpl
extends JSCompositeTypeBaseImpl
implements JSTupleType {
    private final boolean myStrict;
    private final int myFirstOptional;

    public JSTupleTypeImpl(JSTypeSource source, Collection<JSType> _types, boolean strict, int firstOptional) {
        super(source, _types);
        this.myStrict = strict;
        this.myFirstOptional = firstOptional;
    }

    protected JSTupleTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(0);
        }
        if (inputStream == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(1);
        }
        super(source, inputStream);
        this.myStrict = JSTypeSerializer.readBoolean(inputStream);
        this.myFirstOptional = JSTypeSerializer.readInt(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(2);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myStrict, outputStream);
        JSTypeSerializer.writeInt(this.myFirstOptional, outputStream);
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if ("," == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(3);
        }
        return ",";
    }

    public int getOptionalStart() {
        return this.myFirstOptional;
    }

    public int getMinLength() {
        List<JSType> types = this.getTypes();
        JSType lastItem = (JSType)ContainerUtil.getLastItem(types);
        if (this.myFirstOptional != -1) {
            return this.myFirstOptional;
        }
        return lastItem instanceof JSSpreadType ? types.size() - 1 : types.size();
    }

    public int getMaxLength() {
        List<JSType> types = this.getTypes();
        JSType lastItem = (JSType)ContainerUtil.getLastItem(types);
        return lastItem instanceof JSSpreadType ? Integer.MAX_VALUE : types.size();
    }

    @Override
    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        String string = "[" + super.getTypeText(format) + "]";
        if (string == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    protected boolean areTypesPresentablyEquivalent(JSType t, JSType type, ProcessingContext ctx) {
        return false;
    }

    @Override
    protected String getNestedTypePresentation(JSType.TypeTextFormat format, JSType t) {
        if (format == JSType.TypeTextFormat.PRESENTABLE && t instanceof JSNullType) {
            return "*";
        }
        return super.getNestedTypePresentation(format, t);
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource, boolean sourceOnly) {
        if (transformedTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(5);
        }
        if (newSource == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(6);
        }
        JSTupleTypeImpl jSTupleTypeImpl = new JSTupleTypeImpl(newSource, transformedTypes, this.myStrict, this.myFirstOptional);
        if (jSTupleTypeImpl == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(7);
        }
        return jSTupleTypeImpl;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(8);
        }
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(9);
        }
        if (this.myStrict && elementType instanceof JSTupleTypeImpl) {
            List<JSType> elementTypes = ((JSTupleTypeImpl)elementType).getTypes();
            List<JSType> currentTypes = this.getTypes();
            int min = Math.min(elementTypes.size(), currentTypes.size());
            for (int i = 0; i < min; ++i) {
                JSType nestedElement;
                JSType nestedCurrent = currentTypes.get(i);
                if (nestedCurrent instanceof JSSpreadType) {
                    nestedCurrent = ((JSSpreadType)nestedCurrent).getComponentType();
                }
                if (nestedCurrent.isDirectlyAssignableType(nestedElement = elementTypes.get(i), processingContext)) continue;
                return false;
            }
            if (currentTypes.size() < elementTypes.size()) {
                JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
                if (!(lastCurrent instanceof JSSpreadType)) {
                    return !this.isTypeScript();
                }
                if (currentTypes.size() - elementTypes.size() + 1 == 0 && ContainerUtil.getLastItem(elementTypes) instanceof JSSpreadType) {
                    return true;
                }
                return !this.isTypeScript() || JSTupleTypeImpl.checkWithSpreads(processingContext, elementTypes, min, ((JSSpreadType)lastCurrent).getComponentType(), false);
            }
            if (elementTypes.size() < currentTypes.size()) {
                JSType lastItem = (JSType)ContainerUtil.getLastItem(elementTypes);
                if (!(lastItem instanceof JSSpreadType)) {
                    return this.myFirstOptional != -1 && min >= this.myFirstOptional || elementTypes.size() - currentTypes.size() + 1 == 0 && ContainerUtil.getLastItem(currentTypes) instanceof JSSpreadType;
                }
                JSType componentType = ((JSSpreadType)lastItem).getComponentType();
                return JSTupleTypeImpl.checkWithSpreads(processingContext, currentTypes, min, componentType, true);
            }
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private static boolean checkWithSpreads(@NotNull ProcessingContext processingContext, @NotNull List<JSType> currentTypes, int min, @NotNull JSType componentType, boolean forward) {
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(10);
        }
        if (currentTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(11);
        }
        if (componentType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(12);
        }
        for (int i = min; i < currentTypes.size(); ++i) {
            JSType type = currentTypes.get(i);
            if (type instanceof JSSpreadType) {
                type = ((JSSpreadType)type).getComponentType();
            }
            if ((forward ? type : componentType).isDirectlyAssignableType(forward ? componentType : type, processingContext)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public JSType getTypeByIndex(int index) {
        JSType type;
        if (index < 0) {
            return null;
        }
        List<JSType> types = this.getTypes();
        int lastIndex = types.size() - 1;
        if (index <= lastIndex) {
            JSType type2 = types.get(index);
            if (index == lastIndex && type2 instanceof JSSpreadType) {
                return ((JSSpreadType)type2).getComponentType();
            }
            return type2;
        }
        if (lastIndex >= 0 && (type = types.get(lastIndex)) instanceof JSSpreadType) {
            return ((JSSpreadType)type).getComponentType();
        }
        return null;
    }

    public boolean hasTypeByIndex(int index) {
        if (index < 0) {
            return false;
        }
        List<JSType> types = this.getTypes();
        int lastIndex = types.size() - 1;
        if (index <= lastIndex) {
            return true;
        }
        if (lastIndex >= 0) {
            return types.get(lastIndex) instanceof JSSpreadType;
        }
        return false;
    }

    @Nullable
    public JSType excludePrefix(int length) {
        if (length <= 0) {
            return this;
        }
        List<JSType> types = this.getTypes();
        int lastIndex = types.size() - 1;
        if (length > lastIndex) {
            JSType lastType;
            if (lastIndex >= 0 && (lastType = types.get(lastIndex)) instanceof JSSpreadType) {
                return new JSTupleTypeImpl(this.getSource(), ContainerUtil.createMaybeSingletonList((Object)lastType), this.myStrict, -1);
            }
            return null;
        }
        List<JSType> newTypes = types.subList(length, types.size());
        return new JSTupleTypeImpl(this.getSource(), newTypes, this.myStrict, this.myFirstOptional == -1 || this.myFirstOptional + length >= newTypes.size() ? -1 : this.myFirstOptional + length);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult assignableResult;
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(13);
        }
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(14);
        }
        if ((assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(15);
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.toArrayType(true).isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(16);
        }
        return assignableResult3;
    }

    @NotNull
    public final JSType toArrayType(boolean allowResolve) {
        JSType jSType = allowResolve ? this.substitute() : this.toArrayImpl(false);
        if (jSType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(17);
        }
        return jSType;
    }

    @NotNull
    private JSType toArrayImpl(boolean allowResolve) {
        JSTypeSource source = this.getSource();
        List<JSType> types = this.getTypes();
        Collection providers = types.stream().map(el -> () -> el).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, source.getSourceElement(), allowResolve);
        if (commonType instanceof JSNullType) {
            commonType = JSAnyType.get(source.getSourceElement(), false);
        }
        JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(commonType, source);
        if (jSArrayTypeImpl == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(18);
        }
        return jSArrayTypeImpl;
    }

    @Override
    @NotNull
    protected JSType substituteCompositeImpl() {
        JSType jSType = this.toArrayImpl(true);
        if (jSType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(19);
        }
        return jSType;
    }

    @Override
    protected boolean useCacheForRecordType() {
        return true;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType parent = super.asRecordTypeNoCache();
        ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>(parent.getTypeMembers());
        List<JSType> types = this.getTypes();
        for (int i = 0; i < types.size(); ++i) {
            members.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(String.valueOf(i), types.get(i), false));
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(parent.getSource(), members);
        if (jSRecordTypeImpl == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(20);
        }
        return jSRecordTypeImpl;
    }

    @Nullable
    public JSQualifiedName getQualifiedName() {
        return JSQualifiedNameImpl.create("Array", null);
    }

    @NotNull
    public String getDefaultValue() {
        StringBuilder type = new StringBuilder("[");
        List<JSType> types = this.getTypes();
        int size = types.size();
        int i = 0;
        for (JSType jsType : types) {
            type.append(JSTypeUtils.defaultValueOfType(jsType));
            if (i < size - 1) {
                type.append(",");
            }
            ++i;
        }
        String string = type.append("]").toString();
        if (string == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTypes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toArrayType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toArrayImpl";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompositeImpl";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkWithSpreads";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

