/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeCastUtil {
    public static final JSRecordType NO_RECORD_TYPE = new JSRecordTypeImpl(JSTypeSource.EMPTY, ContainerUtil.emptyList());
    public static final Key<Boolean> SKIP_NULL_CHECKS = Key.create((String)"js.type.comparison.skip.null.checks");

    public static boolean isFalsy(@Nullable JSType type) {
        return JSCompositeTypeBaseImpl.isNullOrUndefinedType(type) || JSTypeCastUtil.isFalseBooleanLiteralType(type) || JSTypeCastUtil.isEmptyStringLiteralType(type) || JSTypeCastUtil.isZeroNumberLiteralType(type);
    }

    private static boolean isFalseBooleanLiteralType(@Nullable JSType type) {
        return type instanceof JSBooleanLiteralTypeImpl && ((JSBooleanLiteralTypeImpl)type).getLiteral() == Boolean.FALSE;
    }

    private static boolean isEmptyStringLiteralType(@Nullable JSType type) {
        return type instanceof JSStringLiteralTypeImpl && ((JSStringLiteralTypeImpl)type).getLiteral().isEmpty();
    }

    private static boolean isZeroNumberLiteralType(@Nullable JSType type) {
        return type instanceof JSNumberLiteralTypeImpl && ((JSNumberLiteralTypeImpl)type).getLiteral() == 0.0;
    }

    @NotNull
    public static NullableState getNullableState(@Nullable JSType type, boolean allowResolve) {
        if (!((type = JSCompositeTypeImpl.optimizeTypeIfComposite(type, allowResolve)) instanceof JSCompositeTypeImpl)) {
            if (type instanceof JSNullType) {
                NullableState nullableState = NullableState.HAS_NULL;
                if (nullableState == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(0);
                }
                return nullableState;
            }
            if (type instanceof JSUndefinedType) {
                NullableState nullableState = NullableState.HAS_UNDEFINED;
                if (nullableState == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(1);
                }
                return nullableState;
            }
            NullableState nullableState = NullableState.NOT_NULLABLE;
            if (nullableState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(2);
            }
            return nullableState;
        }
        boolean hasNull = false;
        boolean hasUndefined = false;
        for (JSType part : ((JSCompositeTypeImpl)type).getTypes()) {
            if (part instanceof JSNullType) {
                hasNull = true;
                continue;
            }
            if (part instanceof JSUndefinedType) {
                hasUndefined = true;
                continue;
            }
            if (!hasNull || !hasUndefined) continue;
            break;
        }
        if (hasNull && hasUndefined) {
            NullableState nullableState = NullableState.HAS_NULL_AND_UNDEFINED;
            if (nullableState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(3);
            }
            return nullableState;
        }
        if (hasNull) {
            NullableState nullableState = NullableState.HAS_NULL;
            if (nullableState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(4);
            }
            return nullableState;
        }
        if (hasUndefined) {
            NullableState nullableState = NullableState.HAS_UNDEFINED;
            if (nullableState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(5);
            }
            return nullableState;
        }
        NullableState nullableState = NullableState.NOT_NULLABLE;
        if (nullableState == null) {
            JSTypeCastUtil.$$$reportNull$$$0(6);
        }
        return nullableState;
    }

    @NotNull
    public static AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType thisOperand, @NotNull JSType rOperand, @NotNull ProcessingContext processingContext) {
        boolean generics;
        JSType substitutedType;
        JSType type;
        if (thisOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(7);
        }
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(8);
        }
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(9);
        }
        if (rOperand.isTypeScript() && processingContext.get(SKIP_NULL_CHECKS) != Boolean.TRUE && JSTypeCastUtil.strictNullChecks(processingContext)) {
            if (rOperand instanceof JSNullType) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand instanceof JSNullType || thisOperand instanceof JSAnyType);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(10);
                }
                return assignableResult;
            }
            if (rOperand instanceof JSUndefinedType) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand instanceof JSUndefinedType || thisOperand instanceof JSAnyType || thisOperand instanceof JSVoidType);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(11);
                }
                return assignableResult;
            }
        }
        if (rOperand instanceof JSUndefinedType) {
            AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(12);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)rOperand).getConstraintType();
            if (constraintType != null) {
                boolean functionAssignment = JSGenericParameterImpl.isCallEnvironment(processingContext);
                boolean result2 = functionAssignment ? constraintType.isDirectlyAssignableType(thisOperand, processingContext) : thisOperand.isDirectlyAssignableType(constraintType, processingContext);
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(result2);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(13);
                }
                return assignableResult;
            }
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(rOperand.isDirectlyAssignableType(thisOperand, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(14);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSDecoratedTypeImpl && !((JSDecoratedTypeImpl)rOperand).getDecorations().isEmpty()) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(((JSDecoratedTypeImpl)rOperand).getType(), processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(15);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSUnionOrIntersectionType) {
            JSUnionOrIntersectionType compositeType = (JSUnionOrIntersectionType)rOperand;
            boolean isIntersection = compositeType instanceof JSIntersectionTypeImpl;
            boolean isStrictContext = JSTypeCastUtil.isStrictTypeScriptUnionType(compositeType);
            boolean result3 = JSTypeCastUtil.checkAssignableComposite(thisOperand, compositeType, processingContext, !isIntersection && isStrictContext);
            if (result3 || !isStrictContext) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(result3);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(16);
                }
                return assignableResult;
            }
        } else if (rOperand instanceof JSTypeImpl) {
            JSTypeImpl jsType = (JSTypeImpl)rOperand;
            JSType typedefValue = jsType.getTypedef(null, processingContext);
            if (typedefValue != null) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(typedefValue, processingContext));
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(17);
                }
                return assignableResult;
            }
        } else if (rOperand instanceof JSGenericTypeImpl && ((type = ((JSGenericTypeImpl)rOperand).getType()) instanceof JSTypeImpl && ((JSTypeImpl)type).getTypedef(null, processingContext) != null || type instanceof TypeScriptGenericThisTypeImpl) && (substitutedType = rOperand.substitute()) != rOperand) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(substitutedType, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(18);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSIterableComponentTypeImpl || rOperand instanceof TypeScriptGenericThisTypeImpl || rOperand instanceof TypeScriptTypePredicateTypeImpl || rOperand instanceof JSEvaluableType || rOperand instanceof TypeScriptTypeOperatorJSTypeImpl || rOperand instanceof TypeScriptMappedJSTypeImpl || rOperand instanceof JSCompositeTypeBaseImpl) {
            TypeScriptMappedJSTypeImpl mappedType;
            JSType paramType;
            type = rOperand.substitute();
            if (type != rOperand) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type, processingContext));
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(19);
                }
                return assignableResult;
            }
            if (rOperand instanceof TypeScriptMappedJSTypeImpl && JSTypeCastUtil.isTypeOperatorLikeType(paramType = (mappedType = (TypeScriptMappedJSTypeImpl)rOperand).getParameterType()) && TypeScriptMappedJSTypeImpl.isDirectAssignableForMappedTypeWithTypeOperator(thisOperand, mappedType, processingContext, true)) {
                AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(20);
                }
                return assignableResult;
            }
            if (rOperand instanceof JSEvaluableType) {
                AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(21);
                }
                return assignableResult;
            }
        }
        AssignableResult assignableResult = ((generics = JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext)) || thisOperand.isEcma()) && thisOperand.isEquivalentTo(rOperand, processingContext) ? AssignableResult.ASSIGNABLE : AssignableResult.NOT_SURE;
        if (assignableResult == null) {
            JSTypeCastUtil.$$$reportNull$$$0(22);
        }
        return assignableResult;
    }

    @Contract(value="null -> false")
    public static boolean isTypeOperatorLikeType(@Nullable JSType paramType) {
        return paramType instanceof TypeScriptTypeOperatorJSTypeImpl || paramType instanceof JSGenericParameterImpl && ((JSGenericParameterImpl)paramType).getConstraintType() instanceof TypeScriptTypeOperatorJSTypeImpl;
    }

    public static boolean isAlwaysAssignableType(@NotNull JSType type, boolean isJavaScriptContext, @Nullable ProcessingContext processingContext, @Nullable PsiElement context) {
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(23);
        }
        if (type instanceof JSAnyType || type instanceof TypeScriptNeverJSTypeImpl || type instanceof JSRequireCallExpressionType) {
            return true;
        }
        if ((type instanceof JSNullType || type instanceof JSUndefinedType) && !isJavaScriptContext) {
            if (processingContext != null) {
                return !JSTypeCastUtil.strictNullChecks(processingContext);
            }
            return !TypeScriptConfigUtil.strictNullChecks(context);
        }
        return false;
    }

    public static boolean isAlwaysAssignableType(@NotNull JSType type, @Nullable PsiElement context) {
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(24);
        }
        return JSTypeCastUtil.isAlwaysAssignableType(type, type.getSource().isJavaScript(), null, context);
    }

    public static boolean isStrictTypeScriptUnionType(@NotNull JSUnionOrIntersectionType rOperand) {
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(25);
        }
        assert (rOperand instanceof JSTypeBaseImpl);
        JSTypeBaseImpl baseType = (JSTypeBaseImpl)((Object)rOperand);
        if (!baseType.isTypeScript() || !baseType.getSource().isStrict()) {
            return false;
        }
        for (JSType type : rOperand.getTypes()) {
            if (!(type instanceof JSAnyType)) continue;
            return false;
        }
        return true;
    }

    public static AssignableResult toStrictAssignable(boolean value) {
        return value ? AssignableResult.ASSIGNABLE : AssignableResult.NOT_ASSIGNABLE;
    }

    @Nullable
    public static JSRecordType buildWithAppliedGenericArguments(@NotNull JSClass jsClass, @NotNull JSGenericTypeImpl type) {
        if (jsClass == null) {
            JSTypeCastUtil.$$$reportNull$$$0(26);
        }
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(27);
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner) {
            TypeScriptTypeParameterListOwner owner = (TypeScriptTypeParameterListOwner)jsClass;
            JSTypeSubstitutor outerArguments = type.getOuterArguments();
            if (owner.getTypeParameterList() != null || !outerArguments.isEmpty()) {
                JSTypeSubstitutor genericArgumentsMap = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(owner, type);
                JSType baseType = type.getType();
                boolean isStatic = baseType instanceof JSNamedType && ((JSNamedType)baseType).isStaticOrInstance() == JSContext.STATIC;
                JSRecordType recordType = TypeScriptTypeParser.buildTypeFromClass(jsClass, isStatic);
                return (JSRecordType)JSTypeUtils.applyGenericArguments((JSType)recordType, genericArgumentsMap);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAssignableComposite(@NotNull JSType thisOperand, @NotNull JSUnionOrIntersectionType rOperand, @Nullable ProcessingContext processingContext, boolean needCheckAllTypes) {
        if (thisOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(28);
        }
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(29);
        }
        if (rOperand instanceof JSIntersectionTypeImpl && processingContext != null) {
            processingContext.put(JSGenericTypesEvaluator.ourSuspendGenericEvaluation, (Object)true);
        }
        try {
            for (JSType jsType : rOperand.getTypes()) {
                boolean result2 = thisOperand.isDirectlyAssignableType(jsType, processingContext);
                if (needCheckAllTypes) {
                    if (result2) continue;
                    boolean bl = false;
                    return bl;
                }
                if (!result2) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (processingContext != null) {
                processingContext.put(JSGenericTypesEvaluator.ourSuspendGenericEvaluation, (Object)false);
            }
        }
        return needCheckAllTypes;
    }

    public static boolean compareByExcessProperties(@NotNull JSTypeBaseImpl ownType, @NotNull JSFreshObjectLiteralType otherType) {
        if (ownType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(30);
        }
        if (otherType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(31);
        }
        if (ownType instanceof JSObjectType || JSTypeCastUtil.excessPropertyChecksDisabled(ownType)) {
            return true;
        }
        Set literalProperties = otherType.getPropertyNames();
        JSType expanded = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(ownType);
        if (expanded instanceof JSCompositeTypeImpl) {
            List<JSType> types = ((JSCompositeTypeImpl)expanded).getTypes();
            if (types.isEmpty()) {
                return true;
            }
            Collection<String> properties = JSTypeCastUtil.getObjectTypeProperties(otherType);
            for (JSType type : types) {
                if (!JSTypeCastUtil.checkExcessPropertiesForFinalType(type, properties, literalProperties)) continue;
                return true;
            }
            return false;
        }
        return JSTypeCastUtil.checkExcessPropertiesForFinalType(expanded, JSTypeCastUtil.getObjectTypeProperties(otherType), literalProperties);
    }

    @NotNull
    public static Collection<String> getObjectTypeProperties(@NotNull JSFreshObjectLiteralType otherType) {
        if (otherType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(32);
        }
        JSType objectType = JSNamedType.createType("Object", otherType.getSource(), JSContext.INSTANCE);
        Set set = objectType.asRecordType().getPropertyNames();
        if (set == null) {
            JSTypeCastUtil.$$$reportNull$$$0(33);
        }
        return set;
    }

    private static boolean checkExcessPropertiesForFinalType(@Nullable JSType finalType, @NotNull Collection<String> objectTypeProperties, @NotNull Collection<String> literalProperties) {
        if (objectTypeProperties == null) {
            JSTypeCastUtil.$$$reportNull$$$0(34);
        }
        if (literalProperties == null) {
            JSTypeCastUtil.$$$reportNull$$$0(35);
        }
        if (finalType instanceof JSObjectType || finalType == null) {
            return true;
        }
        JSRecordType ownTypeAsRecord = finalType.asRecordType();
        if (!JSTypeCastUtil.shouldCheckForExcessProperties(ownTypeAsRecord)) {
            return true;
        }
        HashSet otherProps = ContainerUtil.newHashSet(literalProperties);
        otherProps.removeAll(ownTypeAsRecord.getPropertyNames());
        otherProps.removeAll(objectTypeProperties);
        return otherProps.size() == 0;
    }

    private static boolean shouldCheckForExcessProperties(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(36);
        }
        return !recordType.hasIndexers() && recordType.hasProperties();
    }

    public static boolean strictNullChecks(@Nullable ProcessingContext context) {
        return context != null && Boolean.TRUE.equals(context.get(JSTypeComparingContextService.NULL_CHECKS));
    }

    private static boolean excessPropertyChecksDisabled(@NotNull JSTypeBaseImpl type) {
        TypeScriptConfig config2;
        PsiFile scope;
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(37);
        }
        return (scope = type.getSource().getScope()) != null && scope.isValid() && (config2 = TypeScriptConfigUtil.getConfigForPsiFile(scope)) != null && config2.suppressExcessPropertyChecks();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeCastUtil";
                break;
            }
            case 7: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisOperand";
                break;
            }
            case 8: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOperand";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 23: 
            case 24: 
            case 27: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownType";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectTypeProperties";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalProperties";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullableState";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeCastUtil";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectTypeProperties";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysAssignableType";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypeScriptUnionType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildWithAppliedGenericArguments";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignableComposite";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "compareByExcessProperties";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getObjectTypeProperties";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "checkExcessPropertiesForFinalType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheckForExcessProperties";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "excessPropertyChecksDisabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum AssignableResult {
        ASSIGNABLE(true, true),
        NOT_ASSIGNABLE(true, false),
        NOT_SURE(false, false),
        NO_CACHE(false, false);

        private final boolean myStrict;
        private final boolean myAssignable;

        private AssignableResult(boolean strict, boolean assignable) {
            this.myStrict = strict;
            this.myAssignable = assignable;
        }

        public boolean isAssignable() {
            return this.myAssignable;
        }

        public boolean isStrict() {
            return this.myStrict;
        }

        public String toString() {
            return "AssignableResult{myStrict=" + this.myStrict + ", myAssignable=" + this.myAssignable + '}';
        }
    }

    public static enum NullableState {
        HAS_NULL,
        HAS_UNDEFINED,
        HAS_NULL_AND_UNDEFINED,
        NOT_NULLABLE;

    }
}

