/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeFacts {
    public static final JSTypeFacts TYPE_FACTS = new JSTypeFacts();
    public static final Map<String, SimpleFact> typeofEQFacts = ContainerUtil.immutableMapBuilder().put((Object)"string", (Object)SimpleFact.TypeofEQString).put((Object)"number", (Object)SimpleFact.TypeofEQNumber).put((Object)"boolean", (Object)SimpleFact.TypeofEQBoolean).put((Object)"symbol", (Object)SimpleFact.TypeofEQSymbol).put((Object)"undefined", (Object)SimpleFact.EQUndefined).put((Object)"object", (Object)SimpleFact.TypeofEQObject).put((Object)"function", (Object)SimpleFact.TypeofEQFunction).build();
    public static final Map<String, SimpleFact> typeofNEFacts = ContainerUtil.immutableMapBuilder().put((Object)"string", (Object)SimpleFact.TypeofNEString).put((Object)"number", (Object)SimpleFact.TypeofNENumber).put((Object)"boolean", (Object)SimpleFact.TypeofNEBoolean).put((Object)"symbol", (Object)SimpleFact.TypeofNESymbol).put((Object)"undefined", (Object)SimpleFact.NEUndefined).put((Object)"object", (Object)SimpleFact.TypeofNEObject).put((Object)"function", (Object)SimpleFact.TypeofNEFunction).build();

    @NotNull
    public static SimpleFact getFactsForPrimitiveType(@NotNull String primitiveTypeName, boolean assumeTrue) {
        SimpleFact fact;
        if (primitiveTypeName == null) {
            JSTypeFacts.$$$reportNull$$$0(0);
        }
        if (assumeTrue) {
            fact = typeofEQFacts.get(primitiveTypeName);
            if (fact == null) {
                SimpleFact simpleFact = SimpleFact.TypeofEQHostObject;
                if (simpleFact == null) {
                    JSTypeFacts.$$$reportNull$$$0(1);
                }
                return simpleFact;
            }
        } else {
            fact = typeofNEFacts.get(primitiveTypeName);
            if (fact == null) {
                SimpleFact simpleFact = SimpleFact.TypeofNEHostObject;
                if (simpleFact == null) {
                    JSTypeFacts.$$$reportNull$$$0(2);
                }
                return simpleFact;
            }
        }
        SimpleFact simpleFact = fact;
        if (simpleFact == null) {
            JSTypeFacts.$$$reportNull$$$0(3);
        }
        return simpleFact;
    }

    @NotNull
    public Set<SimpleFact> getFacts(@Nullable JSType type, @NotNull PsiElement context, boolean strictNullChecks) {
        if (context == null) {
            JSTypeFacts.$$$reportNull$$$0(4);
        }
        Set<SimpleFact> set = this.getFacts(type, context, strictNullChecks, null);
        if (set == null) {
            JSTypeFacts.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    private Set<SimpleFact> getFacts(@Nullable JSType type, @NotNull PsiElement context, boolean strictNullChecks, @Nullable Set<JSResolvedTypeId> visited) {
        JSResolvedTypeInfo resolvedType;
        if (context == null) {
            JSTypeFacts.$$$reportNull$$$0(6);
        }
        if (type == null || visited != null && !visited.add((JSResolvedTypeId)type.getResolvedTypeId())) {
            Set<SimpleFact> set = Collections.emptySet();
            if (set == null) {
                JSTypeFacts.$$$reportNull$$$0(7);
            }
            return set;
        }
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) instanceof JSStringLiteralTypeImpl) {
            JSStringLiteralTypeImpl literal = (JSStringLiteralTypeImpl)type;
            boolean isEmpty = StringUtil.isEmpty((String)literal.getLiteral());
            EnumSet<SimpleFact> enumSet = strictNullChecks ? (isEmpty ? SimpleFact.EmptyStringStrictFacts : SimpleFact.NonEmptyStringStrictFacts) : (isEmpty ? SimpleFact.EmptyStringFacts : SimpleFact.NonEmptyStringFacts);
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(8);
            }
            return enumSet;
        }
        if (type instanceof JSStringType) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.StringStrictFacts : SimpleFact.StringFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(9);
            }
            return enumSet;
        }
        if (type instanceof JSNumberLiteralTypeImpl) {
            boolean isZero;
            boolean bl = isZero = ((JSNumberLiteralTypeImpl)type).getLiteral() == 0.0;
            EnumSet<SimpleFact> enumSet = strictNullChecks ? (isZero ? SimpleFact.ZeroStrictFacts : SimpleFact.NonZeroStrictFacts) : (isZero ? SimpleFact.ZeroFacts : SimpleFact.NonZeroFacts);
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(10);
            }
            return enumSet;
        }
        if (type instanceof JSNumberType) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.NumberStrictFacts : SimpleFact.NumberFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(11);
            }
            return enumSet;
        }
        if (type instanceof JSResolvableType && (resolvedType = ((JSResolvableType)type).resolveType()).isEnum()) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.NumberStrictFacts : SimpleFact.NumberFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(12);
            }
            return enumSet;
        }
        if (type instanceof JSBooleanType) {
            if (type instanceof JSBooleanLiteralTypeImpl && !((JSBooleanLiteralTypeImpl)type).canBeWidened()) {
                JSBooleanLiteralTypeImpl literalType = (JSBooleanLiteralTypeImpl)type;
                boolean value = literalType.getLiteral();
                EnumSet<SimpleFact> enumSet = strictNullChecks ? (!value ? SimpleFact.FalseStrictFacts : SimpleFact.TrueStrictFacts) : (!value ? SimpleFact.FalseFacts : SimpleFact.TrueFacts);
                if (enumSet == null) {
                    JSTypeFacts.$$$reportNull$$$0(13);
                }
                return enumSet;
            }
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.BooleanStrictFacts : SimpleFact.BooleanFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(14);
            }
            return enumSet;
        }
        if (type instanceof JSVoidType || type instanceof JSUndefinedType) {
            EnumSet<SimpleFact> enumSet = SimpleFact.UndefinedFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(15);
            }
            return enumSet;
        }
        if (type instanceof JSNullType) {
            EnumSet<SimpleFact> enumSet = SimpleFact.NullFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(16);
            }
            return enumSet;
        }
        if (type instanceof JSSymbolType) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.SymbolStrictFacts : SimpleFact.SymbolFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(17);
            }
            return enumSet;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            Set<SimpleFact> set = this.getTypeFactsOfTypes(((JSUnionOrIntersectionType)type).getTypes(), context, strictNullChecks, visited);
            if (set == null) {
                JSTypeFacts.$$$reportNull$$$0(18);
            }
            return set;
        }
        if (type instanceof JSFunctionTypeImpl || type instanceof JSPrimitiveFunctionType) {
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.FunctionStrictFacts : SimpleFact.FunctionFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(19);
            }
            return enumSet;
        }
        if (!(type instanceof JSPrimitiveType)) {
            if (type instanceof JSRecordType && ((JSRecordType)type).getCallSignatures().size() > 0) {
                EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.CallableObjectStrictFacts : SimpleFact.CallableObjectFacts;
                if (enumSet == null) {
                    JSTypeFacts.$$$reportNull$$$0(20);
                }
                return enumSet;
            }
            EnumSet<SimpleFact> enumSet = strictNullChecks ? SimpleFact.ObjectStrictFacts : SimpleFact.ObjectFacts;
            if (enumSet == null) {
                JSTypeFacts.$$$reportNull$$$0(21);
            }
            return enumSet;
        }
        EnumSet<SimpleFact> enumSet = EnumSet.of(SimpleFact.All);
        if (enumSet == null) {
            JSTypeFacts.$$$reportNull$$$0(22);
        }
        return enumSet;
    }

    @NotNull
    private Set<SimpleFact> getTypeFactsOfTypes(@NotNull Collection<JSType> types, @NotNull PsiElement context, boolean strictNullChecks, @Nullable Set<JSResolvedTypeId> visited) {
        if (types == null) {
            JSTypeFacts.$$$reportNull$$$0(23);
        }
        if (context == null) {
            JSTypeFacts.$$$reportNull$$$0(24);
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (JSType type : types) {
            Set<SimpleFact> facts = this.getFacts(type, context, strictNullChecks, visited);
            if (facts.contains((Object)SimpleFact.All)) {
                Set<SimpleFact> set = facts;
                if (set == null) {
                    JSTypeFacts.$$$reportNull$$$0(25);
                }
                return set;
            }
            result2.addAll(facts);
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            JSTypeFacts.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    @NotNull
    public JSType getTypeWithFact(@Nullable JSType type, @NotNull SimpleFact fact, @NotNull PsiElement context, boolean strictNullChecks) {
        if (fact == null) {
            JSTypeFacts.$$$reportNull$$$0(27);
        }
        if (context == null) {
            JSTypeFacts.$$$reportNull$$$0(28);
        }
        JSType jSType = TypeScriptTypeRelations.filterType(type, (Predicate<JSType>)((Predicate)el -> {
            if (fact == null) {
                JSTypeFacts.$$$reportNull$$$0(33);
            }
            if (context == null) {
                JSTypeFacts.$$$reportNull$$$0(34);
            }
            return this.hasFact((JSType)el, fact, context, strictNullChecks);
        }), context);
        if (jSType == null) {
            JSTypeFacts.$$$reportNull$$$0(29);
        }
        return jSType;
    }

    private boolean hasFact(@Nullable JSType type, @NotNull SimpleFact fact, @NotNull PsiElement context, boolean strictNullChecks) {
        Set<SimpleFact> facts;
        if (fact == null) {
            JSTypeFacts.$$$reportNull$$$0(30);
        }
        if (context == null) {
            JSTypeFacts.$$$reportNull$$$0(31);
        }
        return (facts = this.getFacts(type, context, strictNullChecks)).contains((Object)SimpleFact.All) || facts.contains((Object)fact);
    }

    private static boolean isStrictNulls(@NotNull PsiElement context) {
        if (context == null) {
            JSTypeFacts.$$$reportNull$$$0(32);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveTypeName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSTypeFacts";
                break;
            }
            case 4: 
            case 6: 
            case 24: 
            case 28: 
            case 31: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSTypeFacts";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactsForPrimitiveType";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacts";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFactsOfTypes";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeWithFact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFactsForPrimitiveType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFacts";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFactsOfTypes";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTypeWithFact";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "hasFact";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isStrictNulls";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getTypeWithFact$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum SimpleFact {
        TypeofEQString,
        TypeofEQNumber,
        TypeofEQBoolean,
        TypeofEQSymbol,
        TypeofEQObject,
        TypeofEQFunction,
        TypeofEQHostObject,
        TypeofNEString,
        TypeofNENumber,
        TypeofNEBoolean,
        TypeofNESymbol,
        TypeofNEObject,
        TypeofNEFunction,
        TypeofNEHostObject,
        EQUndefined,
        EQNull,
        EQUndefinedOrNull,
        NEUndefined,
        NENull,
        NEUndefinedOrNull,
        Truthy,
        Falsy,
        Discriminatable,
        All;

        public static final EnumSet<SimpleFact> BaseStringStrictFacts;
        public static final EnumSet<SimpleFact> BaseStringFacts;
        public static final EnumSet<SimpleFact> StringStrictFacts;
        public static final EnumSet<SimpleFact> StringFacts;
        public static final EnumSet<SimpleFact> EmptyStringStrictFacts;
        public static final EnumSet<SimpleFact> EmptyStringFacts;
        public static final EnumSet<SimpleFact> NonEmptyStringStrictFacts;
        public static final EnumSet<SimpleFact> NonEmptyStringFacts;
        public static final EnumSet<SimpleFact> BaseNumberStrictFacts;
        public static final EnumSet<SimpleFact> BaseNumberFacts;
        public static final EnumSet<SimpleFact> NumberStrictFacts;
        public static final EnumSet<SimpleFact> NumberFacts;
        public static final EnumSet<SimpleFact> ZeroStrictFacts;
        public static final EnumSet<SimpleFact> ZeroFacts;
        public static final EnumSet<SimpleFact> NonZeroStrictFacts;
        public static final EnumSet<SimpleFact> NonZeroFacts;
        public static final EnumSet<SimpleFact> BaseBooleanStrictFacts;
        public static final EnumSet<SimpleFact> BaseBooleanFacts;
        public static final EnumSet<SimpleFact> BooleanStrictFacts;
        public static final EnumSet<SimpleFact> BooleanFacts;
        public static final EnumSet<SimpleFact> FalseStrictFacts;
        public static final EnumSet<SimpleFact> FalseFacts;
        public static final EnumSet<SimpleFact> TrueStrictFacts;
        public static final EnumSet<SimpleFact> TrueFacts;
        public static final EnumSet<SimpleFact> SymbolStrictFacts;
        public static final EnumSet<SimpleFact> SymbolFacts;
        private static final EnumSet<SimpleFact> HostObjectFacts;
        public static final EnumSet<SimpleFact> ObjectStrictFacts;
        public static final EnumSet<SimpleFact> ObjectFacts;
        public static final EnumSet<SimpleFact> FunctionStrictFacts;
        public static final EnumSet<SimpleFact> FunctionFacts;
        public static final EnumSet<SimpleFact> CallableObjectStrictFacts;
        public static final EnumSet<SimpleFact> CallableObjectFacts;
        public static final EnumSet<SimpleFact> UndefinedFacts;
        public static final EnumSet<SimpleFact> NullFacts;

        @NotNull
        private static EnumSet<SimpleFact> unionEnumSets(@NotNull EnumSet<SimpleFact> start, @NotNull EnumSet<SimpleFact> end) {
            if (start == null) {
                SimpleFact.$$$reportNull$$$0(0);
            }
            if (end == null) {
                SimpleFact.$$$reportNull$$$0(1);
            }
            EnumSet<SimpleFact> result2 = EnumSet.copyOf(start);
            result2.addAll(end);
            EnumSet<SimpleFact> enumSet = result2;
            if (enumSet == null) {
                SimpleFact.$$$reportNull$$$0(2);
            }
            return enumSet;
        }

        @NotNull
        private static EnumSet<SimpleFact> addValues(@NotNull EnumSet<SimpleFact> start, SimpleFact ... facts) {
            if (start == null) {
                SimpleFact.$$$reportNull$$$0(3);
            }
            if (facts == null) {
                SimpleFact.$$$reportNull$$$0(4);
            }
            EnumSet<SimpleFact> result2 = EnumSet.copyOf(start);
            ContainerUtil.addAll(result2, (Object[])facts);
            EnumSet<SimpleFact> enumSet = result2;
            if (enumSet == null) {
                SimpleFact.$$$reportNull$$$0(5);
            }
            return enumSet;
        }

        static {
            BaseStringStrictFacts = EnumSet.of(TypeofEQString, new SimpleFact[]{TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull});
            BaseStringFacts = SimpleFact.unionEnumSets(BaseStringStrictFacts, EnumSet.of(EQUndefined, EQNull, EQUndefinedOrNull, Falsy));
            StringStrictFacts = SimpleFact.unionEnumSets(BaseStringStrictFacts, EnumSet.of(Truthy, Falsy));
            StringFacts = SimpleFact.addValues(BaseStringFacts, Truthy);
            EmptyStringStrictFacts = SimpleFact.addValues(BaseStringStrictFacts, Falsy);
            EmptyStringFacts = BaseStringFacts;
            NonEmptyStringStrictFacts = SimpleFact.addValues(BaseStringStrictFacts, Truthy);
            NonEmptyStringFacts = SimpleFact.addValues(BaseStringFacts, Truthy);
            BaseNumberStrictFacts = EnumSet.of(TypeofEQNumber, new SimpleFact[]{TypeofNEString, TypeofNEBoolean, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull});
            BaseNumberFacts = SimpleFact.addValues(BaseNumberStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            NumberStrictFacts = SimpleFact.addValues(BaseNumberStrictFacts, Truthy, Falsy);
            NumberFacts = SimpleFact.addValues(BaseNumberFacts, Truthy);
            ZeroStrictFacts = SimpleFact.addValues(BaseNumberStrictFacts, Falsy);
            ZeroFacts = BaseNumberFacts;
            NonZeroStrictFacts = SimpleFact.addValues(BaseNumberStrictFacts, Truthy);
            NonZeroFacts = SimpleFact.addValues(BaseNumberFacts, Truthy);
            BaseBooleanStrictFacts = EnumSet.of(TypeofEQBoolean, new SimpleFact[]{TypeofNEString, TypeofNENumber, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull});
            BaseBooleanFacts = SimpleFact.addValues(BaseBooleanStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            BooleanStrictFacts = SimpleFact.addValues(BaseBooleanStrictFacts, Truthy, Falsy);
            BooleanFacts = SimpleFact.addValues(BaseBooleanFacts, Truthy);
            FalseStrictFacts = SimpleFact.addValues(BaseBooleanStrictFacts, Falsy);
            FalseFacts = BaseBooleanFacts;
            TrueStrictFacts = SimpleFact.addValues(BaseBooleanStrictFacts, Truthy);
            TrueFacts = SimpleFact.addValues(BaseBooleanFacts, Truthy);
            SymbolStrictFacts = EnumSet.of(TypeofEQSymbol, new SimpleFact[]{TypeofNEString, TypeofNENumber, TypeofNEBoolean, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, NEUndefined, NENull, NEUndefinedOrNull, Truthy});
            SymbolFacts = SimpleFact.addValues(SymbolStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            HostObjectFacts = EnumSet.of(TypeofEQHostObject, new SimpleFact[]{TypeofNEString, TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, NEUndefined, NENull, NEUndefinedOrNull, Truthy, Discriminatable});
            ObjectStrictFacts = SimpleFact.addValues(HostObjectFacts, TypeofEQObject, TypeofNEFunction);
            ObjectFacts = SimpleFact.addValues(ObjectStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            FunctionStrictFacts = SimpleFact.addValues(HostObjectFacts, TypeofEQFunction, TypeofNEObject);
            FunctionFacts = SimpleFact.addValues(FunctionStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            CallableObjectStrictFacts = SimpleFact.addValues(HostObjectFacts, TypeofEQFunction, TypeofEQObject);
            CallableObjectFacts = SimpleFact.addValues(CallableObjectStrictFacts, EQUndefined, EQNull, EQUndefinedOrNull, Falsy);
            UndefinedFacts = EnumSet.of(TypeofNEString, new SimpleFact[]{TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, TypeofNEObject, TypeofNEFunction, TypeofNEHostObject, EQUndefined, EQUndefinedOrNull, NENull, Falsy});
            NullFacts = EnumSet.of(TypeofEQObject, new SimpleFact[]{TypeofNEString, TypeofNENumber, TypeofNEBoolean, TypeofNESymbol, TypeofNEFunction, TypeofNEHostObject, EQNull, EQUndefinedOrNull, NEUndefined, Falsy});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "start";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "end";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/JSTypeFacts$SimpleFact";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "facts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/JSTypeFacts$SimpleFact";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unionEnumSets";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addValues";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "unionEnumSets";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "addValues";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

